# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[builtins.str],
                 environment_identifier: pulumi.Input[builtins.str],
                 aws_location: Optional[pulumi.Input['ConnectionAwsLocationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 props: Optional[pulumi.Input[Union['ConnectionPropertiesInput0PropertiesArgs', 'ConnectionPropertiesInput1PropertiesArgs', 'ConnectionPropertiesInput2PropertiesArgs', 'ConnectionPropertiesInput3PropertiesArgs', 'ConnectionPropertiesInput4PropertiesArgs', 'ConnectionPropertiesInput5PropertiesArgs', 'ConnectionPropertiesInput6PropertiesArgs']]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the domain in which the connection is created.
        :param pulumi.Input[builtins.str] environment_identifier: The identifier of the environment in which the connection is created.
        :param pulumi.Input['ConnectionAwsLocationArgs'] aws_location: The location where the connection is created.
        :param pulumi.Input[builtins.str] description: The description of the connection.
        :param pulumi.Input[builtins.str] name: The name of the connection.
        :param pulumi.Input[Union['ConnectionPropertiesInput0PropertiesArgs', 'ConnectionPropertiesInput1PropertiesArgs', 'ConnectionPropertiesInput2PropertiesArgs', 'ConnectionPropertiesInput3PropertiesArgs', 'ConnectionPropertiesInput4PropertiesArgs', 'ConnectionPropertiesInput5PropertiesArgs', 'ConnectionPropertiesInput6PropertiesArgs']] props: Connection props.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "environment_identifier", environment_identifier)
        if aws_location is not None:
            pulumi.set(__self__, "aws_location", aws_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if props is not None:
            pulumi.set(__self__, "props", props)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the domain in which the connection is created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the environment in which the connection is created.
        """
        return pulumi.get(self, "environment_identifier")

    @environment_identifier.setter
    def environment_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "environment_identifier", value)

    @property
    @pulumi.getter(name="awsLocation")
    def aws_location(self) -> Optional[pulumi.Input['ConnectionAwsLocationArgs']]:
        """
        The location where the connection is created.
        """
        return pulumi.get(self, "aws_location")

    @aws_location.setter
    def aws_location(self, value: Optional[pulumi.Input['ConnectionAwsLocationArgs']]):
        pulumi.set(self, "aws_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def props(self) -> Optional[pulumi.Input[Union['ConnectionPropertiesInput0PropertiesArgs', 'ConnectionPropertiesInput1PropertiesArgs', 'ConnectionPropertiesInput2PropertiesArgs', 'ConnectionPropertiesInput3PropertiesArgs', 'ConnectionPropertiesInput4PropertiesArgs', 'ConnectionPropertiesInput5PropertiesArgs', 'ConnectionPropertiesInput6PropertiesArgs']]]:
        """
        Connection props.
        """
        return pulumi.get(self, "props")

    @props.setter
    def props(self, value: Optional[pulumi.Input[Union['ConnectionPropertiesInput0PropertiesArgs', 'ConnectionPropertiesInput1PropertiesArgs', 'ConnectionPropertiesInput2PropertiesArgs', 'ConnectionPropertiesInput3PropertiesArgs', 'ConnectionPropertiesInput4PropertiesArgs', 'ConnectionPropertiesInput5PropertiesArgs', 'ConnectionPropertiesInput6PropertiesArgs']]]):
        pulumi.set(self, "props", value)


@pulumi.type_token("aws-native:datazone:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_location: Optional[pulumi.Input[Union['ConnectionAwsLocationArgs', 'ConnectionAwsLocationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 props: Optional[pulumi.Input[Union[Union['ConnectionPropertiesInput0PropertiesArgs', 'ConnectionPropertiesInput0PropertiesArgsDict'], Union['ConnectionPropertiesInput1PropertiesArgs', 'ConnectionPropertiesInput1PropertiesArgsDict'], Union['ConnectionPropertiesInput2PropertiesArgs', 'ConnectionPropertiesInput2PropertiesArgsDict'], Union['ConnectionPropertiesInput3PropertiesArgs', 'ConnectionPropertiesInput3PropertiesArgsDict'], Union['ConnectionPropertiesInput4PropertiesArgs', 'ConnectionPropertiesInput4PropertiesArgsDict'], Union['ConnectionPropertiesInput5PropertiesArgs', 'ConnectionPropertiesInput5PropertiesArgsDict'], Union['ConnectionPropertiesInput6PropertiesArgs', 'ConnectionPropertiesInput6PropertiesArgsDict']]]] = None,
                 __props__=None):
        """
        Connections enables users to connect their DataZone resources (domains, projects, and environments) to external resources/services (data, compute, etc)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionAwsLocationArgs', 'ConnectionAwsLocationArgsDict']] aws_location: The location where the connection is created.
        :param pulumi.Input[builtins.str] description: The description of the connection.
        :param pulumi.Input[builtins.str] domain_identifier: The identifier of the domain in which the connection is created.
        :param pulumi.Input[builtins.str] environment_identifier: The identifier of the environment in which the connection is created.
        :param pulumi.Input[builtins.str] name: The name of the connection.
        :param pulumi.Input[Union[Union['ConnectionPropertiesInput0PropertiesArgs', 'ConnectionPropertiesInput0PropertiesArgsDict'], Union['ConnectionPropertiesInput1PropertiesArgs', 'ConnectionPropertiesInput1PropertiesArgsDict'], Union['ConnectionPropertiesInput2PropertiesArgs', 'ConnectionPropertiesInput2PropertiesArgsDict'], Union['ConnectionPropertiesInput3PropertiesArgs', 'ConnectionPropertiesInput3PropertiesArgsDict'], Union['ConnectionPropertiesInput4PropertiesArgs', 'ConnectionPropertiesInput4PropertiesArgsDict'], Union['ConnectionPropertiesInput5PropertiesArgs', 'ConnectionPropertiesInput5PropertiesArgsDict'], Union['ConnectionPropertiesInput6PropertiesArgs', 'ConnectionPropertiesInput6PropertiesArgsDict']]] props: Connection props.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Connections enables users to connect their DataZone resources (domains, projects, and environments) to external resources/services (data, compute, etc)

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_location: Optional[pulumi.Input[Union['ConnectionAwsLocationArgs', 'ConnectionAwsLocationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 environment_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 props: Optional[pulumi.Input[Union[Union['ConnectionPropertiesInput0PropertiesArgs', 'ConnectionPropertiesInput0PropertiesArgsDict'], Union['ConnectionPropertiesInput1PropertiesArgs', 'ConnectionPropertiesInput1PropertiesArgsDict'], Union['ConnectionPropertiesInput2PropertiesArgs', 'ConnectionPropertiesInput2PropertiesArgsDict'], Union['ConnectionPropertiesInput3PropertiesArgs', 'ConnectionPropertiesInput3PropertiesArgsDict'], Union['ConnectionPropertiesInput4PropertiesArgs', 'ConnectionPropertiesInput4PropertiesArgsDict'], Union['ConnectionPropertiesInput5PropertiesArgs', 'ConnectionPropertiesInput5PropertiesArgsDict'], Union['ConnectionPropertiesInput6PropertiesArgs', 'ConnectionPropertiesInput6PropertiesArgsDict']]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["aws_location"] = aws_location
            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            if environment_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'environment_identifier'")
            __props__.__dict__["environment_identifier"] = environment_identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["props"] = props
            __props__.__dict__["connection_id"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["domain_unit_id"] = None
            __props__.__dict__["environment_id"] = None
            __props__.__dict__["environment_user_role"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "environmentIdentifier", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Connection, __self__).__init__(
            'aws-native:datazone:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConnectionArgs.__new__(ConnectionArgs)

        __props__.__dict__["aws_location"] = None
        __props__.__dict__["connection_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["domain_unit_id"] = None
        __props__.__dict__["environment_id"] = None
        __props__.__dict__["environment_identifier"] = None
        __props__.__dict__["environment_user_role"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project_id"] = None
        __props__.__dict__["props"] = None
        __props__.__dict__["type"] = None
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsLocation")
    def aws_location(self) -> pulumi.Output[Optional['outputs.ConnectionAwsLocation']]:
        """
        The location where the connection is created.
        """
        return pulumi.get(self, "aws_location")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the connection.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the domain in which the connection is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the domain in which the connection is created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="domainUnitId")
    def domain_unit_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the domain unit in which the connection is created.
        """
        return pulumi.get(self, "domain_unit_id")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the environment in which the connection is created.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the environment in which the connection is created.
        """
        return pulumi.get(self, "environment_identifier")

    @property
    @pulumi.getter(name="environmentUserRole")
    def environment_user_role(self) -> pulumi.Output[builtins.str]:
        """
        The role of the user in the environment.
        """
        return pulumi.get(self, "environment_user_role")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the connection is created.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def props(self) -> pulumi.Output[Optional[Any]]:
        """
        Connection props.
        """
        return pulumi.get(self, "props")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the connection.
        """
        return pulumi.get(self, "type")

