# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['LocationSmbArgs', 'LocationSmb']

@pulumi.input_type
class LocationSmbArgs:
    def __init__(__self__, *,
                 agent_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 authentication_type: Optional[pulumi.Input['LocationSmbAuthenticationType']] = None,
                 dns_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
                 mount_options: Optional[pulumi.Input['LocationSmbMountOptionsArgs']] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 server_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LocationSmb resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
        :param pulumi.Input['LocationSmbAuthenticationType'] authentication_type: The authentication mode used to determine identity of user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_ip_addresses: Specifies the IPv4 addresses for the DNS servers that your SMB file server belongs to. This parameter applies only if AuthenticationType is set to KERBEROS. If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right SMB file server.
        :param pulumi.Input[builtins.str] domain: The name of the Windows domain that the SMB server belongs to.
        :param pulumi.Input[builtins.str] kerberos_keytab: The Base64 string representation of the Keytab file. Specifies your Kerberos key table (keytab) file, which includes mappings between your service principal name (SPN) and encryption keys. To avoid task execution errors, make sure that the SPN in the keytab file matches exactly what you specify for KerberosPrincipal and in your krb5.conf file.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf: The string representation of the Krb5Conf file, or the presigned URL to access the Krb5.conf file within an S3 bucket. Specifies a Kerberos configuration file (krb5.conf) that defines your Kerberos realm configuration. To avoid task execution errors, make sure that the service principal name (SPN) in the krb5.conf file matches exactly what you specify for KerberosPrincipal and in your keytab file.
        :param pulumi.Input[builtins.str] kerberos_principal: Specifies a service principal name (SPN), which is an identity in your Kerberos realm that has permission to access the files, folders, and file metadata in your SMB file server. SPNs are case sensitive and must include a prepended cifs/. For example, an SPN might look like cifs/kerberosuser@EXAMPLE.COM. Your task execution will fail if the SPN that you provide for this parameter doesn't match exactly what's in your keytab or krb5.conf files.
        :param pulumi.Input['LocationSmbMountOptionsArgs'] mount_options: Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
        :param pulumi.Input[builtins.str] password: The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        :param pulumi.Input[builtins.str] server_hostname: The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server.
        :param pulumi.Input[builtins.str] subdirectory: The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] user: The user who can mount the share, has the permissions to access files and folders in the SMB share.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if dns_ip_addresses is not None:
            pulumi.set(__self__, "dns_ip_addresses", dns_ip_addresses)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if kerberos_keytab is not None:
            pulumi.set(__self__, "kerberos_keytab", kerberos_keytab)
        if kerberos_krb5_conf is not None:
            pulumi.set(__self__, "kerberos_krb5_conf", kerberos_krb5_conf)
        if kerberos_principal is not None:
            pulumi.set(__self__, "kerberos_principal", kerberos_principal)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server_hostname is not None:
            pulumi.set(__self__, "server_hostname", server_hostname)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "agent_arns", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input['LocationSmbAuthenticationType']]:
        """
        The authentication mode used to determine identity of user.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input['LocationSmbAuthenticationType']]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="dnsIpAddresses")
    def dns_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the IPv4 addresses for the DNS servers that your SMB file server belongs to. This parameter applies only if AuthenticationType is set to KERBEROS. If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right SMB file server.
        """
        return pulumi.get(self, "dns_ip_addresses")

    @dns_ip_addresses.setter
    def dns_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_ip_addresses", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Windows domain that the SMB server belongs to.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="kerberosKeytab")
    def kerberos_keytab(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Base64 string representation of the Keytab file. Specifies your Kerberos key table (keytab) file, which includes mappings between your service principal name (SPN) and encryption keys. To avoid task execution errors, make sure that the SPN in the keytab file matches exactly what you specify for KerberosPrincipal and in your krb5.conf file.
        """
        return pulumi.get(self, "kerberos_keytab")

    @kerberos_keytab.setter
    def kerberos_keytab(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_keytab", value)

    @property
    @pulumi.getter(name="kerberosKrb5Conf")
    def kerberos_krb5_conf(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The string representation of the Krb5Conf file, or the presigned URL to access the Krb5.conf file within an S3 bucket. Specifies a Kerberos configuration file (krb5.conf) that defines your Kerberos realm configuration. To avoid task execution errors, make sure that the service principal name (SPN) in the krb5.conf file matches exactly what you specify for KerberosPrincipal and in your keytab file.
        """
        return pulumi.get(self, "kerberos_krb5_conf")

    @kerberos_krb5_conf.setter
    def kerberos_krb5_conf(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_krb5_conf", value)

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a service principal name (SPN), which is an identity in your Kerberos realm that has permission to access the files, folders, and file metadata in your SMB file server. SPNs are case sensitive and must include a prepended cifs/. For example, an SPN might look like cifs/kerberosuser@EXAMPLE.COM. Your task execution will fail if the SPN that you provide for this parameter doesn't match exactly what's in your keytab or krb5.conf files.
        """
        return pulumi.get(self, "kerberos_principal")

    @kerberos_principal.setter
    def kerberos_principal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kerberos_principal", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input['LocationSmbMountOptionsArgs']]:
        """
        Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input['LocationSmbMountOptionsArgs']]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="serverHostname")
    def server_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server.
        """
        return pulumi.get(self, "server_hostname")

    @server_hostname.setter
    def server_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_hostname", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subdirectory", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user who can mount the share, has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("aws-native:datasync:LocationSmb")
class LocationSmb(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input['LocationSmbAuthenticationType']] = None,
                 dns_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
                 mount_options: Optional[pulumi.Input[Union['LocationSmbMountOptionsArgs', 'LocationSmbMountOptionsArgsDict']]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 server_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DataSync::LocationSMB.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
        :param pulumi.Input['LocationSmbAuthenticationType'] authentication_type: The authentication mode used to determine identity of user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_ip_addresses: Specifies the IPv4 addresses for the DNS servers that your SMB file server belongs to. This parameter applies only if AuthenticationType is set to KERBEROS. If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right SMB file server.
        :param pulumi.Input[builtins.str] domain: The name of the Windows domain that the SMB server belongs to.
        :param pulumi.Input[builtins.str] kerberos_keytab: The Base64 string representation of the Keytab file. Specifies your Kerberos key table (keytab) file, which includes mappings between your service principal name (SPN) and encryption keys. To avoid task execution errors, make sure that the SPN in the keytab file matches exactly what you specify for KerberosPrincipal and in your krb5.conf file.
        :param pulumi.Input[builtins.str] kerberos_krb5_conf: The string representation of the Krb5Conf file, or the presigned URL to access the Krb5.conf file within an S3 bucket. Specifies a Kerberos configuration file (krb5.conf) that defines your Kerberos realm configuration. To avoid task execution errors, make sure that the service principal name (SPN) in the krb5.conf file matches exactly what you specify for KerberosPrincipal and in your keytab file.
        :param pulumi.Input[builtins.str] kerberos_principal: Specifies a service principal name (SPN), which is an identity in your Kerberos realm that has permission to access the files, folders, and file metadata in your SMB file server. SPNs are case sensitive and must include a prepended cifs/. For example, an SPN might look like cifs/kerberosuser@EXAMPLE.COM. Your task execution will fail if the SPN that you provide for this parameter doesn't match exactly what's in your keytab or krb5.conf files.
        :param pulumi.Input[Union['LocationSmbMountOptionsArgs', 'LocationSmbMountOptionsArgsDict']] mount_options: Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
        :param pulumi.Input[builtins.str] password: The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        :param pulumi.Input[builtins.str] server_hostname: The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server.
        :param pulumi.Input[builtins.str] subdirectory: The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] user: The user who can mount the share, has the permissions to access files and folders in the SMB share.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocationSmbArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DataSync::LocationSMB.

        :param str resource_name: The name of the resource.
        :param LocationSmbArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationSmbArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input['LocationSmbAuthenticationType']] = None,
                 dns_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_keytab: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_krb5_conf: Optional[pulumi.Input[builtins.str]] = None,
                 kerberos_principal: Optional[pulumi.Input[builtins.str]] = None,
                 mount_options: Optional[pulumi.Input[Union['LocationSmbMountOptionsArgs', 'LocationSmbMountOptionsArgsDict']]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 server_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationSmbArgs.__new__(LocationSmbArgs)

            if agent_arns is None and not opts.urn:
                raise TypeError("Missing required property 'agent_arns'")
            __props__.__dict__["agent_arns"] = agent_arns
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["dns_ip_addresses"] = dns_ip_addresses
            __props__.__dict__["domain"] = domain
            __props__.__dict__["kerberos_keytab"] = kerberos_keytab
            __props__.__dict__["kerberos_krb5_conf"] = kerberos_krb5_conf
            __props__.__dict__["kerberos_principal"] = kerberos_principal
            __props__.__dict__["mount_options"] = mount_options
            __props__.__dict__["password"] = password
            __props__.__dict__["server_hostname"] = server_hostname
            __props__.__dict__["subdirectory"] = subdirectory
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user"] = user
            __props__.__dict__["location_arn"] = None
            __props__.__dict__["location_uri"] = None
        super(LocationSmb, __self__).__init__(
            'aws-native:datasync:LocationSmb',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LocationSmb':
        """
        Get an existing LocationSmb resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LocationSmbArgs.__new__(LocationSmbArgs)

        __props__.__dict__["agent_arns"] = None
        __props__.__dict__["authentication_type"] = None
        __props__.__dict__["dns_ip_addresses"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["kerberos_keytab"] = None
        __props__.__dict__["kerberos_krb5_conf"] = None
        __props__.__dict__["kerberos_principal"] = None
        __props__.__dict__["location_arn"] = None
        __props__.__dict__["location_uri"] = None
        __props__.__dict__["mount_options"] = None
        __props__.__dict__["password"] = None
        __props__.__dict__["server_hostname"] = None
        __props__.__dict__["subdirectory"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["user"] = None
        return LocationSmb(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block (SMB) location.
        """
        return pulumi.get(self, "agent_arns")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional['LocationSmbAuthenticationType']]:
        """
        The authentication mode used to determine identity of user.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="dnsIpAddresses")
    def dns_ip_addresses(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the IPv4 addresses for the DNS servers that your SMB file server belongs to. This parameter applies only if AuthenticationType is set to KERBEROS. If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right SMB file server.
        """
        return pulumi.get(self, "dns_ip_addresses")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Windows domain that the SMB server belongs to.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="kerberosKeytab")
    def kerberos_keytab(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Base64 string representation of the Keytab file. Specifies your Kerberos key table (keytab) file, which includes mappings between your service principal name (SPN) and encryption keys. To avoid task execution errors, make sure that the SPN in the keytab file matches exactly what you specify for KerberosPrincipal and in your krb5.conf file.
        """
        return pulumi.get(self, "kerberos_keytab")

    @property
    @pulumi.getter(name="kerberosKrb5Conf")
    def kerberos_krb5_conf(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The string representation of the Krb5Conf file, or the presigned URL to access the Krb5.conf file within an S3 bucket. Specifies a Kerberos configuration file (krb5.conf) that defines your Kerberos realm configuration. To avoid task execution errors, make sure that the service principal name (SPN) in the krb5.conf file matches exactly what you specify for KerberosPrincipal and in your keytab file.
        """
        return pulumi.get(self, "kerberos_krb5_conf")

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a service principal name (SPN), which is an identity in your Kerberos realm that has permission to access the files, folders, and file metadata in your SMB file server. SPNs are case sensitive and must include a prepended cifs/. For example, an SPN might look like cifs/kerberosuser@EXAMPLE.COM. Your task execution will fail if the SPN that you provide for this parameter doesn't match exactly what's in your keytab or krb5.conf files.
        """
        return pulumi.get(self, "kerberos_principal")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the SMB location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the SMB location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Output[Optional['outputs.LocationSmbMountOptions']]:
        """
        Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="serverHostname")
    def server_hostname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the SMB server. This value is the IP address or Domain Name Service (DNS) name of the SMB server.
        """
        return pulumi.get(self, "server_hostname")

    @property
    @pulumi.getter
    def subdirectory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination
        """
        return pulumi.get(self, "subdirectory")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user who can mount the share, has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "user")

