# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['LocationObjectStorageArgs', 'LocationObjectStorage']

@pulumi.input_type
class LocationObjectStorageArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 cmk_secret_config: Optional[pulumi.Input['LocationObjectStorageCmkSecretConfigArgs']] = None,
                 custom_secret_config: Optional[pulumi.Input['LocationObjectStorageCustomSecretConfigArgs']] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 server_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 server_port: Optional[pulumi.Input[builtins.int]] = None,
                 server_protocol: Optional[pulumi.Input['LocationObjectStorageServerProtocol']] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a LocationObjectStorage resource.
        :param pulumi.Input[builtins.str] access_key: Optional. The access key is used if credentials are required to access the self-managed object storage server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system. If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
        :param pulumi.Input[builtins.str] bucket_name: The name of the bucket on the self-managed object storage server.
        :param pulumi.Input['LocationObjectStorageCmkSecretConfigArgs'] cmk_secret_config: Specifies configuration information for a DataSync-managed secret, which includes the `SecretKey` that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .
               
               When you include this paramater as part of a `CreateLocationObjectStorage` request, you provide only the KMS key ARN. DataSync uses this KMS key together with the value you specify for the `SecretKey` parameter to create a DataSync-managed secret to store the location access credentials.
               
               Make sure the DataSync has permission to access the KMS key that you specify.
               
               > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        :param pulumi.Input['LocationObjectStorageCustomSecretConfigArgs'] custom_secret_config: Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text. This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
               
               > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        :param pulumi.Input[builtins.str] secret_key: Optional. The secret key is used if credentials are required to access the self-managed object storage server.
        :param pulumi.Input[builtins.str] server_certificate: X.509 PEM content containing a certificate authority or chain to trust.
        :param pulumi.Input[builtins.str] server_hostname: The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server.
        :param pulumi.Input[builtins.int] server_port: The port that your self-managed server accepts inbound network traffic on.
        :param pulumi.Input['LocationObjectStorageServerProtocol'] server_protocol: The protocol that the object storage server uses to communicate.
        :param pulumi.Input[builtins.str] subdirectory: The subdirectory in the self-managed object storage server that is used to read data from.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if agent_arns is not None:
            pulumi.set(__self__, "agent_arns", agent_arns)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if cmk_secret_config is not None:
            pulumi.set(__self__, "cmk_secret_config", cmk_secret_config)
        if custom_secret_config is not None:
            pulumi.set(__self__, "custom_secret_config", custom_secret_config)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if server_hostname is not None:
            pulumi.set(__self__, "server_hostname", server_hostname)
        if server_port is not None:
            pulumi.set(__self__, "server_port", server_port)
        if server_protocol is not None:
            pulumi.set(__self__, "server_protocol", server_protocol)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The access key is used if credentials are required to access the self-managed object storage server.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system. If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "agent_arns", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the bucket on the self-managed object storage server.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="cmkSecretConfig")
    def cmk_secret_config(self) -> Optional[pulumi.Input['LocationObjectStorageCmkSecretConfigArgs']]:
        """
        Specifies configuration information for a DataSync-managed secret, which includes the `SecretKey` that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .

        When you include this paramater as part of a `CreateLocationObjectStorage` request, you provide only the KMS key ARN. DataSync uses this KMS key together with the value you specify for the `SecretKey` parameter to create a DataSync-managed secret to store the location access credentials.

        Make sure the DataSync has permission to access the KMS key that you specify.

        > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        """
        return pulumi.get(self, "cmk_secret_config")

    @cmk_secret_config.setter
    def cmk_secret_config(self, value: Optional[pulumi.Input['LocationObjectStorageCmkSecretConfigArgs']]):
        pulumi.set(self, "cmk_secret_config", value)

    @property
    @pulumi.getter(name="customSecretConfig")
    def custom_secret_config(self) -> Optional[pulumi.Input['LocationObjectStorageCustomSecretConfigArgs']]:
        """
        Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text. This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.

        > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        """
        return pulumi.get(self, "custom_secret_config")

    @custom_secret_config.setter
    def custom_secret_config(self, value: Optional[pulumi.Input['LocationObjectStorageCustomSecretConfigArgs']]):
        pulumi.set(self, "custom_secret_config", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The secret key is used if credentials are required to access the self-managed object storage server.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        X.509 PEM content containing a certificate authority or chain to trust.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_certificate", value)

    @property
    @pulumi.getter(name="serverHostname")
    def server_hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server.
        """
        return pulumi.get(self, "server_hostname")

    @server_hostname.setter
    def server_hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_hostname", value)

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port that your self-managed server accepts inbound network traffic on.
        """
        return pulumi.get(self, "server_port")

    @server_port.setter
    def server_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "server_port", value)

    @property
    @pulumi.getter(name="serverProtocol")
    def server_protocol(self) -> Optional[pulumi.Input['LocationObjectStorageServerProtocol']]:
        """
        The protocol that the object storage server uses to communicate.
        """
        return pulumi.get(self, "server_protocol")

    @server_protocol.setter
    def server_protocol(self, value: Optional[pulumi.Input['LocationObjectStorageServerProtocol']]):
        pulumi.set(self, "server_protocol", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subdirectory in the self-managed object storage server that is used to read data from.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subdirectory", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:datasync:LocationObjectStorage")
class LocationObjectStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 cmk_secret_config: Optional[pulumi.Input[Union['LocationObjectStorageCmkSecretConfigArgs', 'LocationObjectStorageCmkSecretConfigArgsDict']]] = None,
                 custom_secret_config: Optional[pulumi.Input[Union['LocationObjectStorageCustomSecretConfigArgs', 'LocationObjectStorageCustomSecretConfigArgsDict']]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 server_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 server_port: Optional[pulumi.Input[builtins.int]] = None,
                 server_protocol: Optional[pulumi.Input['LocationObjectStorageServerProtocol']] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::DataSync::LocationObjectStorage.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        location_object_storage = aws_native.datasync.LocationObjectStorage("locationObjectStorage",
            agent_arns=["arn:aws:datasync:us-east-2:111222333444:agent/agent-0b0addbeef44b3nfs"],
            bucket_name="MyBucket",
            server_hostname="MyServer@example.com",
            server_protocol=aws_native.datasync.LocationObjectStorageServerProtocol.HTTPS,
            subdirectory="/MySubdirectory")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: Optional. The access key is used if credentials are required to access the self-managed object storage server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] agent_arns: Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system. If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
        :param pulumi.Input[builtins.str] bucket_name: The name of the bucket on the self-managed object storage server.
        :param pulumi.Input[Union['LocationObjectStorageCmkSecretConfigArgs', 'LocationObjectStorageCmkSecretConfigArgsDict']] cmk_secret_config: Specifies configuration information for a DataSync-managed secret, which includes the `SecretKey` that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .
               
               When you include this paramater as part of a `CreateLocationObjectStorage` request, you provide only the KMS key ARN. DataSync uses this KMS key together with the value you specify for the `SecretKey` parameter to create a DataSync-managed secret to store the location access credentials.
               
               Make sure the DataSync has permission to access the KMS key that you specify.
               
               > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        :param pulumi.Input[Union['LocationObjectStorageCustomSecretConfigArgs', 'LocationObjectStorageCustomSecretConfigArgsDict']] custom_secret_config: Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text. This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
               
               > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        :param pulumi.Input[builtins.str] secret_key: Optional. The secret key is used if credentials are required to access the self-managed object storage server.
        :param pulumi.Input[builtins.str] server_certificate: X.509 PEM content containing a certificate authority or chain to trust.
        :param pulumi.Input[builtins.str] server_hostname: The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server.
        :param pulumi.Input[builtins.int] server_port: The port that your self-managed server accepts inbound network traffic on.
        :param pulumi.Input['LocationObjectStorageServerProtocol'] server_protocol: The protocol that the object storage server uses to communicate.
        :param pulumi.Input[builtins.str] subdirectory: The subdirectory in the self-managed object storage server that is used to read data from.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LocationObjectStorageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::DataSync::LocationObjectStorage.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        location_object_storage = aws_native.datasync.LocationObjectStorage("locationObjectStorage",
            agent_arns=["arn:aws:datasync:us-east-2:111222333444:agent/agent-0b0addbeef44b3nfs"],
            bucket_name="MyBucket",
            server_hostname="MyServer@example.com",
            server_protocol=aws_native.datasync.LocationObjectStorageServerProtocol.HTTPS,
            subdirectory="/MySubdirectory")

        ```

        :param str resource_name: The name of the resource.
        :param LocationObjectStorageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationObjectStorageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 cmk_secret_config: Optional[pulumi.Input[Union['LocationObjectStorageCmkSecretConfigArgs', 'LocationObjectStorageCmkSecretConfigArgsDict']]] = None,
                 custom_secret_config: Optional[pulumi.Input[Union['LocationObjectStorageCustomSecretConfigArgs', 'LocationObjectStorageCustomSecretConfigArgsDict']]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 server_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 server_hostname: Optional[pulumi.Input[builtins.str]] = None,
                 server_port: Optional[pulumi.Input[builtins.int]] = None,
                 server_protocol: Optional[pulumi.Input['LocationObjectStorageServerProtocol']] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationObjectStorageArgs.__new__(LocationObjectStorageArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["agent_arns"] = agent_arns
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["cmk_secret_config"] = cmk_secret_config
            __props__.__dict__["custom_secret_config"] = custom_secret_config
            __props__.__dict__["secret_key"] = secret_key
            __props__.__dict__["server_certificate"] = server_certificate
            __props__.__dict__["server_hostname"] = server_hostname
            __props__.__dict__["server_port"] = server_port
            __props__.__dict__["server_protocol"] = server_protocol
            __props__.__dict__["subdirectory"] = subdirectory
            __props__.__dict__["tags"] = tags
            __props__.__dict__["location_arn"] = None
            __props__.__dict__["location_uri"] = None
            __props__.__dict__["managed_secret_config"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["bucketName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LocationObjectStorage, __self__).__init__(
            'aws-native:datasync:LocationObjectStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LocationObjectStorage':
        """
        Get an existing LocationObjectStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LocationObjectStorageArgs.__new__(LocationObjectStorageArgs)

        __props__.__dict__["access_key"] = None
        __props__.__dict__["agent_arns"] = None
        __props__.__dict__["bucket_name"] = None
        __props__.__dict__["cmk_secret_config"] = None
        __props__.__dict__["custom_secret_config"] = None
        __props__.__dict__["location_arn"] = None
        __props__.__dict__["location_uri"] = None
        __props__.__dict__["managed_secret_config"] = None
        __props__.__dict__["secret_key"] = None
        __props__.__dict__["server_certificate"] = None
        __props__.__dict__["server_hostname"] = None
        __props__.__dict__["server_port"] = None
        __props__.__dict__["server_protocol"] = None
        __props__.__dict__["subdirectory"] = None
        __props__.__dict__["tags"] = None
        return LocationObjectStorage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. The access key is used if credentials are required to access the self-managed object storage server.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system. If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
        """
        return pulumi.get(self, "agent_arns")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the bucket on the self-managed object storage server.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="cmkSecretConfig")
    def cmk_secret_config(self) -> pulumi.Output[Optional['outputs.LocationObjectStorageCmkSecretConfig']]:
        """
        Specifies configuration information for a DataSync-managed secret, which includes the `SecretKey` that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .

        When you include this paramater as part of a `CreateLocationObjectStorage` request, you provide only the KMS key ARN. DataSync uses this KMS key together with the value you specify for the `SecretKey` parameter to create a DataSync-managed secret to store the location access credentials.

        Make sure the DataSync has permission to access the KMS key that you specify.

        > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        """
        return pulumi.get(self, "cmk_secret_config")

    @property
    @pulumi.getter(name="customSecretConfig")
    def custom_secret_config(self) -> pulumi.Output[Optional['outputs.LocationObjectStorageCustomSecretConfig']]:
        """
        Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text. This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.

        > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        """
        return pulumi.get(self, "custom_secret_config")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the object storage location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter(name="managedSecretConfig")
    def managed_secret_config(self) -> pulumi.Output['outputs.LocationObjectStorageManagedSecretConfig']:
        return pulumi.get(self, "managed_secret_config")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. The secret key is used if credentials are required to access the self-managed object storage server.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        X.509 PEM content containing a certificate authority or chain to trust.
        """
        return pulumi.get(self, "server_certificate")

    @property
    @pulumi.getter(name="serverHostname")
    def server_hostname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server.
        """
        return pulumi.get(self, "server_hostname")

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port that your self-managed server accepts inbound network traffic on.
        """
        return pulumi.get(self, "server_port")

    @property
    @pulumi.getter(name="serverProtocol")
    def server_protocol(self) -> pulumi.Output[Optional['LocationObjectStorageServerProtocol']]:
        """
        The protocol that the object storage server uses to communicate.
        """
        return pulumi.get(self, "server_protocol")

    @property
    @pulumi.getter
    def subdirectory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The subdirectory in the self-managed object storage server that is used to read data from.
        """
        return pulumi.get(self, "subdirectory")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

