# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['LocationFSxLustreArgs', 'LocationFSxLustre']

@pulumi.input_type
class LocationFSxLustreArgs:
    def __init__(__self__, *,
                 security_group_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 fsx_filesystem_arn: Optional[pulumi.Input[builtins.str]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a LocationFSxLustre resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_arns: The ARNs of the security groups that are to use to configure the FSx for Lustre file system.
        :param pulumi.Input[builtins.str] fsx_filesystem_arn: The Amazon Resource Name (ARN) for the FSx for Lustre file system.
        :param pulumi.Input[builtins.str] subdirectory: A subdirectory in the location's path.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "security_group_arns", security_group_arns)
        if fsx_filesystem_arn is not None:
            pulumi.set(__self__, "fsx_filesystem_arn", fsx_filesystem_arn)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="securityGroupArns")
    def security_group_arns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The ARNs of the security groups that are to use to configure the FSx for Lustre file system.
        """
        return pulumi.get(self, "security_group_arns")

    @security_group_arns.setter
    def security_group_arns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_group_arns", value)

    @property
    @pulumi.getter(name="fsxFilesystemArn")
    def fsx_filesystem_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the FSx for Lustre file system.
        """
        return pulumi.get(self, "fsx_filesystem_arn")

    @fsx_filesystem_arn.setter
    def fsx_filesystem_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fsx_filesystem_arn", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A subdirectory in the location's path.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subdirectory", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:datasync:LocationFSxLustre")
class LocationFSxLustre(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fsx_filesystem_arn: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DataSync::LocationFSxLustre.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        location_f_sx_lustre = aws_native.datasync.LocationFSxLustre("locationFSxLustre",
            fsx_filesystem_arn="arn:aws:fsx:us-east-2:111222333444:file-system/fs-12345fsx",
            security_group_arns=["arn:aws:ec2:us-east-2:11122233344:security-group/sg-12345678901212345"],
            subdirectory="/MySubdirectory")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        location_f_sx_lustre = aws_native.datasync.LocationFSxLustre("locationFSxLustre",
            fsx_filesystem_arn="arn:aws:fsx:us-east-2:111222333444:file-system/fs-12345fsx",
            security_group_arns=["arn:aws:ec2:us-east-2:11122233344:security-group/sg-12345678901212345"],
            subdirectory="/MySubdirectory")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] fsx_filesystem_arn: The Amazon Resource Name (ARN) for the FSx for Lustre file system.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_arns: The ARNs of the security groups that are to use to configure the FSx for Lustre file system.
        :param pulumi.Input[builtins.str] subdirectory: A subdirectory in the location's path.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocationFSxLustreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DataSync::LocationFSxLustre.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        location_f_sx_lustre = aws_native.datasync.LocationFSxLustre("locationFSxLustre",
            fsx_filesystem_arn="arn:aws:fsx:us-east-2:111222333444:file-system/fs-12345fsx",
            security_group_arns=["arn:aws:ec2:us-east-2:11122233344:security-group/sg-12345678901212345"],
            subdirectory="/MySubdirectory")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        location_f_sx_lustre = aws_native.datasync.LocationFSxLustre("locationFSxLustre",
            fsx_filesystem_arn="arn:aws:fsx:us-east-2:111222333444:file-system/fs-12345fsx",
            security_group_arns=["arn:aws:ec2:us-east-2:11122233344:security-group/sg-12345678901212345"],
            subdirectory="/MySubdirectory")

        ```

        :param str resource_name: The name of the resource.
        :param LocationFSxLustreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationFSxLustreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fsx_filesystem_arn: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subdirectory: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationFSxLustreArgs.__new__(LocationFSxLustreArgs)

            __props__.__dict__["fsx_filesystem_arn"] = fsx_filesystem_arn
            if security_group_arns is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_arns'")
            __props__.__dict__["security_group_arns"] = security_group_arns
            __props__.__dict__["subdirectory"] = subdirectory
            __props__.__dict__["tags"] = tags
            __props__.__dict__["location_arn"] = None
            __props__.__dict__["location_uri"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["fsxFilesystemArn", "securityGroupArns[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LocationFSxLustre, __self__).__init__(
            'aws-native:datasync:LocationFSxLustre',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LocationFSxLustre':
        """
        Get an existing LocationFSxLustre resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LocationFSxLustreArgs.__new__(LocationFSxLustreArgs)

        __props__.__dict__["fsx_filesystem_arn"] = None
        __props__.__dict__["location_arn"] = None
        __props__.__dict__["location_uri"] = None
        __props__.__dict__["security_group_arns"] = None
        __props__.__dict__["subdirectory"] = None
        __props__.__dict__["tags"] = None
        return LocationFSxLustre(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fsxFilesystemArn")
    def fsx_filesystem_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the FSx for Lustre file system.
        """
        return pulumi.get(self, "fsx_filesystem_arn")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon FSx for Lustre file system location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the FSx for Lustre location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter(name="securityGroupArns")
    def security_group_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The ARNs of the security groups that are to use to configure the FSx for Lustre file system.
        """
        return pulumi.get(self, "security_group_arns")

    @property
    @pulumi.getter
    def subdirectory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A subdirectory in the location's path.
        """
        return pulumi.get(self, "subdirectory")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

