# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTaskResult',
    'AwaitableGetTaskResult',
    'get_task',
    'get_task_output',
]

@pulumi.output_type
class GetTaskResult:
    def __init__(__self__, cloud_watch_log_group_arn=None, destination_network_interface_arns=None, excludes=None, includes=None, manifest_config=None, name=None, options=None, schedule=None, source_network_interface_arns=None, status=None, tags=None, task_arn=None, task_report_config=None):
        if cloud_watch_log_group_arn and not isinstance(cloud_watch_log_group_arn, str):
            raise TypeError("Expected argument 'cloud_watch_log_group_arn' to be a str")
        pulumi.set(__self__, "cloud_watch_log_group_arn", cloud_watch_log_group_arn)
        if destination_network_interface_arns and not isinstance(destination_network_interface_arns, list):
            raise TypeError("Expected argument 'destination_network_interface_arns' to be a list")
        pulumi.set(__self__, "destination_network_interface_arns", destination_network_interface_arns)
        if excludes and not isinstance(excludes, list):
            raise TypeError("Expected argument 'excludes' to be a list")
        pulumi.set(__self__, "excludes", excludes)
        if includes and not isinstance(includes, list):
            raise TypeError("Expected argument 'includes' to be a list")
        pulumi.set(__self__, "includes", includes)
        if manifest_config and not isinstance(manifest_config, dict):
            raise TypeError("Expected argument 'manifest_config' to be a dict")
        pulumi.set(__self__, "manifest_config", manifest_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if options and not isinstance(options, dict):
            raise TypeError("Expected argument 'options' to be a dict")
        pulumi.set(__self__, "options", options)
        if schedule and not isinstance(schedule, dict):
            raise TypeError("Expected argument 'schedule' to be a dict")
        pulumi.set(__self__, "schedule", schedule)
        if source_network_interface_arns and not isinstance(source_network_interface_arns, list):
            raise TypeError("Expected argument 'source_network_interface_arns' to be a list")
        pulumi.set(__self__, "source_network_interface_arns", source_network_interface_arns)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if task_arn and not isinstance(task_arn, str):
            raise TypeError("Expected argument 'task_arn' to be a str")
        pulumi.set(__self__, "task_arn", task_arn)
        if task_report_config and not isinstance(task_report_config, dict):
            raise TypeError("Expected argument 'task_report_config' to be a dict")
        pulumi.set(__self__, "task_report_config", task_report_config)

    @property
    @pulumi.getter(name="cloudWatchLogGroupArn")
    def cloud_watch_log_group_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Amazon CloudWatch log group that is used to monitor and log events in the task.
        """
        return pulumi.get(self, "cloud_watch_log_group_arn")

    @property
    @pulumi.getter(name="destinationNetworkInterfaceArns")
    def destination_network_interface_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The ARNs of the destination elastic network interfaces (ENIs) that were created for your subnet.
        """
        return pulumi.get(self, "destination_network_interface_arns")

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence['outputs.TaskFilterRule']]:
        """
        Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer. For more information and examples, see [Specifying what DataSync transfers by using filters](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html) .
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence['outputs.TaskFilterRule']]:
        """
        Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer. For more information and examples, see [Specifying what DataSync transfers by using filters](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html) .
        """
        return pulumi.get(self, "includes")

    @property
    @pulumi.getter(name="manifestConfig")
    def manifest_config(self) -> Optional['outputs.TaskManifestConfig']:
        """
        The configuration of the manifest that lists the files or objects that you want DataSync to transfer. For more information, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html) .
        """
        return pulumi.get(self, "manifest_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of a task. This value is a text reference that is used to identify the task in the console.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Optional['outputs.TaskOptions']:
        """
        Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.TaskSchedule']:
        """
        Specifies a schedule for when you want your task to run. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html) .
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="sourceNetworkInterfaceArns")
    def source_network_interface_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The ARNs of the source ENIs that were created for your subnet.
        """
        return pulumi.get(self, "source_network_interface_arns")

    @property
    @pulumi.getter
    def status(self) -> Optional['TaskStatus']:
        """
        The status of the task that was described.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskArn")
    def task_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the task.
        """
        return pulumi.get(self, "task_arn")

    @property
    @pulumi.getter(name="taskReportConfig")
    def task_report_config(self) -> Optional['outputs.TaskReportConfig']:
        """
        The configuration of your task report, which provides detailed information about your DataSync transfer. For more information, see [Monitoring your DataSync transfers with task reports](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html) .
        """
        return pulumi.get(self, "task_report_config")


class AwaitableGetTaskResult(GetTaskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskResult(
            cloud_watch_log_group_arn=self.cloud_watch_log_group_arn,
            destination_network_interface_arns=self.destination_network_interface_arns,
            excludes=self.excludes,
            includes=self.includes,
            manifest_config=self.manifest_config,
            name=self.name,
            options=self.options,
            schedule=self.schedule,
            source_network_interface_arns=self.source_network_interface_arns,
            status=self.status,
            tags=self.tags,
            task_arn=self.task_arn,
            task_report_config=self.task_report_config)


def get_task(task_arn: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskResult:
    """
    Resource schema for AWS::DataSync::Task.


    :param builtins.str task_arn: The ARN of the task.
    """
    __args__ = dict()
    __args__['taskArn'] = task_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datasync:getTask', __args__, opts=opts, typ=GetTaskResult).value

    return AwaitableGetTaskResult(
        cloud_watch_log_group_arn=pulumi.get(__ret__, 'cloud_watch_log_group_arn'),
        destination_network_interface_arns=pulumi.get(__ret__, 'destination_network_interface_arns'),
        excludes=pulumi.get(__ret__, 'excludes'),
        includes=pulumi.get(__ret__, 'includes'),
        manifest_config=pulumi.get(__ret__, 'manifest_config'),
        name=pulumi.get(__ret__, 'name'),
        options=pulumi.get(__ret__, 'options'),
        schedule=pulumi.get(__ret__, 'schedule'),
        source_network_interface_arns=pulumi.get(__ret__, 'source_network_interface_arns'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        task_arn=pulumi.get(__ret__, 'task_arn'),
        task_report_config=pulumi.get(__ret__, 'task_report_config'))
def get_task_output(task_arn: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTaskResult]:
    """
    Resource schema for AWS::DataSync::Task.


    :param builtins.str task_arn: The ARN of the task.
    """
    __args__ = dict()
    __args__['taskArn'] = task_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datasync:getTask', __args__, opts=opts, typ=GetTaskResult)
    return __ret__.apply(lambda __response__: GetTaskResult(
        cloud_watch_log_group_arn=pulumi.get(__response__, 'cloud_watch_log_group_arn'),
        destination_network_interface_arns=pulumi.get(__response__, 'destination_network_interface_arns'),
        excludes=pulumi.get(__response__, 'excludes'),
        includes=pulumi.get(__response__, 'includes'),
        manifest_config=pulumi.get(__response__, 'manifest_config'),
        name=pulumi.get(__response__, 'name'),
        options=pulumi.get(__response__, 'options'),
        schedule=pulumi.get(__response__, 'schedule'),
        source_network_interface_arns=pulumi.get(__response__, 'source_network_interface_arns'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        task_arn=pulumi.get(__response__, 'task_arn'),
        task_report_config=pulumi.get(__response__, 'task_report_config')))
