# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetLocationObjectStorageResult',
    'AwaitableGetLocationObjectStorageResult',
    'get_location_object_storage',
    'get_location_object_storage_output',
]

@pulumi.output_type
class GetLocationObjectStorageResult:
    def __init__(__self__, access_key=None, agent_arns=None, cmk_secret_config=None, custom_secret_config=None, location_arn=None, location_uri=None, managed_secret_config=None, server_certificate=None, server_port=None, server_protocol=None, tags=None):
        if access_key and not isinstance(access_key, str):
            raise TypeError("Expected argument 'access_key' to be a str")
        pulumi.set(__self__, "access_key", access_key)
        if agent_arns and not isinstance(agent_arns, list):
            raise TypeError("Expected argument 'agent_arns' to be a list")
        pulumi.set(__self__, "agent_arns", agent_arns)
        if cmk_secret_config and not isinstance(cmk_secret_config, dict):
            raise TypeError("Expected argument 'cmk_secret_config' to be a dict")
        pulumi.set(__self__, "cmk_secret_config", cmk_secret_config)
        if custom_secret_config and not isinstance(custom_secret_config, dict):
            raise TypeError("Expected argument 'custom_secret_config' to be a dict")
        pulumi.set(__self__, "custom_secret_config", custom_secret_config)
        if location_arn and not isinstance(location_arn, str):
            raise TypeError("Expected argument 'location_arn' to be a str")
        pulumi.set(__self__, "location_arn", location_arn)
        if location_uri and not isinstance(location_uri, str):
            raise TypeError("Expected argument 'location_uri' to be a str")
        pulumi.set(__self__, "location_uri", location_uri)
        if managed_secret_config and not isinstance(managed_secret_config, dict):
            raise TypeError("Expected argument 'managed_secret_config' to be a dict")
        pulumi.set(__self__, "managed_secret_config", managed_secret_config)
        if server_certificate and not isinstance(server_certificate, str):
            raise TypeError("Expected argument 'server_certificate' to be a str")
        pulumi.set(__self__, "server_certificate", server_certificate)
        if server_port and not isinstance(server_port, int):
            raise TypeError("Expected argument 'server_port' to be a int")
        pulumi.set(__self__, "server_port", server_port)
        if server_protocol and not isinstance(server_protocol, str):
            raise TypeError("Expected argument 'server_protocol' to be a str")
        pulumi.set(__self__, "server_protocol", server_protocol)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[builtins.str]:
        """
        Optional. The access key is used if credentials are required to access the self-managed object storage server.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system. If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
        """
        return pulumi.get(self, "agent_arns")

    @property
    @pulumi.getter(name="cmkSecretConfig")
    def cmk_secret_config(self) -> Optional['outputs.LocationObjectStorageCmkSecretConfig']:
        """
        Specifies configuration information for a DataSync-managed secret, which includes the `SecretKey` that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .

        When you include this paramater as part of a `CreateLocationObjectStorage` request, you provide only the KMS key ARN. DataSync uses this KMS key together with the value you specify for the `SecretKey` parameter to create a DataSync-managed secret to store the location access credentials.

        Make sure the DataSync has permission to access the KMS key that you specify.

        > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        """
        return pulumi.get(self, "cmk_secret_config")

    @property
    @pulumi.getter(name="customSecretConfig")
    def custom_secret_config(self) -> Optional['outputs.LocationObjectStorageCustomSecretConfig']:
        """
        Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text. This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.

        > You can use either `CmkSecretConfig` (with `SecretKey` ) or `CustomSecretConfig` (without `SecretKey` ) to provide credentials for a `CreateLocationObjectStorage` request. Do not provide both parameters for the same request.
        """
        return pulumi.get(self, "custom_secret_config")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[builtins.str]:
        """
        The URL of the object storage location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter(name="managedSecretConfig")
    def managed_secret_config(self) -> Optional['outputs.LocationObjectStorageManagedSecretConfig']:
        return pulumi.get(self, "managed_secret_config")

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[builtins.str]:
        """
        X.509 PEM content containing a certificate authority or chain to trust.
        """
        return pulumi.get(self, "server_certificate")

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[builtins.int]:
        """
        The port that your self-managed server accepts inbound network traffic on.
        """
        return pulumi.get(self, "server_port")

    @property
    @pulumi.getter(name="serverProtocol")
    def server_protocol(self) -> Optional['LocationObjectStorageServerProtocol']:
        """
        The protocol that the object storage server uses to communicate.
        """
        return pulumi.get(self, "server_protocol")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLocationObjectStorageResult(GetLocationObjectStorageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationObjectStorageResult(
            access_key=self.access_key,
            agent_arns=self.agent_arns,
            cmk_secret_config=self.cmk_secret_config,
            custom_secret_config=self.custom_secret_config,
            location_arn=self.location_arn,
            location_uri=self.location_uri,
            managed_secret_config=self.managed_secret_config,
            server_certificate=self.server_certificate,
            server_port=self.server_port,
            server_protocol=self.server_protocol,
            tags=self.tags)


def get_location_object_storage(location_arn: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationObjectStorageResult:
    """
    Resource Type definition for AWS::DataSync::LocationObjectStorage.


    :param builtins.str location_arn: The Amazon Resource Name (ARN) of the location that is created.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datasync:getLocationObjectStorage', __args__, opts=opts, typ=GetLocationObjectStorageResult).value

    return AwaitableGetLocationObjectStorageResult(
        access_key=pulumi.get(__ret__, 'access_key'),
        agent_arns=pulumi.get(__ret__, 'agent_arns'),
        cmk_secret_config=pulumi.get(__ret__, 'cmk_secret_config'),
        custom_secret_config=pulumi.get(__ret__, 'custom_secret_config'),
        location_arn=pulumi.get(__ret__, 'location_arn'),
        location_uri=pulumi.get(__ret__, 'location_uri'),
        managed_secret_config=pulumi.get(__ret__, 'managed_secret_config'),
        server_certificate=pulumi.get(__ret__, 'server_certificate'),
        server_port=pulumi.get(__ret__, 'server_port'),
        server_protocol=pulumi.get(__ret__, 'server_protocol'),
        tags=pulumi.get(__ret__, 'tags'))
def get_location_object_storage_output(location_arn: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocationObjectStorageResult]:
    """
    Resource Type definition for AWS::DataSync::LocationObjectStorage.


    :param builtins.str location_arn: The Amazon Resource Name (ARN) of the location that is created.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datasync:getLocationObjectStorage', __args__, opts=opts, typ=GetLocationObjectStorageResult)
    return __ret__.apply(lambda __response__: GetLocationObjectStorageResult(
        access_key=pulumi.get(__response__, 'access_key'),
        agent_arns=pulumi.get(__response__, 'agent_arns'),
        cmk_secret_config=pulumi.get(__response__, 'cmk_secret_config'),
        custom_secret_config=pulumi.get(__response__, 'custom_secret_config'),
        location_arn=pulumi.get(__response__, 'location_arn'),
        location_uri=pulumi.get(__response__, 'location_uri'),
        managed_secret_config=pulumi.get(__response__, 'managed_secret_config'),
        server_certificate=pulumi.get(__response__, 'server_certificate'),
        server_port=pulumi.get(__response__, 'server_port'),
        server_protocol=pulumi.get(__response__, 'server_protocol'),
        tags=pulumi.get(__response__, 'tags')))
