# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetLocationFSxWindowsResult',
    'AwaitableGetLocationFSxWindowsResult',
    'get_location_f_sx_windows',
    'get_location_f_sx_windows_output',
]

@pulumi.output_type
class GetLocationFSxWindowsResult:
    def __init__(__self__, domain=None, location_arn=None, location_uri=None, tags=None, user=None):
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if location_arn and not isinstance(location_arn, str):
            raise TypeError("Expected argument 'location_arn' to be a str")
        pulumi.set(__self__, "location_arn", location_arn)
        if location_uri and not isinstance(location_uri, str):
            raise TypeError("Expected argument 'location_uri' to be a str")
        pulumi.set(__self__, "location_uri", location_uri)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        The name of the Windows domain that the FSx for Windows server belongs to.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon FSx for Windows file system location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[builtins.str]:
        """
        The URL of the FSx for Windows location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        The user who has the permissions to access files and folders in the FSx for Windows file system.
        """
        return pulumi.get(self, "user")


class AwaitableGetLocationFSxWindowsResult(GetLocationFSxWindowsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationFSxWindowsResult(
            domain=self.domain,
            location_arn=self.location_arn,
            location_uri=self.location_uri,
            tags=self.tags,
            user=self.user)


def get_location_f_sx_windows(location_arn: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationFSxWindowsResult:
    """
    Resource schema for AWS::DataSync::LocationFSxWindows.


    :param builtins.str location_arn: The Amazon Resource Name (ARN) of the Amazon FSx for Windows file system location that is created.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datasync:getLocationFSxWindows', __args__, opts=opts, typ=GetLocationFSxWindowsResult).value

    return AwaitableGetLocationFSxWindowsResult(
        domain=pulumi.get(__ret__, 'domain'),
        location_arn=pulumi.get(__ret__, 'location_arn'),
        location_uri=pulumi.get(__ret__, 'location_uri'),
        tags=pulumi.get(__ret__, 'tags'),
        user=pulumi.get(__ret__, 'user'))
def get_location_f_sx_windows_output(location_arn: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocationFSxWindowsResult]:
    """
    Resource schema for AWS::DataSync::LocationFSxWindows.


    :param builtins.str location_arn: The Amazon Resource Name (ARN) of the Amazon FSx for Windows file system location that is created.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datasync:getLocationFSxWindows', __args__, opts=opts, typ=GetLocationFSxWindowsResult)
    return __ret__.apply(lambda __response__: GetLocationFSxWindowsResult(
        domain=pulumi.get(__response__, 'domain'),
        location_arn=pulumi.get(__response__, 'location_arn'),
        location_uri=pulumi.get(__response__, 'location_uri'),
        tags=pulumi.get(__response__, 'tags'),
        user=pulumi.get(__response__, 'user')))
