# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetLocationFSxOntapResult',
    'AwaitableGetLocationFSxOntapResult',
    'get_location_f_sx_ontap',
    'get_location_f_sx_ontap_output',
]

@pulumi.output_type
class GetLocationFSxOntapResult:
    def __init__(__self__, fsx_filesystem_arn=None, location_arn=None, location_uri=None, tags=None):
        if fsx_filesystem_arn and not isinstance(fsx_filesystem_arn, str):
            raise TypeError("Expected argument 'fsx_filesystem_arn' to be a str")
        pulumi.set(__self__, "fsx_filesystem_arn", fsx_filesystem_arn)
        if location_arn and not isinstance(location_arn, str):
            raise TypeError("Expected argument 'location_arn' to be a str")
        pulumi.set(__self__, "location_arn", location_arn)
        if location_uri and not isinstance(location_uri, str):
            raise TypeError("Expected argument 'location_uri' to be a str")
        pulumi.set(__self__, "location_uri", location_uri)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fsxFilesystemArn")
    def fsx_filesystem_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the FSx ONAP file system.
        """
        return pulumi.get(self, "fsx_filesystem_arn")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon FSx ONTAP file system location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[builtins.str]:
        """
        The URL of the FSx ONTAP file system that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLocationFSxOntapResult(GetLocationFSxOntapResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationFSxOntapResult(
            fsx_filesystem_arn=self.fsx_filesystem_arn,
            location_arn=self.location_arn,
            location_uri=self.location_uri,
            tags=self.tags)


def get_location_f_sx_ontap(location_arn: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationFSxOntapResult:
    """
    Resource schema for AWS::DataSync::LocationFSxONTAP.


    :param builtins.str location_arn: The Amazon Resource Name (ARN) of the Amazon FSx ONTAP file system location that is created.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datasync:getLocationFSxOntap', __args__, opts=opts, typ=GetLocationFSxOntapResult).value

    return AwaitableGetLocationFSxOntapResult(
        fsx_filesystem_arn=pulumi.get(__ret__, 'fsx_filesystem_arn'),
        location_arn=pulumi.get(__ret__, 'location_arn'),
        location_uri=pulumi.get(__ret__, 'location_uri'),
        tags=pulumi.get(__ret__, 'tags'))
def get_location_f_sx_ontap_output(location_arn: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocationFSxOntapResult]:
    """
    Resource schema for AWS::DataSync::LocationFSxONTAP.


    :param builtins.str location_arn: The Amazon Resource Name (ARN) of the Amazon FSx ONTAP file system location that is created.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datasync:getLocationFSxOntap', __args__, opts=opts, typ=GetLocationFSxOntapResult)
    return __ret__.apply(lambda __response__: GetLocationFSxOntapResult(
        fsx_filesystem_arn=pulumi.get(__response__, 'fsx_filesystem_arn'),
        location_arn=pulumi.get(__response__, 'location_arn'),
        location_uri=pulumi.get(__response__, 'location_uri'),
        tags=pulumi.get(__response__, 'tags')))
