# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PipelineField',
    'PipelineObject',
    'PipelineParameterAttribute',
    'PipelineParameterObject',
    'PipelineParameterValue',
]

@pulumi.output_type
class PipelineField(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "refValue":
            suggest = "ref_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineField. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineField.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineField.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 ref_value: Optional[builtins.str] = None,
                 string_value: Optional[builtins.str] = None):
        """
        :param builtins.str key: Specifies the name of a field for a particular object. To view valid values for a particular field, see Pipeline Object Reference in the AWS Data Pipeline Developer Guide.
        :param builtins.str ref_value: A field value that you specify as an identifier of another object in the same pipeline definition.
        :param builtins.str string_value: A field value that you specify as a string. To view valid values for a particular field, see Pipeline Object Reference in the AWS Data Pipeline Developer Guide.
        """
        pulumi.set(__self__, "key", key)
        if ref_value is not None:
            pulumi.set(__self__, "ref_value", ref_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Specifies the name of a field for a particular object. To view valid values for a particular field, see Pipeline Object Reference in the AWS Data Pipeline Developer Guide.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="refValue")
    def ref_value(self) -> Optional[builtins.str]:
        """
        A field value that you specify as an identifier of another object in the same pipeline definition.
        """
        return pulumi.get(self, "ref_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        A field value that you specify as a string. To view valid values for a particular field, see Pipeline Object Reference in the AWS Data Pipeline Developer Guide.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class PipelineObject(dict):
    def __init__(__self__, *,
                 fields: Sequence['outputs.PipelineField'],
                 id: builtins.str,
                 name: builtins.str):
        """
        :param Sequence['PipelineField'] fields: Key-value pairs that define the properties of the object.
        :param builtins.str id: The ID of the object.
        :param builtins.str name: The name of the object.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.PipelineField']:
        """
        Key-value pairs that define the properties of the object.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the object.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the object.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PipelineParameterAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineParameterAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineParameterAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineParameterAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 string_value: builtins.str):
        """
        :param builtins.str key: The field identifier.
        :param builtins.str string_value: The field value, expressed as a String.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The field identifier.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> builtins.str:
        """
        The field value, expressed as a String.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class PipelineParameterObject(dict):
    def __init__(__self__, *,
                 attributes: Sequence['outputs.PipelineParameterAttribute'],
                 id: builtins.str):
        """
        :param Sequence['PipelineParameterAttribute'] attributes: The attributes of the parameter object.
        :param builtins.str id: The ID of the parameter object.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.PipelineParameterAttribute']:
        """
        The attributes of the parameter object.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the parameter object.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PipelineParameterValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineParameterValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineParameterValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineParameterValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 string_value: builtins.str):
        """
        :param builtins.str id: The ID of the parameter value.
        :param builtins.str string_value: The field value, expressed as a String.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the parameter value.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> builtins.str:
        """
        The field value, expressed as a String.
        """
        return pulumi.get(self, "string_value")


