# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetScheduleResult',
    'AwaitableGetScheduleResult',
    'get_schedule',
    'get_schedule_output',
]

@pulumi.output_type
class GetScheduleResult:
    def __init__(__self__, cron_expression=None, job_names=None, tags=None):
        if cron_expression and not isinstance(cron_expression, str):
            raise TypeError("Expected argument 'cron_expression' to be a str")
        pulumi.set(__self__, "cron_expression", cron_expression)
        if job_names and not isinstance(job_names, list):
            raise TypeError("Expected argument 'job_names' to be a list")
        pulumi.set(__self__, "job_names", job_names)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[builtins.str]:
        """
        Schedule cron
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="jobNames")
    def job_names(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of jobs to be run, according to the schedule.
        """
        return pulumi.get(self, "job_names")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Metadata tags that have been applied to the schedule.
        """
        return pulumi.get(self, "tags")


class AwaitableGetScheduleResult(GetScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduleResult(
            cron_expression=self.cron_expression,
            job_names=self.job_names,
            tags=self.tags)


def get_schedule(name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduleResult:
    """
    Resource schema for AWS::DataBrew::Schedule.


    :param builtins.str name: Schedule Name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:databrew:getSchedule', __args__, opts=opts, typ=GetScheduleResult).value

    return AwaitableGetScheduleResult(
        cron_expression=pulumi.get(__ret__, 'cron_expression'),
        job_names=pulumi.get(__ret__, 'job_names'),
        tags=pulumi.get(__ret__, 'tags'))
def get_schedule_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduleResult]:
    """
    Resource schema for AWS::DataBrew::Schedule.


    :param builtins.str name: Schedule Name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:databrew:getSchedule', __args__, opts=opts, typ=GetScheduleResult)
    return __ret__.apply(lambda __response__: GetScheduleResult(
        cron_expression=pulumi.get(__response__, 'cron_expression'),
        job_names=pulumi.get(__response__, 'job_names'),
        tags=pulumi.get(__response__, 'tags')))
