# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    def __init__(__self__, dataset_name=None, recipe_name=None, role_arn=None, sample=None, tags=None):
        if dataset_name and not isinstance(dataset_name, str):
            raise TypeError("Expected argument 'dataset_name' to be a str")
        pulumi.set(__self__, "dataset_name", dataset_name)
        if recipe_name and not isinstance(recipe_name, str):
            raise TypeError("Expected argument 'recipe_name' to be a str")
        pulumi.set(__self__, "recipe_name", recipe_name)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if sample and not isinstance(sample, dict):
            raise TypeError("Expected argument 'sample' to be a dict")
        pulumi.set(__self__, "sample", sample)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[builtins.str]:
        """
        Dataset name
        """
        return pulumi.get(self, "dataset_name")

    @property
    @pulumi.getter(name="recipeName")
    def recipe_name(self) -> Optional[builtins.str]:
        """
        Recipe name
        """
        return pulumi.get(self, "recipe_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Role arn
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def sample(self) -> Optional['outputs.ProjectSample']:
        """
        Sample
        """
        return pulumi.get(self, "sample")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Metadata tags that have been applied to the project.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            dataset_name=self.dataset_name,
            recipe_name=self.recipe_name,
            role_arn=self.role_arn,
            sample=self.sample,
            tags=self.tags)


def get_project(name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Resource schema for AWS::DataBrew::Project.


    :param builtins.str name: Project name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:databrew:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        dataset_name=pulumi.get(__ret__, 'dataset_name'),
        recipe_name=pulumi.get(__ret__, 'recipe_name'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        sample=pulumi.get(__ret__, 'sample'),
        tags=pulumi.get(__ret__, 'tags'))
def get_project_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Resource schema for AWS::DataBrew::Project.


    :param builtins.str name: Project name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:databrew:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        dataset_name=pulumi.get(__response__, 'dataset_name'),
        recipe_name=pulumi.get(__response__, 'recipe_name'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        sample=pulumi.get(__response__, 'sample'),
        tags=pulumi.get(__response__, 'tags')))
