# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDatasetResult',
    'AwaitableGetDatasetResult',
    'get_dataset',
    'get_dataset_output',
]

@pulumi.output_type
class GetDatasetResult:
    def __init__(__self__, format=None, format_options=None, input=None, path_options=None, source=None, tags=None):
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if format_options and not isinstance(format_options, dict):
            raise TypeError("Expected argument 'format_options' to be a dict")
        pulumi.set(__self__, "format_options", format_options)
        if input and not isinstance(input, dict):
            raise TypeError("Expected argument 'input' to be a dict")
        pulumi.set(__self__, "input", input)
        if path_options and not isinstance(path_options, dict):
            raise TypeError("Expected argument 'path_options' to be a dict")
        pulumi.set(__self__, "path_options", path_options)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def format(self) -> Optional['DatasetFormat']:
        """
        Dataset format
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatOptions")
    def format_options(self) -> Optional['outputs.DatasetFormatOptions']:
        """
        Format options for dataset
        """
        return pulumi.get(self, "format_options")

    @property
    @pulumi.getter
    def input(self) -> Optional['outputs.DatasetInput']:
        """
        Input
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="pathOptions")
    def path_options(self) -> Optional['outputs.DatasetPathOptions']:
        """
        PathOptions
        """
        return pulumi.get(self, "path_options")

    @property
    @pulumi.getter
    def source(self) -> Optional['DatasetSource']:
        """
        Source type of the dataset
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Metadata tags that have been applied to the dataset.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDatasetResult(GetDatasetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetResult(
            format=self.format,
            format_options=self.format_options,
            input=self.input,
            path_options=self.path_options,
            source=self.source,
            tags=self.tags)


def get_dataset(name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetResult:
    """
    Resource schema for AWS::DataBrew::Dataset.


    :param builtins.str name: Dataset name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:databrew:getDataset', __args__, opts=opts, typ=GetDatasetResult).value

    return AwaitableGetDatasetResult(
        format=pulumi.get(__ret__, 'format'),
        format_options=pulumi.get(__ret__, 'format_options'),
        input=pulumi.get(__ret__, 'input'),
        path_options=pulumi.get(__ret__, 'path_options'),
        source=pulumi.get(__ret__, 'source'),
        tags=pulumi.get(__ret__, 'tags'))
def get_dataset_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetResult]:
    """
    Resource schema for AWS::DataBrew::Dataset.


    :param builtins.str name: Dataset name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:databrew:getDataset', __args__, opts=opts, typ=GetDatasetResult)
    return __ret__.apply(lambda __response__: GetDatasetResult(
        format=pulumi.get(__response__, 'format'),
        format_options=pulumi.get(__response__, 'format_options'),
        input=pulumi.get(__response__, 'input'),
        path_options=pulumi.get(__response__, 'path_options'),
        source=pulumi.get(__response__, 'source'),
        tags=pulumi.get(__response__, 'tags')))
