# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'DatasetCsvOptionsArgs',
    'DatasetCsvOptionsArgsDict',
    'DatasetDataCatalogInputDefinitionArgs',
    'DatasetDataCatalogInputDefinitionArgsDict',
    'DatasetDatabaseInputDefinitionArgs',
    'DatasetDatabaseInputDefinitionArgsDict',
    'DatasetDatetimeOptionsArgs',
    'DatasetDatetimeOptionsArgsDict',
    'DatasetExcelOptionsArgs',
    'DatasetExcelOptionsArgsDict',
    'DatasetFilesLimitArgs',
    'DatasetFilesLimitArgsDict',
    'DatasetFilterExpressionArgs',
    'DatasetFilterExpressionArgsDict',
    'DatasetFilterValueArgs',
    'DatasetFilterValueArgsDict',
    'DatasetFormatOptionsArgs',
    'DatasetFormatOptionsArgsDict',
    'DatasetInputArgs',
    'DatasetInputArgsDict',
    'DatasetJsonOptionsArgs',
    'DatasetJsonOptionsArgsDict',
    'DatasetMetadataArgs',
    'DatasetMetadataArgsDict',
    'DatasetParameterArgs',
    'DatasetParameterArgsDict',
    'DatasetPathOptionsArgs',
    'DatasetPathOptionsArgsDict',
    'DatasetPathParameterArgs',
    'DatasetPathParameterArgsDict',
    'DatasetS3LocationArgs',
    'DatasetS3LocationArgsDict',
    'JobAllowedStatisticsArgs',
    'JobAllowedStatisticsArgsDict',
    'JobColumnSelectorArgs',
    'JobColumnSelectorArgsDict',
    'JobColumnStatisticsConfigurationArgs',
    'JobColumnStatisticsConfigurationArgsDict',
    'JobCsvOutputOptionsArgs',
    'JobCsvOutputOptionsArgsDict',
    'JobDataCatalogOutputArgs',
    'JobDataCatalogOutputArgsDict',
    'JobDatabaseOutputArgs',
    'JobDatabaseOutputArgsDict',
    'JobDatabaseTableOutputOptionsArgs',
    'JobDatabaseTableOutputOptionsArgsDict',
    'JobEntityDetectorConfigurationArgs',
    'JobEntityDetectorConfigurationArgsDict',
    'JobOutputFormatOptionsArgs',
    'JobOutputFormatOptionsArgsDict',
    'JobOutputLocationArgs',
    'JobOutputLocationArgsDict',
    'JobOutputArgs',
    'JobOutputArgsDict',
    'JobProfileConfigurationArgs',
    'JobProfileConfigurationArgsDict',
    'JobRecipeArgs',
    'JobRecipeArgsDict',
    'JobS3LocationArgs',
    'JobS3LocationArgsDict',
    'JobS3TableOutputOptionsArgs',
    'JobS3TableOutputOptionsArgsDict',
    'JobSampleArgs',
    'JobSampleArgsDict',
    'JobStatisticOverrideArgs',
    'JobStatisticOverrideArgsDict',
    'JobStatisticsConfigurationArgs',
    'JobStatisticsConfigurationArgsDict',
    'JobValidationConfigurationArgs',
    'JobValidationConfigurationArgsDict',
    'ProjectSampleArgs',
    'ProjectSampleArgsDict',
    'RecipeActionArgs',
    'RecipeActionArgsDict',
    'RecipeConditionExpressionArgs',
    'RecipeConditionExpressionArgsDict',
    'RecipeDataCatalogInputDefinitionArgs',
    'RecipeDataCatalogInputDefinitionArgsDict',
    'RecipeParametersInputPropertiesArgs',
    'RecipeParametersInputPropertiesArgsDict',
    'RecipeParametersArgs',
    'RecipeParametersArgsDict',
    'RecipeS3LocationArgs',
    'RecipeS3LocationArgsDict',
    'RecipeSecondaryInputArgs',
    'RecipeSecondaryInputArgsDict',
    'RecipeStepArgs',
    'RecipeStepArgsDict',
    'RulesetColumnSelectorArgs',
    'RulesetColumnSelectorArgsDict',
    'RulesetRuleArgs',
    'RulesetRuleArgsDict',
    'RulesetSubstitutionValueArgs',
    'RulesetSubstitutionValueArgsDict',
    'RulesetThresholdArgs',
    'RulesetThresholdArgsDict',
]

MYPY = False

if not MYPY:
    class DatasetCsvOptionsArgsDict(TypedDict):
        """
        Csv options
        """
        delimiter: NotRequired[pulumi.Input[builtins.str]]
        """
        A single character that specifies the delimiter being used in the CSV file.
        """
        header_row: NotRequired[pulumi.Input[builtins.bool]]
        """
        A variable that specifies whether the first row in the file is parsed as the header. If this value is false, column names are auto-generated.
        """
elif False:
    DatasetCsvOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetCsvOptionsArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[builtins.str]] = None,
                 header_row: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Csv options
        :param pulumi.Input[builtins.str] delimiter: A single character that specifies the delimiter being used in the CSV file.
        :param pulumi.Input[builtins.bool] header_row: A variable that specifies whether the first row in the file is parsed as the header. If this value is false, column names are auto-generated.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if header_row is not None:
            pulumi.set(__self__, "header_row", header_row)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A single character that specifies the delimiter being used in the CSV file.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="headerRow")
    def header_row(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A variable that specifies whether the first row in the file is parsed as the header. If this value is false, column names are auto-generated.
        """
        return pulumi.get(self, "header_row")

    @header_row.setter
    def header_row(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "header_row", value)


if not MYPY:
    class DatasetDataCatalogInputDefinitionArgsDict(TypedDict):
        catalog_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Catalog id
        """
        database_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Database name
        """
        table_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Table name
        """
        temp_directory: NotRequired[pulumi.Input['DatasetS3LocationArgsDict']]
        """
        An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
        """
elif False:
    DatasetDataCatalogInputDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetDataCatalogInputDefinitionArgs:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 table_name: Optional[pulumi.Input[builtins.str]] = None,
                 temp_directory: Optional[pulumi.Input['DatasetS3LocationArgs']] = None):
        """
        :param pulumi.Input[builtins.str] catalog_id: Catalog id
        :param pulumi.Input[builtins.str] database_name: Database name
        :param pulumi.Input[builtins.str] table_name: Table name
        :param pulumi.Input['DatasetS3LocationArgs'] temp_directory: An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Catalog id
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Database name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Table name
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['DatasetS3LocationArgs']]:
        """
        An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
        """
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['DatasetS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


if not MYPY:
    class DatasetDatabaseInputDefinitionArgsDict(TypedDict):
        glue_connection_name: pulumi.Input[builtins.str]
        """
        Glue connection name
        """
        database_table_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Database table name
        """
        query_string: NotRequired[pulumi.Input[builtins.str]]
        """
        Custom SQL to run against the provided AWS Glue connection. This SQL will be used as the input for DataBrew projects and jobs.
        """
        temp_directory: NotRequired[pulumi.Input['DatasetS3LocationArgsDict']]
        """
        An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
        """
elif False:
    DatasetDatabaseInputDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetDatabaseInputDefinitionArgs:
    def __init__(__self__, *,
                 glue_connection_name: pulumi.Input[builtins.str],
                 database_table_name: Optional[pulumi.Input[builtins.str]] = None,
                 query_string: Optional[pulumi.Input[builtins.str]] = None,
                 temp_directory: Optional[pulumi.Input['DatasetS3LocationArgs']] = None):
        """
        :param pulumi.Input[builtins.str] glue_connection_name: Glue connection name
        :param pulumi.Input[builtins.str] database_table_name: Database table name
        :param pulumi.Input[builtins.str] query_string: Custom SQL to run against the provided AWS Glue connection. This SQL will be used as the input for DataBrew projects and jobs.
        :param pulumi.Input['DatasetS3LocationArgs'] temp_directory: An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
        """
        pulumi.set(__self__, "glue_connection_name", glue_connection_name)
        if database_table_name is not None:
            pulumi.set(__self__, "database_table_name", database_table_name)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="glueConnectionName")
    def glue_connection_name(self) -> pulumi.Input[builtins.str]:
        """
        Glue connection name
        """
        return pulumi.get(self, "glue_connection_name")

    @glue_connection_name.setter
    def glue_connection_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "glue_connection_name", value)

    @property
    @pulumi.getter(name="databaseTableName")
    def database_table_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Database table name
        """
        return pulumi.get(self, "database_table_name")

    @database_table_name.setter
    def database_table_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_table_name", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom SQL to run against the provided AWS Glue connection. This SQL will be used as the input for DataBrew projects and jobs.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['DatasetS3LocationArgs']]:
        """
        An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
        """
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['DatasetS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


if not MYPY:
    class DatasetDatetimeOptionsArgsDict(TypedDict):
        format: pulumi.Input[builtins.str]
        """
        Date/time format of a date parameter
        """
        locale_code: NotRequired[pulumi.Input[builtins.str]]
        """
        Locale code for a date parameter
        """
        timezone_offset: NotRequired[pulumi.Input[builtins.str]]
        """
        Timezone offset
        """
elif False:
    DatasetDatetimeOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetDatetimeOptionsArgs:
    def __init__(__self__, *,
                 format: pulumi.Input[builtins.str],
                 locale_code: Optional[pulumi.Input[builtins.str]] = None,
                 timezone_offset: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] format: Date/time format of a date parameter
        :param pulumi.Input[builtins.str] locale_code: Locale code for a date parameter
        :param pulumi.Input[builtins.str] timezone_offset: Timezone offset
        """
        pulumi.set(__self__, "format", format)
        if locale_code is not None:
            pulumi.set(__self__, "locale_code", locale_code)
        if timezone_offset is not None:
            pulumi.set(__self__, "timezone_offset", timezone_offset)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[builtins.str]:
        """
        Date/time format of a date parameter
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="localeCode")
    def locale_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Locale code for a date parameter
        """
        return pulumi.get(self, "locale_code")

    @locale_code.setter
    def locale_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "locale_code", value)

    @property
    @pulumi.getter(name="timezoneOffset")
    def timezone_offset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timezone offset
        """
        return pulumi.get(self, "timezone_offset")

    @timezone_offset.setter
    def timezone_offset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone_offset", value)


if not MYPY:
    class DatasetExcelOptionsArgsDict(TypedDict):
        header_row: NotRequired[pulumi.Input[builtins.bool]]
        """
        A variable that specifies whether the first row in the file is parsed as the header. If this value is false, column names are auto-generated.
        """
        sheet_indexes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        One or more sheet numbers in the Excel file that will be included in the dataset.
        """
        sheet_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        One or more named sheets in the Excel file that will be included in the dataset.
        """
elif False:
    DatasetExcelOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetExcelOptionsArgs:
    def __init__(__self__, *,
                 header_row: Optional[pulumi.Input[builtins.bool]] = None,
                 sheet_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 sheet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.bool] header_row: A variable that specifies whether the first row in the file is parsed as the header. If this value is false, column names are auto-generated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] sheet_indexes: One or more sheet numbers in the Excel file that will be included in the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sheet_names: One or more named sheets in the Excel file that will be included in the dataset.
        """
        if header_row is not None:
            pulumi.set(__self__, "header_row", header_row)
        if sheet_indexes is not None:
            pulumi.set(__self__, "sheet_indexes", sheet_indexes)
        if sheet_names is not None:
            pulumi.set(__self__, "sheet_names", sheet_names)

    @property
    @pulumi.getter(name="headerRow")
    def header_row(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A variable that specifies whether the first row in the file is parsed as the header. If this value is false, column names are auto-generated.
        """
        return pulumi.get(self, "header_row")

    @header_row.setter
    def header_row(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "header_row", value)

    @property
    @pulumi.getter(name="sheetIndexes")
    def sheet_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        One or more sheet numbers in the Excel file that will be included in the dataset.
        """
        return pulumi.get(self, "sheet_indexes")

    @sheet_indexes.setter
    def sheet_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "sheet_indexes", value)

    @property
    @pulumi.getter(name="sheetNames")
    def sheet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more named sheets in the Excel file that will be included in the dataset.
        """
        return pulumi.get(self, "sheet_names")

    @sheet_names.setter
    def sheet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sheet_names", value)


if not MYPY:
    class DatasetFilesLimitArgsDict(TypedDict):
        max_files: pulumi.Input[builtins.int]
        """
        Maximum number of files
        """
        order: NotRequired[pulumi.Input['DatasetFilesLimitOrder']]
        """
        Order
        """
        ordered_by: NotRequired[pulumi.Input['DatasetFilesLimitOrderedBy']]
        """
        Ordered by
        """
elif False:
    DatasetFilesLimitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetFilesLimitArgs:
    def __init__(__self__, *,
                 max_files: pulumi.Input[builtins.int],
                 order: Optional[pulumi.Input['DatasetFilesLimitOrder']] = None,
                 ordered_by: Optional[pulumi.Input['DatasetFilesLimitOrderedBy']] = None):
        """
        :param pulumi.Input[builtins.int] max_files: Maximum number of files
        :param pulumi.Input['DatasetFilesLimitOrder'] order: Order
        :param pulumi.Input['DatasetFilesLimitOrderedBy'] ordered_by: Ordered by
        """
        pulumi.set(__self__, "max_files", max_files)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if ordered_by is not None:
            pulumi.set(__self__, "ordered_by", ordered_by)

    @property
    @pulumi.getter(name="maxFiles")
    def max_files(self) -> pulumi.Input[builtins.int]:
        """
        Maximum number of files
        """
        return pulumi.get(self, "max_files")

    @max_files.setter
    def max_files(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_files", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input['DatasetFilesLimitOrder']]:
        """
        Order
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input['DatasetFilesLimitOrder']]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="orderedBy")
    def ordered_by(self) -> Optional[pulumi.Input['DatasetFilesLimitOrderedBy']]:
        """
        Ordered by
        """
        return pulumi.get(self, "ordered_by")

    @ordered_by.setter
    def ordered_by(self, value: Optional[pulumi.Input['DatasetFilesLimitOrderedBy']]):
        pulumi.set(self, "ordered_by", value)


if not MYPY:
    class DatasetFilterExpressionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        """
        Filtering expression for a parameter
        """
        values_map: pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgsDict']]]
        """
        The map of substitution variable names to their values used in this filter expression.
        """
elif False:
    DatasetFilterExpressionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetFilterExpressionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 values_map: pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgs']]]):
        """
        :param pulumi.Input[builtins.str] expression: Filtering expression for a parameter
        :param pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgs']]] values_map: The map of substitution variable names to their values used in this filter expression.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "values_map", values_map)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Filtering expression for a parameter
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="valuesMap")
    def values_map(self) -> pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgs']]]:
        """
        The map of substitution variable names to their values used in this filter expression.
        """
        return pulumi.get(self, "values_map")

    @values_map.setter
    def values_map(self, value: pulumi.Input[Sequence[pulumi.Input['DatasetFilterValueArgs']]]):
        pulumi.set(self, "values_map", value)


if not MYPY:
    class DatasetFilterValueArgsDict(TypedDict):
        """
        A key-value pair to associate expression variable names with their values
        """
        value: pulumi.Input[builtins.str]
        """
        The value to be associated with the substitution variable.
        """
        value_reference: pulumi.Input[builtins.str]
        """
        Variable name
        """
elif False:
    DatasetFilterValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetFilterValueArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[builtins.str],
                 value_reference: pulumi.Input[builtins.str]):
        """
        A key-value pair to associate expression variable names with their values
        :param pulumi.Input[builtins.str] value: The value to be associated with the substitution variable.
        :param pulumi.Input[builtins.str] value_reference: Variable name
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_reference", value_reference)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value to be associated with the substitution variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueReference")
    def value_reference(self) -> pulumi.Input[builtins.str]:
        """
        Variable name
        """
        return pulumi.get(self, "value_reference")

    @value_reference.setter
    def value_reference(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value_reference", value)


if not MYPY:
    class DatasetFormatOptionsArgsDict(TypedDict):
        """
        Format options for dataset
        """
        csv: NotRequired[pulumi.Input['DatasetCsvOptionsArgsDict']]
        """
        Options that define how CSV input is to be interpreted by DataBrew.
        """
        excel: NotRequired[pulumi.Input['DatasetExcelOptionsArgsDict']]
        """
        Options that define how Excel input is to be interpreted by DataBrew.
        """
        json: NotRequired[pulumi.Input['DatasetJsonOptionsArgsDict']]
        """
        Options that define how JSON input is to be interpreted by DataBrew.
        """
elif False:
    DatasetFormatOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetFormatOptionsArgs:
    def __init__(__self__, *,
                 csv: Optional[pulumi.Input['DatasetCsvOptionsArgs']] = None,
                 excel: Optional[pulumi.Input['DatasetExcelOptionsArgs']] = None,
                 json: Optional[pulumi.Input['DatasetJsonOptionsArgs']] = None):
        """
        Format options for dataset
        :param pulumi.Input['DatasetCsvOptionsArgs'] csv: Options that define how CSV input is to be interpreted by DataBrew.
        :param pulumi.Input['DatasetExcelOptionsArgs'] excel: Options that define how Excel input is to be interpreted by DataBrew.
        :param pulumi.Input['DatasetJsonOptionsArgs'] json: Options that define how JSON input is to be interpreted by DataBrew.
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)
        if excel is not None:
            pulumi.set(__self__, "excel", excel)
        if json is not None:
            pulumi.set(__self__, "json", json)

    @property
    @pulumi.getter
    def csv(self) -> Optional[pulumi.Input['DatasetCsvOptionsArgs']]:
        """
        Options that define how CSV input is to be interpreted by DataBrew.
        """
        return pulumi.get(self, "csv")

    @csv.setter
    def csv(self, value: Optional[pulumi.Input['DatasetCsvOptionsArgs']]):
        pulumi.set(self, "csv", value)

    @property
    @pulumi.getter
    def excel(self) -> Optional[pulumi.Input['DatasetExcelOptionsArgs']]:
        """
        Options that define how Excel input is to be interpreted by DataBrew.
        """
        return pulumi.get(self, "excel")

    @excel.setter
    def excel(self, value: Optional[pulumi.Input['DatasetExcelOptionsArgs']]):
        pulumi.set(self, "excel", value)

    @property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input['DatasetJsonOptionsArgs']]:
        """
        Options that define how JSON input is to be interpreted by DataBrew.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input['DatasetJsonOptionsArgs']]):
        pulumi.set(self, "json", value)


if not MYPY:
    class DatasetInputArgsDict(TypedDict):
        """
        Input
        """
        data_catalog_input_definition: NotRequired[pulumi.Input['DatasetDataCatalogInputDefinitionArgsDict']]
        """
        The AWS Glue Data Catalog parameters for the data.
        """
        database_input_definition: NotRequired[pulumi.Input['DatasetDatabaseInputDefinitionArgsDict']]
        """
        Connection information for dataset input files stored in a database.
        """
        metadata: NotRequired[pulumi.Input['DatasetMetadataArgsDict']]
        """
        Contains additional resource information needed for specific datasets.
        """
        s3_input_definition: NotRequired[pulumi.Input['DatasetS3LocationArgsDict']]
        """
        The Amazon S3 location where the data is stored.
        """
elif False:
    DatasetInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetInputArgs:
    def __init__(__self__, *,
                 data_catalog_input_definition: Optional[pulumi.Input['DatasetDataCatalogInputDefinitionArgs']] = None,
                 database_input_definition: Optional[pulumi.Input['DatasetDatabaseInputDefinitionArgs']] = None,
                 metadata: Optional[pulumi.Input['DatasetMetadataArgs']] = None,
                 s3_input_definition: Optional[pulumi.Input['DatasetS3LocationArgs']] = None):
        """
        Input
        :param pulumi.Input['DatasetDataCatalogInputDefinitionArgs'] data_catalog_input_definition: The AWS Glue Data Catalog parameters for the data.
        :param pulumi.Input['DatasetDatabaseInputDefinitionArgs'] database_input_definition: Connection information for dataset input files stored in a database.
        :param pulumi.Input['DatasetMetadataArgs'] metadata: Contains additional resource information needed for specific datasets.
        :param pulumi.Input['DatasetS3LocationArgs'] s3_input_definition: The Amazon S3 location where the data is stored.
        """
        if data_catalog_input_definition is not None:
            pulumi.set(__self__, "data_catalog_input_definition", data_catalog_input_definition)
        if database_input_definition is not None:
            pulumi.set(__self__, "database_input_definition", database_input_definition)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if s3_input_definition is not None:
            pulumi.set(__self__, "s3_input_definition", s3_input_definition)

    @property
    @pulumi.getter(name="dataCatalogInputDefinition")
    def data_catalog_input_definition(self) -> Optional[pulumi.Input['DatasetDataCatalogInputDefinitionArgs']]:
        """
        The AWS Glue Data Catalog parameters for the data.
        """
        return pulumi.get(self, "data_catalog_input_definition")

    @data_catalog_input_definition.setter
    def data_catalog_input_definition(self, value: Optional[pulumi.Input['DatasetDataCatalogInputDefinitionArgs']]):
        pulumi.set(self, "data_catalog_input_definition", value)

    @property
    @pulumi.getter(name="databaseInputDefinition")
    def database_input_definition(self) -> Optional[pulumi.Input['DatasetDatabaseInputDefinitionArgs']]:
        """
        Connection information for dataset input files stored in a database.
        """
        return pulumi.get(self, "database_input_definition")

    @database_input_definition.setter
    def database_input_definition(self, value: Optional[pulumi.Input['DatasetDatabaseInputDefinitionArgs']]):
        pulumi.set(self, "database_input_definition", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['DatasetMetadataArgs']]:
        """
        Contains additional resource information needed for specific datasets.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['DatasetMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="s3InputDefinition")
    def s3_input_definition(self) -> Optional[pulumi.Input['DatasetS3LocationArgs']]:
        """
        The Amazon S3 location where the data is stored.
        """
        return pulumi.get(self, "s3_input_definition")

    @s3_input_definition.setter
    def s3_input_definition(self, value: Optional[pulumi.Input['DatasetS3LocationArgs']]):
        pulumi.set(self, "s3_input_definition", value)


if not MYPY:
    class DatasetJsonOptionsArgsDict(TypedDict):
        """
        Json options
        """
        multi_line: NotRequired[pulumi.Input[builtins.bool]]
        """
        A value that specifies whether JSON input contains embedded new line characters.
        """
elif False:
    DatasetJsonOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetJsonOptionsArgs:
    def __init__(__self__, *,
                 multi_line: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Json options
        :param pulumi.Input[builtins.bool] multi_line: A value that specifies whether JSON input contains embedded new line characters.
        """
        if multi_line is not None:
            pulumi.set(__self__, "multi_line", multi_line)

    @property
    @pulumi.getter(name="multiLine")
    def multi_line(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that specifies whether JSON input contains embedded new line characters.
        """
        return pulumi.get(self, "multi_line")

    @multi_line.setter
    def multi_line(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multi_line", value)


if not MYPY:
    class DatasetMetadataArgsDict(TypedDict):
        source_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        Arn of the source of the dataset. For e.g.: AppFlow Flow ARN.
        """
elif False:
    DatasetMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetMetadataArgs:
    def __init__(__self__, *,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] source_arn: Arn of the source of the dataset. For e.g.: AppFlow Flow ARN.
        """
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Arn of the source of the dataset. For e.g.: AppFlow Flow ARN.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_arn", value)


if not MYPY:
    class DatasetParameterArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the parameter that is used in the dataset's Amazon S3 path.
        """
        type: pulumi.Input['DatasetParameterType']
        """
        Parameter type
        """
        create_column: NotRequired[pulumi.Input[builtins.bool]]
        """
        Add the value of this parameter as a column in a dataset.
        """
        datetime_options: NotRequired[pulumi.Input['DatasetDatetimeOptionsArgsDict']]
        """
        Additional parameter options such as a format and a timezone. Required for datetime parameters.
        """
        filter: NotRequired[pulumi.Input['DatasetFilterExpressionArgsDict']]
        """
        The optional filter expression structure to apply additional matching criteria to the parameter.
        """
elif False:
    DatasetParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 type: pulumi.Input['DatasetParameterType'],
                 create_column: Optional[pulumi.Input[builtins.bool]] = None,
                 datetime_options: Optional[pulumi.Input['DatasetDatetimeOptionsArgs']] = None,
                 filter: Optional[pulumi.Input['DatasetFilterExpressionArgs']] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the parameter that is used in the dataset's Amazon S3 path.
        :param pulumi.Input['DatasetParameterType'] type: Parameter type
        :param pulumi.Input[builtins.bool] create_column: Add the value of this parameter as a column in a dataset.
        :param pulumi.Input['DatasetDatetimeOptionsArgs'] datetime_options: Additional parameter options such as a format and a timezone. Required for datetime parameters.
        :param pulumi.Input['DatasetFilterExpressionArgs'] filter: The optional filter expression structure to apply additional matching criteria to the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if create_column is not None:
            pulumi.set(__self__, "create_column", create_column)
        if datetime_options is not None:
            pulumi.set(__self__, "datetime_options", datetime_options)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the parameter that is used in the dataset's Amazon S3 path.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['DatasetParameterType']:
        """
        Parameter type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['DatasetParameterType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="createColumn")
    def create_column(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Add the value of this parameter as a column in a dataset.
        """
        return pulumi.get(self, "create_column")

    @create_column.setter
    def create_column(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "create_column", value)

    @property
    @pulumi.getter(name="datetimeOptions")
    def datetime_options(self) -> Optional[pulumi.Input['DatasetDatetimeOptionsArgs']]:
        """
        Additional parameter options such as a format and a timezone. Required for datetime parameters.
        """
        return pulumi.get(self, "datetime_options")

    @datetime_options.setter
    def datetime_options(self, value: Optional[pulumi.Input['DatasetDatetimeOptionsArgs']]):
        pulumi.set(self, "datetime_options", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['DatasetFilterExpressionArgs']]:
        """
        The optional filter expression structure to apply additional matching criteria to the parameter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['DatasetFilterExpressionArgs']]):
        pulumi.set(self, "filter", value)


if not MYPY:
    class DatasetPathOptionsArgsDict(TypedDict):
        """
        Path options for dataset
        """
        files_limit: NotRequired[pulumi.Input['DatasetFilesLimitArgsDict']]
        """
        If provided, this structure imposes a limit on a number of files that should be selected.
        """
        last_modified_date_condition: NotRequired[pulumi.Input['DatasetFilterExpressionArgsDict']]
        """
        If provided, this structure defines a date range for matching Amazon S3 objects based on their LastModifiedDate attribute in Amazon S3 .
        """
        parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgsDict']]]]
        """
        A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.
        """
elif False:
    DatasetPathOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetPathOptionsArgs:
    def __init__(__self__, *,
                 files_limit: Optional[pulumi.Input['DatasetFilesLimitArgs']] = None,
                 last_modified_date_condition: Optional[pulumi.Input['DatasetFilterExpressionArgs']] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgs']]]] = None):
        """
        Path options for dataset
        :param pulumi.Input['DatasetFilesLimitArgs'] files_limit: If provided, this structure imposes a limit on a number of files that should be selected.
        :param pulumi.Input['DatasetFilterExpressionArgs'] last_modified_date_condition: If provided, this structure defines a date range for matching Amazon S3 objects based on their LastModifiedDate attribute in Amazon S3 .
        :param pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgs']]] parameters: A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.
        """
        if files_limit is not None:
            pulumi.set(__self__, "files_limit", files_limit)
        if last_modified_date_condition is not None:
            pulumi.set(__self__, "last_modified_date_condition", last_modified_date_condition)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="filesLimit")
    def files_limit(self) -> Optional[pulumi.Input['DatasetFilesLimitArgs']]:
        """
        If provided, this structure imposes a limit on a number of files that should be selected.
        """
        return pulumi.get(self, "files_limit")

    @files_limit.setter
    def files_limit(self, value: Optional[pulumi.Input['DatasetFilesLimitArgs']]):
        pulumi.set(self, "files_limit", value)

    @property
    @pulumi.getter(name="lastModifiedDateCondition")
    def last_modified_date_condition(self) -> Optional[pulumi.Input['DatasetFilterExpressionArgs']]:
        """
        If provided, this structure defines a date range for matching Amazon S3 objects based on their LastModifiedDate attribute in Amazon S3 .
        """
        return pulumi.get(self, "last_modified_date_condition")

    @last_modified_date_condition.setter
    def last_modified_date_condition(self, value: Optional[pulumi.Input['DatasetFilterExpressionArgs']]):
        pulumi.set(self, "last_modified_date_condition", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgs']]]]:
        """
        A structure that maps names of parameters used in the Amazon S3 path of a dataset to their definitions.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetPathParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class DatasetPathParameterArgsDict(TypedDict):
        """
        A key-value pair to associate dataset parameter name with its definition.
        """
        dataset_parameter: pulumi.Input['DatasetParameterArgsDict']
        """
        The path parameter definition.
        """
        path_parameter_name: pulumi.Input[builtins.str]
        """
        The name of the path parameter.
        """
elif False:
    DatasetPathParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetPathParameterArgs:
    def __init__(__self__, *,
                 dataset_parameter: pulumi.Input['DatasetParameterArgs'],
                 path_parameter_name: pulumi.Input[builtins.str]):
        """
        A key-value pair to associate dataset parameter name with its definition.
        :param pulumi.Input['DatasetParameterArgs'] dataset_parameter: The path parameter definition.
        :param pulumi.Input[builtins.str] path_parameter_name: The name of the path parameter.
        """
        pulumi.set(__self__, "dataset_parameter", dataset_parameter)
        pulumi.set(__self__, "path_parameter_name", path_parameter_name)

    @property
    @pulumi.getter(name="datasetParameter")
    def dataset_parameter(self) -> pulumi.Input['DatasetParameterArgs']:
        """
        The path parameter definition.
        """
        return pulumi.get(self, "dataset_parameter")

    @dataset_parameter.setter
    def dataset_parameter(self, value: pulumi.Input['DatasetParameterArgs']):
        pulumi.set(self, "dataset_parameter", value)

    @property
    @pulumi.getter(name="pathParameterName")
    def path_parameter_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the path parameter.
        """
        return pulumi.get(self, "path_parameter_name")

    @path_parameter_name.setter
    def path_parameter_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path_parameter_name", value)


if not MYPY:
    class DatasetS3LocationArgsDict(TypedDict):
        """
        Input location
        """
        bucket: pulumi.Input[builtins.str]
        """
        The Amazon S3 bucket name.
        """
        bucket_owner: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS account ID of the bucket owner.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique name of the object in the bucket.
        """
elif False:
    DatasetS3LocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input location
        :param pulumi.Input[builtins.str] bucket: The Amazon S3 bucket name.
        :param pulumi.Input[builtins.str] bucket_owner: The AWS account ID of the bucket owner.
        :param pulumi.Input[builtins.str] key: The unique name of the object in the bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        if bucket_owner is not None:
            pulumi.set(__self__, "bucket_owner", bucket_owner)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon S3 bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account ID of the bucket owner.
        """
        return pulumi.get(self, "bucket_owner")

    @bucket_owner.setter
    def bucket_owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_owner", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the object in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class JobAllowedStatisticsArgsDict(TypedDict):
        statistics: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        One or more column statistics to allow for columns that contain detected entities.
        """
elif False:
    JobAllowedStatisticsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobAllowedStatisticsArgs:
    def __init__(__self__, *,
                 statistics: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] statistics: One or more column statistics to allow for columns that contain detected entities.
        """
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def statistics(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        One or more column statistics to allow for columns that contain detected entities.
        """
        return pulumi.get(self, "statistics")

    @statistics.setter
    def statistics(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "statistics", value)


if not MYPY:
    class JobColumnSelectorArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of a column from a dataset.
        """
        regex: NotRequired[pulumi.Input[builtins.str]]
        """
        A regular expression for selecting a column from a dataset.
        """
elif False:
    JobColumnSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobColumnSelectorArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 regex: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of a column from a dataset.
        :param pulumi.Input[builtins.str] regex: A regular expression for selecting a column from a dataset.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a column from a dataset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regular expression for selecting a column from a dataset.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class JobColumnStatisticsConfigurationArgsDict(TypedDict):
        statistics: pulumi.Input['JobStatisticsConfigurationArgsDict']
        """
        Configuration for evaluations. Statistics can be used to select evaluations and override parameters of evaluations.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgsDict']]]]
        """
        List of column selectors. Selectors can be used to select columns from the dataset. When selectors are undefined, configuration will be applied to all supported columns.
        """
elif False:
    JobColumnStatisticsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobColumnStatisticsConfigurationArgs:
    def __init__(__self__, *,
                 statistics: pulumi.Input['JobStatisticsConfigurationArgs'],
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]] = None):
        """
        :param pulumi.Input['JobStatisticsConfigurationArgs'] statistics: Configuration for evaluations. Statistics can be used to select evaluations and override parameters of evaluations.
        :param pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]] selectors: List of column selectors. Selectors can be used to select columns from the dataset. When selectors are undefined, configuration will be applied to all supported columns.
        """
        pulumi.set(__self__, "statistics", statistics)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def statistics(self) -> pulumi.Input['JobStatisticsConfigurationArgs']:
        """
        Configuration for evaluations. Statistics can be used to select evaluations and override parameters of evaluations.
        """
        return pulumi.get(self, "statistics")

    @statistics.setter
    def statistics(self, value: pulumi.Input['JobStatisticsConfigurationArgs']):
        pulumi.set(self, "statistics", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]:
        """
        List of column selectors. Selectors can be used to select columns from the dataset. When selectors are undefined, configuration will be applied to all supported columns.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)


if not MYPY:
    class JobCsvOutputOptionsArgsDict(TypedDict):
        """
        Output Csv options
        """
        delimiter: NotRequired[pulumi.Input[builtins.str]]
        """
        A single character that specifies the delimiter used to create CSV job output.
        """
elif False:
    JobCsvOutputOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobCsvOutputOptionsArgs:
    def __init__(__self__, *,
                 delimiter: Optional[pulumi.Input[builtins.str]] = None):
        """
        Output Csv options
        :param pulumi.Input[builtins.str] delimiter: A single character that specifies the delimiter used to create CSV job output.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A single character that specifies the delimiter used to create CSV job output.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delimiter", value)


if not MYPY:
    class JobDataCatalogOutputArgsDict(TypedDict):
        database_name: pulumi.Input[builtins.str]
        """
        The name of a database in the Data Catalog.
        """
        table_name: pulumi.Input[builtins.str]
        """
        The name of a table in the Data Catalog.
        """
        catalog_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the AWS account that holds the Data Catalog that stores the data.
        """
        database_options: NotRequired[pulumi.Input['JobDatabaseTableOutputOptionsArgsDict']]
        """
        Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
        """
        overwrite: NotRequired[pulumi.Input[builtins.bool]]
        """
        A value that, if true, means that any data in the location specified for output is overwritten with new output. Not supported with DatabaseOptions.
        """
        s3_options: NotRequired[pulumi.Input['JobS3TableOutputOptionsArgsDict']]
        """
        Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
        """
elif False:
    JobDataCatalogOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDataCatalogOutputArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[builtins.str],
                 table_name: pulumi.Input[builtins.str],
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_options: Optional[pulumi.Input['JobDatabaseTableOutputOptionsArgs']] = None,
                 overwrite: Optional[pulumi.Input[builtins.bool]] = None,
                 s3_options: Optional[pulumi.Input['JobS3TableOutputOptionsArgs']] = None):
        """
        :param pulumi.Input[builtins.str] database_name: The name of a database in the Data Catalog.
        :param pulumi.Input[builtins.str] table_name: The name of a table in the Data Catalog.
        :param pulumi.Input[builtins.str] catalog_id: The unique identifier of the AWS account that holds the Data Catalog that stores the data.
        :param pulumi.Input['JobDatabaseTableOutputOptionsArgs'] database_options: Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
        :param pulumi.Input[builtins.bool] overwrite: A value that, if true, means that any data in the location specified for output is overwritten with new output. Not supported with DatabaseOptions.
        :param pulumi.Input['JobS3TableOutputOptionsArgs'] s3_options: Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "table_name", table_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_options is not None:
            pulumi.set(__self__, "database_options", database_options)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if s3_options is not None:
            pulumi.set(__self__, "s3_options", s3_options)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of a database in the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of a table in the Data Catalog.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the AWS account that holds the Data Catalog that stores the data.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseOptions")
    def database_options(self) -> Optional[pulumi.Input['JobDatabaseTableOutputOptionsArgs']]:
        """
        Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
        """
        return pulumi.get(self, "database_options")

    @database_options.setter
    def database_options(self, value: Optional[pulumi.Input['JobDatabaseTableOutputOptionsArgs']]):
        pulumi.set(self, "database_options", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that, if true, means that any data in the location specified for output is overwritten with new output. Not supported with DatabaseOptions.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter(name="s3Options")
    def s3_options(self) -> Optional[pulumi.Input['JobS3TableOutputOptionsArgs']]:
        """
        Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
        """
        return pulumi.get(self, "s3_options")

    @s3_options.setter
    def s3_options(self, value: Optional[pulumi.Input['JobS3TableOutputOptionsArgs']]):
        pulumi.set(self, "s3_options", value)


if not MYPY:
    class JobDatabaseOutputArgsDict(TypedDict):
        database_options: pulumi.Input['JobDatabaseTableOutputOptionsArgsDict']
        """
        Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
        """
        glue_connection_name: pulumi.Input[builtins.str]
        """
        Glue connection name
        """
        database_output_mode: NotRequired[pulumi.Input['JobDatabaseOutputDatabaseOutputMode']]
        """
        Database table name
        """
elif False:
    JobDatabaseOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDatabaseOutputArgs:
    def __init__(__self__, *,
                 database_options: pulumi.Input['JobDatabaseTableOutputOptionsArgs'],
                 glue_connection_name: pulumi.Input[builtins.str],
                 database_output_mode: Optional[pulumi.Input['JobDatabaseOutputDatabaseOutputMode']] = None):
        """
        :param pulumi.Input['JobDatabaseTableOutputOptionsArgs'] database_options: Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
        :param pulumi.Input[builtins.str] glue_connection_name: Glue connection name
        :param pulumi.Input['JobDatabaseOutputDatabaseOutputMode'] database_output_mode: Database table name
        """
        pulumi.set(__self__, "database_options", database_options)
        pulumi.set(__self__, "glue_connection_name", glue_connection_name)
        if database_output_mode is not None:
            pulumi.set(__self__, "database_output_mode", database_output_mode)

    @property
    @pulumi.getter(name="databaseOptions")
    def database_options(self) -> pulumi.Input['JobDatabaseTableOutputOptionsArgs']:
        """
        Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
        """
        return pulumi.get(self, "database_options")

    @database_options.setter
    def database_options(self, value: pulumi.Input['JobDatabaseTableOutputOptionsArgs']):
        pulumi.set(self, "database_options", value)

    @property
    @pulumi.getter(name="glueConnectionName")
    def glue_connection_name(self) -> pulumi.Input[builtins.str]:
        """
        Glue connection name
        """
        return pulumi.get(self, "glue_connection_name")

    @glue_connection_name.setter
    def glue_connection_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "glue_connection_name", value)

    @property
    @pulumi.getter(name="databaseOutputMode")
    def database_output_mode(self) -> Optional[pulumi.Input['JobDatabaseOutputDatabaseOutputMode']]:
        """
        Database table name
        """
        return pulumi.get(self, "database_output_mode")

    @database_output_mode.setter
    def database_output_mode(self, value: Optional[pulumi.Input['JobDatabaseOutputDatabaseOutputMode']]):
        pulumi.set(self, "database_output_mode", value)


if not MYPY:
    class JobDatabaseTableOutputOptionsArgsDict(TypedDict):
        table_name: pulumi.Input[builtins.str]
        """
        A prefix for the name of a table DataBrew will create in the database.
        """
        temp_directory: NotRequired[pulumi.Input['JobS3LocationArgsDict']]
        """
        Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
        """
elif False:
    JobDatabaseTableOutputOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDatabaseTableOutputOptionsArgs:
    def __init__(__self__, *,
                 table_name: pulumi.Input[builtins.str],
                 temp_directory: Optional[pulumi.Input['JobS3LocationArgs']] = None):
        """
        :param pulumi.Input[builtins.str] table_name: A prefix for the name of a table DataBrew will create in the database.
        :param pulumi.Input['JobS3LocationArgs'] temp_directory: Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
        """
        pulumi.set(__self__, "table_name", table_name)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[builtins.str]:
        """
        A prefix for the name of a table DataBrew will create in the database.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['JobS3LocationArgs']]:
        """
        Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
        """
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['JobS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


if not MYPY:
    class JobEntityDetectorConfigurationArgsDict(TypedDict):
        entity_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Entity types to detect. Can be any of the following:

        - USA_SSN
        - EMAIL
        - USA_ITIN
        - USA_PASSPORT_NUMBER
        - PHONE_NUMBER
        - USA_DRIVING_LICENSE
        - BANK_ACCOUNT
        - CREDIT_CARD
        - IP_ADDRESS
        - MAC_ADDRESS
        - USA_DEA_NUMBER
        - USA_HCPCS_CODE
        - USA_NATIONAL_PROVIDER_IDENTIFIER
        - USA_NATIONAL_DRUG_CODE
        - USA_HEALTH_INSURANCE_CLAIM_NUMBER
        - USA_MEDICARE_BENEFICIARY_IDENTIFIER
        - USA_CPT_CODE
        - PERSON_NAME
        - DATE

        The Entity type group USA_ALL is also supported, and includes all of the above entity types except PERSON_NAME and DATE.
        """
        allowed_statistics: NotRequired[pulumi.Input['JobAllowedStatisticsArgsDict']]
        """
        Configuration of statistics that are allowed to be run on columns that contain detected entities. When undefined, no statistics will be computed on columns that contain detected entities.
        """
elif False:
    JobEntityDetectorConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobEntityDetectorConfigurationArgs:
    def __init__(__self__, *,
                 entity_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_statistics: Optional[pulumi.Input['JobAllowedStatisticsArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] entity_types: Entity types to detect. Can be any of the following:
               
               - USA_SSN
               - EMAIL
               - USA_ITIN
               - USA_PASSPORT_NUMBER
               - PHONE_NUMBER
               - USA_DRIVING_LICENSE
               - BANK_ACCOUNT
               - CREDIT_CARD
               - IP_ADDRESS
               - MAC_ADDRESS
               - USA_DEA_NUMBER
               - USA_HCPCS_CODE
               - USA_NATIONAL_PROVIDER_IDENTIFIER
               - USA_NATIONAL_DRUG_CODE
               - USA_HEALTH_INSURANCE_CLAIM_NUMBER
               - USA_MEDICARE_BENEFICIARY_IDENTIFIER
               - USA_CPT_CODE
               - PERSON_NAME
               - DATE
               
               The Entity type group USA_ALL is also supported, and includes all of the above entity types except PERSON_NAME and DATE.
        :param pulumi.Input['JobAllowedStatisticsArgs'] allowed_statistics: Configuration of statistics that are allowed to be run on columns that contain detected entities. When undefined, no statistics will be computed on columns that contain detected entities.
        """
        pulumi.set(__self__, "entity_types", entity_types)
        if allowed_statistics is not None:
            pulumi.set(__self__, "allowed_statistics", allowed_statistics)

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Entity types to detect. Can be any of the following:

        - USA_SSN
        - EMAIL
        - USA_ITIN
        - USA_PASSPORT_NUMBER
        - PHONE_NUMBER
        - USA_DRIVING_LICENSE
        - BANK_ACCOUNT
        - CREDIT_CARD
        - IP_ADDRESS
        - MAC_ADDRESS
        - USA_DEA_NUMBER
        - USA_HCPCS_CODE
        - USA_NATIONAL_PROVIDER_IDENTIFIER
        - USA_NATIONAL_DRUG_CODE
        - USA_HEALTH_INSURANCE_CLAIM_NUMBER
        - USA_MEDICARE_BENEFICIARY_IDENTIFIER
        - USA_CPT_CODE
        - PERSON_NAME
        - DATE

        The Entity type group USA_ALL is also supported, and includes all of the above entity types except PERSON_NAME and DATE.
        """
        return pulumi.get(self, "entity_types")

    @entity_types.setter
    def entity_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "entity_types", value)

    @property
    @pulumi.getter(name="allowedStatistics")
    def allowed_statistics(self) -> Optional[pulumi.Input['JobAllowedStatisticsArgs']]:
        """
        Configuration of statistics that are allowed to be run on columns that contain detected entities. When undefined, no statistics will be computed on columns that contain detected entities.
        """
        return pulumi.get(self, "allowed_statistics")

    @allowed_statistics.setter
    def allowed_statistics(self, value: Optional[pulumi.Input['JobAllowedStatisticsArgs']]):
        pulumi.set(self, "allowed_statistics", value)


if not MYPY:
    class JobOutputFormatOptionsArgsDict(TypedDict):
        """
        Format options for job Output
        """
        csv: NotRequired[pulumi.Input['JobCsvOutputOptionsArgsDict']]
        """
        Represents a set of options that define the structure of comma-separated value (CSV) job output.
        """
elif False:
    JobOutputFormatOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobOutputFormatOptionsArgs:
    def __init__(__self__, *,
                 csv: Optional[pulumi.Input['JobCsvOutputOptionsArgs']] = None):
        """
        Format options for job Output
        :param pulumi.Input['JobCsvOutputOptionsArgs'] csv: Represents a set of options that define the structure of comma-separated value (CSV) job output.
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)

    @property
    @pulumi.getter
    def csv(self) -> Optional[pulumi.Input['JobCsvOutputOptionsArgs']]:
        """
        Represents a set of options that define the structure of comma-separated value (CSV) job output.
        """
        return pulumi.get(self, "csv")

    @csv.setter
    def csv(self, value: Optional[pulumi.Input['JobCsvOutputOptionsArgs']]):
        pulumi.set(self, "csv", value)


if not MYPY:
    class JobOutputLocationArgsDict(TypedDict):
        """
        Output location
        """
        bucket: pulumi.Input[builtins.str]
        """
        The Amazon S3 bucket name.
        """
        bucket_owner: NotRequired[pulumi.Input[builtins.str]]
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique name of the object in the bucket.
        """
elif False:
    JobOutputLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobOutputLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None):
        """
        Output location
        :param pulumi.Input[builtins.str] bucket: The Amazon S3 bucket name.
        :param pulumi.Input[builtins.str] key: The unique name of the object in the bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        if bucket_owner is not None:
            pulumi.set(__self__, "bucket_owner", bucket_owner)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon S3 bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "bucket_owner")

    @bucket_owner.setter
    def bucket_owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_owner", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the object in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class JobOutputArgsDict(TypedDict):
        location: pulumi.Input['JobS3LocationArgsDict']
        """
        The location in Amazon S3 where the job writes its output.
        """
        compression_format: NotRequired[pulumi.Input['JobOutputCompressionFormat']]
        """
        The compression algorithm used to compress the output text of the job.
        """
        format: NotRequired[pulumi.Input['JobOutputFormat']]
        """
        The data format of the output of the job.
        """
        format_options: NotRequired[pulumi.Input['JobOutputFormatOptionsArgsDict']]
        """
        Represents options that define how DataBrew formats job output files.
        """
        max_output_files: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of files to be generated by the job and written to the output folder.
        """
        overwrite: NotRequired[pulumi.Input[builtins.bool]]
        """
        A value that, if true, means that any data in the location specified for output is overwritten with new output.
        """
        partition_columns: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The names of one or more partition columns for the output of the job.
        """
elif False:
    JobOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobOutputArgs:
    def __init__(__self__, *,
                 location: pulumi.Input['JobS3LocationArgs'],
                 compression_format: Optional[pulumi.Input['JobOutputCompressionFormat']] = None,
                 format: Optional[pulumi.Input['JobOutputFormat']] = None,
                 format_options: Optional[pulumi.Input['JobOutputFormatOptionsArgs']] = None,
                 max_output_files: Optional[pulumi.Input[builtins.int]] = None,
                 overwrite: Optional[pulumi.Input[builtins.bool]] = None,
                 partition_columns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input['JobS3LocationArgs'] location: The location in Amazon S3 where the job writes its output.
        :param pulumi.Input['JobOutputCompressionFormat'] compression_format: The compression algorithm used to compress the output text of the job.
        :param pulumi.Input['JobOutputFormat'] format: The data format of the output of the job.
        :param pulumi.Input['JobOutputFormatOptionsArgs'] format_options: Represents options that define how DataBrew formats job output files.
        :param pulumi.Input[builtins.int] max_output_files: The maximum number of files to be generated by the job and written to the output folder.
        :param pulumi.Input[builtins.bool] overwrite: A value that, if true, means that any data in the location specified for output is overwritten with new output.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] partition_columns: The names of one or more partition columns for the output of the job.
        """
        pulumi.set(__self__, "location", location)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_options is not None:
            pulumi.set(__self__, "format_options", format_options)
        if max_output_files is not None:
            pulumi.set(__self__, "max_output_files", max_output_files)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if partition_columns is not None:
            pulumi.set(__self__, "partition_columns", partition_columns)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input['JobS3LocationArgs']:
        """
        The location in Amazon S3 where the job writes its output.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input['JobS3LocationArgs']):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional[pulumi.Input['JobOutputCompressionFormat']]:
        """
        The compression algorithm used to compress the output text of the job.
        """
        return pulumi.get(self, "compression_format")

    @compression_format.setter
    def compression_format(self, value: Optional[pulumi.Input['JobOutputCompressionFormat']]):
        pulumi.set(self, "compression_format", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['JobOutputFormat']]:
        """
        The data format of the output of the job.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['JobOutputFormat']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="formatOptions")
    def format_options(self) -> Optional[pulumi.Input['JobOutputFormatOptionsArgs']]:
        """
        Represents options that define how DataBrew formats job output files.
        """
        return pulumi.get(self, "format_options")

    @format_options.setter
    def format_options(self, value: Optional[pulumi.Input['JobOutputFormatOptionsArgs']]):
        pulumi.set(self, "format_options", value)

    @property
    @pulumi.getter(name="maxOutputFiles")
    def max_output_files(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of files to be generated by the job and written to the output folder.
        """
        return pulumi.get(self, "max_output_files")

    @max_output_files.setter
    def max_output_files(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_output_files", value)

    @property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that, if true, means that any data in the location specified for output is overwritten with new output.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "overwrite", value)

    @property
    @pulumi.getter(name="partitionColumns")
    def partition_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The names of one or more partition columns for the output of the job.
        """
        return pulumi.get(self, "partition_columns")

    @partition_columns.setter
    def partition_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "partition_columns", value)


if not MYPY:
    class JobProfileConfigurationArgsDict(TypedDict):
        column_statistics_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgsDict']]]]
        """
        List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select evaluations and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and run all supported evaluations.
        """
        dataset_statistics_configuration: NotRequired[pulumi.Input['JobStatisticsConfigurationArgsDict']]
        """
        Configuration for inter-column evaluations. Configuration can be used to select evaluations and override parameters of evaluations. When configuration is undefined, the profile job will run all supported inter-column evaluations.
        """
        entity_detector_configuration: NotRequired[pulumi.Input['JobEntityDetectorConfigurationArgsDict']]
        """
        Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
        """
        profile_columns: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgsDict']]]]
        """
        List of column selectors. ProfileColumns can be used to select columns from the dataset. When ProfileColumns is undefined, the profile job will profile all supported columns.
        """
elif False:
    JobProfileConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobProfileConfigurationArgs:
    def __init__(__self__, *,
                 column_statistics_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgs']]]] = None,
                 dataset_statistics_configuration: Optional[pulumi.Input['JobStatisticsConfigurationArgs']] = None,
                 entity_detector_configuration: Optional[pulumi.Input['JobEntityDetectorConfigurationArgs']] = None,
                 profile_columns: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgs']]] column_statistics_configurations: List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select evaluations and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and run all supported evaluations.
        :param pulumi.Input['JobStatisticsConfigurationArgs'] dataset_statistics_configuration: Configuration for inter-column evaluations. Configuration can be used to select evaluations and override parameters of evaluations. When configuration is undefined, the profile job will run all supported inter-column evaluations.
        :param pulumi.Input['JobEntityDetectorConfigurationArgs'] entity_detector_configuration: Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
        :param pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]] profile_columns: List of column selectors. ProfileColumns can be used to select columns from the dataset. When ProfileColumns is undefined, the profile job will profile all supported columns.
        """
        if column_statistics_configurations is not None:
            pulumi.set(__self__, "column_statistics_configurations", column_statistics_configurations)
        if dataset_statistics_configuration is not None:
            pulumi.set(__self__, "dataset_statistics_configuration", dataset_statistics_configuration)
        if entity_detector_configuration is not None:
            pulumi.set(__self__, "entity_detector_configuration", entity_detector_configuration)
        if profile_columns is not None:
            pulumi.set(__self__, "profile_columns", profile_columns)

    @property
    @pulumi.getter(name="columnStatisticsConfigurations")
    def column_statistics_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgs']]]]:
        """
        List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select evaluations and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and run all supported evaluations.
        """
        return pulumi.get(self, "column_statistics_configurations")

    @column_statistics_configurations.setter
    def column_statistics_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnStatisticsConfigurationArgs']]]]):
        pulumi.set(self, "column_statistics_configurations", value)

    @property
    @pulumi.getter(name="datasetStatisticsConfiguration")
    def dataset_statistics_configuration(self) -> Optional[pulumi.Input['JobStatisticsConfigurationArgs']]:
        """
        Configuration for inter-column evaluations. Configuration can be used to select evaluations and override parameters of evaluations. When configuration is undefined, the profile job will run all supported inter-column evaluations.
        """
        return pulumi.get(self, "dataset_statistics_configuration")

    @dataset_statistics_configuration.setter
    def dataset_statistics_configuration(self, value: Optional[pulumi.Input['JobStatisticsConfigurationArgs']]):
        pulumi.set(self, "dataset_statistics_configuration", value)

    @property
    @pulumi.getter(name="entityDetectorConfiguration")
    def entity_detector_configuration(self) -> Optional[pulumi.Input['JobEntityDetectorConfigurationArgs']]:
        """
        Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
        """
        return pulumi.get(self, "entity_detector_configuration")

    @entity_detector_configuration.setter
    def entity_detector_configuration(self, value: Optional[pulumi.Input['JobEntityDetectorConfigurationArgs']]):
        pulumi.set(self, "entity_detector_configuration", value)

    @property
    @pulumi.getter(name="profileColumns")
    def profile_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]:
        """
        List of column selectors. ProfileColumns can be used to select columns from the dataset. When ProfileColumns is undefined, the profile job will profile all supported columns.
        """
        return pulumi.get(self, "profile_columns")

    @profile_columns.setter
    def profile_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobColumnSelectorArgs']]]]):
        pulumi.set(self, "profile_columns", value)


if not MYPY:
    class JobRecipeArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Recipe name
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        Recipe version
        """
elif False:
    JobRecipeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobRecipeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: Recipe name
        :param pulumi.Input[builtins.str] version: Recipe version
        """
        pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Recipe name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Recipe version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class JobS3LocationArgsDict(TypedDict):
        """
        S3 Output location
        """
        bucket: pulumi.Input[builtins.str]
        """
        The Amazon S3 bucket name.
        """
        bucket_owner: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS account ID of the bucket owner.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique name of the object in the bucket.
        """
elif False:
    JobS3LocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None):
        """
        S3 Output location
        :param pulumi.Input[builtins.str] bucket: The Amazon S3 bucket name.
        :param pulumi.Input[builtins.str] bucket_owner: The AWS account ID of the bucket owner.
        :param pulumi.Input[builtins.str] key: The unique name of the object in the bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        if bucket_owner is not None:
            pulumi.set(__self__, "bucket_owner", bucket_owner)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon S3 bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account ID of the bucket owner.
        """
        return pulumi.get(self, "bucket_owner")

    @bucket_owner.setter
    def bucket_owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_owner", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the object in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class JobS3TableOutputOptionsArgsDict(TypedDict):
        location: pulumi.Input['JobS3LocationArgsDict']
        """
        Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
        """
elif False:
    JobS3TableOutputOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobS3TableOutputOptionsArgs:
    def __init__(__self__, *,
                 location: pulumi.Input['JobS3LocationArgs']):
        """
        :param pulumi.Input['JobS3LocationArgs'] location: Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
        """
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input['JobS3LocationArgs']:
        """
        Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input['JobS3LocationArgs']):
        pulumi.set(self, "location", value)


if not MYPY:
    class JobSampleArgsDict(TypedDict):
        """
        Job Sample
        """
        mode: NotRequired[pulumi.Input['JobSampleMode']]
        """
        A value that determines whether the profile job is run on the entire dataset or a specified number of rows. This value must be one of the following:

        - FULL_DATASET - The profile job is run on the entire dataset.
        - CUSTOM_ROWS - The profile job is run on the number of rows specified in the `Size` parameter.
        """
        size: NotRequired[pulumi.Input[builtins.int]]
        """
        The `Size` parameter is only required when the mode is CUSTOM_ROWS. The profile job is run on the specified number of rows. The maximum value for size is Long.MAX_VALUE.

        Long.MAX_VALUE = 9223372036854775807
        """
elif False:
    JobSampleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobSampleArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input['JobSampleMode']] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None):
        """
        Job Sample
        :param pulumi.Input['JobSampleMode'] mode: A value that determines whether the profile job is run on the entire dataset or a specified number of rows. This value must be one of the following:
               
               - FULL_DATASET - The profile job is run on the entire dataset.
               - CUSTOM_ROWS - The profile job is run on the number of rows specified in the `Size` parameter.
        :param pulumi.Input[builtins.int] size: The `Size` parameter is only required when the mode is CUSTOM_ROWS. The profile job is run on the specified number of rows. The maximum value for size is Long.MAX_VALUE.
               
               Long.MAX_VALUE = 9223372036854775807
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['JobSampleMode']]:
        """
        A value that determines whether the profile job is run on the entire dataset or a specified number of rows. This value must be one of the following:

        - FULL_DATASET - The profile job is run on the entire dataset.
        - CUSTOM_ROWS - The profile job is run on the number of rows specified in the `Size` parameter.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['JobSampleMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The `Size` parameter is only required when the mode is CUSTOM_ROWS. The profile job is run on the specified number of rows. The maximum value for size is Long.MAX_VALUE.

        Long.MAX_VALUE = 9223372036854775807
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class JobStatisticOverrideArgsDict(TypedDict):
        parameters: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]
        """
        A map that includes overrides of an evaluation’s parameters.
        """
        statistic: pulumi.Input[builtins.str]
        """
        The name of an evaluation
        """
elif False:
    JobStatisticOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobStatisticOverrideArgs:
    def __init__(__self__, *,
                 parameters: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 statistic: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map that includes overrides of an evaluation’s parameters.
        :param pulumi.Input[builtins.str] statistic: The name of an evaluation
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "statistic", statistic)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        A map that includes overrides of an evaluation’s parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input[builtins.str]:
        """
        The name of an evaluation
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "statistic", value)


if not MYPY:
    class JobStatisticsConfigurationArgsDict(TypedDict):
        included_statistics: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of included evaluations. When the list is undefined, all supported evaluations will be included.
        """
        overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgsDict']]]]
        """
        List of overrides for evaluations.
        """
elif False:
    JobStatisticsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobStatisticsConfigurationArgs:
    def __init__(__self__, *,
                 included_statistics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] included_statistics: List of included evaluations. When the list is undefined, all supported evaluations will be included.
        :param pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgs']]] overrides: List of overrides for evaluations.
        """
        if included_statistics is not None:
            pulumi.set(__self__, "included_statistics", included_statistics)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter(name="includedStatistics")
    def included_statistics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of included evaluations. When the list is undefined, all supported evaluations will be included.
        """
        return pulumi.get(self, "included_statistics")

    @included_statistics.setter
    def included_statistics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "included_statistics", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgs']]]]:
        """
        List of overrides for evaluations.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobStatisticOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)


if not MYPY:
    class JobValidationConfigurationArgsDict(TypedDict):
        """
        Configuration to attach Rulesets to the job
        """
        ruleset_arn: pulumi.Input[builtins.str]
        """
        Arn of the Ruleset
        """
        validation_mode: NotRequired[pulumi.Input['JobValidationMode']]
        """
        Mode of data quality validation. Default mode is "CHECK_ALL" which verifies all rules defined in the selected ruleset.
        """
elif False:
    JobValidationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobValidationConfigurationArgs:
    def __init__(__self__, *,
                 ruleset_arn: pulumi.Input[builtins.str],
                 validation_mode: Optional[pulumi.Input['JobValidationMode']] = None):
        """
        Configuration to attach Rulesets to the job
        :param pulumi.Input[builtins.str] ruleset_arn: Arn of the Ruleset
        :param pulumi.Input['JobValidationMode'] validation_mode: Mode of data quality validation. Default mode is "CHECK_ALL" which verifies all rules defined in the selected ruleset.
        """
        pulumi.set(__self__, "ruleset_arn", ruleset_arn)
        if validation_mode is not None:
            pulumi.set(__self__, "validation_mode", validation_mode)

    @property
    @pulumi.getter(name="rulesetArn")
    def ruleset_arn(self) -> pulumi.Input[builtins.str]:
        """
        Arn of the Ruleset
        """
        return pulumi.get(self, "ruleset_arn")

    @ruleset_arn.setter
    def ruleset_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ruleset_arn", value)

    @property
    @pulumi.getter(name="validationMode")
    def validation_mode(self) -> Optional[pulumi.Input['JobValidationMode']]:
        """
        Mode of data quality validation. Default mode is "CHECK_ALL" which verifies all rules defined in the selected ruleset.
        """
        return pulumi.get(self, "validation_mode")

    @validation_mode.setter
    def validation_mode(self, value: Optional[pulumi.Input['JobValidationMode']]):
        pulumi.set(self, "validation_mode", value)


if not MYPY:
    class ProjectSampleArgsDict(TypedDict):
        type: pulumi.Input['ProjectSampleType']
        """
        Sample type
        """
        size: NotRequired[pulumi.Input[builtins.int]]
        """
        Sample size
        """
elif False:
    ProjectSampleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectSampleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ProjectSampleType'],
                 size: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input['ProjectSampleType'] type: Sample type
        :param pulumi.Input[builtins.int] size: Sample size
        """
        pulumi.set(__self__, "type", type)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ProjectSampleType']:
        """
        Sample type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ProjectSampleType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Sample size
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class RecipeActionArgsDict(TypedDict):
        operation: pulumi.Input[builtins.str]
        """
        Step action operation
        """
        parameters: NotRequired[pulumi.Input[Union['RecipeParametersArgsDict', Mapping[str, pulumi.Input[builtins.str]]]]]
        """
        Contextual parameters for the transformation.
        """
elif False:
    RecipeActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeActionArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[builtins.str],
                 parameters: Optional[pulumi.Input[Union['RecipeParametersArgs', Mapping[str, pulumi.Input[builtins.str]]]]] = None):
        """
        :param pulumi.Input[builtins.str] operation: Step action operation
        :param pulumi.Input[Union['RecipeParametersArgs', Mapping[str, pulumi.Input[builtins.str]]]] parameters: Contextual parameters for the transformation.
        """
        pulumi.set(__self__, "operation", operation)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[builtins.str]:
        """
        Step action operation
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Union['RecipeParametersArgs', Mapping[str, pulumi.Input[builtins.str]]]]]:
        """
        Contextual parameters for the transformation.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Union['RecipeParametersArgs', Mapping[str, pulumi.Input[builtins.str]]]]]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class RecipeConditionExpressionArgsDict(TypedDict):
        """
        Condition expressions applied to the step action
        """
        condition: pulumi.Input[builtins.str]
        """
        Input condition to be applied to the target column
        """
        target_column: pulumi.Input[builtins.str]
        """
        Name of the target column
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        Value of the condition
        """
elif False:
    RecipeConditionExpressionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeConditionExpressionArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[builtins.str],
                 target_column: pulumi.Input[builtins.str],
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Condition expressions applied to the step action
        :param pulumi.Input[builtins.str] condition: Input condition to be applied to the target column
        :param pulumi.Input[builtins.str] target_column: Name of the target column
        :param pulumi.Input[builtins.str] value: Value of the condition
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "target_column", target_column)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[builtins.str]:
        """
        Input condition to be applied to the target column
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="targetColumn")
    def target_column(self) -> pulumi.Input[builtins.str]:
        """
        Name of the target column
        """
        return pulumi.get(self, "target_column")

    @target_column.setter
    def target_column(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_column", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value of the condition
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RecipeDataCatalogInputDefinitionArgsDict(TypedDict):
        catalog_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Catalog id
        """
        database_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Database name
        """
        table_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Table name
        """
        temp_directory: NotRequired[pulumi.Input['RecipeS3LocationArgsDict']]
elif False:
    RecipeDataCatalogInputDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeDataCatalogInputDefinitionArgs:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 table_name: Optional[pulumi.Input[builtins.str]] = None,
                 temp_directory: Optional[pulumi.Input['RecipeS3LocationArgs']] = None):
        """
        :param pulumi.Input[builtins.str] catalog_id: Catalog id
        :param pulumi.Input[builtins.str] database_name: Database name
        :param pulumi.Input[builtins.str] table_name: Table name
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if temp_directory is not None:
            pulumi.set(__self__, "temp_directory", temp_directory)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Catalog id
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Database name
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Table name
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tempDirectory")
    def temp_directory(self) -> Optional[pulumi.Input['RecipeS3LocationArgs']]:
        return pulumi.get(self, "temp_directory")

    @temp_directory.setter
    def temp_directory(self, value: Optional[pulumi.Input['RecipeS3LocationArgs']]):
        pulumi.set(self, "temp_directory", value)


if not MYPY:
    class RecipeParametersInputPropertiesArgsDict(TypedDict):
        """
        Input
        """
        data_catalog_input_definition: NotRequired[pulumi.Input['RecipeDataCatalogInputDefinitionArgsDict']]
        s3_input_definition: NotRequired[pulumi.Input['RecipeS3LocationArgsDict']]
elif False:
    RecipeParametersInputPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeParametersInputPropertiesArgs:
    def __init__(__self__, *,
                 data_catalog_input_definition: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']] = None,
                 s3_input_definition: Optional[pulumi.Input['RecipeS3LocationArgs']] = None):
        """
        Input
        """
        if data_catalog_input_definition is not None:
            pulumi.set(__self__, "data_catalog_input_definition", data_catalog_input_definition)
        if s3_input_definition is not None:
            pulumi.set(__self__, "s3_input_definition", s3_input_definition)

    @property
    @pulumi.getter(name="dataCatalogInputDefinition")
    def data_catalog_input_definition(self) -> Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]:
        return pulumi.get(self, "data_catalog_input_definition")

    @data_catalog_input_definition.setter
    def data_catalog_input_definition(self, value: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]):
        pulumi.set(self, "data_catalog_input_definition", value)

    @property
    @pulumi.getter(name="s3InputDefinition")
    def s3_input_definition(self) -> Optional[pulumi.Input['RecipeS3LocationArgs']]:
        return pulumi.get(self, "s3_input_definition")

    @s3_input_definition.setter
    def s3_input_definition(self, value: Optional[pulumi.Input['RecipeS3LocationArgs']]):
        pulumi.set(self, "s3_input_definition", value)


if not MYPY:
    class RecipeParametersArgsDict(TypedDict):
        aggregate_function: NotRequired[pulumi.Input[builtins.str]]
        base: NotRequired[pulumi.Input[builtins.str]]
        case_statement: NotRequired[pulumi.Input[builtins.str]]
        category_map: NotRequired[pulumi.Input[builtins.str]]
        chars_to_remove: NotRequired[pulumi.Input[builtins.str]]
        collapse_consecutive_whitespace: NotRequired[pulumi.Input[builtins.str]]
        column_data_type: NotRequired[pulumi.Input[builtins.str]]
        column_range: NotRequired[pulumi.Input[builtins.str]]
        count: NotRequired[pulumi.Input[builtins.str]]
        custom_characters: NotRequired[pulumi.Input[builtins.str]]
        custom_stop_words: NotRequired[pulumi.Input[builtins.str]]
        custom_value: NotRequired[pulumi.Input[builtins.str]]
        datasets_columns: NotRequired[pulumi.Input[builtins.str]]
        date_add_value: NotRequired[pulumi.Input[builtins.str]]
        date_time_format: NotRequired[pulumi.Input[builtins.str]]
        date_time_parameters: NotRequired[pulumi.Input[builtins.str]]
        delete_other_rows: NotRequired[pulumi.Input[builtins.str]]
        delimiter: NotRequired[pulumi.Input[builtins.str]]
        end_pattern: NotRequired[pulumi.Input[builtins.str]]
        end_position: NotRequired[pulumi.Input[builtins.str]]
        end_value: NotRequired[pulumi.Input[builtins.str]]
        expand_contractions: NotRequired[pulumi.Input[builtins.str]]
        exponent: NotRequired[pulumi.Input[builtins.str]]
        false_string: NotRequired[pulumi.Input[builtins.str]]
        group_by_agg_function_options: NotRequired[pulumi.Input[builtins.str]]
        group_by_columns: NotRequired[pulumi.Input[builtins.str]]
        hidden_columns: NotRequired[pulumi.Input[builtins.str]]
        ignore_case: NotRequired[pulumi.Input[builtins.str]]
        include_in_split: NotRequired[pulumi.Input[builtins.str]]
        input: NotRequired[pulumi.Input['RecipeParametersInputPropertiesArgsDict']]
        """
        Input
        """
        interval: NotRequired[pulumi.Input[builtins.str]]
        is_text: NotRequired[pulumi.Input[builtins.str]]
        join_keys: NotRequired[pulumi.Input[builtins.str]]
        join_type: NotRequired[pulumi.Input[builtins.str]]
        left_columns: NotRequired[pulumi.Input[builtins.str]]
        limit: NotRequired[pulumi.Input[builtins.str]]
        lower_bound: NotRequired[pulumi.Input[builtins.str]]
        map_type: NotRequired[pulumi.Input[builtins.str]]
        mode_type: NotRequired[pulumi.Input[builtins.str]]
        multi_line: NotRequired[pulumi.Input[builtins.bool]]
        num_rows: NotRequired[pulumi.Input[builtins.str]]
        num_rows_after: NotRequired[pulumi.Input[builtins.str]]
        num_rows_before: NotRequired[pulumi.Input[builtins.str]]
        order_by_column: NotRequired[pulumi.Input[builtins.str]]
        order_by_columns: NotRequired[pulumi.Input[builtins.str]]
        other: NotRequired[pulumi.Input[builtins.str]]
        pattern: NotRequired[pulumi.Input[builtins.str]]
        pattern_option1: NotRequired[pulumi.Input[builtins.str]]
        pattern_option2: NotRequired[pulumi.Input[builtins.str]]
        pattern_options: NotRequired[pulumi.Input[builtins.str]]
        period: NotRequired[pulumi.Input[builtins.str]]
        position: NotRequired[pulumi.Input[builtins.str]]
        remove_all_punctuation: NotRequired[pulumi.Input[builtins.str]]
        remove_all_quotes: NotRequired[pulumi.Input[builtins.str]]
        remove_all_whitespace: NotRequired[pulumi.Input[builtins.str]]
        remove_custom_characters: NotRequired[pulumi.Input[builtins.str]]
        remove_custom_value: NotRequired[pulumi.Input[builtins.str]]
        remove_leading_and_trailing_punctuation: NotRequired[pulumi.Input[builtins.str]]
        remove_leading_and_trailing_quotes: NotRequired[pulumi.Input[builtins.str]]
        remove_leading_and_trailing_whitespace: NotRequired[pulumi.Input[builtins.str]]
        remove_letters: NotRequired[pulumi.Input[builtins.str]]
        remove_numbers: NotRequired[pulumi.Input[builtins.str]]
        remove_source_column: NotRequired[pulumi.Input[builtins.str]]
        remove_special_characters: NotRequired[pulumi.Input[builtins.str]]
        right_columns: NotRequired[pulumi.Input[builtins.str]]
        sample_size: NotRequired[pulumi.Input[builtins.str]]
        sample_type: NotRequired[pulumi.Input[builtins.str]]
        second_input: NotRequired[pulumi.Input[builtins.str]]
        secondary_inputs: NotRequired[pulumi.Input[Sequence[pulumi.Input['RecipeSecondaryInputArgsDict']]]]
        sheet_indexes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        sheet_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        source_column: NotRequired[pulumi.Input[builtins.str]]
        source_column1: NotRequired[pulumi.Input[builtins.str]]
        source_column2: NotRequired[pulumi.Input[builtins.str]]
        source_columns: NotRequired[pulumi.Input[builtins.str]]
        start_column_index: NotRequired[pulumi.Input[builtins.str]]
        start_pattern: NotRequired[pulumi.Input[builtins.str]]
        start_position: NotRequired[pulumi.Input[builtins.str]]
        start_value: NotRequired[pulumi.Input[builtins.str]]
        stemming_mode: NotRequired[pulumi.Input[builtins.str]]
        step_count: NotRequired[pulumi.Input[builtins.str]]
        step_index: NotRequired[pulumi.Input[builtins.str]]
        stop_words_mode: NotRequired[pulumi.Input[builtins.str]]
        strategy: NotRequired[pulumi.Input[builtins.str]]
        target_column: NotRequired[pulumi.Input[builtins.str]]
        target_column_names: NotRequired[pulumi.Input[builtins.str]]
        target_date_format: NotRequired[pulumi.Input[builtins.str]]
        target_index: NotRequired[pulumi.Input[builtins.str]]
        time_zone: NotRequired[pulumi.Input[builtins.str]]
        tokenizer_pattern: NotRequired[pulumi.Input[builtins.str]]
        true_string: NotRequired[pulumi.Input[builtins.str]]
        udf_lang: NotRequired[pulumi.Input[builtins.str]]
        units: NotRequired[pulumi.Input[builtins.str]]
        unpivot_column: NotRequired[pulumi.Input[builtins.str]]
        upper_bound: NotRequired[pulumi.Input[builtins.str]]
        use_new_data_frame: NotRequired[pulumi.Input[builtins.str]]
        value: NotRequired[pulumi.Input[builtins.str]]
        value1: NotRequired[pulumi.Input[builtins.str]]
        value2: NotRequired[pulumi.Input[builtins.str]]
        value_column: NotRequired[pulumi.Input[builtins.str]]
        view_frame: NotRequired[pulumi.Input[builtins.str]]
elif False:
    RecipeParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeParametersArgs:
    def __init__(__self__, *,
                 aggregate_function: Optional[pulumi.Input[builtins.str]] = None,
                 base: Optional[pulumi.Input[builtins.str]] = None,
                 case_statement: Optional[pulumi.Input[builtins.str]] = None,
                 category_map: Optional[pulumi.Input[builtins.str]] = None,
                 chars_to_remove: Optional[pulumi.Input[builtins.str]] = None,
                 collapse_consecutive_whitespace: Optional[pulumi.Input[builtins.str]] = None,
                 column_data_type: Optional[pulumi.Input[builtins.str]] = None,
                 column_range: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.str]] = None,
                 custom_characters: Optional[pulumi.Input[builtins.str]] = None,
                 custom_stop_words: Optional[pulumi.Input[builtins.str]] = None,
                 custom_value: Optional[pulumi.Input[builtins.str]] = None,
                 datasets_columns: Optional[pulumi.Input[builtins.str]] = None,
                 date_add_value: Optional[pulumi.Input[builtins.str]] = None,
                 date_time_format: Optional[pulumi.Input[builtins.str]] = None,
                 date_time_parameters: Optional[pulumi.Input[builtins.str]] = None,
                 delete_other_rows: Optional[pulumi.Input[builtins.str]] = None,
                 delimiter: Optional[pulumi.Input[builtins.str]] = None,
                 end_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 end_position: Optional[pulumi.Input[builtins.str]] = None,
                 end_value: Optional[pulumi.Input[builtins.str]] = None,
                 expand_contractions: Optional[pulumi.Input[builtins.str]] = None,
                 exponent: Optional[pulumi.Input[builtins.str]] = None,
                 false_string: Optional[pulumi.Input[builtins.str]] = None,
                 group_by_agg_function_options: Optional[pulumi.Input[builtins.str]] = None,
                 group_by_columns: Optional[pulumi.Input[builtins.str]] = None,
                 hidden_columns: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_case: Optional[pulumi.Input[builtins.str]] = None,
                 include_in_split: Optional[pulumi.Input[builtins.str]] = None,
                 input: Optional[pulumi.Input['RecipeParametersInputPropertiesArgs']] = None,
                 interval: Optional[pulumi.Input[builtins.str]] = None,
                 is_text: Optional[pulumi.Input[builtins.str]] = None,
                 join_keys: Optional[pulumi.Input[builtins.str]] = None,
                 join_type: Optional[pulumi.Input[builtins.str]] = None,
                 left_columns: Optional[pulumi.Input[builtins.str]] = None,
                 limit: Optional[pulumi.Input[builtins.str]] = None,
                 lower_bound: Optional[pulumi.Input[builtins.str]] = None,
                 map_type: Optional[pulumi.Input[builtins.str]] = None,
                 mode_type: Optional[pulumi.Input[builtins.str]] = None,
                 multi_line: Optional[pulumi.Input[builtins.bool]] = None,
                 num_rows: Optional[pulumi.Input[builtins.str]] = None,
                 num_rows_after: Optional[pulumi.Input[builtins.str]] = None,
                 num_rows_before: Optional[pulumi.Input[builtins.str]] = None,
                 order_by_column: Optional[pulumi.Input[builtins.str]] = None,
                 order_by_columns: Optional[pulumi.Input[builtins.str]] = None,
                 other: Optional[pulumi.Input[builtins.str]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_option1: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_option2: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_options: Optional[pulumi.Input[builtins.str]] = None,
                 period: Optional[pulumi.Input[builtins.str]] = None,
                 position: Optional[pulumi.Input[builtins.str]] = None,
                 remove_all_punctuation: Optional[pulumi.Input[builtins.str]] = None,
                 remove_all_quotes: Optional[pulumi.Input[builtins.str]] = None,
                 remove_all_whitespace: Optional[pulumi.Input[builtins.str]] = None,
                 remove_custom_characters: Optional[pulumi.Input[builtins.str]] = None,
                 remove_custom_value: Optional[pulumi.Input[builtins.str]] = None,
                 remove_leading_and_trailing_punctuation: Optional[pulumi.Input[builtins.str]] = None,
                 remove_leading_and_trailing_quotes: Optional[pulumi.Input[builtins.str]] = None,
                 remove_leading_and_trailing_whitespace: Optional[pulumi.Input[builtins.str]] = None,
                 remove_letters: Optional[pulumi.Input[builtins.str]] = None,
                 remove_numbers: Optional[pulumi.Input[builtins.str]] = None,
                 remove_source_column: Optional[pulumi.Input[builtins.str]] = None,
                 remove_special_characters: Optional[pulumi.Input[builtins.str]] = None,
                 right_columns: Optional[pulumi.Input[builtins.str]] = None,
                 sample_size: Optional[pulumi.Input[builtins.str]] = None,
                 sample_type: Optional[pulumi.Input[builtins.str]] = None,
                 second_input: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeSecondaryInputArgs']]]] = None,
                 sheet_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 sheet_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_column: Optional[pulumi.Input[builtins.str]] = None,
                 source_column1: Optional[pulumi.Input[builtins.str]] = None,
                 source_column2: Optional[pulumi.Input[builtins.str]] = None,
                 source_columns: Optional[pulumi.Input[builtins.str]] = None,
                 start_column_index: Optional[pulumi.Input[builtins.str]] = None,
                 start_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 start_position: Optional[pulumi.Input[builtins.str]] = None,
                 start_value: Optional[pulumi.Input[builtins.str]] = None,
                 stemming_mode: Optional[pulumi.Input[builtins.str]] = None,
                 step_count: Optional[pulumi.Input[builtins.str]] = None,
                 step_index: Optional[pulumi.Input[builtins.str]] = None,
                 stop_words_mode: Optional[pulumi.Input[builtins.str]] = None,
                 strategy: Optional[pulumi.Input[builtins.str]] = None,
                 target_column: Optional[pulumi.Input[builtins.str]] = None,
                 target_column_names: Optional[pulumi.Input[builtins.str]] = None,
                 target_date_format: Optional[pulumi.Input[builtins.str]] = None,
                 target_index: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 tokenizer_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 true_string: Optional[pulumi.Input[builtins.str]] = None,
                 udf_lang: Optional[pulumi.Input[builtins.str]] = None,
                 units: Optional[pulumi.Input[builtins.str]] = None,
                 unpivot_column: Optional[pulumi.Input[builtins.str]] = None,
                 upper_bound: Optional[pulumi.Input[builtins.str]] = None,
                 use_new_data_frame: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 value1: Optional[pulumi.Input[builtins.str]] = None,
                 value2: Optional[pulumi.Input[builtins.str]] = None,
                 value_column: Optional[pulumi.Input[builtins.str]] = None,
                 view_frame: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['RecipeParametersInputPropertiesArgs'] input: Input
        """
        if aggregate_function is not None:
            pulumi.set(__self__, "aggregate_function", aggregate_function)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if case_statement is not None:
            pulumi.set(__self__, "case_statement", case_statement)
        if category_map is not None:
            pulumi.set(__self__, "category_map", category_map)
        if chars_to_remove is not None:
            pulumi.set(__self__, "chars_to_remove", chars_to_remove)
        if collapse_consecutive_whitespace is not None:
            pulumi.set(__self__, "collapse_consecutive_whitespace", collapse_consecutive_whitespace)
        if column_data_type is not None:
            pulumi.set(__self__, "column_data_type", column_data_type)
        if column_range is not None:
            pulumi.set(__self__, "column_range", column_range)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if custom_characters is not None:
            pulumi.set(__self__, "custom_characters", custom_characters)
        if custom_stop_words is not None:
            pulumi.set(__self__, "custom_stop_words", custom_stop_words)
        if custom_value is not None:
            pulumi.set(__self__, "custom_value", custom_value)
        if datasets_columns is not None:
            pulumi.set(__self__, "datasets_columns", datasets_columns)
        if date_add_value is not None:
            pulumi.set(__self__, "date_add_value", date_add_value)
        if date_time_format is not None:
            pulumi.set(__self__, "date_time_format", date_time_format)
        if date_time_parameters is not None:
            pulumi.set(__self__, "date_time_parameters", date_time_parameters)
        if delete_other_rows is not None:
            pulumi.set(__self__, "delete_other_rows", delete_other_rows)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if end_pattern is not None:
            pulumi.set(__self__, "end_pattern", end_pattern)
        if end_position is not None:
            pulumi.set(__self__, "end_position", end_position)
        if end_value is not None:
            pulumi.set(__self__, "end_value", end_value)
        if expand_contractions is not None:
            pulumi.set(__self__, "expand_contractions", expand_contractions)
        if exponent is not None:
            pulumi.set(__self__, "exponent", exponent)
        if false_string is not None:
            pulumi.set(__self__, "false_string", false_string)
        if group_by_agg_function_options is not None:
            pulumi.set(__self__, "group_by_agg_function_options", group_by_agg_function_options)
        if group_by_columns is not None:
            pulumi.set(__self__, "group_by_columns", group_by_columns)
        if hidden_columns is not None:
            pulumi.set(__self__, "hidden_columns", hidden_columns)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if include_in_split is not None:
            pulumi.set(__self__, "include_in_split", include_in_split)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if is_text is not None:
            pulumi.set(__self__, "is_text", is_text)
        if join_keys is not None:
            pulumi.set(__self__, "join_keys", join_keys)
        if join_type is not None:
            pulumi.set(__self__, "join_type", join_type)
        if left_columns is not None:
            pulumi.set(__self__, "left_columns", left_columns)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if lower_bound is not None:
            pulumi.set(__self__, "lower_bound", lower_bound)
        if map_type is not None:
            pulumi.set(__self__, "map_type", map_type)
        if mode_type is not None:
            pulumi.set(__self__, "mode_type", mode_type)
        if multi_line is not None:
            pulumi.set(__self__, "multi_line", multi_line)
        if num_rows is not None:
            pulumi.set(__self__, "num_rows", num_rows)
        if num_rows_after is not None:
            pulumi.set(__self__, "num_rows_after", num_rows_after)
        if num_rows_before is not None:
            pulumi.set(__self__, "num_rows_before", num_rows_before)
        if order_by_column is not None:
            pulumi.set(__self__, "order_by_column", order_by_column)
        if order_by_columns is not None:
            pulumi.set(__self__, "order_by_columns", order_by_columns)
        if other is not None:
            pulumi.set(__self__, "other", other)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_option1 is not None:
            pulumi.set(__self__, "pattern_option1", pattern_option1)
        if pattern_option2 is not None:
            pulumi.set(__self__, "pattern_option2", pattern_option2)
        if pattern_options is not None:
            pulumi.set(__self__, "pattern_options", pattern_options)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if remove_all_punctuation is not None:
            pulumi.set(__self__, "remove_all_punctuation", remove_all_punctuation)
        if remove_all_quotes is not None:
            pulumi.set(__self__, "remove_all_quotes", remove_all_quotes)
        if remove_all_whitespace is not None:
            pulumi.set(__self__, "remove_all_whitespace", remove_all_whitespace)
        if remove_custom_characters is not None:
            pulumi.set(__self__, "remove_custom_characters", remove_custom_characters)
        if remove_custom_value is not None:
            pulumi.set(__self__, "remove_custom_value", remove_custom_value)
        if remove_leading_and_trailing_punctuation is not None:
            pulumi.set(__self__, "remove_leading_and_trailing_punctuation", remove_leading_and_trailing_punctuation)
        if remove_leading_and_trailing_quotes is not None:
            pulumi.set(__self__, "remove_leading_and_trailing_quotes", remove_leading_and_trailing_quotes)
        if remove_leading_and_trailing_whitespace is not None:
            pulumi.set(__self__, "remove_leading_and_trailing_whitespace", remove_leading_and_trailing_whitespace)
        if remove_letters is not None:
            pulumi.set(__self__, "remove_letters", remove_letters)
        if remove_numbers is not None:
            pulumi.set(__self__, "remove_numbers", remove_numbers)
        if remove_source_column is not None:
            pulumi.set(__self__, "remove_source_column", remove_source_column)
        if remove_special_characters is not None:
            pulumi.set(__self__, "remove_special_characters", remove_special_characters)
        if right_columns is not None:
            pulumi.set(__self__, "right_columns", right_columns)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if sample_type is not None:
            pulumi.set(__self__, "sample_type", sample_type)
        if second_input is not None:
            pulumi.set(__self__, "second_input", second_input)
        if secondary_inputs is not None:
            pulumi.set(__self__, "secondary_inputs", secondary_inputs)
        if sheet_indexes is not None:
            pulumi.set(__self__, "sheet_indexes", sheet_indexes)
        if sheet_names is not None:
            pulumi.set(__self__, "sheet_names", sheet_names)
        if source_column is not None:
            pulumi.set(__self__, "source_column", source_column)
        if source_column1 is not None:
            pulumi.set(__self__, "source_column1", source_column1)
        if source_column2 is not None:
            pulumi.set(__self__, "source_column2", source_column2)
        if source_columns is not None:
            pulumi.set(__self__, "source_columns", source_columns)
        if start_column_index is not None:
            pulumi.set(__self__, "start_column_index", start_column_index)
        if start_pattern is not None:
            pulumi.set(__self__, "start_pattern", start_pattern)
        if start_position is not None:
            pulumi.set(__self__, "start_position", start_position)
        if start_value is not None:
            pulumi.set(__self__, "start_value", start_value)
        if stemming_mode is not None:
            pulumi.set(__self__, "stemming_mode", stemming_mode)
        if step_count is not None:
            pulumi.set(__self__, "step_count", step_count)
        if step_index is not None:
            pulumi.set(__self__, "step_index", step_index)
        if stop_words_mode is not None:
            pulumi.set(__self__, "stop_words_mode", stop_words_mode)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if target_column is not None:
            pulumi.set(__self__, "target_column", target_column)
        if target_column_names is not None:
            pulumi.set(__self__, "target_column_names", target_column_names)
        if target_date_format is not None:
            pulumi.set(__self__, "target_date_format", target_date_format)
        if target_index is not None:
            pulumi.set(__self__, "target_index", target_index)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if tokenizer_pattern is not None:
            pulumi.set(__self__, "tokenizer_pattern", tokenizer_pattern)
        if true_string is not None:
            pulumi.set(__self__, "true_string", true_string)
        if udf_lang is not None:
            pulumi.set(__self__, "udf_lang", udf_lang)
        if units is not None:
            pulumi.set(__self__, "units", units)
        if unpivot_column is not None:
            pulumi.set(__self__, "unpivot_column", unpivot_column)
        if upper_bound is not None:
            pulumi.set(__self__, "upper_bound", upper_bound)
        if use_new_data_frame is not None:
            pulumi.set(__self__, "use_new_data_frame", use_new_data_frame)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value1 is not None:
            pulumi.set(__self__, "value1", value1)
        if value2 is not None:
            pulumi.set(__self__, "value2", value2)
        if value_column is not None:
            pulumi.set(__self__, "value_column", value_column)
        if view_frame is not None:
            pulumi.set(__self__, "view_frame", view_frame)

    @property
    @pulumi.getter(name="aggregateFunction")
    def aggregate_function(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "aggregate_function")

    @aggregate_function.setter
    def aggregate_function(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aggregate_function", value)

    @property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base", value)

    @property
    @pulumi.getter(name="caseStatement")
    def case_statement(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "case_statement")

    @case_statement.setter
    def case_statement(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "case_statement", value)

    @property
    @pulumi.getter(name="categoryMap")
    def category_map(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "category_map")

    @category_map.setter
    def category_map(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "category_map", value)

    @property
    @pulumi.getter(name="charsToRemove")
    def chars_to_remove(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "chars_to_remove")

    @chars_to_remove.setter
    def chars_to_remove(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "chars_to_remove", value)

    @property
    @pulumi.getter(name="collapseConsecutiveWhitespace")
    def collapse_consecutive_whitespace(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "collapse_consecutive_whitespace")

    @collapse_consecutive_whitespace.setter
    def collapse_consecutive_whitespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collapse_consecutive_whitespace", value)

    @property
    @pulumi.getter(name="columnDataType")
    def column_data_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "column_data_type")

    @column_data_type.setter
    def column_data_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "column_data_type", value)

    @property
    @pulumi.getter(name="columnRange")
    def column_range(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "column_range")

    @column_range.setter
    def column_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "column_range", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="customCharacters")
    def custom_characters(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "custom_characters")

    @custom_characters.setter
    def custom_characters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_characters", value)

    @property
    @pulumi.getter(name="customStopWords")
    def custom_stop_words(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "custom_stop_words")

    @custom_stop_words.setter
    def custom_stop_words(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_stop_words", value)

    @property
    @pulumi.getter(name="customValue")
    def custom_value(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "custom_value")

    @custom_value.setter
    def custom_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_value", value)

    @property
    @pulumi.getter(name="datasetsColumns")
    def datasets_columns(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "datasets_columns")

    @datasets_columns.setter
    def datasets_columns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datasets_columns", value)

    @property
    @pulumi.getter(name="dateAddValue")
    def date_add_value(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "date_add_value")

    @date_add_value.setter
    def date_add_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_add_value", value)

    @property
    @pulumi.getter(name="dateTimeFormat")
    def date_time_format(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "date_time_format")

    @date_time_format.setter
    def date_time_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_time_format", value)

    @property
    @pulumi.getter(name="dateTimeParameters")
    def date_time_parameters(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "date_time_parameters")

    @date_time_parameters.setter
    def date_time_parameters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_time_parameters", value)

    @property
    @pulumi.getter(name="deleteOtherRows")
    def delete_other_rows(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "delete_other_rows")

    @delete_other_rows.setter
    def delete_other_rows(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_other_rows", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="endPattern")
    def end_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "end_pattern")

    @end_pattern.setter
    def end_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_pattern", value)

    @property
    @pulumi.getter(name="endPosition")
    def end_position(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "end_position")

    @end_position.setter
    def end_position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_position", value)

    @property
    @pulumi.getter(name="endValue")
    def end_value(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "end_value")

    @end_value.setter
    def end_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_value", value)

    @property
    @pulumi.getter(name="expandContractions")
    def expand_contractions(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "expand_contractions")

    @expand_contractions.setter
    def expand_contractions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expand_contractions", value)

    @property
    @pulumi.getter
    def exponent(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "exponent")

    @exponent.setter
    def exponent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exponent", value)

    @property
    @pulumi.getter(name="falseString")
    def false_string(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "false_string")

    @false_string.setter
    def false_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "false_string", value)

    @property
    @pulumi.getter(name="groupByAggFunctionOptions")
    def group_by_agg_function_options(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "group_by_agg_function_options")

    @group_by_agg_function_options.setter
    def group_by_agg_function_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_by_agg_function_options", value)

    @property
    @pulumi.getter(name="groupByColumns")
    def group_by_columns(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "group_by_columns")

    @group_by_columns.setter
    def group_by_columns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_by_columns", value)

    @property
    @pulumi.getter(name="hiddenColumns")
    def hidden_columns(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "hidden_columns")

    @hidden_columns.setter
    def hidden_columns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hidden_columns", value)

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ignore_case")

    @ignore_case.setter
    def ignore_case(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ignore_case", value)

    @property
    @pulumi.getter(name="includeInSplit")
    def include_in_split(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "include_in_split")

    @include_in_split.setter
    def include_in_split(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "include_in_split", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['RecipeParametersInputPropertiesArgs']]:
        """
        Input
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['RecipeParametersInputPropertiesArgs']]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="isText")
    def is_text(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "is_text")

    @is_text.setter
    def is_text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "is_text", value)

    @property
    @pulumi.getter(name="joinKeys")
    def join_keys(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "join_keys")

    @join_keys.setter
    def join_keys(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "join_keys", value)

    @property
    @pulumi.getter(name="joinType")
    def join_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "join_type")

    @join_type.setter
    def join_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "join_type", value)

    @property
    @pulumi.getter(name="leftColumns")
    def left_columns(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "left_columns")

    @left_columns.setter
    def left_columns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "left_columns", value)

    @property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "lower_bound")

    @lower_bound.setter
    def lower_bound(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lower_bound", value)

    @property
    @pulumi.getter(name="mapType")
    def map_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "map_type")

    @map_type.setter
    def map_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "map_type", value)

    @property
    @pulumi.getter(name="modeType")
    def mode_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "mode_type")

    @mode_type.setter
    def mode_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode_type", value)

    @property
    @pulumi.getter(name="multiLine")
    def multi_line(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "multi_line")

    @multi_line.setter
    def multi_line(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multi_line", value)

    @property
    @pulumi.getter(name="numRows")
    def num_rows(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "num_rows")

    @num_rows.setter
    def num_rows(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "num_rows", value)

    @property
    @pulumi.getter(name="numRowsAfter")
    def num_rows_after(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "num_rows_after")

    @num_rows_after.setter
    def num_rows_after(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "num_rows_after", value)

    @property
    @pulumi.getter(name="numRowsBefore")
    def num_rows_before(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "num_rows_before")

    @num_rows_before.setter
    def num_rows_before(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "num_rows_before", value)

    @property
    @pulumi.getter(name="orderByColumn")
    def order_by_column(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "order_by_column")

    @order_by_column.setter
    def order_by_column(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "order_by_column", value)

    @property
    @pulumi.getter(name="orderByColumns")
    def order_by_columns(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "order_by_columns")

    @order_by_columns.setter
    def order_by_columns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "order_by_columns", value)

    @property
    @pulumi.getter
    def other(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "other")

    @other.setter
    def other(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "other", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="patternOption1")
    def pattern_option1(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "pattern_option1")

    @pattern_option1.setter
    def pattern_option1(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_option1", value)

    @property
    @pulumi.getter(name="patternOption2")
    def pattern_option2(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "pattern_option2")

    @pattern_option2.setter
    def pattern_option2(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_option2", value)

    @property
    @pulumi.getter(name="patternOptions")
    def pattern_options(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "pattern_options")

    @pattern_options.setter
    def pattern_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_options", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="removeAllPunctuation")
    def remove_all_punctuation(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_all_punctuation")

    @remove_all_punctuation.setter
    def remove_all_punctuation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_all_punctuation", value)

    @property
    @pulumi.getter(name="removeAllQuotes")
    def remove_all_quotes(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_all_quotes")

    @remove_all_quotes.setter
    def remove_all_quotes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_all_quotes", value)

    @property
    @pulumi.getter(name="removeAllWhitespace")
    def remove_all_whitespace(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_all_whitespace")

    @remove_all_whitespace.setter
    def remove_all_whitespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_all_whitespace", value)

    @property
    @pulumi.getter(name="removeCustomCharacters")
    def remove_custom_characters(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_custom_characters")

    @remove_custom_characters.setter
    def remove_custom_characters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_custom_characters", value)

    @property
    @pulumi.getter(name="removeCustomValue")
    def remove_custom_value(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_custom_value")

    @remove_custom_value.setter
    def remove_custom_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_custom_value", value)

    @property
    @pulumi.getter(name="removeLeadingAndTrailingPunctuation")
    def remove_leading_and_trailing_punctuation(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_leading_and_trailing_punctuation")

    @remove_leading_and_trailing_punctuation.setter
    def remove_leading_and_trailing_punctuation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_leading_and_trailing_punctuation", value)

    @property
    @pulumi.getter(name="removeLeadingAndTrailingQuotes")
    def remove_leading_and_trailing_quotes(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_leading_and_trailing_quotes")

    @remove_leading_and_trailing_quotes.setter
    def remove_leading_and_trailing_quotes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_leading_and_trailing_quotes", value)

    @property
    @pulumi.getter(name="removeLeadingAndTrailingWhitespace")
    def remove_leading_and_trailing_whitespace(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_leading_and_trailing_whitespace")

    @remove_leading_and_trailing_whitespace.setter
    def remove_leading_and_trailing_whitespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_leading_and_trailing_whitespace", value)

    @property
    @pulumi.getter(name="removeLetters")
    def remove_letters(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_letters")

    @remove_letters.setter
    def remove_letters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_letters", value)

    @property
    @pulumi.getter(name="removeNumbers")
    def remove_numbers(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_numbers")

    @remove_numbers.setter
    def remove_numbers(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_numbers", value)

    @property
    @pulumi.getter(name="removeSourceColumn")
    def remove_source_column(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_source_column")

    @remove_source_column.setter
    def remove_source_column(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_source_column", value)

    @property
    @pulumi.getter(name="removeSpecialCharacters")
    def remove_special_characters(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "remove_special_characters")

    @remove_special_characters.setter
    def remove_special_characters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remove_special_characters", value)

    @property
    @pulumi.getter(name="rightColumns")
    def right_columns(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "right_columns")

    @right_columns.setter
    def right_columns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "right_columns", value)

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "sample_size")

    @sample_size.setter
    def sample_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sample_size", value)

    @property
    @pulumi.getter(name="sampleType")
    def sample_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "sample_type")

    @sample_type.setter
    def sample_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sample_type", value)

    @property
    @pulumi.getter(name="secondInput")
    def second_input(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "second_input")

    @second_input.setter
    def second_input(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "second_input", value)

    @property
    @pulumi.getter(name="secondaryInputs")
    def secondary_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipeSecondaryInputArgs']]]]:
        return pulumi.get(self, "secondary_inputs")

    @secondary_inputs.setter
    def secondary_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeSecondaryInputArgs']]]]):
        pulumi.set(self, "secondary_inputs", value)

    @property
    @pulumi.getter(name="sheetIndexes")
    def sheet_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        return pulumi.get(self, "sheet_indexes")

    @sheet_indexes.setter
    def sheet_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "sheet_indexes", value)

    @property
    @pulumi.getter(name="sheetNames")
    def sheet_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "sheet_names")

    @sheet_names.setter
    def sheet_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sheet_names", value)

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "source_column")

    @source_column.setter
    def source_column(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_column", value)

    @property
    @pulumi.getter(name="sourceColumn1")
    def source_column1(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "source_column1")

    @source_column1.setter
    def source_column1(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_column1", value)

    @property
    @pulumi.getter(name="sourceColumn2")
    def source_column2(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "source_column2")

    @source_column2.setter
    def source_column2(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_column2", value)

    @property
    @pulumi.getter(name="sourceColumns")
    def source_columns(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "source_columns")

    @source_columns.setter
    def source_columns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_columns", value)

    @property
    @pulumi.getter(name="startColumnIndex")
    def start_column_index(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "start_column_index")

    @start_column_index.setter
    def start_column_index(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_column_index", value)

    @property
    @pulumi.getter(name="startPattern")
    def start_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "start_pattern")

    @start_pattern.setter
    def start_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_pattern", value)

    @property
    @pulumi.getter(name="startPosition")
    def start_position(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "start_position")

    @start_position.setter
    def start_position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_position", value)

    @property
    @pulumi.getter(name="startValue")
    def start_value(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "start_value")

    @start_value.setter
    def start_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_value", value)

    @property
    @pulumi.getter(name="stemmingMode")
    def stemming_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "stemming_mode")

    @stemming_mode.setter
    def stemming_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stemming_mode", value)

    @property
    @pulumi.getter(name="stepCount")
    def step_count(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "step_count")

    @step_count.setter
    def step_count(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "step_count", value)

    @property
    @pulumi.getter(name="stepIndex")
    def step_index(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "step_index")

    @step_index.setter
    def step_index(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "step_index", value)

    @property
    @pulumi.getter(name="stopWordsMode")
    def stop_words_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "stop_words_mode")

    @stop_words_mode.setter
    def stop_words_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stop_words_mode", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter(name="targetColumn")
    def target_column(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "target_column")

    @target_column.setter
    def target_column(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_column", value)

    @property
    @pulumi.getter(name="targetColumnNames")
    def target_column_names(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "target_column_names")

    @target_column_names.setter
    def target_column_names(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_column_names", value)

    @property
    @pulumi.getter(name="targetDateFormat")
    def target_date_format(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "target_date_format")

    @target_date_format.setter
    def target_date_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_date_format", value)

    @property
    @pulumi.getter(name="targetIndex")
    def target_index(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "target_index")

    @target_index.setter
    def target_index(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_index", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="tokenizerPattern")
    def tokenizer_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tokenizer_pattern")

    @tokenizer_pattern.setter
    def tokenizer_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tokenizer_pattern", value)

    @property
    @pulumi.getter(name="trueString")
    def true_string(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "true_string")

    @true_string.setter
    def true_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "true_string", value)

    @property
    @pulumi.getter(name="udfLang")
    def udf_lang(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "udf_lang")

    @udf_lang.setter
    def udf_lang(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "udf_lang", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "units", value)

    @property
    @pulumi.getter(name="unpivotColumn")
    def unpivot_column(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "unpivot_column")

    @unpivot_column.setter
    def unpivot_column(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unpivot_column", value)

    @property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "upper_bound")

    @upper_bound.setter
    def upper_bound(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upper_bound", value)

    @property
    @pulumi.getter(name="useNewDataFrame")
    def use_new_data_frame(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "use_new_data_frame")

    @use_new_data_frame.setter
    def use_new_data_frame(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "use_new_data_frame", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def value1(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "value1")

    @value1.setter
    def value1(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value1", value)

    @property
    @pulumi.getter
    def value2(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "value2")

    @value2.setter
    def value2(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value2", value)

    @property
    @pulumi.getter(name="valueColumn")
    def value_column(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "value_column")

    @value_column.setter
    def value_column(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value_column", value)

    @property
    @pulumi.getter(name="viewFrame")
    def view_frame(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "view_frame")

    @view_frame.setter
    def view_frame(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "view_frame", value)


if not MYPY:
    class RecipeS3LocationArgsDict(TypedDict):
        """
        Input location
        """
        bucket: pulumi.Input[builtins.str]
        key: NotRequired[pulumi.Input[builtins.str]]
elif False:
    RecipeS3LocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 key: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input location
        """
        pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class RecipeSecondaryInputArgsDict(TypedDict):
        """
        Secondary input
        """
        data_catalog_input_definition: NotRequired[pulumi.Input['RecipeDataCatalogInputDefinitionArgsDict']]
        s3_input_definition: NotRequired[pulumi.Input['RecipeS3LocationArgsDict']]
elif False:
    RecipeSecondaryInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeSecondaryInputArgs:
    def __init__(__self__, *,
                 data_catalog_input_definition: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']] = None,
                 s3_input_definition: Optional[pulumi.Input['RecipeS3LocationArgs']] = None):
        """
        Secondary input
        """
        if data_catalog_input_definition is not None:
            pulumi.set(__self__, "data_catalog_input_definition", data_catalog_input_definition)
        if s3_input_definition is not None:
            pulumi.set(__self__, "s3_input_definition", s3_input_definition)

    @property
    @pulumi.getter(name="dataCatalogInputDefinition")
    def data_catalog_input_definition(self) -> Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]:
        return pulumi.get(self, "data_catalog_input_definition")

    @data_catalog_input_definition.setter
    def data_catalog_input_definition(self, value: Optional[pulumi.Input['RecipeDataCatalogInputDefinitionArgs']]):
        pulumi.set(self, "data_catalog_input_definition", value)

    @property
    @pulumi.getter(name="s3InputDefinition")
    def s3_input_definition(self) -> Optional[pulumi.Input['RecipeS3LocationArgs']]:
        return pulumi.get(self, "s3_input_definition")

    @s3_input_definition.setter
    def s3_input_definition(self, value: Optional[pulumi.Input['RecipeS3LocationArgs']]):
        pulumi.set(self, "s3_input_definition", value)


if not MYPY:
    class RecipeStepArgsDict(TypedDict):
        action: pulumi.Input['RecipeActionArgsDict']
        """
        The particular action to be performed in the recipe step.
        """
        condition_expressions: NotRequired[pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgsDict']]]]
        """
        Condition expressions applied to the step action
        """
elif False:
    RecipeStepArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RecipeStepArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['RecipeActionArgs'],
                 condition_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]]] = None):
        """
        :param pulumi.Input['RecipeActionArgs'] action: The particular action to be performed in the recipe step.
        :param pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]] condition_expressions: Condition expressions applied to the step action
        """
        pulumi.set(__self__, "action", action)
        if condition_expressions is not None:
            pulumi.set(__self__, "condition_expressions", condition_expressions)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['RecipeActionArgs']:
        """
        The particular action to be performed in the recipe step.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['RecipeActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="conditionExpressions")
    def condition_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]]]:
        """
        Condition expressions applied to the step action
        """
        return pulumi.get(self, "condition_expressions")

    @condition_expressions.setter
    def condition_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipeConditionExpressionArgs']]]]):
        pulumi.set(self, "condition_expressions", value)


if not MYPY:
    class RulesetColumnSelectorArgsDict(TypedDict):
        """
        Selector of a column from a dataset for profile job configuration. One selector includes either a column name or a regular expression
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of a column from a dataset
        """
        regex: NotRequired[pulumi.Input[builtins.str]]
        """
        A regular expression for selecting a column from a dataset
        """
elif False:
    RulesetColumnSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulesetColumnSelectorArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 regex: Optional[pulumi.Input[builtins.str]] = None):
        """
        Selector of a column from a dataset for profile job configuration. One selector includes either a column name or a regular expression
        :param pulumi.Input[builtins.str] name: The name of a column from a dataset
        :param pulumi.Input[builtins.str] regex: A regular expression for selecting a column from a dataset
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a column from a dataset
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regular expression for selecting a column from a dataset
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class RulesetRuleArgsDict(TypedDict):
        """
        Data quality rule for a target resource (dataset)
        """
        check_expression: pulumi.Input[builtins.str]
        """
        The expression which includes column references, condition names followed by variable references, possibly grouped and combined with other conditions. For example, `(:col1 starts_with :prefix1 or :col1 starts_with :prefix2) and (:col1 ends_with :suffix1 or :col1 ends_with :suffix2)` . Column and value references are substitution variables that should start with the ':' symbol. Depending on the context, substitution variables' values can be either an actual value or a column name. These values are defined in the SubstitutionMap. If a CheckExpression starts with a column reference, then ColumnSelectors in the rule should be null. If ColumnSelectors has been defined, then there should be no columnn reference in the left side of a condition, for example, `is_between :val1 and :val2` .
        """
        name: pulumi.Input[builtins.str]
        """
        Name of the rule
        """
        column_selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['RulesetColumnSelectorArgsDict']]]]
        """
        List of column selectors. Selectors can be used to select columns using a name or regular expression from the dataset. Rule will be applied to selected columns.
        """
        disabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        A value that specifies whether the rule is disabled. Once a rule is disabled, a profile job will not validate it during a job run. Default value is false.
        """
        substitution_map: NotRequired[pulumi.Input[Sequence[pulumi.Input['RulesetSubstitutionValueArgsDict']]]]
        """
        The map of substitution variable names to their values used in a check expression. Variable names should start with a ':' (colon). Variable values can either be actual values or column names. To differentiate between the two, column names should be enclosed in backticks, for example, `":col1": "`Column A`".`
        """
        threshold: NotRequired[pulumi.Input['RulesetThresholdArgsDict']]
        """
        The threshold used with a non-aggregate check expression. Non-aggregate check expressions will be applied to each row in a specific column, and the threshold will be used to determine whether the validation succeeds.
        """
elif False:
    RulesetRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulesetRuleArgs:
    def __init__(__self__, *,
                 check_expression: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 column_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['RulesetColumnSelectorArgs']]]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 substitution_map: Optional[pulumi.Input[Sequence[pulumi.Input['RulesetSubstitutionValueArgs']]]] = None,
                 threshold: Optional[pulumi.Input['RulesetThresholdArgs']] = None):
        """
        Data quality rule for a target resource (dataset)
        :param pulumi.Input[builtins.str] check_expression: The expression which includes column references, condition names followed by variable references, possibly grouped and combined with other conditions. For example, `(:col1 starts_with :prefix1 or :col1 starts_with :prefix2) and (:col1 ends_with :suffix1 or :col1 ends_with :suffix2)` . Column and value references are substitution variables that should start with the ':' symbol. Depending on the context, substitution variables' values can be either an actual value or a column name. These values are defined in the SubstitutionMap. If a CheckExpression starts with a column reference, then ColumnSelectors in the rule should be null. If ColumnSelectors has been defined, then there should be no columnn reference in the left side of a condition, for example, `is_between :val1 and :val2` .
        :param pulumi.Input[builtins.str] name: Name of the rule
        :param pulumi.Input[Sequence[pulumi.Input['RulesetColumnSelectorArgs']]] column_selectors: List of column selectors. Selectors can be used to select columns using a name or regular expression from the dataset. Rule will be applied to selected columns.
        :param pulumi.Input[builtins.bool] disabled: A value that specifies whether the rule is disabled. Once a rule is disabled, a profile job will not validate it during a job run. Default value is false.
        :param pulumi.Input[Sequence[pulumi.Input['RulesetSubstitutionValueArgs']]] substitution_map: The map of substitution variable names to their values used in a check expression. Variable names should start with a ':' (colon). Variable values can either be actual values or column names. To differentiate between the two, column names should be enclosed in backticks, for example, `":col1": "`Column A`".`
        :param pulumi.Input['RulesetThresholdArgs'] threshold: The threshold used with a non-aggregate check expression. Non-aggregate check expressions will be applied to each row in a specific column, and the threshold will be used to determine whether the validation succeeds.
        """
        pulumi.set(__self__, "check_expression", check_expression)
        pulumi.set(__self__, "name", name)
        if column_selectors is not None:
            pulumi.set(__self__, "column_selectors", column_selectors)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if substitution_map is not None:
            pulumi.set(__self__, "substitution_map", substitution_map)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="checkExpression")
    def check_expression(self) -> pulumi.Input[builtins.str]:
        """
        The expression which includes column references, condition names followed by variable references, possibly grouped and combined with other conditions. For example, `(:col1 starts_with :prefix1 or :col1 starts_with :prefix2) and (:col1 ends_with :suffix1 or :col1 ends_with :suffix2)` . Column and value references are substitution variables that should start with the ':' symbol. Depending on the context, substitution variables' values can be either an actual value or a column name. These values are defined in the SubstitutionMap. If a CheckExpression starts with a column reference, then ColumnSelectors in the rule should be null. If ColumnSelectors has been defined, then there should be no columnn reference in the left side of a condition, for example, `is_between :val1 and :val2` .
        """
        return pulumi.get(self, "check_expression")

    @check_expression.setter
    def check_expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "check_expression", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="columnSelectors")
    def column_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulesetColumnSelectorArgs']]]]:
        """
        List of column selectors. Selectors can be used to select columns using a name or regular expression from the dataset. Rule will be applied to selected columns.
        """
        return pulumi.get(self, "column_selectors")

    @column_selectors.setter
    def column_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulesetColumnSelectorArgs']]]]):
        pulumi.set(self, "column_selectors", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that specifies whether the rule is disabled. Once a rule is disabled, a profile job will not validate it during a job run. Default value is false.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="substitutionMap")
    def substitution_map(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulesetSubstitutionValueArgs']]]]:
        """
        The map of substitution variable names to their values used in a check expression. Variable names should start with a ':' (colon). Variable values can either be actual values or column names. To differentiate between the two, column names should be enclosed in backticks, for example, `":col1": "`Column A`".`
        """
        return pulumi.get(self, "substitution_map")

    @substitution_map.setter
    def substitution_map(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulesetSubstitutionValueArgs']]]]):
        pulumi.set(self, "substitution_map", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input['RulesetThresholdArgs']]:
        """
        The threshold used with a non-aggregate check expression. Non-aggregate check expressions will be applied to each row in a specific column, and the threshold will be used to determine whether the validation succeeds.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input['RulesetThresholdArgs']]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class RulesetSubstitutionValueArgsDict(TypedDict):
        """
        A key-value pair to associate expression's substitution variable names with their values
        """
        value: pulumi.Input[builtins.str]
        """
        Value or column name
        """
        value_reference: pulumi.Input[builtins.str]
        """
        Variable name
        """
elif False:
    RulesetSubstitutionValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulesetSubstitutionValueArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[builtins.str],
                 value_reference: pulumi.Input[builtins.str]):
        """
        A key-value pair to associate expression's substitution variable names with their values
        :param pulumi.Input[builtins.str] value: Value or column name
        :param pulumi.Input[builtins.str] value_reference: Variable name
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_reference", value_reference)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value or column name
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueReference")
    def value_reference(self) -> pulumi.Input[builtins.str]:
        """
        Variable name
        """
        return pulumi.get(self, "value_reference")

    @value_reference.setter
    def value_reference(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value_reference", value)


if not MYPY:
    class RulesetThresholdArgsDict(TypedDict):
        value: pulumi.Input[builtins.float]
        """
        The value of a threshold.
        """
        type: NotRequired[pulumi.Input['RulesetThresholdType']]
        """
        The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the threshold value.
        """
        unit: NotRequired[pulumi.Input['RulesetThresholdUnit']]
        """
        Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
        """
elif False:
    RulesetThresholdArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulesetThresholdArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[builtins.float],
                 type: Optional[pulumi.Input['RulesetThresholdType']] = None,
                 unit: Optional[pulumi.Input['RulesetThresholdUnit']] = None):
        """
        :param pulumi.Input[builtins.float] value: The value of a threshold.
        :param pulumi.Input['RulesetThresholdType'] type: The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the threshold value.
        :param pulumi.Input['RulesetThresholdUnit'] unit: Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
        """
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.float]:
        """
        The value of a threshold.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['RulesetThresholdType']]:
        """
        The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the threshold value.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['RulesetThresholdType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input['RulesetThresholdUnit']]:
        """
        Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input['RulesetThresholdUnit']]):
        pulumi.set(self, "unit", value)


