# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['SegmentDefinitionArgs', 'SegmentDefinition']

@pulumi.input_type
class SegmentDefinitionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 domain_name: pulumi.Input[builtins.str],
                 segment_groups: pulumi.Input['SegmentDefinitionSegmentGroupArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 segment_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a SegmentDefinition resource.
        :param pulumi.Input[builtins.str] display_name: The display name of the segment definition.
        :param pulumi.Input[builtins.str] domain_name: The unique name of the domain.
        :param pulumi.Input['SegmentDefinitionSegmentGroupArgs'] segment_groups: An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
        :param pulumi.Input[builtins.str] description: The description of the segment definition.
        :param pulumi.Input[builtins.str] segment_definition_name: The unique name of the segment definition.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for this resource.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "segment_groups", segment_groups)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if segment_definition_name is not None:
            pulumi.set(__self__, "segment_definition_name", segment_definition_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The display name of the segment definition.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        The unique name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="segmentGroups")
    def segment_groups(self) -> pulumi.Input['SegmentDefinitionSegmentGroupArgs']:
        """
        An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
        """
        return pulumi.get(self, "segment_groups")

    @segment_groups.setter
    def segment_groups(self, value: pulumi.Input['SegmentDefinitionSegmentGroupArgs']):
        pulumi.set(self, "segment_groups", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the segment definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="segmentDefinitionName")
    def segment_definition_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the segment definition.
        """
        return pulumi.get(self, "segment_definition_name")

    @segment_definition_name.setter
    def segment_definition_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "segment_definition_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:customerprofiles:SegmentDefinition")
class SegmentDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 segment_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 segment_groups: Optional[pulumi.Input[Union['SegmentDefinitionSegmentGroupArgs', 'SegmentDefinitionSegmentGroupArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        A segment definition resource of Amazon Connect Customer Profiles

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the segment definition.
        :param pulumi.Input[builtins.str] display_name: The display name of the segment definition.
        :param pulumi.Input[builtins.str] domain_name: The unique name of the domain.
        :param pulumi.Input[builtins.str] segment_definition_name: The unique name of the segment definition.
        :param pulumi.Input[Union['SegmentDefinitionSegmentGroupArgs', 'SegmentDefinitionSegmentGroupArgsDict']] segment_groups: An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SegmentDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A segment definition resource of Amazon Connect Customer Profiles

        :param str resource_name: The name of the resource.
        :param SegmentDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SegmentDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 segment_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                 segment_groups: Optional[pulumi.Input[Union['SegmentDefinitionSegmentGroupArgs', 'SegmentDefinitionSegmentGroupArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SegmentDefinitionArgs.__new__(SegmentDefinitionArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["segment_definition_name"] = segment_definition_name
            if segment_groups is None and not opts.urn:
                raise TypeError("Missing required property 'segment_groups'")
            __props__.__dict__["segment_groups"] = segment_groups
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["segment_definition_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["displayName", "domainName", "segmentDefinitionName", "segmentGroups"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SegmentDefinition, __self__).__init__(
            'aws-native:customerprofiles:SegmentDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SegmentDefinition':
        """
        Get an existing SegmentDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SegmentDefinitionArgs.__new__(SegmentDefinitionArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["segment_definition_arn"] = None
        __props__.__dict__["segment_definition_name"] = None
        __props__.__dict__["segment_groups"] = None
        __props__.__dict__["tags"] = None
        return SegmentDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The time of this segment definition got created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the segment definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the segment definition.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="segmentDefinitionArn")
    def segment_definition_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the segment definition.
        """
        return pulumi.get(self, "segment_definition_arn")

    @property
    @pulumi.getter(name="segmentDefinitionName")
    def segment_definition_name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the segment definition.
        """
        return pulumi.get(self, "segment_definition_name")

    @property
    @pulumi.getter(name="segmentGroups")
    def segment_groups(self) -> pulumi.Output['outputs.SegmentDefinitionSegmentGroup']:
        """
        An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
        """
        return pulumi.get(self, "segment_groups")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

