# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CalculatedAttributeDefinitionAttributeDetails',
    'CalculatedAttributeDefinitionAttributeItem',
    'CalculatedAttributeDefinitionConditions',
    'CalculatedAttributeDefinitionRange',
    'CalculatedAttributeDefinitionThreshold',
    'DestinationDetailsProperties',
    'DomainAttributeTypesSelector',
    'DomainAutoMerging',
    'DomainConflictResolution',
    'DomainConsolidation',
    'DomainExportingConfig',
    'DomainJobSchedule',
    'DomainMatching',
    'DomainMatchingRule',
    'DomainRuleBasedMatching',
    'DomainS3ExportingConfig',
    'DomainStats',
    'EventTriggerCondition',
    'EventTriggerDimension',
    'EventTriggerLimits',
    'EventTriggerObjectAttribute',
    'EventTriggerPeriod',
    'IntegrationConnectorOperator',
    'IntegrationFlowDefinition',
    'IntegrationIncrementalPullConfig',
    'IntegrationMarketoSourceProperties',
    'IntegrationObjectTypeMapping',
    'IntegrationS3SourceProperties',
    'IntegrationSalesforceSourceProperties',
    'IntegrationScheduledTriggerProperties',
    'IntegrationServiceNowSourceProperties',
    'IntegrationSourceConnectorProperties',
    'IntegrationSourceFlowConfig',
    'IntegrationTask',
    'IntegrationTaskPropertiesMap',
    'IntegrationTriggerConfig',
    'IntegrationTriggerProperties',
    'IntegrationZendeskSourceProperties',
    'ObjectTypeField',
    'ObjectTypeFieldMap',
    'ObjectTypeKey',
    'ObjectTypeKeyMap',
    'SegmentDefinitionAddressDimension',
    'SegmentDefinitionAttributeDimension',
    'SegmentDefinitionCalculatedAttributeDimension',
    'SegmentDefinitionConditionOverrides',
    'SegmentDefinitionDateDimension',
    'SegmentDefinitionDimension0Properties',
    'SegmentDefinitionDimension1Properties',
    'SegmentDefinitionExtraLengthValueProfileDimension',
    'SegmentDefinitionGroup',
    'SegmentDefinitionProfileAttributes',
    'SegmentDefinitionProfileDimension',
    'SegmentDefinitionRangeOverride',
    'SegmentDefinitionSegmentGroup',
    'SegmentDefinitionSourceSegment',
]

@pulumi.output_type
class CalculatedAttributeDefinitionAttributeDetails(dict):
    """
    Mathematical expression and a list of attribute items specified in that expression.
    """
    def __init__(__self__, *,
                 attributes: Sequence['outputs.CalculatedAttributeDefinitionAttributeItem'],
                 expression: builtins.str):
        """
        Mathematical expression and a list of attribute items specified in that expression.
        :param Sequence['CalculatedAttributeDefinitionAttributeItem'] attributes: Mathematical expression and a list of attribute items specified in that expression.
        :param builtins.str expression: Mathematical expression that is performed on attribute items provided in the attribute list. Each element in the expression should follow the structure of \\"{ObjectTypeName.AttributeName}\\".
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.CalculatedAttributeDefinitionAttributeItem']:
        """
        Mathematical expression and a list of attribute items specified in that expression.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Mathematical expression that is performed on attribute items provided in the attribute list. Each element in the expression should follow the structure of \\"{ObjectTypeName.AttributeName}\\".
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class CalculatedAttributeDefinitionAttributeItem(dict):
    """
    The details of a single attribute item specified in the mathematical expression.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        The details of a single attribute item specified in the mathematical expression.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class CalculatedAttributeDefinitionConditions(dict):
    """
    The conditions including range, object count, and threshold for the calculated attribute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectCount":
            suggest = "object_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CalculatedAttributeDefinitionConditions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CalculatedAttributeDefinitionConditions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CalculatedAttributeDefinitionConditions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_count: Optional[builtins.int] = None,
                 range: Optional['outputs.CalculatedAttributeDefinitionRange'] = None,
                 threshold: Optional['outputs.CalculatedAttributeDefinitionThreshold'] = None):
        """
        The conditions including range, object count, and threshold for the calculated attribute.
        :param builtins.int object_count: The number of profile objects used for the calculated attribute.
        :param 'CalculatedAttributeDefinitionRange' range: The relative time period over which data is included in the aggregation.
        :param 'CalculatedAttributeDefinitionThreshold' threshold: The threshold for the calculated attribute.
        """
        if object_count is not None:
            pulumi.set(__self__, "object_count", object_count)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="objectCount")
    def object_count(self) -> Optional[builtins.int]:
        """
        The number of profile objects used for the calculated attribute.
        """
        return pulumi.get(self, "object_count")

    @property
    @pulumi.getter
    def range(self) -> Optional['outputs.CalculatedAttributeDefinitionRange']:
        """
        The relative time period over which data is included in the aggregation.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter
    def threshold(self) -> Optional['outputs.CalculatedAttributeDefinitionThreshold']:
        """
        The threshold for the calculated attribute.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class CalculatedAttributeDefinitionRange(dict):
    """
    The relative time period over which data is included in the aggregation.
    """
    def __init__(__self__, *,
                 unit: 'CalculatedAttributeDefinitionRangeUnit',
                 value: builtins.int):
        """
        The relative time period over which data is included in the aggregation.
        :param 'CalculatedAttributeDefinitionRangeUnit' unit: The unit of time.
        :param builtins.int value: The amount of time of the specified unit.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> 'CalculatedAttributeDefinitionRangeUnit':
        """
        The unit of time.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        """
        The amount of time of the specified unit.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CalculatedAttributeDefinitionThreshold(dict):
    """
    The threshold for the calculated attribute.
    """
    def __init__(__self__, *,
                 operator: 'CalculatedAttributeDefinitionThresholdOperator',
                 value: builtins.str):
        """
        The threshold for the calculated attribute.
        :param 'CalculatedAttributeDefinitionThresholdOperator' operator: The operator of the threshold.
        :param builtins.str value: The value of the threshold.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operator(self) -> 'CalculatedAttributeDefinitionThresholdOperator':
        """
        The operator of the threshold.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the threshold.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DestinationDetailsProperties(dict):
    """
    Details regarding the Kinesis stream.
    """
    def __init__(__self__, *,
                 status: 'EventStreamStatus',
                 uri: builtins.str):
        """
        Details regarding the Kinesis stream.
        :param 'EventStreamStatus' status: The status of enabling the Kinesis stream as a destination for export.
        :param builtins.str uri: The StreamARN of the destination to deliver profile events to. For example, arn:aws:kinesis:region:account-id:stream/stream-name.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def status(self) -> 'EventStreamStatus':
        """
        The status of enabling the Kinesis stream as a destination for export.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The StreamARN of the destination to deliver profile events to. For example, arn:aws:kinesis:region:account-id:stream/stream-name.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class DomainAttributeTypesSelector(dict):
    """
    Configures information about the AttributeTypesSelector where the rule-based identity resolution uses to match profiles.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeMatchingModel":
            suggest = "attribute_matching_model"
        elif key == "emailAddress":
            suggest = "email_address"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAttributeTypesSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAttributeTypesSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAttributeTypesSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_matching_model: 'DomainAttributeTypesSelectorAttributeMatchingModel',
                 address: Optional[Sequence[builtins.str]] = None,
                 email_address: Optional[Sequence[builtins.str]] = None,
                 phone_number: Optional[Sequence[builtins.str]] = None):
        """
        Configures information about the AttributeTypesSelector where the rule-based identity resolution uses to match profiles.
        :param 'DomainAttributeTypesSelectorAttributeMatchingModel' attribute_matching_model: Configures the AttributeMatchingModel, you can either choose ONE_TO_ONE or MANY_TO_MANY.
        :param Sequence[builtins.str] address: The Address type. You can choose from Address, BusinessAddress, MaillingAddress, and ShippingAddress. You only can use the Address type in the MatchingRule. For example, if you want to match profile based on BusinessAddress.City or MaillingAddress.City, you need to choose the BusinessAddress and the MaillingAddress to represent the Address type and specify the Address.City on the matching rule.
        :param Sequence[builtins.str] email_address: The Email type. You can choose from EmailAddress, BusinessEmailAddress and PersonalEmailAddress. You only can use the EmailAddress type in the MatchingRule. For example, if you want to match profile based on PersonalEmailAddress or BusinessEmailAddress, you need to choose the PersonalEmailAddress and the BusinessEmailAddress to represent the EmailAddress type and only specify the EmailAddress on the matching rule.
        :param Sequence[builtins.str] phone_number: The PhoneNumber type. You can choose from PhoneNumber, HomePhoneNumber, and MobilePhoneNumber. You only can use the PhoneNumber type in the MatchingRule. For example, if you want to match a profile based on Phone or HomePhone, you need to choose the Phone and the HomePhone to represent the PhoneNumber type and only specify the PhoneNumber on the matching rule.
        """
        pulumi.set(__self__, "attribute_matching_model", attribute_matching_model)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="attributeMatchingModel")
    def attribute_matching_model(self) -> 'DomainAttributeTypesSelectorAttributeMatchingModel':
        """
        Configures the AttributeMatchingModel, you can either choose ONE_TO_ONE or MANY_TO_MANY.
        """
        return pulumi.get(self, "attribute_matching_model")

    @property
    @pulumi.getter
    def address(self) -> Optional[Sequence[builtins.str]]:
        """
        The Address type. You can choose from Address, BusinessAddress, MaillingAddress, and ShippingAddress. You only can use the Address type in the MatchingRule. For example, if you want to match profile based on BusinessAddress.City or MaillingAddress.City, you need to choose the BusinessAddress and the MaillingAddress to represent the Address type and specify the Address.City on the matching rule.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[Sequence[builtins.str]]:
        """
        The Email type. You can choose from EmailAddress, BusinessEmailAddress and PersonalEmailAddress. You only can use the EmailAddress type in the MatchingRule. For example, if you want to match profile based on PersonalEmailAddress or BusinessEmailAddress, you need to choose the PersonalEmailAddress and the BusinessEmailAddress to represent the EmailAddress type and only specify the EmailAddress on the matching rule.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[Sequence[builtins.str]]:
        """
        The PhoneNumber type. You can choose from PhoneNumber, HomePhoneNumber, and MobilePhoneNumber. You only can use the PhoneNumber type in the MatchingRule. For example, if you want to match a profile based on Phone or HomePhone, you need to choose the Phone and the HomePhone to represent the PhoneNumber type and only specify the PhoneNumber on the matching rule.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class DomainAutoMerging(dict):
    """
    Configuration information about the auto-merging process.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolution":
            suggest = "conflict_resolution"
        elif key == "minAllowedConfidenceScoreForMerging":
            suggest = "min_allowed_confidence_score_for_merging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAutoMerging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAutoMerging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAutoMerging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 conflict_resolution: Optional['outputs.DomainConflictResolution'] = None,
                 consolidation: Optional['outputs.DomainConsolidation'] = None,
                 min_allowed_confidence_score_for_merging: Optional[builtins.float] = None):
        """
        Configuration information about the auto-merging process.
        :param builtins.bool enabled: The flag that enables the auto-merging of duplicate profiles.
        :param 'DomainConflictResolution' conflict_resolution: Determines how the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same `FirstName` and `LastName` , `ConflictResolution` specifies which `EmailAddress` should be used.
        :param 'DomainConsolidation' consolidation: A list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
        :param builtins.float min_allowed_confidence_score_for_merging: A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
        """
        pulumi.set(__self__, "enabled", enabled)
        if conflict_resolution is not None:
            pulumi.set(__self__, "conflict_resolution", conflict_resolution)
        if consolidation is not None:
            pulumi.set(__self__, "consolidation", consolidation)
        if min_allowed_confidence_score_for_merging is not None:
            pulumi.set(__self__, "min_allowed_confidence_score_for_merging", min_allowed_confidence_score_for_merging)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        The flag that enables the auto-merging of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="conflictResolution")
    def conflict_resolution(self) -> Optional['outputs.DomainConflictResolution']:
        """
        Determines how the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same `FirstName` and `LastName` , `ConflictResolution` specifies which `EmailAddress` should be used.
        """
        return pulumi.get(self, "conflict_resolution")

    @property
    @pulumi.getter
    def consolidation(self) -> Optional['outputs.DomainConsolidation']:
        """
        A list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
        """
        return pulumi.get(self, "consolidation")

    @property
    @pulumi.getter(name="minAllowedConfidenceScoreForMerging")
    def min_allowed_confidence_score_for_merging(self) -> Optional[builtins.float]:
        """
        A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
        """
        return pulumi.get(self, "min_allowed_confidence_score_for_merging")


@pulumi.output_type
class DomainConflictResolution(dict):
    """
    How the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same FirstName and LastName (and that is the matching criteria), which EmailAddress should be used? 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolvingModel":
            suggest = "conflict_resolving_model"
        elif key == "sourceName":
            suggest = "source_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainConflictResolution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainConflictResolution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainConflictResolution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_resolving_model: 'DomainConflictResolutionConflictResolvingModel',
                 source_name: Optional[builtins.str] = None):
        """
        How the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same FirstName and LastName (and that is the matching criteria), which EmailAddress should be used? 
        :param 'DomainConflictResolutionConflictResolvingModel' conflict_resolving_model: How the auto-merging process should resolve conflicts between different profiles.
        :param builtins.str source_name: The ObjectType name that is used to resolve profile merging conflicts when choosing SOURCE as the ConflictResolvingModel.
        """
        pulumi.set(__self__, "conflict_resolving_model", conflict_resolving_model)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)

    @property
    @pulumi.getter(name="conflictResolvingModel")
    def conflict_resolving_model(self) -> 'DomainConflictResolutionConflictResolvingModel':
        """
        How the auto-merging process should resolve conflicts between different profiles.
        """
        return pulumi.get(self, "conflict_resolving_model")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[builtins.str]:
        """
        The ObjectType name that is used to resolve profile merging conflicts when choosing SOURCE as the ConflictResolvingModel.
        """
        return pulumi.get(self, "source_name")


@pulumi.output_type
class DomainConsolidation(dict):
    """
    A list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchingAttributesList":
            suggest = "matching_attributes_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainConsolidation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainConsolidation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainConsolidation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 matching_attributes_list: Sequence[Sequence[builtins.str]]):
        """
        A list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
        :param Sequence[Sequence[builtins.str]] matching_attributes_list: A list of matching criteria.
        """
        pulumi.set(__self__, "matching_attributes_list", matching_attributes_list)

    @property
    @pulumi.getter(name="matchingAttributesList")
    def matching_attributes_list(self) -> Sequence[Sequence[builtins.str]]:
        """
        A list of matching criteria.
        """
        return pulumi.get(self, "matching_attributes_list")


@pulumi.output_type
class DomainExportingConfig(dict):
    """
    Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Exporting":
            suggest = "s3_exporting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainExportingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainExportingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainExportingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_exporting: Optional['outputs.DomainS3ExportingConfig'] = None):
        """
        Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
        """
        if s3_exporting is not None:
            pulumi.set(__self__, "s3_exporting", s3_exporting)

    @property
    @pulumi.getter(name="s3Exporting")
    def s3_exporting(self) -> Optional['outputs.DomainS3ExportingConfig']:
        return pulumi.get(self, "s3_exporting")


@pulumi.output_type
class DomainJobSchedule(dict):
    """
    The day and time when do you want to start the Identity Resolution Job every week.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfTheWeek":
            suggest = "day_of_the_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainJobSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainJobSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainJobSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_the_week: 'DomainJobScheduleDayOfTheWeek',
                 time: builtins.str):
        """
        The day and time when do you want to start the Identity Resolution Job every week.
        :param 'DomainJobScheduleDayOfTheWeek' day_of_the_week: The day when the Identity Resolution Job should run every week.
        :param builtins.str time: The time when the Identity Resolution Job should run every week.
        """
        pulumi.set(__self__, "day_of_the_week", day_of_the_week)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="dayOfTheWeek")
    def day_of_the_week(self) -> 'DomainJobScheduleDayOfTheWeek':
        """
        The day when the Identity Resolution Job should run every week.
        """
        return pulumi.get(self, "day_of_the_week")

    @property
    @pulumi.getter
    def time(self) -> builtins.str:
        """
        The time when the Identity Resolution Job should run every week.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class DomainMatching(dict):
    """
    The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. After the Identity Resolution Job completes, use the GetMatches API to return and review the results. Or, if you have configured ExportingConfig in the MatchingRequest, you can download the results from S3.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoMerging":
            suggest = "auto_merging"
        elif key == "exportingConfig":
            suggest = "exporting_config"
        elif key == "jobSchedule":
            suggest = "job_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMatching. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMatching.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMatching.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 auto_merging: Optional['outputs.DomainAutoMerging'] = None,
                 exporting_config: Optional['outputs.DomainExportingConfig'] = None,
                 job_schedule: Optional['outputs.DomainJobSchedule'] = None):
        """
        The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. After the Identity Resolution Job completes, use the GetMatches API to return and review the results. Or, if you have configured ExportingConfig in the MatchingRequest, you can download the results from S3.
        :param builtins.bool enabled: The flag that enables the matching process of duplicate profiles.
        :param 'DomainAutoMerging' auto_merging: Configuration information about the auto-merging process.
        :param 'DomainExportingConfig' exporting_config: The S3 location where Identity Resolution Jobs write result files.
        :param 'DomainJobSchedule' job_schedule: The day and time when do you want to start the Identity Resolution Job every week.
        """
        pulumi.set(__self__, "enabled", enabled)
        if auto_merging is not None:
            pulumi.set(__self__, "auto_merging", auto_merging)
        if exporting_config is not None:
            pulumi.set(__self__, "exporting_config", exporting_config)
        if job_schedule is not None:
            pulumi.set(__self__, "job_schedule", job_schedule)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        The flag that enables the matching process of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="autoMerging")
    def auto_merging(self) -> Optional['outputs.DomainAutoMerging']:
        """
        Configuration information about the auto-merging process.
        """
        return pulumi.get(self, "auto_merging")

    @property
    @pulumi.getter(name="exportingConfig")
    def exporting_config(self) -> Optional['outputs.DomainExportingConfig']:
        """
        The S3 location where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "exporting_config")

    @property
    @pulumi.getter(name="jobSchedule")
    def job_schedule(self) -> Optional['outputs.DomainJobSchedule']:
        """
        The day and time when do you want to start the Identity Resolution Job every week.
        """
        return pulumi.get(self, "job_schedule")


@pulumi.output_type
class DomainMatchingRule(dict):
    """
    Specifies how does the rule-based matching process should match profiles.
    """
    def __init__(__self__, *,
                 rule: Sequence[builtins.str]):
        """
        Specifies how does the rule-based matching process should match profiles.
        :param Sequence[builtins.str] rule: A single rule level of the `MatchRules` . Configures how the rule-based matching process should match profiles.
        """
        pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def rule(self) -> Sequence[builtins.str]:
        """
        A single rule level of the `MatchRules` . Configures how the rule-based matching process should match profiles.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class DomainRuleBasedMatching(dict):
    """
    The process of matching duplicate profiles using the Rule-Based matching. If RuleBasedMatching = true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your configuration in the RuleBasedMatchingRequest. You can use the ListRuleBasedMatches and GetSimilarProfiles API to return and review the results. Also, if you have configured ExportingConfig in the RuleBasedMatchingRequest, you can download the results from S3.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeTypesSelector":
            suggest = "attribute_types_selector"
        elif key == "conflictResolution":
            suggest = "conflict_resolution"
        elif key == "exportingConfig":
            suggest = "exporting_config"
        elif key == "matchingRules":
            suggest = "matching_rules"
        elif key == "maxAllowedRuleLevelForMatching":
            suggest = "max_allowed_rule_level_for_matching"
        elif key == "maxAllowedRuleLevelForMerging":
            suggest = "max_allowed_rule_level_for_merging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRuleBasedMatching. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRuleBasedMatching.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRuleBasedMatching.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 attribute_types_selector: Optional['outputs.DomainAttributeTypesSelector'] = None,
                 conflict_resolution: Optional['outputs.DomainConflictResolution'] = None,
                 exporting_config: Optional['outputs.DomainExportingConfig'] = None,
                 matching_rules: Optional[Sequence['outputs.DomainMatchingRule']] = None,
                 max_allowed_rule_level_for_matching: Optional[builtins.int] = None,
                 max_allowed_rule_level_for_merging: Optional[builtins.int] = None,
                 status: Optional['DomainRuleBasedMatchingStatus'] = None):
        """
        The process of matching duplicate profiles using the Rule-Based matching. If RuleBasedMatching = true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your configuration in the RuleBasedMatchingRequest. You can use the ListRuleBasedMatches and GetSimilarProfiles API to return and review the results. Also, if you have configured ExportingConfig in the RuleBasedMatchingRequest, you can download the results from S3.
        :param builtins.bool enabled: The flag that enables the rule-based matching process of duplicate profiles.
        :param 'DomainAttributeTypesSelector' attribute_types_selector: Configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles.
        :param 'DomainConflictResolution' conflict_resolution: Determines how the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same `FirstName` and `LastName` , `ConflictResolution` specifies which `EmailAddress` should be used.
        :param 'DomainExportingConfig' exporting_config: The S3 location where Identity Resolution Jobs write result files.
        :param Sequence['DomainMatchingRule'] matching_rules: Configures how the rule-based matching process should match profiles. You can have up to 15 MatchingRule in the MatchingRules.
        :param builtins.int max_allowed_rule_level_for_matching: Indicates the maximum allowed rule level for matching.
        :param builtins.int max_allowed_rule_level_for_merging: Indicates the maximum allowed rule level for merging.
        :param 'DomainRuleBasedMatchingStatus' status: The status of rule-based matching rule.
        """
        pulumi.set(__self__, "enabled", enabled)
        if attribute_types_selector is not None:
            pulumi.set(__self__, "attribute_types_selector", attribute_types_selector)
        if conflict_resolution is not None:
            pulumi.set(__self__, "conflict_resolution", conflict_resolution)
        if exporting_config is not None:
            pulumi.set(__self__, "exporting_config", exporting_config)
        if matching_rules is not None:
            pulumi.set(__self__, "matching_rules", matching_rules)
        if max_allowed_rule_level_for_matching is not None:
            pulumi.set(__self__, "max_allowed_rule_level_for_matching", max_allowed_rule_level_for_matching)
        if max_allowed_rule_level_for_merging is not None:
            pulumi.set(__self__, "max_allowed_rule_level_for_merging", max_allowed_rule_level_for_merging)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        The flag that enables the rule-based matching process of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="attributeTypesSelector")
    def attribute_types_selector(self) -> Optional['outputs.DomainAttributeTypesSelector']:
        """
        Configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles.
        """
        return pulumi.get(self, "attribute_types_selector")

    @property
    @pulumi.getter(name="conflictResolution")
    def conflict_resolution(self) -> Optional['outputs.DomainConflictResolution']:
        """
        Determines how the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same `FirstName` and `LastName` , `ConflictResolution` specifies which `EmailAddress` should be used.
        """
        return pulumi.get(self, "conflict_resolution")

    @property
    @pulumi.getter(name="exportingConfig")
    def exporting_config(self) -> Optional['outputs.DomainExportingConfig']:
        """
        The S3 location where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "exporting_config")

    @property
    @pulumi.getter(name="matchingRules")
    def matching_rules(self) -> Optional[Sequence['outputs.DomainMatchingRule']]:
        """
        Configures how the rule-based matching process should match profiles. You can have up to 15 MatchingRule in the MatchingRules.
        """
        return pulumi.get(self, "matching_rules")

    @property
    @pulumi.getter(name="maxAllowedRuleLevelForMatching")
    def max_allowed_rule_level_for_matching(self) -> Optional[builtins.int]:
        """
        Indicates the maximum allowed rule level for matching.
        """
        return pulumi.get(self, "max_allowed_rule_level_for_matching")

    @property
    @pulumi.getter(name="maxAllowedRuleLevelForMerging")
    def max_allowed_rule_level_for_merging(self) -> Optional[builtins.int]:
        """
        Indicates the maximum allowed rule level for merging.
        """
        return pulumi.get(self, "max_allowed_rule_level_for_merging")

    @property
    @pulumi.getter
    def status(self) -> Optional['DomainRuleBasedMatchingStatus']:
        """
        The status of rule-based matching rule.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DomainS3ExportingConfig(dict):
    """
    The S3 location where Identity Resolution Jobs write result files.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyName":
            suggest = "s3_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainS3ExportingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainS3ExportingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainS3ExportingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: builtins.str,
                 s3_key_name: Optional[builtins.str] = None):
        """
        The S3 location where Identity Resolution Jobs write result files.
        :param builtins.str s3_bucket_name: The name of the S3 bucket where Identity Resolution Jobs write result files.
        :param builtins.str s3_key_name: The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_name is not None:
            pulumi.set(__self__, "s3_key_name", s3_key_name)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> builtins.str:
        """
        The name of the S3 bucket where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyName")
    def s3_key_name(self) -> Optional[builtins.str]:
        """
        The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_key_name")


@pulumi.output_type
class DomainStats(dict):
    """
    Usage-specific statistics about the domain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "meteringProfileCount":
            suggest = "metering_profile_count"
        elif key == "objectCount":
            suggest = "object_count"
        elif key == "profileCount":
            suggest = "profile_count"
        elif key == "totalSize":
            suggest = "total_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainStats. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainStats.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainStats.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metering_profile_count: Optional[builtins.float] = None,
                 object_count: Optional[builtins.float] = None,
                 profile_count: Optional[builtins.float] = None,
                 total_size: Optional[builtins.float] = None):
        """
        Usage-specific statistics about the domain.
        :param builtins.float metering_profile_count: The number of profiles that you are currently paying for in the domain. If you have more than 100 objects associated with a single profile, that profile counts as two profiles. If you have more than 200 objects, that profile counts as three, and so on.
        :param builtins.float object_count: The total number of objects in domain.
        :param builtins.float profile_count: The total number of profiles currently in the domain.
        :param builtins.float total_size: The total size, in bytes, of all objects in the domain.
        """
        if metering_profile_count is not None:
            pulumi.set(__self__, "metering_profile_count", metering_profile_count)
        if object_count is not None:
            pulumi.set(__self__, "object_count", object_count)
        if profile_count is not None:
            pulumi.set(__self__, "profile_count", profile_count)
        if total_size is not None:
            pulumi.set(__self__, "total_size", total_size)

    @property
    @pulumi.getter(name="meteringProfileCount")
    def metering_profile_count(self) -> Optional[builtins.float]:
        """
        The number of profiles that you are currently paying for in the domain. If you have more than 100 objects associated with a single profile, that profile counts as two profiles. If you have more than 200 objects, that profile counts as three, and so on.
        """
        return pulumi.get(self, "metering_profile_count")

    @property
    @pulumi.getter(name="objectCount")
    def object_count(self) -> Optional[builtins.float]:
        """
        The total number of objects in domain.
        """
        return pulumi.get(self, "object_count")

    @property
    @pulumi.getter(name="profileCount")
    def profile_count(self) -> Optional[builtins.float]:
        """
        The total number of profiles currently in the domain.
        """
        return pulumi.get(self, "profile_count")

    @property
    @pulumi.getter(name="totalSize")
    def total_size(self) -> Optional[builtins.float]:
        """
        The total size, in bytes, of all objects in the domain.
        """
        return pulumi.get(self, "total_size")


@pulumi.output_type
class EventTriggerCondition(dict):
    """
    Specifies the circumstances under which the event should trigger the destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTriggerDimensions":
            suggest = "event_trigger_dimensions"
        elif key == "logicalOperator":
            suggest = "logical_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTriggerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTriggerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTriggerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_trigger_dimensions: Sequence['outputs.EventTriggerDimension'],
                 logical_operator: 'EventTriggerLogicalOperator'):
        """
        Specifies the circumstances under which the event should trigger the destination.
        """
        pulumi.set(__self__, "event_trigger_dimensions", event_trigger_dimensions)
        pulumi.set(__self__, "logical_operator", logical_operator)

    @property
    @pulumi.getter(name="eventTriggerDimensions")
    def event_trigger_dimensions(self) -> Sequence['outputs.EventTriggerDimension']:
        return pulumi.get(self, "event_trigger_dimensions")

    @property
    @pulumi.getter(name="logicalOperator")
    def logical_operator(self) -> 'EventTriggerLogicalOperator':
        return pulumi.get(self, "logical_operator")


@pulumi.output_type
class EventTriggerDimension(dict):
    """
    A specific event dimension to be assessed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectAttributes":
            suggest = "object_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTriggerDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTriggerDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTriggerDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_attributes: Sequence['outputs.EventTriggerObjectAttribute']):
        """
        A specific event dimension to be assessed.
        """
        pulumi.set(__self__, "object_attributes", object_attributes)

    @property
    @pulumi.getter(name="objectAttributes")
    def object_attributes(self) -> Sequence['outputs.EventTriggerObjectAttribute']:
        return pulumi.get(self, "object_attributes")


@pulumi.output_type
class EventTriggerLimits(dict):
    """
    Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventExpiration":
            suggest = "event_expiration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTriggerLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTriggerLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTriggerLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_expiration: Optional[builtins.int] = None,
                 periods: Optional[Sequence['outputs.EventTriggerPeriod']] = None):
        """
        Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
        :param builtins.int event_expiration: Specifies that an event will only trigger the destination if it is processed within a certain latency period.
        :param Sequence['EventTriggerPeriod'] periods: A list of time periods during which the limits apply.
        """
        if event_expiration is not None:
            pulumi.set(__self__, "event_expiration", event_expiration)
        if periods is not None:
            pulumi.set(__self__, "periods", periods)

    @property
    @pulumi.getter(name="eventExpiration")
    def event_expiration(self) -> Optional[builtins.int]:
        """
        Specifies that an event will only trigger the destination if it is processed within a certain latency period.
        """
        return pulumi.get(self, "event_expiration")

    @property
    @pulumi.getter
    def periods(self) -> Optional[Sequence['outputs.EventTriggerPeriod']]:
        """
        A list of time periods during which the limits apply.
        """
        return pulumi.get(self, "periods")


@pulumi.output_type
class EventTriggerObjectAttribute(dict):
    """
    The criteria that a specific object attribute must meet to trigger the destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "fieldName":
            suggest = "field_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTriggerObjectAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTriggerObjectAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTriggerObjectAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: 'EventTriggerObjectAttributeComparisonOperator',
                 values: Sequence[builtins.str],
                 field_name: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None):
        """
        The criteria that a specific object attribute must meet to trigger the destination.
        :param 'EventTriggerObjectAttributeComparisonOperator' comparison_operator: The operator used to compare an attribute against a list of values.
        :param Sequence[builtins.str] values: A list of attribute values used for comparison.
        :param builtins.str field_name: A field defined within an object type.
        :param builtins.str source: An attribute contained within a source object.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "values", values)
        if field_name is not None:
            pulumi.set(__self__, "field_name", field_name)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> 'EventTriggerObjectAttributeComparisonOperator':
        """
        The operator used to compare an attribute against a list of values.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        A list of attribute values used for comparison.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[builtins.str]:
        """
        A field defined within an object type.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        An attribute contained within a source object.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class EventTriggerPeriod(dict):
    """
    Defines a limit and the time period during which it is enforced.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInvocationsPerProfile":
            suggest = "max_invocations_per_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTriggerPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTriggerPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTriggerPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unit: 'EventTriggerPeriodUnit',
                 value: builtins.int,
                 max_invocations_per_profile: Optional[builtins.int] = None,
                 unlimited: Optional[builtins.bool] = None):
        """
        Defines a limit and the time period during which it is enforced.
        :param 'EventTriggerPeriodUnit' unit: The unit of time.
        :param builtins.int value: The amount of time of the specified unit.
        :param builtins.int max_invocations_per_profile: The maximum allowed number of destination invocations per profile.
        :param builtins.bool unlimited: If set to true, there is no limit on the number of destination invocations per profile. The default is false.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)
        if max_invocations_per_profile is not None:
            pulumi.set(__self__, "max_invocations_per_profile", max_invocations_per_profile)
        if unlimited is not None:
            pulumi.set(__self__, "unlimited", unlimited)

    @property
    @pulumi.getter
    def unit(self) -> 'EventTriggerPeriodUnit':
        """
        The unit of time.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        """
        The amount of time of the specified unit.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="maxInvocationsPerProfile")
    def max_invocations_per_profile(self) -> Optional[builtins.int]:
        """
        The maximum allowed number of destination invocations per profile.
        """
        return pulumi.get(self, "max_invocations_per_profile")

    @property
    @pulumi.getter
    def unlimited(self) -> Optional[builtins.bool]:
        """
        If set to true, there is no limit on the number of destination invocations per profile. The default is false.
        """
        return pulumi.get(self, "unlimited")


@pulumi.output_type
class IntegrationConnectorOperator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationConnectorOperator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationConnectorOperator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationConnectorOperator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 marketo: Optional['IntegrationMarketoConnectorOperator'] = None,
                 s3: Optional['IntegrationS3ConnectorOperator'] = None,
                 salesforce: Optional['IntegrationSalesforceConnectorOperator'] = None,
                 service_now: Optional['IntegrationServiceNowConnectorOperator'] = None,
                 zendesk: Optional['IntegrationZendeskConnectorOperator'] = None):
        """
        :param 'IntegrationMarketoConnectorOperator' marketo: The operation to be performed on the provided Marketo source fields.
        :param 'IntegrationS3ConnectorOperator' s3: The operation to be performed on the provided Amazon S3 source fields.
        :param 'IntegrationSalesforceConnectorOperator' salesforce: The operation to be performed on the provided Salesforce source fields.
        :param 'IntegrationServiceNowConnectorOperator' service_now: The operation to be performed on the provided ServiceNow source fields.
        :param 'IntegrationZendeskConnectorOperator' zendesk: The operation to be performed on the provided Zendesk source fields.
        """
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter
    def marketo(self) -> Optional['IntegrationMarketoConnectorOperator']:
        """
        The operation to be performed on the provided Marketo source fields.
        """
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def s3(self) -> Optional['IntegrationS3ConnectorOperator']:
        """
        The operation to be performed on the provided Amazon S3 source fields.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['IntegrationSalesforceConnectorOperator']:
        """
        The operation to be performed on the provided Salesforce source fields.
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['IntegrationServiceNowConnectorOperator']:
        """
        The operation to be performed on the provided ServiceNow source fields.
        """
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['IntegrationZendeskConnectorOperator']:
        """
        The operation to be performed on the provided Zendesk source fields.
        """
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class IntegrationFlowDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowName":
            suggest = "flow_name"
        elif key == "kmsArn":
            suggest = "kms_arn"
        elif key == "sourceFlowConfig":
            suggest = "source_flow_config"
        elif key == "triggerConfig":
            suggest = "trigger_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationFlowDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationFlowDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationFlowDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_name: builtins.str,
                 kms_arn: builtins.str,
                 source_flow_config: 'outputs.IntegrationSourceFlowConfig',
                 tasks: Sequence['outputs.IntegrationTask'],
                 trigger_config: 'outputs.IntegrationTriggerConfig',
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str flow_name: The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
        :param builtins.str kms_arn: The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key you provide for encryption.
        :param 'IntegrationSourceFlowConfig' source_flow_config: The configuration that controls how Customer Profiles retrieves data from the source.
        :param Sequence['IntegrationTask'] tasks: A list of tasks that Customer Profiles performs while transferring the data in the flow run.
        :param 'IntegrationTriggerConfig' trigger_config: The trigger settings that determine how and when the flow runs.
        :param builtins.str description: A description of the flow you want to create.
        """
        pulumi.set(__self__, "flow_name", flow_name)
        pulumi.set(__self__, "kms_arn", kms_arn)
        pulumi.set(__self__, "source_flow_config", source_flow_config)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "trigger_config", trigger_config)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="flowName")
    def flow_name(self) -> builtins.str:
        """
        The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
        """
        return pulumi.get(self, "flow_name")

    @property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key you provide for encryption.
        """
        return pulumi.get(self, "kms_arn")

    @property
    @pulumi.getter(name="sourceFlowConfig")
    def source_flow_config(self) -> 'outputs.IntegrationSourceFlowConfig':
        """
        The configuration that controls how Customer Profiles retrieves data from the source.
        """
        return pulumi.get(self, "source_flow_config")

    @property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.IntegrationTask']:
        """
        A list of tasks that Customer Profiles performs while transferring the data in the flow run.
        """
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> 'outputs.IntegrationTriggerConfig':
        """
        The trigger settings that determine how and when the flow runs.
        """
        return pulumi.get(self, "trigger_config")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the flow you want to create.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class IntegrationIncrementalPullConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datetimeTypeFieldName":
            suggest = "datetime_type_field_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationIncrementalPullConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationIncrementalPullConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationIncrementalPullConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datetime_type_field_name: Optional[builtins.str] = None):
        """
        :param builtins.str datetime_type_field_name: A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
        """
        if datetime_type_field_name is not None:
            pulumi.set(__self__, "datetime_type_field_name", datetime_type_field_name)

    @property
    @pulumi.getter(name="datetimeTypeFieldName")
    def datetime_type_field_name(self) -> Optional[builtins.str]:
        """
        A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
        """
        return pulumi.get(self, "datetime_type_field_name")


@pulumi.output_type
class IntegrationMarketoSourceProperties(dict):
    def __init__(__self__, *,
                 object: builtins.str):
        """
        :param builtins.str object: The object specified in the Marketo flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object specified in the Marketo flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class IntegrationObjectTypeMapping(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key.
        :param builtins.str value: The value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationS3SourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationS3SourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationS3SourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationS3SourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 bucket_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The Amazon S3 bucket name where the source files are stored.
        :param builtins.str bucket_prefix: The object key for the Amazon S3 bucket in which the source files are stored.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The Amazon S3 bucket name where the source files are stored.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[builtins.str]:
        """
        The object key for the Amazon S3 bucket in which the source files are stored.
        """
        return pulumi.get(self, "bucket_prefix")


@pulumi.output_type
class IntegrationSalesforceSourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDynamicFieldUpdate":
            suggest = "enable_dynamic_field_update"
        elif key == "includeDeletedRecords":
            suggest = "include_deleted_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationSalesforceSourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationSalesforceSourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationSalesforceSourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: builtins.str,
                 enable_dynamic_field_update: Optional[builtins.bool] = None,
                 include_deleted_records: Optional[builtins.bool] = None):
        """
        :param builtins.str object: The object specified in the Salesforce flow source.
        :param builtins.bool enable_dynamic_field_update: The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
        :param builtins.bool include_deleted_records: Indicates whether Amazon AppFlow includes deleted files in the flow run.
        """
        pulumi.set(__self__, "object", object)
        if enable_dynamic_field_update is not None:
            pulumi.set(__self__, "enable_dynamic_field_update", enable_dynamic_field_update)
        if include_deleted_records is not None:
            pulumi.set(__self__, "include_deleted_records", include_deleted_records)

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object specified in the Salesforce flow source.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="enableDynamicFieldUpdate")
    def enable_dynamic_field_update(self) -> Optional[builtins.bool]:
        """
        The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
        """
        return pulumi.get(self, "enable_dynamic_field_update")

    @property
    @pulumi.getter(name="includeDeletedRecords")
    def include_deleted_records(self) -> Optional[builtins.bool]:
        """
        Indicates whether Amazon AppFlow includes deleted files in the flow run.
        """
        return pulumi.get(self, "include_deleted_records")


@pulumi.output_type
class IntegrationScheduledTriggerProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"
        elif key == "dataPullMode":
            suggest = "data_pull_mode"
        elif key == "firstExecutionFrom":
            suggest = "first_execution_from"
        elif key == "scheduleEndTime":
            suggest = "schedule_end_time"
        elif key == "scheduleOffset":
            suggest = "schedule_offset"
        elif key == "scheduleStartTime":
            suggest = "schedule_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationScheduledTriggerProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationScheduledTriggerProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationScheduledTriggerProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: builtins.str,
                 data_pull_mode: Optional['IntegrationScheduledTriggerPropertiesDataPullMode'] = None,
                 first_execution_from: Optional[builtins.float] = None,
                 schedule_end_time: Optional[builtins.float] = None,
                 schedule_offset: Optional[builtins.int] = None,
                 schedule_start_time: Optional[builtins.float] = None,
                 timezone: Optional[builtins.str] = None):
        """
        :param builtins.str schedule_expression: The scheduling expression that determines the rate at which the schedule will run, for example rate (5 minutes).
        :param 'IntegrationScheduledTriggerPropertiesDataPullMode' data_pull_mode: Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
        :param builtins.float first_execution_from: Specifies the date range for the records to import from the connector in the first flow run.
        :param builtins.float schedule_end_time: Specifies the scheduled end time for a scheduled-trigger flow.
        :param builtins.int schedule_offset: Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
        :param builtins.float schedule_start_time: Specifies the scheduled start time for a scheduled-trigger flow. The value must be a date/time value in EPOCH format.
        :param builtins.str timezone: Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as America/New_York.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if data_pull_mode is not None:
            pulumi.set(__self__, "data_pull_mode", data_pull_mode)
        if first_execution_from is not None:
            pulumi.set(__self__, "first_execution_from", first_execution_from)
        if schedule_end_time is not None:
            pulumi.set(__self__, "schedule_end_time", schedule_end_time)
        if schedule_offset is not None:
            pulumi.set(__self__, "schedule_offset", schedule_offset)
        if schedule_start_time is not None:
            pulumi.set(__self__, "schedule_start_time", schedule_start_time)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> builtins.str:
        """
        The scheduling expression that determines the rate at which the schedule will run, for example rate (5 minutes).
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="dataPullMode")
    def data_pull_mode(self) -> Optional['IntegrationScheduledTriggerPropertiesDataPullMode']:
        """
        Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
        """
        return pulumi.get(self, "data_pull_mode")

    @property
    @pulumi.getter(name="firstExecutionFrom")
    def first_execution_from(self) -> Optional[builtins.float]:
        """
        Specifies the date range for the records to import from the connector in the first flow run.
        """
        return pulumi.get(self, "first_execution_from")

    @property
    @pulumi.getter(name="scheduleEndTime")
    def schedule_end_time(self) -> Optional[builtins.float]:
        """
        Specifies the scheduled end time for a scheduled-trigger flow.
        """
        return pulumi.get(self, "schedule_end_time")

    @property
    @pulumi.getter(name="scheduleOffset")
    def schedule_offset(self) -> Optional[builtins.int]:
        """
        Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
        """
        return pulumi.get(self, "schedule_offset")

    @property
    @pulumi.getter(name="scheduleStartTime")
    def schedule_start_time(self) -> Optional[builtins.float]:
        """
        Specifies the scheduled start time for a scheduled-trigger flow. The value must be a date/time value in EPOCH format.
        """
        return pulumi.get(self, "schedule_start_time")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[builtins.str]:
        """
        Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as America/New_York.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class IntegrationServiceNowSourceProperties(dict):
    def __init__(__self__, *,
                 object: builtins.str):
        """
        :param builtins.str object: The object specified in the ServiceNow flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object specified in the ServiceNow flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class IntegrationSourceConnectorProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationSourceConnectorProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationSourceConnectorProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationSourceConnectorProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 marketo: Optional['outputs.IntegrationMarketoSourceProperties'] = None,
                 s3: Optional['outputs.IntegrationS3SourceProperties'] = None,
                 salesforce: Optional['outputs.IntegrationSalesforceSourceProperties'] = None,
                 service_now: Optional['outputs.IntegrationServiceNowSourceProperties'] = None,
                 zendesk: Optional['outputs.IntegrationZendeskSourceProperties'] = None):
        """
        :param 'IntegrationMarketoSourceProperties' marketo: The properties that are applied when Marketo is being used as a source.
        :param 'IntegrationS3SourceProperties' s3: The properties that are applied when Amazon S3 is being used as the flow source.
        :param 'IntegrationSalesforceSourceProperties' salesforce: The properties that are applied when Salesforce is being used as a source.
        :param 'IntegrationServiceNowSourceProperties' service_now: The properties that are applied when ServiceNow is being used as a source.
        :param 'IntegrationZendeskSourceProperties' zendesk: The properties that are applied when using Zendesk as a flow source.
        """
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter
    def marketo(self) -> Optional['outputs.IntegrationMarketoSourceProperties']:
        """
        The properties that are applied when Marketo is being used as a source.
        """
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.IntegrationS3SourceProperties']:
        """
        The properties that are applied when Amazon S3 is being used as the flow source.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['outputs.IntegrationSalesforceSourceProperties']:
        """
        The properties that are applied when Salesforce is being used as a source.
        """
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['outputs.IntegrationServiceNowSourceProperties']:
        """
        The properties that are applied when ServiceNow is being used as a source.
        """
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['outputs.IntegrationZendeskSourceProperties']:
        """
        The properties that are applied when using Zendesk as a flow source.
        """
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class IntegrationSourceFlowConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "sourceConnectorProperties":
            suggest = "source_connector_properties"
        elif key == "connectorProfileName":
            suggest = "connector_profile_name"
        elif key == "incrementalPullConfig":
            suggest = "incremental_pull_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationSourceFlowConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationSourceFlowConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationSourceFlowConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: 'IntegrationConnectorType',
                 source_connector_properties: 'outputs.IntegrationSourceConnectorProperties',
                 connector_profile_name: Optional[builtins.str] = None,
                 incremental_pull_config: Optional['outputs.IntegrationIncrementalPullConfig'] = None):
        """
        :param 'IntegrationConnectorType' connector_type: The type of connector, such as Salesforce, Marketo, and so on.
        :param 'IntegrationSourceConnectorProperties' source_connector_properties: Specifies the information that is required to query a particular source connector.
        :param builtins.str connector_profile_name: The name of the Amazon AppFlow connector profile. This name must be unique for each connector profile in the AWS account .
        :param 'IntegrationIncrementalPullConfig' incremental_pull_config: Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
        """
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "source_connector_properties", source_connector_properties)
        if connector_profile_name is not None:
            pulumi.set(__self__, "connector_profile_name", connector_profile_name)
        if incremental_pull_config is not None:
            pulumi.set(__self__, "incremental_pull_config", incremental_pull_config)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> 'IntegrationConnectorType':
        """
        The type of connector, such as Salesforce, Marketo, and so on.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="sourceConnectorProperties")
    def source_connector_properties(self) -> 'outputs.IntegrationSourceConnectorProperties':
        """
        Specifies the information that is required to query a particular source connector.
        """
        return pulumi.get(self, "source_connector_properties")

    @property
    @pulumi.getter(name="connectorProfileName")
    def connector_profile_name(self) -> Optional[builtins.str]:
        """
        The name of the Amazon AppFlow connector profile. This name must be unique for each connector profile in the AWS account .
        """
        return pulumi.get(self, "connector_profile_name")

    @property
    @pulumi.getter(name="incrementalPullConfig")
    def incremental_pull_config(self) -> Optional['outputs.IntegrationIncrementalPullConfig']:
        """
        Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
        """
        return pulumi.get(self, "incremental_pull_config")


@pulumi.output_type
class IntegrationTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFields":
            suggest = "source_fields"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "connectorOperator":
            suggest = "connector_operator"
        elif key == "destinationField":
            suggest = "destination_field"
        elif key == "taskProperties":
            suggest = "task_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_fields: Sequence[builtins.str],
                 task_type: 'IntegrationTaskType',
                 connector_operator: Optional['outputs.IntegrationConnectorOperator'] = None,
                 destination_field: Optional[builtins.str] = None,
                 task_properties: Optional[Sequence['outputs.IntegrationTaskPropertiesMap']] = None):
        """
        :param Sequence[builtins.str] source_fields: The source fields to which a particular task is applied.
        :param 'IntegrationTaskType' task_type: Specifies the particular task implementation that Amazon AppFlow performs.
        :param 'IntegrationConnectorOperator' connector_operator: The operation to be performed on the provided source fields.
        :param builtins.str destination_field: A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
        :param Sequence['IntegrationTaskPropertiesMap'] task_properties: A map used to store task-related information. The service looks for particular information based on the TaskType.
        """
        pulumi.set(__self__, "source_fields", source_fields)
        pulumi.set(__self__, "task_type", task_type)
        if connector_operator is not None:
            pulumi.set(__self__, "connector_operator", connector_operator)
        if destination_field is not None:
            pulumi.set(__self__, "destination_field", destination_field)
        if task_properties is not None:
            pulumi.set(__self__, "task_properties", task_properties)

    @property
    @pulumi.getter(name="sourceFields")
    def source_fields(self) -> Sequence[builtins.str]:
        """
        The source fields to which a particular task is applied.
        """
        return pulumi.get(self, "source_fields")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> 'IntegrationTaskType':
        """
        Specifies the particular task implementation that Amazon AppFlow performs.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="connectorOperator")
    def connector_operator(self) -> Optional['outputs.IntegrationConnectorOperator']:
        """
        The operation to be performed on the provided source fields.
        """
        return pulumi.get(self, "connector_operator")

    @property
    @pulumi.getter(name="destinationField")
    def destination_field(self) -> Optional[builtins.str]:
        """
        A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
        """
        return pulumi.get(self, "destination_field")

    @property
    @pulumi.getter(name="taskProperties")
    def task_properties(self) -> Optional[Sequence['outputs.IntegrationTaskPropertiesMap']]:
        """
        A map used to store task-related information. The service looks for particular information based on the TaskType.
        """
        return pulumi.get(self, "task_properties")


@pulumi.output_type
class IntegrationTaskPropertiesMap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorPropertyKey":
            suggest = "operator_property_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTaskPropertiesMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTaskPropertiesMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTaskPropertiesMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_property_key: 'IntegrationOperatorPropertiesKeys',
                 property: builtins.str):
        """
        :param 'IntegrationOperatorPropertiesKeys' operator_property_key: The task property key.
        :param builtins.str property: The task property value.
        """
        pulumi.set(__self__, "operator_property_key", operator_property_key)
        pulumi.set(__self__, "property", property)

    @property
    @pulumi.getter(name="operatorPropertyKey")
    def operator_property_key(self) -> 'IntegrationOperatorPropertiesKeys':
        """
        The task property key.
        """
        return pulumi.get(self, "operator_property_key")

    @property
    @pulumi.getter
    def property(self) -> builtins.str:
        """
        The task property value.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class IntegrationTriggerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggerType":
            suggest = "trigger_type"
        elif key == "triggerProperties":
            suggest = "trigger_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTriggerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTriggerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTriggerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trigger_type: 'IntegrationTriggerType',
                 trigger_properties: Optional['outputs.IntegrationTriggerProperties'] = None):
        """
        :param 'IntegrationTriggerType' trigger_type: Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.
        :param 'IntegrationTriggerProperties' trigger_properties: Specifies the configuration details of a schedule-triggered flow that you define. Currently, these settings only apply to the Scheduled trigger type.
        """
        pulumi.set(__self__, "trigger_type", trigger_type)
        if trigger_properties is not None:
            pulumi.set(__self__, "trigger_properties", trigger_properties)

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> 'IntegrationTriggerType':
        """
        Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="triggerProperties")
    def trigger_properties(self) -> Optional['outputs.IntegrationTriggerProperties']:
        """
        Specifies the configuration details of a schedule-triggered flow that you define. Currently, these settings only apply to the Scheduled trigger type.
        """
        return pulumi.get(self, "trigger_properties")


@pulumi.output_type
class IntegrationTriggerProperties(dict):
    def __init__(__self__, *,
                 scheduled: Optional['outputs.IntegrationScheduledTriggerProperties'] = None):
        """
        :param 'IntegrationScheduledTriggerProperties' scheduled: Specifies the configuration details of a schedule-triggered flow that you define.
        """
        if scheduled is not None:
            pulumi.set(__self__, "scheduled", scheduled)

    @property
    @pulumi.getter
    def scheduled(self) -> Optional['outputs.IntegrationScheduledTriggerProperties']:
        """
        Specifies the configuration details of a schedule-triggered flow that you define.
        """
        return pulumi.get(self, "scheduled")


@pulumi.output_type
class IntegrationZendeskSourceProperties(dict):
    def __init__(__self__, *,
                 object: builtins.str):
        """
        :param builtins.str object: The object specified in the Zendesk flow source.
        """
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object specified in the Zendesk flow source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ObjectTypeField(dict):
    """
    Represents a field in a ProfileObjectType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeField. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeField.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeField.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional['ObjectTypeFieldContentType'] = None,
                 source: Optional[builtins.str] = None,
                 target: Optional[builtins.str] = None):
        """
        Represents a field in a ProfileObjectType.
        :param 'ObjectTypeFieldContentType' content_type: The content type of the field. Used for determining equality when searching.
        :param builtins.str source: A field of a ProfileObject. For example: _source.FirstName, where "_source" is a ProfileObjectType of a Zendesk user and "FirstName" is a field in that ObjectType.
        :param builtins.str target: The location of the data in the standard ProfileObject model. For example: _profile.Address.PostalCode.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional['ObjectTypeFieldContentType']:
        """
        The content type of the field. Used for determining equality when searching.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        A field of a ProfileObject. For example: _source.FirstName, where "_source" is a ProfileObjectType of a Zendesk user and "FirstName" is a field in that ObjectType.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        The location of the data in the standard ProfileObject model. For example: _profile.Address.PostalCode.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ObjectTypeFieldMap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectTypeField":
            suggest = "object_type_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeFieldMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeFieldMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeFieldMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 object_type_field: Optional['outputs.ObjectTypeField'] = None):
        """
        :param builtins.str name: Name of the field.
        :param 'ObjectTypeField' object_type_field: Represents a field in a ProfileObjectType.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_type_field is not None:
            pulumi.set(__self__, "object_type_field", object_type_field)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectTypeField")
    def object_type_field(self) -> Optional['outputs.ObjectTypeField']:
        """
        Represents a field in a ProfileObjectType.
        """
        return pulumi.get(self, "object_type_field")


@pulumi.output_type
class ObjectTypeKey(dict):
    """
    An object that defines the Key element of a ProfileObject. A Key is a special element that can be used to search for a customer profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldNames":
            suggest = "field_names"
        elif key == "standardIdentifiers":
            suggest = "standard_identifiers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_names: Optional[Sequence[builtins.str]] = None,
                 standard_identifiers: Optional[Sequence['ObjectTypeKeyStandardIdentifiersItem']] = None):
        """
        An object that defines the Key element of a ProfileObject. A Key is a special element that can be used to search for a customer profile.
        :param Sequence[builtins.str] field_names: The reference for the key name of the fields map. 
        :param Sequence['ObjectTypeKeyStandardIdentifiersItem'] standard_identifiers: The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple PROFILE keys. PROFILE means that this key can be used to tie an object to a PROFILE. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it is only used for matching objects to profiles.
        """
        if field_names is not None:
            pulumi.set(__self__, "field_names", field_names)
        if standard_identifiers is not None:
            pulumi.set(__self__, "standard_identifiers", standard_identifiers)

    @property
    @pulumi.getter(name="fieldNames")
    def field_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The reference for the key name of the fields map. 
        """
        return pulumi.get(self, "field_names")

    @property
    @pulumi.getter(name="standardIdentifiers")
    def standard_identifiers(self) -> Optional[Sequence['ObjectTypeKeyStandardIdentifiersItem']]:
        """
        The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple PROFILE keys. PROFILE means that this key can be used to tie an object to a PROFILE. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it is only used for matching objects to profiles.
        """
        return pulumi.get(self, "standard_identifiers")


@pulumi.output_type
class ObjectTypeKeyMap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectTypeKeyList":
            suggest = "object_type_key_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeKeyMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeKeyMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeKeyMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 object_type_key_list: Optional[Sequence['outputs.ObjectTypeKey']] = None):
        """
        :param builtins.str name: Name of the key.
        :param Sequence['ObjectTypeKey'] object_type_key_list: A list of ObjectTypeKey.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_type_key_list is not None:
            pulumi.set(__self__, "object_type_key_list", object_type_key_list)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectTypeKeyList")
    def object_type_key_list(self) -> Optional[Sequence['outputs.ObjectTypeKey']]:
        """
        A list of ObjectTypeKey.
        """
        return pulumi.get(self, "object_type_key_list")


@pulumi.output_type
class SegmentDefinitionAddressDimension(dict):
    """
    The address based criteria for the segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionAddressDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionAddressDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionAddressDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 city: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 country: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 county: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 postal_code: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 province: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 state: Optional['outputs.SegmentDefinitionProfileDimension'] = None):
        """
        The address based criteria for the segment.
        """
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def city(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def country(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "state")


@pulumi.output_type
class SegmentDefinitionAttributeDimension(dict):
    """
    Specifies attribute based criteria for a segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionType":
            suggest = "dimension_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionAttributeDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionAttributeDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionAttributeDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_type: 'SegmentDefinitionAttributeDimensionType',
                 values: Sequence[builtins.str]):
        """
        Specifies attribute based criteria for a segment.
        """
        pulumi.set(__self__, "dimension_type", dimension_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionType")
    def dimension_type(self) -> 'SegmentDefinitionAttributeDimensionType':
        return pulumi.get(self, "dimension_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class SegmentDefinitionCalculatedAttributeDimension(dict):
    """
    Specifies calculated attribute based criteria for a segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionType":
            suggest = "dimension_type"
        elif key == "conditionOverrides":
            suggest = "condition_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionCalculatedAttributeDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionCalculatedAttributeDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionCalculatedAttributeDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_type: 'SegmentDefinitionAttributeDimensionType',
                 values: Sequence[builtins.str],
                 condition_overrides: Optional['outputs.SegmentDefinitionConditionOverrides'] = None):
        """
        Specifies calculated attribute based criteria for a segment.
        """
        pulumi.set(__self__, "dimension_type", dimension_type)
        pulumi.set(__self__, "values", values)
        if condition_overrides is not None:
            pulumi.set(__self__, "condition_overrides", condition_overrides)

    @property
    @pulumi.getter(name="dimensionType")
    def dimension_type(self) -> 'SegmentDefinitionAttributeDimensionType':
        return pulumi.get(self, "dimension_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="conditionOverrides")
    def condition_overrides(self) -> Optional['outputs.SegmentDefinitionConditionOverrides']:
        return pulumi.get(self, "condition_overrides")


@pulumi.output_type
class SegmentDefinitionConditionOverrides(dict):
    """
    Overrides the condition block within the original calculated attribute definition.
    """
    def __init__(__self__, *,
                 range: Optional['outputs.SegmentDefinitionRangeOverride'] = None):
        """
        Overrides the condition block within the original calculated attribute definition.
        """
        if range is not None:
            pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter
    def range(self) -> Optional['outputs.SegmentDefinitionRangeOverride']:
        return pulumi.get(self, "range")


@pulumi.output_type
class SegmentDefinitionDateDimension(dict):
    """
    Specifies date based criteria for a segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionType":
            suggest = "dimension_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionDateDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionDateDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionDateDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_type: 'SegmentDefinitionDateDimensionType',
                 values: Sequence[builtins.str]):
        """
        Specifies date based criteria for a segment.
        """
        pulumi.set(__self__, "dimension_type", dimension_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionType")
    def dimension_type(self) -> 'SegmentDefinitionDateDimensionType':
        return pulumi.get(self, "dimension_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class SegmentDefinitionDimension0Properties(dict):
    """
    The criteria that define the dimensions for the segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "profileAttributes":
            suggest = "profile_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionDimension0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionDimension0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionDimension0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 profile_attributes: 'outputs.SegmentDefinitionProfileAttributes'):
        """
        The criteria that define the dimensions for the segment.
        """
        pulumi.set(__self__, "profile_attributes", profile_attributes)

    @property
    @pulumi.getter(name="profileAttributes")
    def profile_attributes(self) -> 'outputs.SegmentDefinitionProfileAttributes':
        return pulumi.get(self, "profile_attributes")


@pulumi.output_type
class SegmentDefinitionDimension1Properties(dict):
    """
    The criteria that define the dimensions for the segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "calculatedAttributes":
            suggest = "calculated_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionDimension1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionDimension1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionDimension1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 calculated_attributes: Optional[Mapping[str, 'outputs.SegmentDefinitionCalculatedAttributeDimension']] = None):
        """
        The criteria that define the dimensions for the segment.
        """
        if calculated_attributes is not None:
            pulumi.set(__self__, "calculated_attributes", calculated_attributes)

    @property
    @pulumi.getter(name="calculatedAttributes")
    def calculated_attributes(self) -> Optional[Mapping[str, 'outputs.SegmentDefinitionCalculatedAttributeDimension']]:
        return pulumi.get(self, "calculated_attributes")


@pulumi.output_type
class SegmentDefinitionExtraLengthValueProfileDimension(dict):
    """
    Specifies criteria for a segment using extended-length string values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionType":
            suggest = "dimension_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionExtraLengthValueProfileDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionExtraLengthValueProfileDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionExtraLengthValueProfileDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_type: 'SegmentDefinitionStringDimensionType',
                 values: Sequence[builtins.str]):
        """
        Specifies criteria for a segment using extended-length string values.
        """
        pulumi.set(__self__, "dimension_type", dimension_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionType")
    def dimension_type(self) -> 'SegmentDefinitionStringDimensionType':
        return pulumi.get(self, "dimension_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class SegmentDefinitionGroup(dict):
    """
    An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceSegments":
            suggest = "source_segments"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence[Any]] = None,
                 source_segments: Optional[Sequence['outputs.SegmentDefinitionSourceSegment']] = None,
                 source_type: Optional['SegmentDefinitionIncludeOptions'] = None,
                 type: Optional['SegmentDefinitionIncludeOptions'] = None):
        """
        An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
        :param Sequence[Union['SegmentDefinitionDimension0Properties', 'SegmentDefinitionDimension1Properties']] dimensions: Defines the attributes to segment on.
        :param Sequence['SegmentDefinitionSourceSegment'] source_segments: Defines the starting source of data.
        :param 'SegmentDefinitionIncludeOptions' source_type: Defines how to interact with the source data.
        :param 'SegmentDefinitionIncludeOptions' type: Defines how to interact with the profiles found in the current filtering.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if source_segments is not None:
            pulumi.set(__self__, "source_segments", source_segments)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence[Any]]:
        """
        Defines the attributes to segment on.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="sourceSegments")
    def source_segments(self) -> Optional[Sequence['outputs.SegmentDefinitionSourceSegment']]:
        """
        Defines the starting source of data.
        """
        return pulumi.get(self, "source_segments")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional['SegmentDefinitionIncludeOptions']:
        """
        Defines how to interact with the source data.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def type(self) -> Optional['SegmentDefinitionIncludeOptions']:
        """
        Defines how to interact with the profiles found in the current filtering.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SegmentDefinitionProfileAttributes(dict):
    """
    Specifies the dimension settings within profile attributes for a segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountNumber":
            suggest = "account_number"
        elif key == "additionalInformation":
            suggest = "additional_information"
        elif key == "billingAddress":
            suggest = "billing_address"
        elif key == "birthDate":
            suggest = "birth_date"
        elif key == "businessEmailAddress":
            suggest = "business_email_address"
        elif key == "businessName":
            suggest = "business_name"
        elif key == "businessPhoneNumber":
            suggest = "business_phone_number"
        elif key == "emailAddress":
            suggest = "email_address"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "genderString":
            suggest = "gender_string"
        elif key == "homePhoneNumber":
            suggest = "home_phone_number"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "mailingAddress":
            suggest = "mailing_address"
        elif key == "middleName":
            suggest = "middle_name"
        elif key == "mobilePhoneNumber":
            suggest = "mobile_phone_number"
        elif key == "partyTypeString":
            suggest = "party_type_string"
        elif key == "personalEmailAddress":
            suggest = "personal_email_address"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "shippingAddress":
            suggest = "shipping_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionProfileAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionProfileAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionProfileAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_number: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 additional_information: Optional['outputs.SegmentDefinitionExtraLengthValueProfileDimension'] = None,
                 address: Optional['outputs.SegmentDefinitionAddressDimension'] = None,
                 attributes: Optional[Mapping[str, 'outputs.SegmentDefinitionAttributeDimension']] = None,
                 billing_address: Optional['outputs.SegmentDefinitionAddressDimension'] = None,
                 birth_date: Optional['outputs.SegmentDefinitionDateDimension'] = None,
                 business_email_address: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 business_name: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 business_phone_number: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 email_address: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 first_name: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 gender_string: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 home_phone_number: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 last_name: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 mailing_address: Optional['outputs.SegmentDefinitionAddressDimension'] = None,
                 middle_name: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 mobile_phone_number: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 party_type_string: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 personal_email_address: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 phone_number: Optional['outputs.SegmentDefinitionProfileDimension'] = None,
                 shipping_address: Optional['outputs.SegmentDefinitionAddressDimension'] = None):
        """
        Specifies the dimension settings within profile attributes for a segment.
        """
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if billing_address is not None:
            pulumi.set(__self__, "billing_address", billing_address)
        if birth_date is not None:
            pulumi.set(__self__, "birth_date", birth_date)
        if business_email_address is not None:
            pulumi.set(__self__, "business_email_address", business_email_address)
        if business_name is not None:
            pulumi.set(__self__, "business_name", business_name)
        if business_phone_number is not None:
            pulumi.set(__self__, "business_phone_number", business_phone_number)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if gender_string is not None:
            pulumi.set(__self__, "gender_string", gender_string)
        if home_phone_number is not None:
            pulumi.set(__self__, "home_phone_number", home_phone_number)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if mailing_address is not None:
            pulumi.set(__self__, "mailing_address", mailing_address)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone_number is not None:
            pulumi.set(__self__, "mobile_phone_number", mobile_phone_number)
        if party_type_string is not None:
            pulumi.set(__self__, "party_type_string", party_type_string)
        if personal_email_address is not None:
            pulumi.set(__self__, "personal_email_address", personal_email_address)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if shipping_address is not None:
            pulumi.set(__self__, "shipping_address", shipping_address)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional['outputs.SegmentDefinitionExtraLengthValueProfileDimension']:
        return pulumi.get(self, "additional_information")

    @property
    @pulumi.getter
    def address(self) -> Optional['outputs.SegmentDefinitionAddressDimension']:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, 'outputs.SegmentDefinitionAttributeDimension']]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> Optional['outputs.SegmentDefinitionAddressDimension']:
        return pulumi.get(self, "billing_address")

    @property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> Optional['outputs.SegmentDefinitionDateDimension']:
        return pulumi.get(self, "birth_date")

    @property
    @pulumi.getter(name="businessEmailAddress")
    def business_email_address(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "business_email_address")

    @property
    @pulumi.getter(name="businessName")
    def business_name(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "business_name")

    @property
    @pulumi.getter(name="businessPhoneNumber")
    def business_phone_number(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "business_phone_number")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="genderString")
    def gender_string(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "gender_string")

    @property
    @pulumi.getter(name="homePhoneNumber")
    def home_phone_number(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "home_phone_number")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="mailingAddress")
    def mailing_address(self) -> Optional['outputs.SegmentDefinitionAddressDimension']:
        return pulumi.get(self, "mailing_address")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="mobilePhoneNumber")
    def mobile_phone_number(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "mobile_phone_number")

    @property
    @pulumi.getter(name="partyTypeString")
    def party_type_string(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "party_type_string")

    @property
    @pulumi.getter(name="personalEmailAddress")
    def personal_email_address(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "personal_email_address")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional['outputs.SegmentDefinitionProfileDimension']:
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="shippingAddress")
    def shipping_address(self) -> Optional['outputs.SegmentDefinitionAddressDimension']:
        return pulumi.get(self, "shipping_address")


@pulumi.output_type
class SegmentDefinitionProfileDimension(dict):
    """
    Specifies profile based criteria for a segment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionType":
            suggest = "dimension_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionProfileDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionProfileDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionProfileDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_type: 'SegmentDefinitionStringDimensionType',
                 values: Sequence[builtins.str]):
        """
        Specifies profile based criteria for a segment.
        """
        pulumi.set(__self__, "dimension_type", dimension_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionType")
    def dimension_type(self) -> 'SegmentDefinitionStringDimensionType':
        return pulumi.get(self, "dimension_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class SegmentDefinitionRangeOverride(dict):
    """
    Defines the range to be applied to the calculated attribute definition.
    """
    def __init__(__self__, *,
                 start: builtins.int,
                 unit: 'SegmentDefinitionRangeOverrideUnit',
                 end: Optional[builtins.int] = None):
        """
        Defines the range to be applied to the calculated attribute definition.
        :param builtins.int start: The starting point for this overridden range.
        :param 'SegmentDefinitionRangeOverrideUnit' unit: The unit to be applied to the range.
        :param builtins.int end: The ending point for this overridden range.
        """
        pulumi.set(__self__, "start", start)
        pulumi.set(__self__, "unit", unit)
        if end is not None:
            pulumi.set(__self__, "end", end)

    @property
    @pulumi.getter
    def start(self) -> builtins.int:
        """
        The starting point for this overridden range.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter
    def unit(self) -> 'SegmentDefinitionRangeOverrideUnit':
        """
        The unit to be applied to the range.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def end(self) -> Optional[builtins.int]:
        """
        The ending point for this overridden range.
        """
        return pulumi.get(self, "end")


@pulumi.output_type
class SegmentDefinitionSegmentGroup(dict):
    def __init__(__self__, *,
                 groups: Optional[Sequence['outputs.SegmentDefinitionGroup']] = None,
                 include: Optional['SegmentDefinitionIncludeOptions'] = None):
        """
        :param Sequence['SegmentDefinitionGroup'] groups: Holds the list of groups within the segment definition.
        :param 'SegmentDefinitionIncludeOptions' include: Defines whether to include or exclude the profiles that fit the segment criteria.
        """
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if include is not None:
            pulumi.set(__self__, "include", include)

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence['outputs.SegmentDefinitionGroup']]:
        """
        Holds the list of groups within the segment definition.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def include(self) -> Optional['SegmentDefinitionIncludeOptions']:
        """
        Defines whether to include or exclude the profiles that fit the segment criteria.
        """
        return pulumi.get(self, "include")


@pulumi.output_type
class SegmentDefinitionSourceSegment(dict):
    """
    The base segment to build the segment on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentDefinitionName":
            suggest = "segment_definition_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentDefinitionSourceSegment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentDefinitionSourceSegment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentDefinitionSourceSegment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 segment_definition_name: Optional[builtins.str] = None):
        """
        The base segment to build the segment on.
        :param builtins.str segment_definition_name: The name of the source segment.
        """
        if segment_definition_name is not None:
            pulumi.set(__self__, "segment_definition_name", segment_definition_name)

    @property
    @pulumi.getter(name="segmentDefinitionName")
    def segment_definition_name(self) -> Optional[builtins.str]:
        """
        The name of the source segment.
        """
        return pulumi.get(self, "segment_definition_name")


