# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetSegmentDefinitionResult',
    'AwaitableGetSegmentDefinitionResult',
    'get_segment_definition',
    'get_segment_definition_output',
]

@pulumi.output_type
class GetSegmentDefinitionResult:
    def __init__(__self__, created_at=None, description=None, segment_definition_arn=None, tags=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if segment_definition_arn and not isinstance(segment_definition_arn, str):
            raise TypeError("Expected argument 'segment_definition_arn' to be a str")
        pulumi.set(__self__, "segment_definition_arn", segment_definition_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The time of this segment definition got created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the segment definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="segmentDefinitionArn")
    def segment_definition_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the segment definition.
        """
        return pulumi.get(self, "segment_definition_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSegmentDefinitionResult(GetSegmentDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSegmentDefinitionResult(
            created_at=self.created_at,
            description=self.description,
            segment_definition_arn=self.segment_definition_arn,
            tags=self.tags)


def get_segment_definition(domain_name: Optional[builtins.str] = None,
                           segment_definition_name: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSegmentDefinitionResult:
    """
    A segment definition resource of Amazon Connect Customer Profiles


    :param builtins.str domain_name: The unique name of the domain.
    :param builtins.str segment_definition_name: The unique name of the segment definition.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['segmentDefinitionName'] = segment_definition_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:customerprofiles:getSegmentDefinition', __args__, opts=opts, typ=GetSegmentDefinitionResult).value

    return AwaitableGetSegmentDefinitionResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        segment_definition_arn=pulumi.get(__ret__, 'segment_definition_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_segment_definition_output(domain_name: Optional[pulumi.Input[builtins.str]] = None,
                                  segment_definition_name: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSegmentDefinitionResult]:
    """
    A segment definition resource of Amazon Connect Customer Profiles


    :param builtins.str domain_name: The unique name of the domain.
    :param builtins.str segment_definition_name: The unique name of the segment definition.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['segmentDefinitionName'] = segment_definition_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:customerprofiles:getSegmentDefinition', __args__, opts=opts, typ=GetSegmentDefinitionResult)
    return __ret__.apply(lambda __response__: GetSegmentDefinitionResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        segment_definition_arn=pulumi.get(__response__, 'segment_definition_arn'),
        tags=pulumi.get(__response__, 'tags')))
