# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetEventTriggerResult',
    'AwaitableGetEventTriggerResult',
    'get_event_trigger',
    'get_event_trigger_output',
]

@pulumi.output_type
class GetEventTriggerResult:
    def __init__(__self__, created_at=None, description=None, event_trigger_conditions=None, event_trigger_limits=None, last_updated_at=None, object_type_name=None, segment_filter=None, tags=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if event_trigger_conditions and not isinstance(event_trigger_conditions, list):
            raise TypeError("Expected argument 'event_trigger_conditions' to be a list")
        pulumi.set(__self__, "event_trigger_conditions", event_trigger_conditions)
        if event_trigger_limits and not isinstance(event_trigger_limits, dict):
            raise TypeError("Expected argument 'event_trigger_limits' to be a dict")
        pulumi.set(__self__, "event_trigger_limits", event_trigger_limits)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if object_type_name and not isinstance(object_type_name, str):
            raise TypeError("Expected argument 'object_type_name' to be a str")
        pulumi.set(__self__, "object_type_name", object_type_name)
        if segment_filter and not isinstance(segment_filter, str):
            raise TypeError("Expected argument 'segment_filter' to be a str")
        pulumi.set(__self__, "segment_filter", segment_filter)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The timestamp of when the event trigger was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the event trigger.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventTriggerConditions")
    def event_trigger_conditions(self) -> Optional[Sequence['outputs.EventTriggerCondition']]:
        """
        A list of conditions that determine when an event should trigger the destination.
        """
        return pulumi.get(self, "event_trigger_conditions")

    @property
    @pulumi.getter(name="eventTriggerLimits")
    def event_trigger_limits(self) -> Optional['outputs.EventTriggerLimits']:
        """
        Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
        """
        return pulumi.get(self, "event_trigger_limits")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[builtins.str]:
        """
        The timestamp of when the event trigger was most recently updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter(name="objectTypeName")
    def object_type_name(self) -> Optional[builtins.str]:
        """
        The unique name of the object type.
        """
        return pulumi.get(self, "object_type_name")

    @property
    @pulumi.getter(name="segmentFilter")
    def segment_filter(self) -> Optional[builtins.str]:
        """
        The destination is triggered only for profiles that meet the criteria of a segment definition.
        """
        return pulumi.get(self, "segment_filter")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEventTriggerResult(GetEventTriggerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventTriggerResult(
            created_at=self.created_at,
            description=self.description,
            event_trigger_conditions=self.event_trigger_conditions,
            event_trigger_limits=self.event_trigger_limits,
            last_updated_at=self.last_updated_at,
            object_type_name=self.object_type_name,
            segment_filter=self.segment_filter,
            tags=self.tags)


def get_event_trigger(domain_name: Optional[builtins.str] = None,
                      event_trigger_name: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventTriggerResult:
    """
    An event trigger resource of Amazon Connect Customer Profiles


    :param builtins.str domain_name: The unique name of the domain.
    :param builtins.str event_trigger_name: The unique name of the event trigger.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['eventTriggerName'] = event_trigger_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:customerprofiles:getEventTrigger', __args__, opts=opts, typ=GetEventTriggerResult).value

    return AwaitableGetEventTriggerResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        event_trigger_conditions=pulumi.get(__ret__, 'event_trigger_conditions'),
        event_trigger_limits=pulumi.get(__ret__, 'event_trigger_limits'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        object_type_name=pulumi.get(__ret__, 'object_type_name'),
        segment_filter=pulumi.get(__ret__, 'segment_filter'),
        tags=pulumi.get(__ret__, 'tags'))
def get_event_trigger_output(domain_name: Optional[pulumi.Input[builtins.str]] = None,
                             event_trigger_name: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventTriggerResult]:
    """
    An event trigger resource of Amazon Connect Customer Profiles


    :param builtins.str domain_name: The unique name of the domain.
    :param builtins.str event_trigger_name: The unique name of the event trigger.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['eventTriggerName'] = event_trigger_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:customerprofiles:getEventTrigger', __args__, opts=opts, typ=GetEventTriggerResult)
    return __ret__.apply(lambda __response__: GetEventTriggerResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        event_trigger_conditions=pulumi.get(__response__, 'event_trigger_conditions'),
        event_trigger_limits=pulumi.get(__response__, 'event_trigger_limits'),
        last_updated_at=pulumi.get(__response__, 'last_updated_at'),
        object_type_name=pulumi.get(__response__, 'object_type_name'),
        segment_filter=pulumi.get(__response__, 'segment_filter'),
        tags=pulumi.get(__response__, 'tags')))
