# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['EventTriggerArgs', 'EventTrigger']

@pulumi.input_type
class EventTriggerArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[builtins.str],
                 event_trigger_conditions: pulumi.Input[Sequence[pulumi.Input['EventTriggerConditionArgs']]],
                 object_type_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 event_trigger_limits: Optional[pulumi.Input['EventTriggerLimitsArgs']] = None,
                 event_trigger_name: Optional[pulumi.Input[builtins.str]] = None,
                 segment_filter: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a EventTrigger resource.
        :param pulumi.Input[builtins.str] domain_name: The unique name of the domain.
        :param pulumi.Input[Sequence[pulumi.Input['EventTriggerConditionArgs']]] event_trigger_conditions: A list of conditions that determine when an event should trigger the destination.
        :param pulumi.Input[builtins.str] object_type_name: The unique name of the object type.
        :param pulumi.Input[builtins.str] description: The description of the event trigger.
        :param pulumi.Input['EventTriggerLimitsArgs'] event_trigger_limits: Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
        :param pulumi.Input[builtins.str] event_trigger_name: The unique name of the event trigger.
        :param pulumi.Input[builtins.str] segment_filter: The destination is triggered only for profiles that meet the criteria of a segment definition.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "event_trigger_conditions", event_trigger_conditions)
        pulumi.set(__self__, "object_type_name", object_type_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_trigger_limits is not None:
            pulumi.set(__self__, "event_trigger_limits", event_trigger_limits)
        if event_trigger_name is not None:
            pulumi.set(__self__, "event_trigger_name", event_trigger_name)
        if segment_filter is not None:
            pulumi.set(__self__, "segment_filter", segment_filter)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        The unique name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="eventTriggerConditions")
    def event_trigger_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['EventTriggerConditionArgs']]]:
        """
        A list of conditions that determine when an event should trigger the destination.
        """
        return pulumi.get(self, "event_trigger_conditions")

    @event_trigger_conditions.setter
    def event_trigger_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['EventTriggerConditionArgs']]]):
        pulumi.set(self, "event_trigger_conditions", value)

    @property
    @pulumi.getter(name="objectTypeName")
    def object_type_name(self) -> pulumi.Input[builtins.str]:
        """
        The unique name of the object type.
        """
        return pulumi.get(self, "object_type_name")

    @object_type_name.setter
    def object_type_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object_type_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the event trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventTriggerLimits")
    def event_trigger_limits(self) -> Optional[pulumi.Input['EventTriggerLimitsArgs']]:
        """
        Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
        """
        return pulumi.get(self, "event_trigger_limits")

    @event_trigger_limits.setter
    def event_trigger_limits(self, value: Optional[pulumi.Input['EventTriggerLimitsArgs']]):
        pulumi.set(self, "event_trigger_limits", value)

    @property
    @pulumi.getter(name="eventTriggerName")
    def event_trigger_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the event trigger.
        """
        return pulumi.get(self, "event_trigger_name")

    @event_trigger_name.setter
    def event_trigger_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_trigger_name", value)

    @property
    @pulumi.getter(name="segmentFilter")
    def segment_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination is triggered only for profiles that meet the criteria of a segment definition.
        """
        return pulumi.get(self, "segment_filter")

    @segment_filter.setter
    def segment_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "segment_filter", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:customerprofiles:EventTrigger")
class EventTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 event_trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventTriggerConditionArgs', 'EventTriggerConditionArgsDict']]]]] = None,
                 event_trigger_limits: Optional[pulumi.Input[Union['EventTriggerLimitsArgs', 'EventTriggerLimitsArgsDict']]] = None,
                 event_trigger_name: Optional[pulumi.Input[builtins.str]] = None,
                 object_type_name: Optional[pulumi.Input[builtins.str]] = None,
                 segment_filter: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        An event trigger resource of Amazon Connect Customer Profiles

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the event trigger.
        :param pulumi.Input[builtins.str] domain_name: The unique name of the domain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventTriggerConditionArgs', 'EventTriggerConditionArgsDict']]]] event_trigger_conditions: A list of conditions that determine when an event should trigger the destination.
        :param pulumi.Input[Union['EventTriggerLimitsArgs', 'EventTriggerLimitsArgsDict']] event_trigger_limits: Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
        :param pulumi.Input[builtins.str] event_trigger_name: The unique name of the event trigger.
        :param pulumi.Input[builtins.str] object_type_name: The unique name of the object type.
        :param pulumi.Input[builtins.str] segment_filter: The destination is triggered only for profiles that meet the criteria of a segment definition.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventTriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An event trigger resource of Amazon Connect Customer Profiles

        :param str resource_name: The name of the resource.
        :param EventTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 event_trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventTriggerConditionArgs', 'EventTriggerConditionArgsDict']]]]] = None,
                 event_trigger_limits: Optional[pulumi.Input[Union['EventTriggerLimitsArgs', 'EventTriggerLimitsArgsDict']]] = None,
                 event_trigger_name: Optional[pulumi.Input[builtins.str]] = None,
                 object_type_name: Optional[pulumi.Input[builtins.str]] = None,
                 segment_filter: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventTriggerArgs.__new__(EventTriggerArgs)

            __props__.__dict__["description"] = description
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            if event_trigger_conditions is None and not opts.urn:
                raise TypeError("Missing required property 'event_trigger_conditions'")
            __props__.__dict__["event_trigger_conditions"] = event_trigger_conditions
            __props__.__dict__["event_trigger_limits"] = event_trigger_limits
            __props__.__dict__["event_trigger_name"] = event_trigger_name
            if object_type_name is None and not opts.urn:
                raise TypeError("Missing required property 'object_type_name'")
            __props__.__dict__["object_type_name"] = object_type_name
            __props__.__dict__["segment_filter"] = segment_filter
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["last_updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainName", "eventTriggerName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EventTrigger, __self__).__init__(
            'aws-native:customerprofiles:EventTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EventTrigger':
        """
        Get an existing EventTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EventTriggerArgs.__new__(EventTriggerArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["event_trigger_conditions"] = None
        __props__.__dict__["event_trigger_limits"] = None
        __props__.__dict__["event_trigger_name"] = None
        __props__.__dict__["last_updated_at"] = None
        __props__.__dict__["object_type_name"] = None
        __props__.__dict__["segment_filter"] = None
        __props__.__dict__["tags"] = None
        return EventTrigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the event trigger was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the event trigger.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="eventTriggerConditions")
    def event_trigger_conditions(self) -> pulumi.Output[Sequence['outputs.EventTriggerCondition']]:
        """
        A list of conditions that determine when an event should trigger the destination.
        """
        return pulumi.get(self, "event_trigger_conditions")

    @property
    @pulumi.getter(name="eventTriggerLimits")
    def event_trigger_limits(self) -> pulumi.Output[Optional['outputs.EventTriggerLimits']]:
        """
        Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
        """
        return pulumi.get(self, "event_trigger_limits")

    @property
    @pulumi.getter(name="eventTriggerName")
    def event_trigger_name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the event trigger.
        """
        return pulumi.get(self, "event_trigger_name")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the event trigger was most recently updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter(name="objectTypeName")
    def object_type_name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the object type.
        """
        return pulumi.get(self, "object_type_name")

    @property
    @pulumi.getter(name="segmentFilter")
    def segment_filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The destination is triggered only for profiles that meet the criteria of a segment definition.
        """
        return pulumi.get(self, "segment_filter")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

