# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetEnabledBaselineResult',
    'AwaitableGetEnabledBaselineResult',
    'get_enabled_baseline',
    'get_enabled_baseline_output',
]

@pulumi.output_type
class GetEnabledBaselineResult:
    def __init__(__self__, baseline_version=None, enabled_baseline_identifier=None, parameters=None, tags=None):
        if baseline_version and not isinstance(baseline_version, str):
            raise TypeError("Expected argument 'baseline_version' to be a str")
        pulumi.set(__self__, "baseline_version", baseline_version)
        if enabled_baseline_identifier and not isinstance(enabled_baseline_identifier, str):
            raise TypeError("Expected argument 'enabled_baseline_identifier' to be a str")
        pulumi.set(__self__, "enabled_baseline_identifier", enabled_baseline_identifier)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="baselineVersion")
    def baseline_version(self) -> Optional[builtins.str]:
        """
        The enabled version of the `Baseline` .
        """
        return pulumi.get(self, "baseline_version")

    @property
    @pulumi.getter(name="enabledBaselineIdentifier")
    def enabled_baseline_identifier(self) -> Optional[builtins.str]:
        return pulumi.get(self, "enabled_baseline_identifier")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.EnabledBaselineParameter']]:
        """
        Shows the parameters that are applied when enabling this `Baseline` .
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        return pulumi.get(self, "tags")


class AwaitableGetEnabledBaselineResult(GetEnabledBaselineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnabledBaselineResult(
            baseline_version=self.baseline_version,
            enabled_baseline_identifier=self.enabled_baseline_identifier,
            parameters=self.parameters,
            tags=self.tags)


def get_enabled_baseline(enabled_baseline_identifier: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnabledBaselineResult:
    """
    Definition of AWS::ControlTower::EnabledBaseline Resource Type
    """
    __args__ = dict()
    __args__['enabledBaselineIdentifier'] = enabled_baseline_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:controltower:getEnabledBaseline', __args__, opts=opts, typ=GetEnabledBaselineResult).value

    return AwaitableGetEnabledBaselineResult(
        baseline_version=pulumi.get(__ret__, 'baseline_version'),
        enabled_baseline_identifier=pulumi.get(__ret__, 'enabled_baseline_identifier'),
        parameters=pulumi.get(__ret__, 'parameters'),
        tags=pulumi.get(__ret__, 'tags'))
def get_enabled_baseline_output(enabled_baseline_identifier: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnabledBaselineResult]:
    """
    Definition of AWS::ControlTower::EnabledBaseline Resource Type
    """
    __args__ = dict()
    __args__['enabledBaselineIdentifier'] = enabled_baseline_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:controltower:getEnabledBaseline', __args__, opts=opts, typ=GetEnabledBaselineResult)
    return __ret__.apply(lambda __response__: GetEnabledBaselineResult(
        baseline_version=pulumi.get(__response__, 'baseline_version'),
        enabled_baseline_identifier=pulumi.get(__response__, 'enabled_baseline_identifier'),
        parameters=pulumi.get(__response__, 'parameters'),
        tags=pulumi.get(__response__, 'tags')))
