# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CampaignAgentlessConfig',
    'CampaignAnswerMachineDetectionConfig',
    'CampaignChannelSubtypeConfig',
    'CampaignCommunicationLimit',
    'CampaignCommunicationLimits',
    'CampaignCommunicationLimitsConfig',
    'CampaignCommunicationTimeConfig',
    'CampaignDailyHour',
    'CampaignEmailChannelSubtypeConfig',
    'CampaignEmailOutboundConfig',
    'CampaignEmailOutboundMode',
    'CampaignEventTrigger',
    'CampaignLocalTimeZoneConfig',
    'CampaignOpenHours',
    'CampaignPredictiveConfig',
    'CampaignProgressiveConfig',
    'CampaignRestrictedPeriod',
    'CampaignRestrictedPeriods',
    'CampaignSchedule',
    'CampaignSmsChannelSubtypeConfig',
    'CampaignSmsOutboundConfig',
    'CampaignSmsOutboundMode',
    'CampaignSource',
    'CampaignTelephonyChannelSubtypeConfig',
    'CampaignTelephonyOutboundConfig',
    'CampaignTelephonyOutboundMode',
    'CampaignTimeRange',
    'CampaignTimeWindow',
]

@pulumi.output_type
class CampaignAgentlessConfig(dict):
    """
    Agentless config
    """
    def __init__(__self__):
        """
        Agentless config
        """
        pass


@pulumi.output_type
class CampaignAnswerMachineDetectionConfig(dict):
    """
    The configuration used for answering machine detection during outbound calls
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAnswerMachineDetection":
            suggest = "enable_answer_machine_detection"
        elif key == "awaitAnswerMachinePrompt":
            suggest = "await_answer_machine_prompt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignAnswerMachineDetectionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignAnswerMachineDetectionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignAnswerMachineDetectionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_answer_machine_detection: builtins.bool,
                 await_answer_machine_prompt: Optional[builtins.bool] = None):
        """
        The configuration used for answering machine detection during outbound calls
        :param builtins.bool enable_answer_machine_detection: Flag to decided whether outbound calls should have answering machine detection enabled or not
        :param builtins.bool await_answer_machine_prompt: Enables detection of prompts (e.g., beep after after a voicemail greeting)
        """
        pulumi.set(__self__, "enable_answer_machine_detection", enable_answer_machine_detection)
        if await_answer_machine_prompt is not None:
            pulumi.set(__self__, "await_answer_machine_prompt", await_answer_machine_prompt)

    @property
    @pulumi.getter(name="enableAnswerMachineDetection")
    def enable_answer_machine_detection(self) -> builtins.bool:
        """
        Flag to decided whether outbound calls should have answering machine detection enabled or not
        """
        return pulumi.get(self, "enable_answer_machine_detection")

    @property
    @pulumi.getter(name="awaitAnswerMachinePrompt")
    def await_answer_machine_prompt(self) -> Optional[builtins.bool]:
        """
        Enables detection of prompts (e.g., beep after after a voicemail greeting)
        """
        return pulumi.get(self, "await_answer_machine_prompt")


@pulumi.output_type
class CampaignChannelSubtypeConfig(dict):
    """
    The possible types of channel subtype config parameters
    """
    def __init__(__self__, *,
                 email: Optional['outputs.CampaignEmailChannelSubtypeConfig'] = None,
                 sms: Optional['outputs.CampaignSmsChannelSubtypeConfig'] = None,
                 telephony: Optional['outputs.CampaignTelephonyChannelSubtypeConfig'] = None):
        """
        The possible types of channel subtype config parameters
        :param 'CampaignEmailChannelSubtypeConfig' email: The configuration of the email channel subtype.
        :param 'CampaignSmsChannelSubtypeConfig' sms: The configuration of the SMS channel subtype.
        :param 'CampaignTelephonyChannelSubtypeConfig' telephony: The configuration of the telephony channel subtype.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if sms is not None:
            pulumi.set(__self__, "sms", sms)
        if telephony is not None:
            pulumi.set(__self__, "telephony", telephony)

    @property
    @pulumi.getter
    def email(self) -> Optional['outputs.CampaignEmailChannelSubtypeConfig']:
        """
        The configuration of the email channel subtype.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def sms(self) -> Optional['outputs.CampaignSmsChannelSubtypeConfig']:
        """
        The configuration of the SMS channel subtype.
        """
        return pulumi.get(self, "sms")

    @property
    @pulumi.getter
    def telephony(self) -> Optional['outputs.CampaignTelephonyChannelSubtypeConfig']:
        """
        The configuration of the telephony channel subtype.
        """
        return pulumi.get(self, "telephony")


@pulumi.output_type
class CampaignCommunicationLimit(dict):
    """
    Communication Limit
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCountPerRecipient":
            suggest = "max_count_per_recipient"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignCommunicationLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignCommunicationLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignCommunicationLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: builtins.int,
                 max_count_per_recipient: builtins.int,
                 unit: 'CampaignCommunicationLimitTimeUnit'):
        """
        Communication Limit
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "max_count_per_recipient", max_count_per_recipient)
        pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def frequency(self) -> builtins.int:
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="maxCountPerRecipient")
    def max_count_per_recipient(self) -> builtins.int:
        return pulumi.get(self, "max_count_per_recipient")

    @property
    @pulumi.getter
    def unit(self) -> 'CampaignCommunicationLimitTimeUnit':
        return pulumi.get(self, "unit")


@pulumi.output_type
class CampaignCommunicationLimits(dict):
    """
    Communication limits
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "communicationLimitList":
            suggest = "communication_limit_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignCommunicationLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignCommunicationLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignCommunicationLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 communication_limit_list: Optional[Sequence['outputs.CampaignCommunicationLimit']] = None):
        """
        Communication limits
        :param Sequence['CampaignCommunicationLimit'] communication_limit_list: The list of CommunicationLimits.
        """
        if communication_limit_list is not None:
            pulumi.set(__self__, "communication_limit_list", communication_limit_list)

    @property
    @pulumi.getter(name="communicationLimitList")
    def communication_limit_list(self) -> Optional[Sequence['outputs.CampaignCommunicationLimit']]:
        """
        The list of CommunicationLimits.
        """
        return pulumi.get(self, "communication_limit_list")


@pulumi.output_type
class CampaignCommunicationLimitsConfig(dict):
    """
    Communication limits config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allChannelsSubtypes":
            suggest = "all_channels_subtypes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignCommunicationLimitsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignCommunicationLimitsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignCommunicationLimitsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_channels_subtypes: Optional['outputs.CampaignCommunicationLimits'] = None):
        """
        Communication limits config
        :param 'CampaignCommunicationLimits' all_channels_subtypes: The CommunicationLimits that apply to all channel subtypes defined in an outbound campaign.
        """
        if all_channels_subtypes is not None:
            pulumi.set(__self__, "all_channels_subtypes", all_channels_subtypes)

    @property
    @pulumi.getter(name="allChannelsSubtypes")
    def all_channels_subtypes(self) -> Optional['outputs.CampaignCommunicationLimits']:
        """
        The CommunicationLimits that apply to all channel subtypes defined in an outbound campaign.
        """
        return pulumi.get(self, "all_channels_subtypes")


@pulumi.output_type
class CampaignCommunicationTimeConfig(dict):
    """
    Campaign communication time config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localTimeZoneConfig":
            suggest = "local_time_zone_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignCommunicationTimeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignCommunicationTimeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignCommunicationTimeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_time_zone_config: 'outputs.CampaignLocalTimeZoneConfig',
                 email: Optional['outputs.CampaignTimeWindow'] = None,
                 sms: Optional['outputs.CampaignTimeWindow'] = None,
                 telephony: Optional['outputs.CampaignTimeWindow'] = None):
        """
        Campaign communication time config
        :param 'CampaignLocalTimeZoneConfig' local_time_zone_config: The local timezone configuration.
        :param 'CampaignTimeWindow' email: The communication time configuration for the email channel subtype.
        :param 'CampaignTimeWindow' sms: The communication time configuration for the SMS channel subtype.
        :param 'CampaignTimeWindow' telephony: The communication time configuration for the telephony channel subtype.
        """
        pulumi.set(__self__, "local_time_zone_config", local_time_zone_config)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if sms is not None:
            pulumi.set(__self__, "sms", sms)
        if telephony is not None:
            pulumi.set(__self__, "telephony", telephony)

    @property
    @pulumi.getter(name="localTimeZoneConfig")
    def local_time_zone_config(self) -> 'outputs.CampaignLocalTimeZoneConfig':
        """
        The local timezone configuration.
        """
        return pulumi.get(self, "local_time_zone_config")

    @property
    @pulumi.getter
    def email(self) -> Optional['outputs.CampaignTimeWindow']:
        """
        The communication time configuration for the email channel subtype.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def sms(self) -> Optional['outputs.CampaignTimeWindow']:
        """
        The communication time configuration for the SMS channel subtype.
        """
        return pulumi.get(self, "sms")

    @property
    @pulumi.getter
    def telephony(self) -> Optional['outputs.CampaignTimeWindow']:
        """
        The communication time configuration for the telephony channel subtype.
        """
        return pulumi.get(self, "telephony")


@pulumi.output_type
class CampaignDailyHour(dict):
    """
    Daily Hour
    """
    def __init__(__self__, *,
                 key: Optional['CampaignDayOfWeek'] = None,
                 value: Optional[Sequence['outputs.CampaignTimeRange']] = None):
        """
        Daily Hour
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional['CampaignDayOfWeek']:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[Sequence['outputs.CampaignTimeRange']]:
        return pulumi.get(self, "value")


@pulumi.output_type
class CampaignEmailChannelSubtypeConfig(dict):
    """
    Email Channel Subtype config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultOutboundConfig":
            suggest = "default_outbound_config"
        elif key == "outboundMode":
            suggest = "outbound_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignEmailChannelSubtypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignEmailChannelSubtypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignEmailChannelSubtypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_outbound_config: 'outputs.CampaignEmailOutboundConfig',
                 outbound_mode: 'outputs.CampaignEmailOutboundMode',
                 capacity: Optional[builtins.float] = None):
        """
        Email Channel Subtype config
        :param 'CampaignEmailOutboundConfig' default_outbound_config: The default email outbound configuration of an outbound campaign.
        :param 'CampaignEmailOutboundMode' outbound_mode: The outbound mode for email of an outbound campaign.
        :param builtins.float capacity: The allocation of email capacity between multiple running outbound campaigns.
        """
        pulumi.set(__self__, "default_outbound_config", default_outbound_config)
        pulumi.set(__self__, "outbound_mode", outbound_mode)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter(name="defaultOutboundConfig")
    def default_outbound_config(self) -> 'outputs.CampaignEmailOutboundConfig':
        """
        The default email outbound configuration of an outbound campaign.
        """
        return pulumi.get(self, "default_outbound_config")

    @property
    @pulumi.getter(name="outboundMode")
    def outbound_mode(self) -> 'outputs.CampaignEmailOutboundMode':
        """
        The outbound mode for email of an outbound campaign.
        """
        return pulumi.get(self, "outbound_mode")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.float]:
        """
        The allocation of email capacity between multiple running outbound campaigns.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class CampaignEmailOutboundConfig(dict):
    """
    Default SMS outbound config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectSourceEmailAddress":
            suggest = "connect_source_email_address"
        elif key == "wisdomTemplateArn":
            suggest = "wisdom_template_arn"
        elif key == "sourceEmailAddressDisplayName":
            suggest = "source_email_address_display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignEmailOutboundConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignEmailOutboundConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignEmailOutboundConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_source_email_address: builtins.str,
                 wisdom_template_arn: builtins.str,
                 source_email_address_display_name: Optional[builtins.str] = None):
        """
        Default SMS outbound config
        :param builtins.str connect_source_email_address: The Amazon Connect source email address.
        :param builtins.str wisdom_template_arn: The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
        :param builtins.str source_email_address_display_name: The display name for the Amazon Connect source email address.
        """
        pulumi.set(__self__, "connect_source_email_address", connect_source_email_address)
        pulumi.set(__self__, "wisdom_template_arn", wisdom_template_arn)
        if source_email_address_display_name is not None:
            pulumi.set(__self__, "source_email_address_display_name", source_email_address_display_name)

    @property
    @pulumi.getter(name="connectSourceEmailAddress")
    def connect_source_email_address(self) -> builtins.str:
        """
        The Amazon Connect source email address.
        """
        return pulumi.get(self, "connect_source_email_address")

    @property
    @pulumi.getter(name="wisdomTemplateArn")
    def wisdom_template_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
        """
        return pulumi.get(self, "wisdom_template_arn")

    @property
    @pulumi.getter(name="sourceEmailAddressDisplayName")
    def source_email_address_display_name(self) -> Optional[builtins.str]:
        """
        The display name for the Amazon Connect source email address.
        """
        return pulumi.get(self, "source_email_address_display_name")


@pulumi.output_type
class CampaignEmailOutboundMode(dict):
    """
    Email Outbound Mode
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentlessConfig":
            suggest = "agentless_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignEmailOutboundMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignEmailOutboundMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignEmailOutboundMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agentless_config: Optional['outputs.CampaignAgentlessConfig'] = None):
        """
        Email Outbound Mode
        :param 'CampaignAgentlessConfig' agentless_config: The agentless outbound mode configuration for email.
        """
        if agentless_config is not None:
            pulumi.set(__self__, "agentless_config", agentless_config)

    @property
    @pulumi.getter(name="agentlessConfig")
    def agentless_config(self) -> Optional['outputs.CampaignAgentlessConfig']:
        """
        The agentless outbound mode configuration for email.
        """
        return pulumi.get(self, "agentless_config")


@pulumi.output_type
class CampaignEventTrigger(dict):
    """
    The event trigger of the campaign
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerProfilesDomainArn":
            suggest = "customer_profiles_domain_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignEventTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignEventTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignEventTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_profiles_domain_arn: Optional[builtins.str] = None):
        """
        The event trigger of the campaign
        :param builtins.str customer_profiles_domain_arn: The Amazon Resource Name (ARN) of the Customer Profiles domain.
        """
        if customer_profiles_domain_arn is not None:
            pulumi.set(__self__, "customer_profiles_domain_arn", customer_profiles_domain_arn)

    @property
    @pulumi.getter(name="customerProfilesDomainArn")
    def customer_profiles_domain_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Customer Profiles domain.
        """
        return pulumi.get(self, "customer_profiles_domain_arn")


@pulumi.output_type
class CampaignLocalTimeZoneConfig(dict):
    """
    Local time zone config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTimeZone":
            suggest = "default_time_zone"
        elif key == "localTimeZoneDetection":
            suggest = "local_time_zone_detection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignLocalTimeZoneConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignLocalTimeZoneConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignLocalTimeZoneConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_time_zone: Optional[builtins.str] = None,
                 local_time_zone_detection: Optional[Sequence['CampaignLocalTimeZoneDetectionType']] = None):
        """
        Local time zone config
        :param builtins.str default_time_zone: The timezone to use for all recipients.
        :param Sequence['CampaignLocalTimeZoneDetectionType'] local_time_zone_detection: Detects methods for the recipient's timezone.
        """
        if default_time_zone is not None:
            pulumi.set(__self__, "default_time_zone", default_time_zone)
        if local_time_zone_detection is not None:
            pulumi.set(__self__, "local_time_zone_detection", local_time_zone_detection)

    @property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> Optional[builtins.str]:
        """
        The timezone to use for all recipients.
        """
        return pulumi.get(self, "default_time_zone")

    @property
    @pulumi.getter(name="localTimeZoneDetection")
    def local_time_zone_detection(self) -> Optional[Sequence['CampaignLocalTimeZoneDetectionType']]:
        """
        Detects methods for the recipient's timezone.
        """
        return pulumi.get(self, "local_time_zone_detection")


@pulumi.output_type
class CampaignOpenHours(dict):
    """
    Open Hours config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailyHours":
            suggest = "daily_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignOpenHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignOpenHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignOpenHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_hours: Sequence['outputs.CampaignDailyHour']):
        """
        Open Hours config
        :param Sequence['CampaignDailyHour'] daily_hours: The daily hours configuration.
        """
        pulumi.set(__self__, "daily_hours", daily_hours)

    @property
    @pulumi.getter(name="dailyHours")
    def daily_hours(self) -> Sequence['outputs.CampaignDailyHour']:
        """
        The daily hours configuration.
        """
        return pulumi.get(self, "daily_hours")


@pulumi.output_type
class CampaignPredictiveConfig(dict):
    """
    Predictive config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthAllocation":
            suggest = "bandwidth_allocation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignPredictiveConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignPredictiveConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignPredictiveConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_allocation: builtins.float):
        """
        Predictive config
        :param builtins.float bandwidth_allocation: Bandwidth allocation for the predictive outbound mode.
        """
        pulumi.set(__self__, "bandwidth_allocation", bandwidth_allocation)

    @property
    @pulumi.getter(name="bandwidthAllocation")
    def bandwidth_allocation(self) -> builtins.float:
        """
        Bandwidth allocation for the predictive outbound mode.
        """
        return pulumi.get(self, "bandwidth_allocation")


@pulumi.output_type
class CampaignProgressiveConfig(dict):
    """
    Progressive config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthAllocation":
            suggest = "bandwidth_allocation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignProgressiveConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignProgressiveConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignProgressiveConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_allocation: builtins.float):
        """
        Progressive config
        :param builtins.float bandwidth_allocation: Bandwidth allocation for the progressive outbound mode.
        """
        pulumi.set(__self__, "bandwidth_allocation", bandwidth_allocation)

    @property
    @pulumi.getter(name="bandwidthAllocation")
    def bandwidth_allocation(self) -> builtins.float:
        """
        Bandwidth allocation for the progressive outbound mode.
        """
        return pulumi.get(self, "bandwidth_allocation")


@pulumi.output_type
class CampaignRestrictedPeriod(dict):
    """
    Restricted period
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignRestrictedPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignRestrictedPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignRestrictedPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: builtins.str,
                 start_date: builtins.str,
                 name: Optional[builtins.str] = None):
        """
        Restricted period
        :param builtins.str name: The name of a restricted period
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> builtins.str:
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of a restricted period
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CampaignRestrictedPeriods(dict):
    """
    Restricted period config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictedPeriodList":
            suggest = "restricted_period_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignRestrictedPeriods. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignRestrictedPeriods.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignRestrictedPeriods.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restricted_period_list: Optional[Sequence['outputs.CampaignRestrictedPeriod']] = None):
        """
        Restricted period config
        :param Sequence['CampaignRestrictedPeriod'] restricted_period_list: The restricted period list.
        """
        if restricted_period_list is not None:
            pulumi.set(__self__, "restricted_period_list", restricted_period_list)

    @property
    @pulumi.getter(name="restrictedPeriodList")
    def restricted_period_list(self) -> Optional[Sequence['outputs.CampaignRestrictedPeriod']]:
        """
        The restricted period list.
        """
        return pulumi.get(self, "restricted_period_list")


@pulumi.output_type
class CampaignSchedule(dict):
    """
    Campaign schedule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "refreshFrequency":
            suggest = "refresh_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: builtins.str,
                 start_time: builtins.str,
                 refresh_frequency: Optional[builtins.str] = None):
        """
        Campaign schedule
        :param builtins.str end_time: The end time of the schedule in UTC.
        :param builtins.str start_time: The start time of the schedule in UTC.
        :param builtins.str refresh_frequency: The refresh frequency of the campaign.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)
        if refresh_frequency is not None:
            pulumi.set(__self__, "refresh_frequency", refresh_frequency)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> builtins.str:
        """
        The end time of the schedule in UTC.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        The start time of the schedule in UTC.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="refreshFrequency")
    def refresh_frequency(self) -> Optional[builtins.str]:
        """
        The refresh frequency of the campaign.
        """
        return pulumi.get(self, "refresh_frequency")


@pulumi.output_type
class CampaignSmsChannelSubtypeConfig(dict):
    """
    SMS Channel Subtype config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultOutboundConfig":
            suggest = "default_outbound_config"
        elif key == "outboundMode":
            suggest = "outbound_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignSmsChannelSubtypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignSmsChannelSubtypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignSmsChannelSubtypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_outbound_config: 'outputs.CampaignSmsOutboundConfig',
                 outbound_mode: 'outputs.CampaignSmsOutboundMode',
                 capacity: Optional[builtins.float] = None):
        """
        SMS Channel Subtype config
        :param 'CampaignSmsOutboundConfig' default_outbound_config: The default SMS outbound configuration of an outbound campaign.
        :param 'CampaignSmsOutboundMode' outbound_mode: The outbound mode of SMS for an outbound campaign.
        :param builtins.float capacity: The allocation of SMS capacity between multiple running outbound campaigns.
        """
        pulumi.set(__self__, "default_outbound_config", default_outbound_config)
        pulumi.set(__self__, "outbound_mode", outbound_mode)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter(name="defaultOutboundConfig")
    def default_outbound_config(self) -> 'outputs.CampaignSmsOutboundConfig':
        """
        The default SMS outbound configuration of an outbound campaign.
        """
        return pulumi.get(self, "default_outbound_config")

    @property
    @pulumi.getter(name="outboundMode")
    def outbound_mode(self) -> 'outputs.CampaignSmsOutboundMode':
        """
        The outbound mode of SMS for an outbound campaign.
        """
        return pulumi.get(self, "outbound_mode")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.float]:
        """
        The allocation of SMS capacity between multiple running outbound campaigns.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class CampaignSmsOutboundConfig(dict):
    """
    Default SMS outbound config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectSourcePhoneNumberArn":
            suggest = "connect_source_phone_number_arn"
        elif key == "wisdomTemplateArn":
            suggest = "wisdom_template_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignSmsOutboundConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignSmsOutboundConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignSmsOutboundConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_source_phone_number_arn: builtins.str,
                 wisdom_template_arn: builtins.str):
        """
        Default SMS outbound config
        :param builtins.str connect_source_phone_number_arn: The Amazon Resource Name (ARN) of the Amazon Connect source SMS phone number.
        :param builtins.str wisdom_template_arn: The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
        """
        pulumi.set(__self__, "connect_source_phone_number_arn", connect_source_phone_number_arn)
        pulumi.set(__self__, "wisdom_template_arn", wisdom_template_arn)

    @property
    @pulumi.getter(name="connectSourcePhoneNumberArn")
    def connect_source_phone_number_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon Connect source SMS phone number.
        """
        return pulumi.get(self, "connect_source_phone_number_arn")

    @property
    @pulumi.getter(name="wisdomTemplateArn")
    def wisdom_template_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
        """
        return pulumi.get(self, "wisdom_template_arn")


@pulumi.output_type
class CampaignSmsOutboundMode(dict):
    """
    SMS Outbound Mode
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentlessConfig":
            suggest = "agentless_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignSmsOutboundMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignSmsOutboundMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignSmsOutboundMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agentless_config: Optional['outputs.CampaignAgentlessConfig'] = None):
        """
        SMS Outbound Mode
        :param 'CampaignAgentlessConfig' agentless_config: Contains agentless outbound mode configuration.
        """
        if agentless_config is not None:
            pulumi.set(__self__, "agentless_config", agentless_config)

    @property
    @pulumi.getter(name="agentlessConfig")
    def agentless_config(self) -> Optional['outputs.CampaignAgentlessConfig']:
        """
        Contains agentless outbound mode configuration.
        """
        return pulumi.get(self, "agentless_config")


@pulumi.output_type
class CampaignSource(dict):
    """
    The possible source of the campaign
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerProfilesSegmentArn":
            suggest = "customer_profiles_segment_arn"
        elif key == "eventTrigger":
            suggest = "event_trigger"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_profiles_segment_arn: Optional[builtins.str] = None,
                 event_trigger: Optional['outputs.CampaignEventTrigger'] = None):
        """
        The possible source of the campaign
        :param builtins.str customer_profiles_segment_arn: The Amazon Resource Name (ARN) of the Customer Profiles segment.
        :param 'CampaignEventTrigger' event_trigger: The event trigger of the campaign.
        """
        if customer_profiles_segment_arn is not None:
            pulumi.set(__self__, "customer_profiles_segment_arn", customer_profiles_segment_arn)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)

    @property
    @pulumi.getter(name="customerProfilesSegmentArn")
    def customer_profiles_segment_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Customer Profiles segment.
        """
        return pulumi.get(self, "customer_profiles_segment_arn")

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional['outputs.CampaignEventTrigger']:
        """
        The event trigger of the campaign.
        """
        return pulumi.get(self, "event_trigger")


@pulumi.output_type
class CampaignTelephonyChannelSubtypeConfig(dict):
    """
    Telephony Channel Subtype config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultOutboundConfig":
            suggest = "default_outbound_config"
        elif key == "outboundMode":
            suggest = "outbound_mode"
        elif key == "connectQueueId":
            suggest = "connect_queue_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignTelephonyChannelSubtypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignTelephonyChannelSubtypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignTelephonyChannelSubtypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_outbound_config: 'outputs.CampaignTelephonyOutboundConfig',
                 outbound_mode: 'outputs.CampaignTelephonyOutboundMode',
                 capacity: Optional[builtins.float] = None,
                 connect_queue_id: Optional[builtins.str] = None):
        """
        Telephony Channel Subtype config
        :param 'CampaignTelephonyOutboundConfig' default_outbound_config: The default telephony outbound configuration of an outbound campaign.
        :param 'CampaignTelephonyOutboundMode' outbound_mode: The outbound mode of telephony for an outbound campaign.
        :param builtins.float capacity: The allocation of telephony capacity between multiple running outbound campaigns.
        :param builtins.str connect_queue_id: The identifier of the Amazon Connect queue associated with telephony outbound requests of an outbound campaign.
        """
        pulumi.set(__self__, "default_outbound_config", default_outbound_config)
        pulumi.set(__self__, "outbound_mode", outbound_mode)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if connect_queue_id is not None:
            pulumi.set(__self__, "connect_queue_id", connect_queue_id)

    @property
    @pulumi.getter(name="defaultOutboundConfig")
    def default_outbound_config(self) -> 'outputs.CampaignTelephonyOutboundConfig':
        """
        The default telephony outbound configuration of an outbound campaign.
        """
        return pulumi.get(self, "default_outbound_config")

    @property
    @pulumi.getter(name="outboundMode")
    def outbound_mode(self) -> 'outputs.CampaignTelephonyOutboundMode':
        """
        The outbound mode of telephony for an outbound campaign.
        """
        return pulumi.get(self, "outbound_mode")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.float]:
        """
        The allocation of telephony capacity between multiple running outbound campaigns.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="connectQueueId")
    def connect_queue_id(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon Connect queue associated with telephony outbound requests of an outbound campaign.
        """
        return pulumi.get(self, "connect_queue_id")


@pulumi.output_type
class CampaignTelephonyOutboundConfig(dict):
    """
    Default Telephone Outbound config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectContactFlowId":
            suggest = "connect_contact_flow_id"
        elif key == "answerMachineDetectionConfig":
            suggest = "answer_machine_detection_config"
        elif key == "connectSourcePhoneNumber":
            suggest = "connect_source_phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignTelephonyOutboundConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignTelephonyOutboundConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignTelephonyOutboundConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_contact_flow_id: builtins.str,
                 answer_machine_detection_config: Optional['outputs.CampaignAnswerMachineDetectionConfig'] = None,
                 connect_source_phone_number: Optional[builtins.str] = None):
        """
        Default Telephone Outbound config
        :param builtins.str connect_contact_flow_id: The identifier of the published Amazon Connect contact flow.
        :param 'CampaignAnswerMachineDetectionConfig' answer_machine_detection_config: The answering machine detection configuration.
        :param builtins.str connect_source_phone_number: The Amazon Connect source phone number.
        """
        pulumi.set(__self__, "connect_contact_flow_id", connect_contact_flow_id)
        if answer_machine_detection_config is not None:
            pulumi.set(__self__, "answer_machine_detection_config", answer_machine_detection_config)
        if connect_source_phone_number is not None:
            pulumi.set(__self__, "connect_source_phone_number", connect_source_phone_number)

    @property
    @pulumi.getter(name="connectContactFlowId")
    def connect_contact_flow_id(self) -> builtins.str:
        """
        The identifier of the published Amazon Connect contact flow.
        """
        return pulumi.get(self, "connect_contact_flow_id")

    @property
    @pulumi.getter(name="answerMachineDetectionConfig")
    def answer_machine_detection_config(self) -> Optional['outputs.CampaignAnswerMachineDetectionConfig']:
        """
        The answering machine detection configuration.
        """
        return pulumi.get(self, "answer_machine_detection_config")

    @property
    @pulumi.getter(name="connectSourcePhoneNumber")
    def connect_source_phone_number(self) -> Optional[builtins.str]:
        """
        The Amazon Connect source phone number.
        """
        return pulumi.get(self, "connect_source_phone_number")


@pulumi.output_type
class CampaignTelephonyOutboundMode(dict):
    """
    Telephony Outbound Mode
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentlessConfig":
            suggest = "agentless_config"
        elif key == "predictiveConfig":
            suggest = "predictive_config"
        elif key == "progressiveConfig":
            suggest = "progressive_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignTelephonyOutboundMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignTelephonyOutboundMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignTelephonyOutboundMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agentless_config: Optional['outputs.CampaignAgentlessConfig'] = None,
                 predictive_config: Optional['outputs.CampaignPredictiveConfig'] = None,
                 progressive_config: Optional['outputs.CampaignProgressiveConfig'] = None):
        """
        Telephony Outbound Mode
        :param 'CampaignAgentlessConfig' agentless_config: The agentless outbound mode configuration for telephony.
        :param 'CampaignPredictiveConfig' predictive_config: Contains predictive outbound mode configuration.
        :param 'CampaignProgressiveConfig' progressive_config: Contains progressive telephony outbound mode configuration.
        """
        if agentless_config is not None:
            pulumi.set(__self__, "agentless_config", agentless_config)
        if predictive_config is not None:
            pulumi.set(__self__, "predictive_config", predictive_config)
        if progressive_config is not None:
            pulumi.set(__self__, "progressive_config", progressive_config)

    @property
    @pulumi.getter(name="agentlessConfig")
    def agentless_config(self) -> Optional['outputs.CampaignAgentlessConfig']:
        """
        The agentless outbound mode configuration for telephony.
        """
        return pulumi.get(self, "agentless_config")

    @property
    @pulumi.getter(name="predictiveConfig")
    def predictive_config(self) -> Optional['outputs.CampaignPredictiveConfig']:
        """
        Contains predictive outbound mode configuration.
        """
        return pulumi.get(self, "predictive_config")

    @property
    @pulumi.getter(name="progressiveConfig")
    def progressive_config(self) -> Optional['outputs.CampaignProgressiveConfig']:
        """
        Contains progressive telephony outbound mode configuration.
        """
        return pulumi.get(self, "progressive_config")


@pulumi.output_type
class CampaignTimeRange(dict):
    """
    Time range in 24 hour format
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignTimeRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignTimeRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignTimeRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: builtins.str,
                 start_time: builtins.str):
        """
        Time range in 24 hour format
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> builtins.str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        return pulumi.get(self, "start_time")


@pulumi.output_type
class CampaignTimeWindow(dict):
    """
    Time window config
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openHours":
            suggest = "open_hours"
        elif key == "restrictedPeriods":
            suggest = "restricted_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignTimeWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignTimeWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignTimeWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_hours: 'outputs.CampaignOpenHours',
                 restricted_periods: Optional['outputs.CampaignRestrictedPeriods'] = None):
        """
        Time window config
        :param 'CampaignOpenHours' open_hours: The open hours configuration.
        :param 'CampaignRestrictedPeriods' restricted_periods: The restricted periods configuration.
        """
        pulumi.set(__self__, "open_hours", open_hours)
        if restricted_periods is not None:
            pulumi.set(__self__, "restricted_periods", restricted_periods)

    @property
    @pulumi.getter(name="openHours")
    def open_hours(self) -> 'outputs.CampaignOpenHours':
        """
        The open hours configuration.
        """
        return pulumi.get(self, "open_hours")

    @property
    @pulumi.getter(name="restrictedPeriods")
    def restricted_periods(self) -> Optional['outputs.CampaignRestrictedPeriods']:
        """
        The restricted periods configuration.
        """
        return pulumi.get(self, "restricted_periods")


