# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCampaignResult',
    'AwaitableGetCampaignResult',
    'get_campaign',
    'get_campaign_output',
]

@pulumi.output_type
class GetCampaignResult:
    def __init__(__self__, arn=None, channel_subtype_config=None, communication_limits_override=None, communication_time_config=None, connect_campaign_flow_arn=None, name=None, schedule=None, source=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if channel_subtype_config and not isinstance(channel_subtype_config, dict):
            raise TypeError("Expected argument 'channel_subtype_config' to be a dict")
        pulumi.set(__self__, "channel_subtype_config", channel_subtype_config)
        if communication_limits_override and not isinstance(communication_limits_override, dict):
            raise TypeError("Expected argument 'communication_limits_override' to be a dict")
        pulumi.set(__self__, "communication_limits_override", communication_limits_override)
        if communication_time_config and not isinstance(communication_time_config, dict):
            raise TypeError("Expected argument 'communication_time_config' to be a dict")
        pulumi.set(__self__, "communication_time_config", communication_time_config)
        if connect_campaign_flow_arn and not isinstance(connect_campaign_flow_arn, str):
            raise TypeError("Expected argument 'connect_campaign_flow_arn' to be a str")
        pulumi.set(__self__, "connect_campaign_flow_arn", connect_campaign_flow_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schedule and not isinstance(schedule, dict):
            raise TypeError("Expected argument 'schedule' to be a dict")
        pulumi.set(__self__, "schedule", schedule)
        if source and not isinstance(source, dict):
            raise TypeError("Expected argument 'source' to be a dict")
        pulumi.set(__self__, "source", source)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Amazon Connect Campaign Arn
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="channelSubtypeConfig")
    def channel_subtype_config(self) -> Optional['outputs.CampaignChannelSubtypeConfig']:
        """
        Contains channel subtype configuration for an outbound campaign.
        """
        return pulumi.get(self, "channel_subtype_config")

    @property
    @pulumi.getter(name="communicationLimitsOverride")
    def communication_limits_override(self) -> Optional['outputs.CampaignCommunicationLimitsConfig']:
        """
        Communication limits configuration for an outbound campaign.
        """
        return pulumi.get(self, "communication_limits_override")

    @property
    @pulumi.getter(name="communicationTimeConfig")
    def communication_time_config(self) -> Optional['outputs.CampaignCommunicationTimeConfig']:
        """
        Contains communication time configuration for an outbound campaign.
        """
        return pulumi.get(self, "communication_time_config")

    @property
    @pulumi.getter(name="connectCampaignFlowArn")
    def connect_campaign_flow_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
        """
        return pulumi.get(self, "connect_campaign_flow_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the outbound campaign.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.CampaignSchedule']:
        """
        Contains the schedule configuration.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.CampaignSource']:
        """
        Contains source configuration.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCampaignResult(GetCampaignResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCampaignResult(
            arn=self.arn,
            channel_subtype_config=self.channel_subtype_config,
            communication_limits_override=self.communication_limits_override,
            communication_time_config=self.communication_time_config,
            connect_campaign_flow_arn=self.connect_campaign_flow_arn,
            name=self.name,
            schedule=self.schedule,
            source=self.source,
            tags=self.tags)


def get_campaign(arn: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCampaignResult:
    """
    Definition of AWS::ConnectCampaignsV2::Campaign Resource Type


    :param builtins.str arn: Amazon Connect Campaign Arn
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connectcampaignsv2:getCampaign', __args__, opts=opts, typ=GetCampaignResult).value

    return AwaitableGetCampaignResult(
        arn=pulumi.get(__ret__, 'arn'),
        channel_subtype_config=pulumi.get(__ret__, 'channel_subtype_config'),
        communication_limits_override=pulumi.get(__ret__, 'communication_limits_override'),
        communication_time_config=pulumi.get(__ret__, 'communication_time_config'),
        connect_campaign_flow_arn=pulumi.get(__ret__, 'connect_campaign_flow_arn'),
        name=pulumi.get(__ret__, 'name'),
        schedule=pulumi.get(__ret__, 'schedule'),
        source=pulumi.get(__ret__, 'source'),
        tags=pulumi.get(__ret__, 'tags'))
def get_campaign_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCampaignResult]:
    """
    Definition of AWS::ConnectCampaignsV2::Campaign Resource Type


    :param builtins.str arn: Amazon Connect Campaign Arn
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:connectcampaignsv2:getCampaign', __args__, opts=opts, typ=GetCampaignResult)
    return __ret__.apply(lambda __response__: GetCampaignResult(
        arn=pulumi.get(__response__, 'arn'),
        channel_subtype_config=pulumi.get(__response__, 'channel_subtype_config'),
        communication_limits_override=pulumi.get(__response__, 'communication_limits_override'),
        communication_time_config=pulumi.get(__response__, 'communication_time_config'),
        connect_campaign_flow_arn=pulumi.get(__response__, 'connect_campaign_flow_arn'),
        name=pulumi.get(__response__, 'name'),
        schedule=pulumi.get(__response__, 'schedule'),
        source=pulumi.get(__response__, 'source'),
        tags=pulumi.get(__response__, 'tags')))
