# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['CampaignArgs', 'Campaign']

@pulumi.input_type
class CampaignArgs:
    def __init__(__self__, *,
                 channel_subtype_config: pulumi.Input['CampaignChannelSubtypeConfigArgs'],
                 connect_instance_id: pulumi.Input[builtins.str],
                 communication_limits_override: Optional[pulumi.Input['CampaignCommunicationLimitsConfigArgs']] = None,
                 communication_time_config: Optional[pulumi.Input['CampaignCommunicationTimeConfigArgs']] = None,
                 connect_campaign_flow_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['CampaignScheduleArgs']] = None,
                 source: Optional[pulumi.Input['CampaignSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Campaign resource.
        :param pulumi.Input['CampaignChannelSubtypeConfigArgs'] channel_subtype_config: Contains channel subtype configuration for an outbound campaign.
        :param pulumi.Input[builtins.str] connect_instance_id: The identifier of the Amazon Connect instance. You can find the `instanceId` in the ARN of the instance.
        :param pulumi.Input['CampaignCommunicationLimitsConfigArgs'] communication_limits_override: Communication limits configuration for an outbound campaign.
        :param pulumi.Input['CampaignCommunicationTimeConfigArgs'] communication_time_config: Contains communication time configuration for an outbound campaign.
        :param pulumi.Input[builtins.str] connect_campaign_flow_arn: The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
        :param pulumi.Input[builtins.str] name: The name of the outbound campaign.
        :param pulumi.Input['CampaignScheduleArgs'] schedule: Contains the schedule configuration.
        :param pulumi.Input['CampaignSourceArgs'] source: Contains source configuration.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: One or more tags.
        """
        pulumi.set(__self__, "channel_subtype_config", channel_subtype_config)
        pulumi.set(__self__, "connect_instance_id", connect_instance_id)
        if communication_limits_override is not None:
            pulumi.set(__self__, "communication_limits_override", communication_limits_override)
        if communication_time_config is not None:
            pulumi.set(__self__, "communication_time_config", communication_time_config)
        if connect_campaign_flow_arn is not None:
            pulumi.set(__self__, "connect_campaign_flow_arn", connect_campaign_flow_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="channelSubtypeConfig")
    def channel_subtype_config(self) -> pulumi.Input['CampaignChannelSubtypeConfigArgs']:
        """
        Contains channel subtype configuration for an outbound campaign.
        """
        return pulumi.get(self, "channel_subtype_config")

    @channel_subtype_config.setter
    def channel_subtype_config(self, value: pulumi.Input['CampaignChannelSubtypeConfigArgs']):
        pulumi.set(self, "channel_subtype_config", value)

    @property
    @pulumi.getter(name="connectInstanceId")
    def connect_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Connect instance. You can find the `instanceId` in the ARN of the instance.
        """
        return pulumi.get(self, "connect_instance_id")

    @connect_instance_id.setter
    def connect_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connect_instance_id", value)

    @property
    @pulumi.getter(name="communicationLimitsOverride")
    def communication_limits_override(self) -> Optional[pulumi.Input['CampaignCommunicationLimitsConfigArgs']]:
        """
        Communication limits configuration for an outbound campaign.
        """
        return pulumi.get(self, "communication_limits_override")

    @communication_limits_override.setter
    def communication_limits_override(self, value: Optional[pulumi.Input['CampaignCommunicationLimitsConfigArgs']]):
        pulumi.set(self, "communication_limits_override", value)

    @property
    @pulumi.getter(name="communicationTimeConfig")
    def communication_time_config(self) -> Optional[pulumi.Input['CampaignCommunicationTimeConfigArgs']]:
        """
        Contains communication time configuration for an outbound campaign.
        """
        return pulumi.get(self, "communication_time_config")

    @communication_time_config.setter
    def communication_time_config(self, value: Optional[pulumi.Input['CampaignCommunicationTimeConfigArgs']]):
        pulumi.set(self, "communication_time_config", value)

    @property
    @pulumi.getter(name="connectCampaignFlowArn")
    def connect_campaign_flow_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
        """
        return pulumi.get(self, "connect_campaign_flow_arn")

    @connect_campaign_flow_arn.setter
    def connect_campaign_flow_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connect_campaign_flow_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the outbound campaign.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['CampaignScheduleArgs']]:
        """
        Contains the schedule configuration.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['CampaignScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['CampaignSourceArgs']]:
        """
        Contains source configuration.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['CampaignSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:connectcampaignsv2:Campaign")
class Campaign(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_subtype_config: Optional[pulumi.Input[Union['CampaignChannelSubtypeConfigArgs', 'CampaignChannelSubtypeConfigArgsDict']]] = None,
                 communication_limits_override: Optional[pulumi.Input[Union['CampaignCommunicationLimitsConfigArgs', 'CampaignCommunicationLimitsConfigArgsDict']]] = None,
                 communication_time_config: Optional[pulumi.Input[Union['CampaignCommunicationTimeConfigArgs', 'CampaignCommunicationTimeConfigArgsDict']]] = None,
                 connect_campaign_flow_arn: Optional[pulumi.Input[builtins.str]] = None,
                 connect_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['CampaignScheduleArgs', 'CampaignScheduleArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['CampaignSourceArgs', 'CampaignSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::ConnectCampaignsV2::Campaign Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CampaignChannelSubtypeConfigArgs', 'CampaignChannelSubtypeConfigArgsDict']] channel_subtype_config: Contains channel subtype configuration for an outbound campaign.
        :param pulumi.Input[Union['CampaignCommunicationLimitsConfigArgs', 'CampaignCommunicationLimitsConfigArgsDict']] communication_limits_override: Communication limits configuration for an outbound campaign.
        :param pulumi.Input[Union['CampaignCommunicationTimeConfigArgs', 'CampaignCommunicationTimeConfigArgsDict']] communication_time_config: Contains communication time configuration for an outbound campaign.
        :param pulumi.Input[builtins.str] connect_campaign_flow_arn: The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
        :param pulumi.Input[builtins.str] connect_instance_id: The identifier of the Amazon Connect instance. You can find the `instanceId` in the ARN of the instance.
        :param pulumi.Input[builtins.str] name: The name of the outbound campaign.
        :param pulumi.Input[Union['CampaignScheduleArgs', 'CampaignScheduleArgsDict']] schedule: Contains the schedule configuration.
        :param pulumi.Input[Union['CampaignSourceArgs', 'CampaignSourceArgsDict']] source: Contains source configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: One or more tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CampaignArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::ConnectCampaignsV2::Campaign Resource Type

        :param str resource_name: The name of the resource.
        :param CampaignArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CampaignArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_subtype_config: Optional[pulumi.Input[Union['CampaignChannelSubtypeConfigArgs', 'CampaignChannelSubtypeConfigArgsDict']]] = None,
                 communication_limits_override: Optional[pulumi.Input[Union['CampaignCommunicationLimitsConfigArgs', 'CampaignCommunicationLimitsConfigArgsDict']]] = None,
                 communication_time_config: Optional[pulumi.Input[Union['CampaignCommunicationTimeConfigArgs', 'CampaignCommunicationTimeConfigArgsDict']]] = None,
                 connect_campaign_flow_arn: Optional[pulumi.Input[builtins.str]] = None,
                 connect_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['CampaignScheduleArgs', 'CampaignScheduleArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['CampaignSourceArgs', 'CampaignSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CampaignArgs.__new__(CampaignArgs)

            if channel_subtype_config is None and not opts.urn:
                raise TypeError("Missing required property 'channel_subtype_config'")
            __props__.__dict__["channel_subtype_config"] = channel_subtype_config
            __props__.__dict__["communication_limits_override"] = communication_limits_override
            __props__.__dict__["communication_time_config"] = communication_time_config
            __props__.__dict__["connect_campaign_flow_arn"] = connect_campaign_flow_arn
            if connect_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'connect_instance_id'")
            __props__.__dict__["connect_instance_id"] = connect_instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["connectInstanceId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Campaign, __self__).__init__(
            'aws-native:connectcampaignsv2:Campaign',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Campaign':
        """
        Get an existing Campaign resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CampaignArgs.__new__(CampaignArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["channel_subtype_config"] = None
        __props__.__dict__["communication_limits_override"] = None
        __props__.__dict__["communication_time_config"] = None
        __props__.__dict__["connect_campaign_flow_arn"] = None
        __props__.__dict__["connect_instance_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["schedule"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["tags"] = None
        return Campaign(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Connect Campaign Arn
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="channelSubtypeConfig")
    def channel_subtype_config(self) -> pulumi.Output['outputs.CampaignChannelSubtypeConfig']:
        """
        Contains channel subtype configuration for an outbound campaign.
        """
        return pulumi.get(self, "channel_subtype_config")

    @property
    @pulumi.getter(name="communicationLimitsOverride")
    def communication_limits_override(self) -> pulumi.Output[Optional['outputs.CampaignCommunicationLimitsConfig']]:
        """
        Communication limits configuration for an outbound campaign.
        """
        return pulumi.get(self, "communication_limits_override")

    @property
    @pulumi.getter(name="communicationTimeConfig")
    def communication_time_config(self) -> pulumi.Output[Optional['outputs.CampaignCommunicationTimeConfig']]:
        """
        Contains communication time configuration for an outbound campaign.
        """
        return pulumi.get(self, "communication_time_config")

    @property
    @pulumi.getter(name="connectCampaignFlowArn")
    def connect_campaign_flow_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
        """
        return pulumi.get(self, "connect_campaign_flow_arn")

    @property
    @pulumi.getter(name="connectInstanceId")
    def connect_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Connect instance. You can find the `instanceId` in the ARN of the instance.
        """
        return pulumi.get(self, "connect_instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the outbound campaign.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.CampaignSchedule']]:
        """
        Contains the schedule configuration.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional['outputs.CampaignSource']]:
        """
        Contains source configuration.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")

