# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserHierarchyStructureArgs', 'UserHierarchyStructure']

@pulumi.input_type
class UserHierarchyStructureArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[builtins.str],
                 user_hierarchy_structure: Optional[pulumi.Input['UserHierarchyStructurePropertiesArgs']] = None):
        """
        The set of arguments for constructing a UserHierarchyStructure resource.
        :param pulumi.Input[builtins.str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input['UserHierarchyStructurePropertiesArgs'] user_hierarchy_structure: Information about the hierarchy structure.
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        if user_hierarchy_structure is not None:
            pulumi.set(__self__, "user_hierarchy_structure", user_hierarchy_structure)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="userHierarchyStructure")
    def user_hierarchy_structure(self) -> Optional[pulumi.Input['UserHierarchyStructurePropertiesArgs']]:
        """
        Information about the hierarchy structure.
        """
        return pulumi.get(self, "user_hierarchy_structure")

    @user_hierarchy_structure.setter
    def user_hierarchy_structure(self, value: Optional[pulumi.Input['UserHierarchyStructurePropertiesArgs']]):
        pulumi.set(self, "user_hierarchy_structure", value)


@pulumi.type_token("aws-native:connect:UserHierarchyStructure")
class UserHierarchyStructure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 user_hierarchy_structure: Optional[pulumi.Input[Union['UserHierarchyStructurePropertiesArgs', 'UserHierarchyStructurePropertiesArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Connect::UserHierarchyStructure

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input[Union['UserHierarchyStructurePropertiesArgs', 'UserHierarchyStructurePropertiesArgsDict']] user_hierarchy_structure: Information about the hierarchy structure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserHierarchyStructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Connect::UserHierarchyStructure

        :param str resource_name: The name of the resource.
        :param UserHierarchyStructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserHierarchyStructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 user_hierarchy_structure: Optional[pulumi.Input[Union['UserHierarchyStructurePropertiesArgs', 'UserHierarchyStructurePropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserHierarchyStructureArgs.__new__(UserHierarchyStructureArgs)

            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            __props__.__dict__["user_hierarchy_structure"] = user_hierarchy_structure
            __props__.__dict__["user_hierarchy_structure_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instanceArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(UserHierarchyStructure, __self__).__init__(
            'aws-native:connect:UserHierarchyStructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'UserHierarchyStructure':
        """
        Get an existing UserHierarchyStructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = UserHierarchyStructureArgs.__new__(UserHierarchyStructureArgs)

        __props__.__dict__["instance_arn"] = None
        __props__.__dict__["user_hierarchy_structure"] = None
        __props__.__dict__["user_hierarchy_structure_arn"] = None
        return UserHierarchyStructure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="userHierarchyStructure")
    def user_hierarchy_structure(self) -> pulumi.Output[Optional['outputs.UserHierarchyStructureProperties']]:
        """
        Information about the hierarchy structure.
        """
        return pulumi.get(self, "user_hierarchy_structure")

    @property
    @pulumi.getter(name="userHierarchyStructureArn")
    def user_hierarchy_structure_arn(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the User Hierarchy Structure.
        """
        return pulumi.get(self, "user_hierarchy_structure_arn")

