# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['SecurityProfileArgs', 'SecurityProfile']

@pulumi.input_type
class SecurityProfileArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[builtins.str],
                 allowed_access_control_hierarchy_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_access_control_tags: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileTagArgs']]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileApplicationArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hierarchy_restricted_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 tag_restricted_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a SecurityProfile resource.
        :param pulumi.Input[builtins.str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input[builtins.str] allowed_access_control_hierarchy_group_id: The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityProfileTagArgs']]] allowed_access_control_tags: The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityProfileApplicationArgs']]] applications: A list of third-party applications that the security profile will give access to.
        :param pulumi.Input[builtins.str] description: The description of the security profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hierarchy_restricted_resources: The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: Permissions assigned to the security profile.
        :param pulumi.Input[builtins.str] security_profile_name: The name of the security profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tag_restricted_resources: The list of resources that a security profile applies tag restrictions to in Amazon Connect.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for this resource.
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        if allowed_access_control_hierarchy_group_id is not None:
            pulumi.set(__self__, "allowed_access_control_hierarchy_group_id", allowed_access_control_hierarchy_group_id)
        if allowed_access_control_tags is not None:
            pulumi.set(__self__, "allowed_access_control_tags", allowed_access_control_tags)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hierarchy_restricted_resources is not None:
            pulumi.set(__self__, "hierarchy_restricted_resources", hierarchy_restricted_resources)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if security_profile_name is not None:
            pulumi.set(__self__, "security_profile_name", security_profile_name)
        if tag_restricted_resources is not None:
            pulumi.set(__self__, "tag_restricted_resources", tag_restricted_resources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="allowedAccessControlHierarchyGroupId")
    def allowed_access_control_hierarchy_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
        """
        return pulumi.get(self, "allowed_access_control_hierarchy_group_id")

    @allowed_access_control_hierarchy_group_id.setter
    def allowed_access_control_hierarchy_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allowed_access_control_hierarchy_group_id", value)

    @property
    @pulumi.getter(name="allowedAccessControlTags")
    def allowed_access_control_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileTagArgs']]]]:
        """
        The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
        """
        return pulumi.get(self, "allowed_access_control_tags")

    @allowed_access_control_tags.setter
    def allowed_access_control_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileTagArgs']]]]):
        pulumi.set(self, "allowed_access_control_tags", value)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileApplicationArgs']]]]:
        """
        A list of third-party applications that the security profile will give access to.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileApplicationArgs']]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the security profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hierarchyRestrictedResources")
    def hierarchy_restricted_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
        """
        return pulumi.get(self, "hierarchy_restricted_resources")

    @hierarchy_restricted_resources.setter
    def hierarchy_restricted_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hierarchy_restricted_resources", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Permissions assigned to the security profile.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="securityProfileName")
    def security_profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the security profile.
        """
        return pulumi.get(self, "security_profile_name")

    @security_profile_name.setter
    def security_profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_profile_name", value)

    @property
    @pulumi.getter(name="tagRestrictedResources")
    def tag_restricted_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of resources that a security profile applies tag restrictions to in Amazon Connect.
        """
        return pulumi.get(self, "tag_restricted_resources")

    @tag_restricted_resources.setter
    def tag_restricted_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tag_restricted_resources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:connect:SecurityProfile")
class SecurityProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_access_control_hierarchy_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_access_control_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileTagArgs', 'SecurityProfileTagArgsDict']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileApplicationArgs', 'SecurityProfileApplicationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hierarchy_restricted_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 tag_restricted_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Connect::SecurityProfile

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allowed_access_control_hierarchy_group_id: The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileTagArgs', 'SecurityProfileTagArgsDict']]]] allowed_access_control_tags: The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileApplicationArgs', 'SecurityProfileApplicationArgsDict']]]] applications: A list of third-party applications that the security profile will give access to.
        :param pulumi.Input[builtins.str] description: The description of the security profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hierarchy_restricted_resources: The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
        :param pulumi.Input[builtins.str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: Permissions assigned to the security profile.
        :param pulumi.Input[builtins.str] security_profile_name: The name of the security profile.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tag_restricted_resources: The list of resources that a security profile applies tag restrictions to in Amazon Connect.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Connect::SecurityProfile

        :param str resource_name: The name of the resource.
        :param SecurityProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_access_control_hierarchy_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_access_control_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileTagArgs', 'SecurityProfileTagArgsDict']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileApplicationArgs', 'SecurityProfileApplicationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hierarchy_restricted_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 tag_restricted_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityProfileArgs.__new__(SecurityProfileArgs)

            __props__.__dict__["allowed_access_control_hierarchy_group_id"] = allowed_access_control_hierarchy_group_id
            __props__.__dict__["allowed_access_control_tags"] = allowed_access_control_tags
            __props__.__dict__["applications"] = applications
            __props__.__dict__["description"] = description
            __props__.__dict__["hierarchy_restricted_resources"] = hierarchy_restricted_resources
            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["security_profile_name"] = security_profile_name
            __props__.__dict__["tag_restricted_resources"] = tag_restricted_resources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["last_modified_region"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["security_profile_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instanceArn", "securityProfileName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SecurityProfile, __self__).__init__(
            'aws-native:connect:SecurityProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SecurityProfile':
        """
        Get an existing SecurityProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SecurityProfileArgs.__new__(SecurityProfileArgs)

        __props__.__dict__["allowed_access_control_hierarchy_group_id"] = None
        __props__.__dict__["allowed_access_control_tags"] = None
        __props__.__dict__["applications"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["hierarchy_restricted_resources"] = None
        __props__.__dict__["instance_arn"] = None
        __props__.__dict__["last_modified_region"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["permissions"] = None
        __props__.__dict__["security_profile_arn"] = None
        __props__.__dict__["security_profile_name"] = None
        __props__.__dict__["tag_restricted_resources"] = None
        __props__.__dict__["tags"] = None
        return SecurityProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedAccessControlHierarchyGroupId")
    def allowed_access_control_hierarchy_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
        """
        return pulumi.get(self, "allowed_access_control_hierarchy_group_id")

    @property
    @pulumi.getter(name="allowedAccessControlTags")
    def allowed_access_control_tags(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityProfileTag']]]:
        """
        The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
        """
        return pulumi.get(self, "allowed_access_control_tags")

    @property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityProfileApplication']]]:
        """
        A list of third-party applications that the security profile will give access to.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the security profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hierarchyRestrictedResources")
    def hierarchy_restricted_resources(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
        """
        return pulumi.get(self, "hierarchy_restricted_resources")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="lastModifiedRegion")
    def last_modified_region(self) -> pulumi.Output[builtins.str]:
        """
        The AWS Region where this resource was last modified.
        """
        return pulumi.get(self, "last_modified_region")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.float]:
        """
        The timestamp when this resource was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Permissions assigned to the security profile.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="securityProfileArn")
    def security_profile_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the security profile.
        """
        return pulumi.get(self, "security_profile_arn")

    @property
    @pulumi.getter(name="securityProfileName")
    def security_profile_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the security profile.
        """
        return pulumi.get(self, "security_profile_name")

    @property
    @pulumi.getter(name="tagRestrictedResources")
    def tag_restricted_resources(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of resources that a security profile applies tag restrictions to in Amazon Connect.
        """
        return pulumi.get(self, "tag_restricted_resources")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

