# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConstraintsProperties',
    'EvaluationFormBaseItem',
    'EvaluationFormItem',
    'EvaluationFormNumericQuestionAutomation',
    'EvaluationFormNumericQuestionOption',
    'EvaluationFormNumericQuestionProperties',
    'EvaluationFormNumericQuestionPropertyValueAutomation',
    'EvaluationFormQuestion',
    'EvaluationFormQuestionTypeProperties',
    'EvaluationFormScoringStrategy',
    'EvaluationFormSection',
    'EvaluationFormSingleSelectQuestionAutomation',
    'EvaluationFormSingleSelectQuestionAutomationOption',
    'EvaluationFormSingleSelectQuestionOption',
    'EvaluationFormSingleSelectQuestionProperties',
    'EvaluationFormSingleSelectQuestionRuleCategoryAutomation',
    'HoursOfOperationConfig',
    'HoursOfOperationOverride',
    'HoursOfOperationOverrideConfig',
    'HoursOfOperationOverrideTimeSlice',
    'HoursOfOperationTimeSlice',
    'InstanceAttributes',
    'InstanceStorageConfigEncryptionConfig',
    'InstanceStorageConfigKinesisFirehoseConfig',
    'InstanceStorageConfigKinesisStreamConfig',
    'InstanceStorageConfigKinesisVideoStreamConfig',
    'InstanceStorageConfigS3Config',
    'QueueOutboundCallerConfig',
    'QueueOutboundEmailConfig',
    'QuickConnectConfig',
    'QuickConnectPhoneNumberQuickConnectConfig',
    'QuickConnectQueueQuickConnectConfig',
    'QuickConnectUserQuickConnectConfig',
    'RoutingProfileCrossChannelBehavior',
    'RoutingProfileMediaConcurrency',
    'RoutingProfileQueueConfig',
    'RoutingProfileQueueReference',
    'RuleActions',
    'RuleAssignContactCategoryAction',
    'RuleCreateCaseAction',
    'RuleEndAssociatedTasksAction',
    'RuleEventBridgeAction',
    'RuleField',
    'RuleFieldValue',
    'RuleNotificationRecipientType',
    'RuleReference',
    'RuleSendNotificationAction',
    'RuleSubmitAutoEvaluationAction',
    'RuleTaskAction',
    'RuleTriggerEventSource',
    'RuleUpdateCaseAction',
    'SecurityProfileApplication',
    'SecurityProfileTag',
    'TaskTemplateDefaultFieldValue',
    'TaskTemplateField',
    'TaskTemplateFieldIdentifier',
    'TaskTemplateInvisibleFieldInfo',
    'TaskTemplateReadOnlyFieldInfo',
    'TaskTemplateRequiredFieldInfo',
    'UserHierarchyStructureLevelFive',
    'UserHierarchyStructureLevelFour',
    'UserHierarchyStructureLevelOne',
    'UserHierarchyStructureLevelThree',
    'UserHierarchyStructureLevelTwo',
    'UserHierarchyStructureProperties',
    'UserIdentityInfo',
    'UserPhoneConfig',
    'UserProficiency',
    'ValuesProperties',
]

@pulumi.output_type
class ConstraintsProperties(dict):
    """
    The constraints for the task template
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invisibleFields":
            suggest = "invisible_fields"
        elif key == "readOnlyFields":
            suggest = "read_only_fields"
        elif key == "requiredFields":
            suggest = "required_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConstraintsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConstraintsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConstraintsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invisible_fields: Optional[Sequence['outputs.TaskTemplateInvisibleFieldInfo']] = None,
                 read_only_fields: Optional[Sequence['outputs.TaskTemplateReadOnlyFieldInfo']] = None,
                 required_fields: Optional[Sequence['outputs.TaskTemplateRequiredFieldInfo']] = None):
        """
        The constraints for the task template
        :param Sequence['TaskTemplateInvisibleFieldInfo'] invisible_fields: Lists the fields that are invisible to agents.
        :param Sequence['TaskTemplateReadOnlyFieldInfo'] read_only_fields: Lists the fields that are read-only to agents, and cannot be edited.
        :param Sequence['TaskTemplateRequiredFieldInfo'] required_fields: Lists the fields that are required to be filled by agents.
        """
        if invisible_fields is not None:
            pulumi.set(__self__, "invisible_fields", invisible_fields)
        if read_only_fields is not None:
            pulumi.set(__self__, "read_only_fields", read_only_fields)
        if required_fields is not None:
            pulumi.set(__self__, "required_fields", required_fields)

    @property
    @pulumi.getter(name="invisibleFields")
    def invisible_fields(self) -> Optional[Sequence['outputs.TaskTemplateInvisibleFieldInfo']]:
        """
        Lists the fields that are invisible to agents.
        """
        return pulumi.get(self, "invisible_fields")

    @property
    @pulumi.getter(name="readOnlyFields")
    def read_only_fields(self) -> Optional[Sequence['outputs.TaskTemplateReadOnlyFieldInfo']]:
        """
        Lists the fields that are read-only to agents, and cannot be edited.
        """
        return pulumi.get(self, "read_only_fields")

    @property
    @pulumi.getter(name="requiredFields")
    def required_fields(self) -> Optional[Sequence['outputs.TaskTemplateRequiredFieldInfo']]:
        """
        Lists the fields that are required to be filled by agents.
        """
        return pulumi.get(self, "required_fields")


@pulumi.output_type
class EvaluationFormBaseItem(dict):
    """
    An item at the root level. All items must be sections.
    """
    def __init__(__self__, *,
                 section: 'outputs.EvaluationFormSection'):
        """
        An item at the root level. All items must be sections.
        :param 'EvaluationFormSection' section: A subsection or inner section of an item.
        """
        pulumi.set(__self__, "section", section)

    @property
    @pulumi.getter
    def section(self) -> 'outputs.EvaluationFormSection':
        """
        A subsection or inner section of an item.
        """
        return pulumi.get(self, "section")


@pulumi.output_type
class EvaluationFormItem(dict):
    """
    Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
    """
    def __init__(__self__, *,
                 question: Optional['outputs.EvaluationFormQuestion'] = None,
                 section: Optional['outputs.EvaluationFormSection'] = None):
        """
        Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
        :param 'EvaluationFormQuestion' question: The information of the question.
        :param 'EvaluationFormSection' section: The information of the section.
        """
        if question is not None:
            pulumi.set(__self__, "question", question)
        if section is not None:
            pulumi.set(__self__, "section", section)

    @property
    @pulumi.getter
    def question(self) -> Optional['outputs.EvaluationFormQuestion']:
        """
        The information of the question.
        """
        return pulumi.get(self, "question")

    @property
    @pulumi.getter
    def section(self) -> Optional['outputs.EvaluationFormSection']:
        """
        The information of the section.
        """
        return pulumi.get(self, "section")


@pulumi.output_type
class EvaluationFormNumericQuestionAutomation(dict):
    """
    Information about the automation configuration in numeric questions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyValue":
            suggest = "property_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormNumericQuestionAutomation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormNumericQuestionAutomation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormNumericQuestionAutomation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property_value: 'outputs.EvaluationFormNumericQuestionPropertyValueAutomation'):
        """
        Information about the automation configuration in numeric questions.
        :param 'EvaluationFormNumericQuestionPropertyValueAutomation' property_value: The property value of the automation.
        """
        pulumi.set(__self__, "property_value", property_value)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> 'outputs.EvaluationFormNumericQuestionPropertyValueAutomation':
        """
        The property value of the automation.
        """
        return pulumi.get(self, "property_value")


@pulumi.output_type
class EvaluationFormNumericQuestionOption(dict):
    """
    Information about the option range used for scoring in numeric questions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"
        elif key == "automaticFail":
            suggest = "automatic_fail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormNumericQuestionOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormNumericQuestionOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormNumericQuestionOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: builtins.int,
                 min_value: builtins.int,
                 automatic_fail: Optional[builtins.bool] = None,
                 score: Optional[builtins.int] = None):
        """
        Information about the option range used for scoring in numeric questions.
        :param builtins.int max_value: The maximum answer value of the range option.
        :param builtins.int min_value: The minimum answer value of the range option.
        :param builtins.bool automatic_fail: The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation gets a score of 0.
        :param builtins.int score: The score assigned to answer values within the range option.
                *Minimum*: 0
                *Maximum*: 10
        """
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)
        if automatic_fail is not None:
            pulumi.set(__self__, "automatic_fail", automatic_fail)
        if score is not None:
            pulumi.set(__self__, "score", score)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> builtins.int:
        """
        The maximum answer value of the range option.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> builtins.int:
        """
        The minimum answer value of the range option.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter(name="automaticFail")
    def automatic_fail(self) -> Optional[builtins.bool]:
        """
        The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation gets a score of 0.
        """
        return pulumi.get(self, "automatic_fail")

    @property
    @pulumi.getter
    def score(self) -> Optional[builtins.int]:
        """
        The score assigned to answer values within the range option.
         *Minimum*: 0
         *Maximum*: 10
        """
        return pulumi.get(self, "score")


@pulumi.output_type
class EvaluationFormNumericQuestionProperties(dict):
    """
    Information about properties for a numeric question in an evaluation form.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormNumericQuestionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormNumericQuestionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormNumericQuestionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: builtins.int,
                 min_value: builtins.int,
                 automation: Optional['outputs.EvaluationFormNumericQuestionAutomation'] = None,
                 options: Optional[Sequence['outputs.EvaluationFormNumericQuestionOption']] = None):
        """
        Information about properties for a numeric question in an evaluation form.
        :param builtins.int max_value: The maximum answer value.
        :param builtins.int min_value: The minimum answer value.
        :param 'EvaluationFormNumericQuestionAutomation' automation: The automation properties of the numeric question.
        :param Sequence['EvaluationFormNumericQuestionOption'] options: The scoring options of the numeric question.
        """
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)
        if automation is not None:
            pulumi.set(__self__, "automation", automation)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> builtins.int:
        """
        The maximum answer value.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> builtins.int:
        """
        The minimum answer value.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter
    def automation(self) -> Optional['outputs.EvaluationFormNumericQuestionAutomation']:
        """
        The automation properties of the numeric question.
        """
        return pulumi.get(self, "automation")

    @property
    @pulumi.getter
    def options(self) -> Optional[Sequence['outputs.EvaluationFormNumericQuestionOption']]:
        """
        The scoring options of the numeric question.
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class EvaluationFormNumericQuestionPropertyValueAutomation(dict):
    """
    Information about the property value used in automation of a numeric questions.
    """
    def __init__(__self__, *,
                 label: 'EvaluationFormNumericQuestionPropertyValueAutomationLabel'):
        """
        Information about the property value used in automation of a numeric questions.
        :param 'EvaluationFormNumericQuestionPropertyValueAutomationLabel' label: The property label of the automation.
        """
        pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter
    def label(self) -> 'EvaluationFormNumericQuestionPropertyValueAutomationLabel':
        """
        The property label of the automation.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class EvaluationFormQuestion(dict):
    """
    Information about a question from an evaluation form.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "questionType":
            suggest = "question_type"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "notApplicableEnabled":
            suggest = "not_applicable_enabled"
        elif key == "questionTypeProperties":
            suggest = "question_type_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormQuestion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormQuestion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormQuestion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 question_type: 'EvaluationFormQuestionQuestionType',
                 ref_id: builtins.str,
                 title: builtins.str,
                 instructions: Optional[builtins.str] = None,
                 not_applicable_enabled: Optional[builtins.bool] = None,
                 question_type_properties: Optional['outputs.EvaluationFormQuestionTypeProperties'] = None,
                 weight: Optional[builtins.float] = None):
        """
        Information about a question from an evaluation form.
        :param 'EvaluationFormQuestionQuestionType' question_type: The type of the question.
                *Allowed values*: ``NUMERIC`` | ``SINGLESELECT`` | ``TEXT``
        :param builtins.str ref_id: The identifier of the question. An identifier must be unique within the evaluation form.
                *Length Constraints*: Minimum length of 1. Maximum length of 40.
        :param builtins.str title: The title of the question.
                *Length Constraints*: Minimum length of 1. Maximum length of 350.
        :param builtins.str instructions: The instructions of the section.
                *Length Constraints*: Minimum length of 0. Maximum length of 1024.
        :param builtins.bool not_applicable_enabled: The flag to enable not applicable answers to the question.
        :param 'EvaluationFormQuestionTypeProperties' question_type_properties: The properties of the type of question. Text questions do not have to define question type properties.
        :param builtins.float weight: The scoring weight of the section.
                *Minimum*: 0
                *Maximum*: 100
        """
        pulumi.set(__self__, "question_type", question_type)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "title", title)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if not_applicable_enabled is not None:
            pulumi.set(__self__, "not_applicable_enabled", not_applicable_enabled)
        if question_type_properties is not None:
            pulumi.set(__self__, "question_type_properties", question_type_properties)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="questionType")
    def question_type(self) -> 'EvaluationFormQuestionQuestionType':
        """
        The type of the question.
         *Allowed values*: ``NUMERIC`` | ``SINGLESELECT`` | ``TEXT``
        """
        return pulumi.get(self, "question_type")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        The identifier of the question. An identifier must be unique within the evaluation form.
         *Length Constraints*: Minimum length of 1. Maximum length of 40.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        The title of the question.
         *Length Constraints*: Minimum length of 1. Maximum length of 350.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def instructions(self) -> Optional[builtins.str]:
        """
        The instructions of the section.
         *Length Constraints*: Minimum length of 0. Maximum length of 1024.
        """
        return pulumi.get(self, "instructions")

    @property
    @pulumi.getter(name="notApplicableEnabled")
    def not_applicable_enabled(self) -> Optional[builtins.bool]:
        """
        The flag to enable not applicable answers to the question.
        """
        return pulumi.get(self, "not_applicable_enabled")

    @property
    @pulumi.getter(name="questionTypeProperties")
    def question_type_properties(self) -> Optional['outputs.EvaluationFormQuestionTypeProperties']:
        """
        The properties of the type of question. Text questions do not have to define question type properties.
        """
        return pulumi.get(self, "question_type_properties")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.float]:
        """
        The scoring weight of the section.
         *Minimum*: 0
         *Maximum*: 100
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class EvaluationFormQuestionTypeProperties(dict):
    """
    Information about properties for a question in an evaluation form. The question type properties must be either for a numeric question or a single select question.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "singleSelect":
            suggest = "single_select"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormQuestionTypeProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormQuestionTypeProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormQuestionTypeProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 numeric: Optional['outputs.EvaluationFormNumericQuestionProperties'] = None,
                 single_select: Optional['outputs.EvaluationFormSingleSelectQuestionProperties'] = None):
        """
        Information about properties for a question in an evaluation form. The question type properties must be either for a numeric question or a single select question.
        :param 'EvaluationFormNumericQuestionProperties' numeric: The properties of the numeric question.
        :param 'EvaluationFormSingleSelectQuestionProperties' single_select: The properties of the numeric question.
        """
        if numeric is not None:
            pulumi.set(__self__, "numeric", numeric)
        if single_select is not None:
            pulumi.set(__self__, "single_select", single_select)

    @property
    @pulumi.getter
    def numeric(self) -> Optional['outputs.EvaluationFormNumericQuestionProperties']:
        """
        The properties of the numeric question.
        """
        return pulumi.get(self, "numeric")

    @property
    @pulumi.getter(name="singleSelect")
    def single_select(self) -> Optional['outputs.EvaluationFormSingleSelectQuestionProperties']:
        """
        The properties of the numeric question.
        """
        return pulumi.get(self, "single_select")


@pulumi.output_type
class EvaluationFormScoringStrategy(dict):
    """
    A scoring strategy of the evaluation form.
    """
    def __init__(__self__, *,
                 mode: 'EvaluationFormScoringStrategyMode',
                 status: 'EvaluationFormScoringStrategyStatus'):
        """
        A scoring strategy of the evaluation form.
        :param 'EvaluationFormScoringStrategyMode' mode: The scoring mode of the evaluation form.
                *Allowed values*: ``QUESTION_ONLY`` | ``SECTION_ONLY``
        :param 'EvaluationFormScoringStrategyStatus' status: The scoring status of the evaluation form.
                *Allowed values*: ``ENABLED`` | ``DISABLED``
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def mode(self) -> 'EvaluationFormScoringStrategyMode':
        """
        The scoring mode of the evaluation form.
         *Allowed values*: ``QUESTION_ONLY`` | ``SECTION_ONLY``
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def status(self) -> 'EvaluationFormScoringStrategyStatus':
        """
        The scoring status of the evaluation form.
         *Allowed values*: ``ENABLED`` | ``DISABLED``
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class EvaluationFormSection(dict):
    """
    Information about a section from an evaluation form. A section can contain sections and/or questions. Evaluation forms can only contain sections and subsections (two level nesting).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "refId":
            suggest = "ref_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormSection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormSection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormSection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ref_id: builtins.str,
                 title: builtins.str,
                 instructions: Optional[builtins.str] = None,
                 items: Optional[Sequence['outputs.EvaluationFormItem']] = None,
                 weight: Optional[builtins.float] = None):
        """
        Information about a section from an evaluation form. A section can contain sections and/or questions. Evaluation forms can only contain sections and subsections (two level nesting).
        :param builtins.str ref_id: The identifier of the section. An identifier must be unique within the evaluation form.
                *Length Constraints*: Minimum length of 1. Maximum length of 40.
        :param builtins.str title: The title of the section.
                *Length Constraints*: Minimum length of 1. Maximum length of 128.
        :param builtins.str instructions: The instructions of the section.
        :param Sequence['EvaluationFormItem'] items: The items of the section.
                *Minimum*: 1
        :param builtins.float weight: The scoring weight of the section.
                *Minimum*: 0 
                *Maximum*: 100
        """
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "title", title)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        The identifier of the section. An identifier must be unique within the evaluation form.
         *Length Constraints*: Minimum length of 1. Maximum length of 40.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        The title of the section.
         *Length Constraints*: Minimum length of 1. Maximum length of 128.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def instructions(self) -> Optional[builtins.str]:
        """
        The instructions of the section.
        """
        return pulumi.get(self, "instructions")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.EvaluationFormItem']]:
        """
        The items of the section.
         *Minimum*: 1
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.float]:
        """
        The scoring weight of the section.
         *Minimum*: 0 
         *Maximum*: 100
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class EvaluationFormSingleSelectQuestionAutomation(dict):
    """
    Information about the automation configuration in single select questions. Automation options are evaluated in order, and the first matched option is applied. If no automation option matches, and there is a default option, then the default option is applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultOptionRefId":
            suggest = "default_option_ref_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormSingleSelectQuestionAutomation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormSingleSelectQuestionAutomation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormSingleSelectQuestionAutomation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 options: Sequence['outputs.EvaluationFormSingleSelectQuestionAutomationOption'],
                 default_option_ref_id: Optional[builtins.str] = None):
        """
        Information about the automation configuration in single select questions. Automation options are evaluated in order, and the first matched option is applied. If no automation option matches, and there is a default option, then the default option is applied.
        :param Sequence['EvaluationFormSingleSelectQuestionAutomationOption'] options: The automation options of the single select question.
                *Minimum*: 1
                *Maximum*: 20
        :param builtins.str default_option_ref_id: The identifier of the default answer option, when none of the automation options match the criteria.
                *Length Constraints*: Minimum length of 1. Maximum length of 40.
        """
        pulumi.set(__self__, "options", options)
        if default_option_ref_id is not None:
            pulumi.set(__self__, "default_option_ref_id", default_option_ref_id)

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.EvaluationFormSingleSelectQuestionAutomationOption']:
        """
        The automation options of the single select question.
         *Minimum*: 1
         *Maximum*: 20
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="defaultOptionRefId")
    def default_option_ref_id(self) -> Optional[builtins.str]:
        """
        The identifier of the default answer option, when none of the automation options match the criteria.
         *Length Constraints*: Minimum length of 1. Maximum length of 40.
        """
        return pulumi.get(self, "default_option_ref_id")


@pulumi.output_type
class EvaluationFormSingleSelectQuestionAutomationOption(dict):
    """
    The automation options of the single select question.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleCategory":
            suggest = "rule_category"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormSingleSelectQuestionAutomationOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormSingleSelectQuestionAutomationOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormSingleSelectQuestionAutomationOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_category: 'outputs.EvaluationFormSingleSelectQuestionRuleCategoryAutomation'):
        """
        The automation options of the single select question.
        :param 'EvaluationFormSingleSelectQuestionRuleCategoryAutomation' rule_category: The automation option based on a rule category for the single select question.
        """
        pulumi.set(__self__, "rule_category", rule_category)

    @property
    @pulumi.getter(name="ruleCategory")
    def rule_category(self) -> 'outputs.EvaluationFormSingleSelectQuestionRuleCategoryAutomation':
        """
        The automation option based on a rule category for the single select question.
        """
        return pulumi.get(self, "rule_category")


@pulumi.output_type
class EvaluationFormSingleSelectQuestionOption(dict):
    """
    Information about the automation configuration in single select questions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "refId":
            suggest = "ref_id"
        elif key == "automaticFail":
            suggest = "automatic_fail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormSingleSelectQuestionOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormSingleSelectQuestionOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormSingleSelectQuestionOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ref_id: builtins.str,
                 text: builtins.str,
                 automatic_fail: Optional[builtins.bool] = None,
                 score: Optional[builtins.int] = None):
        """
        Information about the automation configuration in single select questions.
        :param builtins.str ref_id: The identifier of the answer option. An identifier must be unique within the question.
                *Length Constraints*: Minimum length of 1. Maximum length of 40.
        :param builtins.str text: The title of the answer option.
                *Length Constraints*: Minimum length of 1. Maximum length of 128.
        :param builtins.bool automatic_fail: The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation gets a score of 0.
        :param builtins.int score: The score assigned to the answer option.
                *Minimum*: 0
                *Maximum*: 10
        """
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "text", text)
        if automatic_fail is not None:
            pulumi.set(__self__, "automatic_fail", automatic_fail)
        if score is not None:
            pulumi.set(__self__, "score", score)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        The identifier of the answer option. An identifier must be unique within the question.
         *Length Constraints*: Minimum length of 1. Maximum length of 40.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def text(self) -> builtins.str:
        """
        The title of the answer option.
         *Length Constraints*: Minimum length of 1. Maximum length of 128.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="automaticFail")
    def automatic_fail(self) -> Optional[builtins.bool]:
        """
        The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation gets a score of 0.
        """
        return pulumi.get(self, "automatic_fail")

    @property
    @pulumi.getter
    def score(self) -> Optional[builtins.int]:
        """
        The score assigned to the answer option.
         *Minimum*: 0
         *Maximum*: 10
        """
        return pulumi.get(self, "score")


@pulumi.output_type
class EvaluationFormSingleSelectQuestionProperties(dict):
    """
    Information about the options in single select questions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayAs":
            suggest = "display_as"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormSingleSelectQuestionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormSingleSelectQuestionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormSingleSelectQuestionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 options: Sequence['outputs.EvaluationFormSingleSelectQuestionOption'],
                 automation: Optional['outputs.EvaluationFormSingleSelectQuestionAutomation'] = None,
                 display_as: Optional['EvaluationFormSingleSelectQuestionPropertiesDisplayAs'] = None):
        """
        Information about the options in single select questions.
        :param Sequence['EvaluationFormSingleSelectQuestionOption'] options: The answer options of the single select question.
                *Minimum*: 2
                *Maximum*: 256
        :param 'EvaluationFormSingleSelectQuestionAutomation' automation: The display mode of the single select question.
        :param 'EvaluationFormSingleSelectQuestionPropertiesDisplayAs' display_as: The display mode of the single select question.
                *Allowed values*: ``DROPDOWN`` | ``RADIO``
        """
        pulumi.set(__self__, "options", options)
        if automation is not None:
            pulumi.set(__self__, "automation", automation)
        if display_as is not None:
            pulumi.set(__self__, "display_as", display_as)

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.EvaluationFormSingleSelectQuestionOption']:
        """
        The answer options of the single select question.
         *Minimum*: 2
         *Maximum*: 256
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def automation(self) -> Optional['outputs.EvaluationFormSingleSelectQuestionAutomation']:
        """
        The display mode of the single select question.
        """
        return pulumi.get(self, "automation")

    @property
    @pulumi.getter(name="displayAs")
    def display_as(self) -> Optional['EvaluationFormSingleSelectQuestionPropertiesDisplayAs']:
        """
        The display mode of the single select question.
         *Allowed values*: ``DROPDOWN`` | ``RADIO``
        """
        return pulumi.get(self, "display_as")


@pulumi.output_type
class EvaluationFormSingleSelectQuestionRuleCategoryAutomation(dict):
    """
    Information about the automation option based on a rule category for a single select question.
     *Length Constraints*: Minimum length of 1. Maximum length of 50.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "optionRefId":
            suggest = "option_ref_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EvaluationFormSingleSelectQuestionRuleCategoryAutomation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EvaluationFormSingleSelectQuestionRuleCategoryAutomation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EvaluationFormSingleSelectQuestionRuleCategoryAutomation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: builtins.str,
                 condition: 'EvaluationFormSingleSelectQuestionRuleCategoryAutomationCondition',
                 option_ref_id: builtins.str):
        """
        Information about the automation option based on a rule category for a single select question.
         *Length Constraints*: Minimum length of 1. Maximum length of 50.
        :param builtins.str category: The category name, as defined in Rules.
                *Minimum*: 1
                *Maximum*: 50
        :param 'EvaluationFormSingleSelectQuestionRuleCategoryAutomationCondition' condition: The condition to apply for the automation option. If the condition is PRESENT, then the option is applied when the contact data includes the category. Similarly, if the condition is NOT_PRESENT, then the option is applied when the contact data does not include the category.
                *Allowed values*: ``PRESENT`` | ``NOT_PRESENT``
                *Maximum*: 50
        :param builtins.str option_ref_id: The identifier of the answer option. An identifier must be unique within the question.
                *Length Constraints*: Minimum length of 1. Maximum length of 40.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "option_ref_id", option_ref_id)

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        The category name, as defined in Rules.
         *Minimum*: 1
         *Maximum*: 50
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def condition(self) -> 'EvaluationFormSingleSelectQuestionRuleCategoryAutomationCondition':
        """
        The condition to apply for the automation option. If the condition is PRESENT, then the option is applied when the contact data includes the category. Similarly, if the condition is NOT_PRESENT, then the option is applied when the contact data does not include the category.
         *Allowed values*: ``PRESENT`` | ``NOT_PRESENT``
         *Maximum*: 50
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="optionRefId")
    def option_ref_id(self) -> builtins.str:
        """
        The identifier of the answer option. An identifier must be unique within the question.
         *Length Constraints*: Minimum length of 1. Maximum length of 40.
        """
        return pulumi.get(self, "option_ref_id")


@pulumi.output_type
class HoursOfOperationConfig(dict):
    """
    Contains information about the hours of operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoursOfOperationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoursOfOperationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoursOfOperationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: 'HoursOfOperationConfigDay',
                 end_time: 'outputs.HoursOfOperationTimeSlice',
                 start_time: 'outputs.HoursOfOperationTimeSlice'):
        """
        Contains information about the hours of operation.
        :param 'HoursOfOperationConfigDay' day: The day that the hours of operation applies to.
        :param 'HoursOfOperationTimeSlice' end_time: The end time that your contact center closes.
        :param 'HoursOfOperationTimeSlice' start_time: The start time that your contact center opens.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> 'HoursOfOperationConfigDay':
        """
        The day that the hours of operation applies to.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> 'outputs.HoursOfOperationTimeSlice':
        """
        The end time that your contact center closes.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.HoursOfOperationTimeSlice':
        """
        The start time that your contact center opens.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class HoursOfOperationOverride(dict):
    """
    Overrides attached to the hours of operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveFrom":
            suggest = "effective_from"
        elif key == "effectiveTill":
            suggest = "effective_till"
        elif key == "overrideConfig":
            suggest = "override_config"
        elif key == "overrideName":
            suggest = "override_name"
        elif key == "hoursOfOperationOverrideId":
            suggest = "hours_of_operation_override_id"
        elif key == "overrideDescription":
            suggest = "override_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoursOfOperationOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoursOfOperationOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoursOfOperationOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_from: builtins.str,
                 effective_till: builtins.str,
                 override_config: Sequence['outputs.HoursOfOperationOverrideConfig'],
                 override_name: builtins.str,
                 hours_of_operation_override_id: Optional[builtins.str] = None,
                 override_description: Optional[builtins.str] = None):
        """
        Overrides attached to the hours of operation.
        :param builtins.str effective_from: The date from which the hours of operation override would be effective.
        :param builtins.str effective_till: The date till which the hours of operation override would be effective.
        :param builtins.str hours_of_operation_override_id: The identifier for the hours of operation override.
        """
        pulumi.set(__self__, "effective_from", effective_from)
        pulumi.set(__self__, "effective_till", effective_till)
        pulumi.set(__self__, "override_config", override_config)
        pulumi.set(__self__, "override_name", override_name)
        if hours_of_operation_override_id is not None:
            pulumi.set(__self__, "hours_of_operation_override_id", hours_of_operation_override_id)
        if override_description is not None:
            pulumi.set(__self__, "override_description", override_description)

    @property
    @pulumi.getter(name="effectiveFrom")
    def effective_from(self) -> builtins.str:
        """
        The date from which the hours of operation override would be effective.
        """
        return pulumi.get(self, "effective_from")

    @property
    @pulumi.getter(name="effectiveTill")
    def effective_till(self) -> builtins.str:
        """
        The date till which the hours of operation override would be effective.
        """
        return pulumi.get(self, "effective_till")

    @property
    @pulumi.getter(name="overrideConfig")
    def override_config(self) -> Sequence['outputs.HoursOfOperationOverrideConfig']:
        return pulumi.get(self, "override_config")

    @property
    @pulumi.getter(name="overrideName")
    def override_name(self) -> builtins.str:
        return pulumi.get(self, "override_name")

    @property
    @pulumi.getter(name="hoursOfOperationOverrideId")
    def hours_of_operation_override_id(self) -> Optional[builtins.str]:
        """
        The identifier for the hours of operation override.
        """
        return pulumi.get(self, "hours_of_operation_override_id")

    @property
    @pulumi.getter(name="overrideDescription")
    def override_description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "override_description")


@pulumi.output_type
class HoursOfOperationOverrideConfig(dict):
    """
    Contains information about the hours of operation override.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoursOfOperationOverrideConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoursOfOperationOverrideConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoursOfOperationOverrideConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: 'HoursOfOperationOverrideConfigDay',
                 end_time: 'outputs.HoursOfOperationOverrideTimeSlice',
                 start_time: 'outputs.HoursOfOperationOverrideTimeSlice'):
        """
        Contains information about the hours of operation override.
        :param 'HoursOfOperationOverrideConfigDay' day: The day that the hours of operation override applies to.
        :param 'HoursOfOperationOverrideTimeSlice' end_time: The new end time that your contact center closes for the overriden days.
        :param 'HoursOfOperationOverrideTimeSlice' start_time: The new start time that your contact center opens for the overriden days.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> 'HoursOfOperationOverrideConfigDay':
        """
        The day that the hours of operation override applies to.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> 'outputs.HoursOfOperationOverrideTimeSlice':
        """
        The new end time that your contact center closes for the overriden days.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.HoursOfOperationOverrideTimeSlice':
        """
        The new start time that your contact center opens for the overriden days.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class HoursOfOperationOverrideTimeSlice(dict):
    """
    The start time or end time for an an hours of operation override.
    """
    def __init__(__self__, *,
                 hours: builtins.int,
                 minutes: builtins.int):
        """
        The start time or end time for an an hours of operation override.
        :param builtins.int hours: The hours.
        :param builtins.int minutes: The minutes.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> builtins.int:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> builtins.int:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class HoursOfOperationTimeSlice(dict):
    """
    The start time or end time for an hours of operation.
    """
    def __init__(__self__, *,
                 hours: builtins.int,
                 minutes: builtins.int):
        """
        The start time or end time for an hours of operation.
        :param builtins.int hours: The hours.
        :param builtins.int minutes: The minutes.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> builtins.int:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> builtins.int:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class InstanceAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundCalls":
            suggest = "inbound_calls"
        elif key == "outboundCalls":
            suggest = "outbound_calls"
        elif key == "autoResolveBestVoices":
            suggest = "auto_resolve_best_voices"
        elif key == "contactLens":
            suggest = "contact_lens"
        elif key == "contactflowLogs":
            suggest = "contactflow_logs"
        elif key == "earlyMedia":
            suggest = "early_media"
        elif key == "useCustomTtsVoices":
            suggest = "use_custom_tts_voices"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_calls: builtins.bool,
                 outbound_calls: builtins.bool,
                 auto_resolve_best_voices: Optional[builtins.bool] = None,
                 contact_lens: Optional[builtins.bool] = None,
                 contactflow_logs: Optional[builtins.bool] = None,
                 early_media: Optional[builtins.bool] = None,
                 use_custom_tts_voices: Optional[builtins.bool] = None):
        pulumi.set(__self__, "inbound_calls", inbound_calls)
        pulumi.set(__self__, "outbound_calls", outbound_calls)
        if auto_resolve_best_voices is not None:
            pulumi.set(__self__, "auto_resolve_best_voices", auto_resolve_best_voices)
        if contact_lens is not None:
            pulumi.set(__self__, "contact_lens", contact_lens)
        if contactflow_logs is not None:
            pulumi.set(__self__, "contactflow_logs", contactflow_logs)
        if early_media is not None:
            pulumi.set(__self__, "early_media", early_media)
        if use_custom_tts_voices is not None:
            pulumi.set(__self__, "use_custom_tts_voices", use_custom_tts_voices)

    @property
    @pulumi.getter(name="inboundCalls")
    def inbound_calls(self) -> builtins.bool:
        return pulumi.get(self, "inbound_calls")

    @property
    @pulumi.getter(name="outboundCalls")
    def outbound_calls(self) -> builtins.bool:
        return pulumi.get(self, "outbound_calls")

    @property
    @pulumi.getter(name="autoResolveBestVoices")
    def auto_resolve_best_voices(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "auto_resolve_best_voices")

    @property
    @pulumi.getter(name="contactLens")
    def contact_lens(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "contact_lens")

    @property
    @pulumi.getter(name="contactflowLogs")
    def contactflow_logs(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "contactflow_logs")

    @property
    @pulumi.getter(name="earlyMedia")
    def early_media(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "early_media")

    @property
    @pulumi.getter(name="useCustomTtsVoices")
    def use_custom_tts_voices(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "use_custom_tts_voices")


@pulumi.output_type
class InstanceStorageConfigEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStorageConfigEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStorageConfigEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStorageConfigEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: 'InstanceStorageConfigEncryptionType',
                 key_id: builtins.str):
        """
        :param 'InstanceStorageConfigEncryptionType' encryption_type: The type of encryption.
        :param builtins.str key_id: The full ARN of the encryption key.
               
               > Be sure to provide the full ARN of the encryption key, not just the ID.
               > 
               > Amazon Connect supports only KMS keys with the default key spec of [`SYMMETRIC_DEFAULT`](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-symmetric-default) .
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> 'InstanceStorageConfigEncryptionType':
        """
        The type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> builtins.str:
        """
        The full ARN of the encryption key.

        > Be sure to provide the full ARN of the encryption key, not just the ID.
        > 
        > Amazon Connect supports only KMS keys with the default key spec of [`SYMMETRIC_DEFAULT`](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-symmetric-default) .
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class InstanceStorageConfigKinesisFirehoseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firehoseArn":
            suggest = "firehose_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStorageConfigKinesisFirehoseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStorageConfigKinesisFirehoseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStorageConfigKinesisFirehoseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 firehose_arn: builtins.str):
        """
        :param builtins.str firehose_arn: The Amazon Resource Name (ARN) of the delivery stream.
        """
        pulumi.set(__self__, "firehose_arn", firehose_arn)

    @property
    @pulumi.getter(name="firehoseArn")
    def firehose_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the delivery stream.
        """
        return pulumi.get(self, "firehose_arn")


@pulumi.output_type
class InstanceStorageConfigKinesisStreamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStorageConfigKinesisStreamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStorageConfigKinesisStreamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStorageConfigKinesisStreamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream_arn: builtins.str):
        """
        :param builtins.str stream_arn: The Amazon Resource Name (ARN) of the data stream.
        """
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the data stream.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class InstanceStorageConfigKinesisVideoStreamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "retentionPeriodHours":
            suggest = "retention_period_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStorageConfigKinesisVideoStreamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStorageConfigKinesisVideoStreamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStorageConfigKinesisVideoStreamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_config: 'outputs.InstanceStorageConfigEncryptionConfig',
                 prefix: builtins.str,
                 retention_period_hours: builtins.float):
        """
        :param 'InstanceStorageConfigEncryptionConfig' encryption_config: The encryption configuration.
        :param builtins.str prefix: The prefix of the video stream.
        :param builtins.float retention_period_hours: The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.
               
               The default value is 0, indicating that the stream does not persist data.
        """
        pulumi.set(__self__, "encryption_config", encryption_config)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "retention_period_hours", retention_period_hours)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> 'outputs.InstanceStorageConfigEncryptionConfig':
        """
        The encryption configuration.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        The prefix of the video stream.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="retentionPeriodHours")
    def retention_period_hours(self) -> builtins.float:
        """
        The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.

        The default value is 0, indicating that the stream does not persist data.
        """
        return pulumi.get(self, "retention_period_hours")


@pulumi.output_type
class InstanceStorageConfigS3Config(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "encryptionConfig":
            suggest = "encryption_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStorageConfigS3Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStorageConfigS3Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStorageConfigS3Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 bucket_prefix: builtins.str,
                 encryption_config: Optional['outputs.InstanceStorageConfigEncryptionConfig'] = None):
        """
        :param builtins.str bucket_name: The S3 bucket name.
        :param builtins.str bucket_prefix: The S3 bucket prefix.
        :param 'InstanceStorageConfigEncryptionConfig' encryption_config: The Amazon S3 encryption configuration.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The S3 bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> builtins.str:
        """
        The S3 bucket prefix.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.InstanceStorageConfigEncryptionConfig']:
        """
        The Amazon S3 encryption configuration.
        """
        return pulumi.get(self, "encryption_config")


@pulumi.output_type
class QueueOutboundCallerConfig(dict):
    """
    The outbound caller ID name, number, and outbound whisper flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outboundCallerIdName":
            suggest = "outbound_caller_id_name"
        elif key == "outboundCallerIdNumberArn":
            suggest = "outbound_caller_id_number_arn"
        elif key == "outboundFlowArn":
            suggest = "outbound_flow_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueOutboundCallerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueOutboundCallerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueOutboundCallerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 outbound_caller_id_name: Optional[builtins.str] = None,
                 outbound_caller_id_number_arn: Optional[builtins.str] = None,
                 outbound_flow_arn: Optional[builtins.str] = None):
        """
        The outbound caller ID name, number, and outbound whisper flow.
        :param builtins.str outbound_caller_id_name: The caller ID name.
        :param builtins.str outbound_caller_id_number_arn: The Amazon Resource Name (ARN) of the outbound caller ID number.
               
               > Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid` . This is the same ARN format that is returned when you create a phone number using CloudFormation , or when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
        :param builtins.str outbound_flow_arn: The Amazon Resource Name (ARN) of the outbound flow.
        """
        if outbound_caller_id_name is not None:
            pulumi.set(__self__, "outbound_caller_id_name", outbound_caller_id_name)
        if outbound_caller_id_number_arn is not None:
            pulumi.set(__self__, "outbound_caller_id_number_arn", outbound_caller_id_number_arn)
        if outbound_flow_arn is not None:
            pulumi.set(__self__, "outbound_flow_arn", outbound_flow_arn)

    @property
    @pulumi.getter(name="outboundCallerIdName")
    def outbound_caller_id_name(self) -> Optional[builtins.str]:
        """
        The caller ID name.
        """
        return pulumi.get(self, "outbound_caller_id_name")

    @property
    @pulumi.getter(name="outboundCallerIdNumberArn")
    def outbound_caller_id_number_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the outbound caller ID number.

        > Only use the phone number ARN format that doesn't contain `instance` in the path, for example, `arn:aws:connect:us-east-1:1234567890:phone-number/uuid` . This is the same ARN format that is returned when you create a phone number using CloudFormation , or when you call the [ListPhoneNumbersV2](https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html) API.
        """
        return pulumi.get(self, "outbound_caller_id_number_arn")

    @property
    @pulumi.getter(name="outboundFlowArn")
    def outbound_flow_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the outbound flow.
        """
        return pulumi.get(self, "outbound_flow_arn")


@pulumi.output_type
class QueueOutboundEmailConfig(dict):
    """
    The outbound email address ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outboundEmailAddressId":
            suggest = "outbound_email_address_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueOutboundEmailConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueOutboundEmailConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueOutboundEmailConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 outbound_email_address_id: Optional[builtins.str] = None):
        """
        The outbound email address ID.
        :param builtins.str outbound_email_address_id: The identifier of the email address.
        """
        if outbound_email_address_id is not None:
            pulumi.set(__self__, "outbound_email_address_id", outbound_email_address_id)

    @property
    @pulumi.getter(name="outboundEmailAddressId")
    def outbound_email_address_id(self) -> Optional[builtins.str]:
        """
        The identifier of the email address.
        """
        return pulumi.get(self, "outbound_email_address_id")


@pulumi.output_type
class QuickConnectConfig(dict):
    """
    Configuration settings for the quick connect.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quickConnectType":
            suggest = "quick_connect_type"
        elif key == "phoneConfig":
            suggest = "phone_config"
        elif key == "queueConfig":
            suggest = "queue_config"
        elif key == "userConfig":
            suggest = "user_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quick_connect_type: 'QuickConnectType',
                 phone_config: Optional['outputs.QuickConnectPhoneNumberQuickConnectConfig'] = None,
                 queue_config: Optional['outputs.QuickConnectQueueQuickConnectConfig'] = None,
                 user_config: Optional['outputs.QuickConnectUserQuickConnectConfig'] = None):
        """
        Configuration settings for the quick connect.
        :param 'QuickConnectType' quick_connect_type: The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
        :param 'QuickConnectPhoneNumberQuickConnectConfig' phone_config: The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
        :param 'QuickConnectQueueQuickConnectConfig' queue_config: The queue configuration. This is required only if QuickConnectType is QUEUE.
        :param 'QuickConnectUserQuickConnectConfig' user_config: The user configuration. This is required only if QuickConnectType is USER.
        """
        pulumi.set(__self__, "quick_connect_type", quick_connect_type)
        if phone_config is not None:
            pulumi.set(__self__, "phone_config", phone_config)
        if queue_config is not None:
            pulumi.set(__self__, "queue_config", queue_config)
        if user_config is not None:
            pulumi.set(__self__, "user_config", user_config)

    @property
    @pulumi.getter(name="quickConnectType")
    def quick_connect_type(self) -> 'QuickConnectType':
        """
        The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
        """
        return pulumi.get(self, "quick_connect_type")

    @property
    @pulumi.getter(name="phoneConfig")
    def phone_config(self) -> Optional['outputs.QuickConnectPhoneNumberQuickConnectConfig']:
        """
        The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
        """
        return pulumi.get(self, "phone_config")

    @property
    @pulumi.getter(name="queueConfig")
    def queue_config(self) -> Optional['outputs.QuickConnectQueueQuickConnectConfig']:
        """
        The queue configuration. This is required only if QuickConnectType is QUEUE.
        """
        return pulumi.get(self, "queue_config")

    @property
    @pulumi.getter(name="userConfig")
    def user_config(self) -> Optional['outputs.QuickConnectUserQuickConnectConfig']:
        """
        The user configuration. This is required only if QuickConnectType is USER.
        """
        return pulumi.get(self, "user_config")


@pulumi.output_type
class QuickConnectPhoneNumberQuickConnectConfig(dict):
    """
    The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectPhoneNumberQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectPhoneNumberQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectPhoneNumberQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_number: builtins.str):
        """
        The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
        :param builtins.str phone_number: The phone number in E.164 format.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        The phone number in E.164 format.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class QuickConnectQueueQuickConnectConfig(dict):
    """
    The queue configuration. This is required only if QuickConnectType is QUEUE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowArn":
            suggest = "contact_flow_arn"
        elif key == "queueArn":
            suggest = "queue_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectQueueQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectQueueQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectQueueQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_arn: builtins.str,
                 queue_arn: builtins.str):
        """
        The queue configuration. This is required only if QuickConnectType is QUEUE.
        :param builtins.str contact_flow_arn: The Amazon Resource Name (ARN) of the flow.
        :param builtins.str queue_arn: The Amazon Resource Name (ARN) of the queue.
        """
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        pulumi.set(__self__, "queue_arn", queue_arn)

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the flow.
        """
        return pulumi.get(self, "contact_flow_arn")

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the queue.
        """
        return pulumi.get(self, "queue_arn")


@pulumi.output_type
class QuickConnectUserQuickConnectConfig(dict):
    """
    The user configuration. This is required only if QuickConnectType is USER.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowArn":
            suggest = "contact_flow_arn"
        elif key == "userArn":
            suggest = "user_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuickConnectUserQuickConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuickConnectUserQuickConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuickConnectUserQuickConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_arn: builtins.str,
                 user_arn: builtins.str):
        """
        The user configuration. This is required only if QuickConnectType is USER.
        :param builtins.str contact_flow_arn: The Amazon Resource Name (ARN) of the flow.
        :param builtins.str user_arn: The Amazon Resource Name (ARN) of the user.
        """
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        pulumi.set(__self__, "user_arn", user_arn)

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the flow.
        """
        return pulumi.get(self, "contact_flow_arn")

    @property
    @pulumi.getter(name="userArn")
    def user_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the user.
        """
        return pulumi.get(self, "user_arn")


@pulumi.output_type
class RoutingProfileCrossChannelBehavior(dict):
    """
    Defines the cross-channel routing behavior that allows an agent working on a contact in one channel to be offered a contact from a different channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "behaviorType":
            suggest = "behavior_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingProfileCrossChannelBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingProfileCrossChannelBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingProfileCrossChannelBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 behavior_type: 'RoutingProfileBehaviorType'):
        """
        Defines the cross-channel routing behavior that allows an agent working on a contact in one channel to be offered a contact from a different channel.
        :param 'RoutingProfileBehaviorType' behavior_type: Specifies the other channels that can be routed to an agent handling their current channel.
        """
        pulumi.set(__self__, "behavior_type", behavior_type)

    @property
    @pulumi.getter(name="behaviorType")
    def behavior_type(self) -> 'RoutingProfileBehaviorType':
        """
        Specifies the other channels that can be routed to an agent handling their current channel.
        """
        return pulumi.get(self, "behavior_type")


@pulumi.output_type
class RoutingProfileMediaConcurrency(dict):
    """
    Contains information about which channels are supported, and how many contacts an agent can have on a channel simultaneously.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossChannelBehavior":
            suggest = "cross_channel_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingProfileMediaConcurrency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingProfileMediaConcurrency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingProfileMediaConcurrency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel: 'RoutingProfileChannel',
                 concurrency: builtins.int,
                 cross_channel_behavior: Optional['outputs.RoutingProfileCrossChannelBehavior'] = None):
        """
        Contains information about which channels are supported, and how many contacts an agent can have on a channel simultaneously.
        :param 'RoutingProfileChannel' channel: The channels that agents can handle in the Contact Control Panel (CCP).
        :param builtins.int concurrency: The number of contacts an agent can have on a channel simultaneously.
               
               Valid Range for `VOICE` : Minimum value of 1. Maximum value of 1.
               
               Valid Range for `CHAT` : Minimum value of 1. Maximum value of 10.
               
               Valid Range for `TASK` : Minimum value of 1. Maximum value of 10.
        :param 'RoutingProfileCrossChannelBehavior' cross_channel_behavior: Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "concurrency", concurrency)
        if cross_channel_behavior is not None:
            pulumi.set(__self__, "cross_channel_behavior", cross_channel_behavior)

    @property
    @pulumi.getter
    def channel(self) -> 'RoutingProfileChannel':
        """
        The channels that agents can handle in the Contact Control Panel (CCP).
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def concurrency(self) -> builtins.int:
        """
        The number of contacts an agent can have on a channel simultaneously.

        Valid Range for `VOICE` : Minimum value of 1. Maximum value of 1.

        Valid Range for `CHAT` : Minimum value of 1. Maximum value of 10.

        Valid Range for `TASK` : Minimum value of 1. Maximum value of 10.
        """
        return pulumi.get(self, "concurrency")

    @property
    @pulumi.getter(name="crossChannelBehavior")
    def cross_channel_behavior(self) -> Optional['outputs.RoutingProfileCrossChannelBehavior']:
        """
        Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.
        """
        return pulumi.get(self, "cross_channel_behavior")


@pulumi.output_type
class RoutingProfileQueueConfig(dict):
    """
    Contains information about the queue and channel for which priority and delay can be set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueReference":
            suggest = "queue_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingProfileQueueConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingProfileQueueConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingProfileQueueConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay: builtins.int,
                 priority: builtins.int,
                 queue_reference: 'outputs.RoutingProfileQueueReference'):
        """
        Contains information about the queue and channel for which priority and delay can be set.
        :param builtins.int delay: The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide* .
        :param builtins.int priority: The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) .
        :param 'RoutingProfileQueueReference' queue_reference: Contains information about a queue resource.
        """
        pulumi.set(__self__, "delay", delay)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "queue_reference", queue_reference)

    @property
    @pulumi.getter
    def delay(self) -> builtins.int:
        """
        The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) in the *Amazon Connect Administrator Guide* .
        """
        return pulumi.get(self, "delay")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        The order in which contacts are to be handled for the queue. For more information, see [Queues: priority and delay](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html) .
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="queueReference")
    def queue_reference(self) -> 'outputs.RoutingProfileQueueReference':
        """
        Contains information about a queue resource.
        """
        return pulumi.get(self, "queue_reference")


@pulumi.output_type
class RoutingProfileQueueReference(dict):
    """
    Contains the channel and queue identifier for a routing profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueArn":
            suggest = "queue_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingProfileQueueReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingProfileQueueReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingProfileQueueReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel: 'RoutingProfileChannel',
                 queue_arn: builtins.str):
        """
        Contains the channel and queue identifier for a routing profile.
        :param 'RoutingProfileChannel' channel: The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
        :param builtins.str queue_arn: The Amazon Resource Name (ARN) of the queue.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "queue_arn", queue_arn)

    @property
    @pulumi.getter
    def channel(self) -> 'RoutingProfileChannel':
        """
        The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the queue.
        """
        return pulumi.get(self, "queue_arn")


@pulumi.output_type
class RuleActions(dict):
    """
    A list of actions to be run when the rule is triggered.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignContactCategoryActions":
            suggest = "assign_contact_category_actions"
        elif key == "createCaseActions":
            suggest = "create_case_actions"
        elif key == "endAssociatedTasksActions":
            suggest = "end_associated_tasks_actions"
        elif key == "eventBridgeActions":
            suggest = "event_bridge_actions"
        elif key == "sendNotificationActions":
            suggest = "send_notification_actions"
        elif key == "submitAutoEvaluationActions":
            suggest = "submit_auto_evaluation_actions"
        elif key == "taskActions":
            suggest = "task_actions"
        elif key == "updateCaseActions":
            suggest = "update_case_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assign_contact_category_actions: Optional[Sequence['outputs.RuleAssignContactCategoryAction']] = None,
                 create_case_actions: Optional[Sequence['outputs.RuleCreateCaseAction']] = None,
                 end_associated_tasks_actions: Optional[Sequence['outputs.RuleEndAssociatedTasksAction']] = None,
                 event_bridge_actions: Optional[Sequence['outputs.RuleEventBridgeAction']] = None,
                 send_notification_actions: Optional[Sequence['outputs.RuleSendNotificationAction']] = None,
                 submit_auto_evaluation_actions: Optional[Sequence['outputs.RuleSubmitAutoEvaluationAction']] = None,
                 task_actions: Optional[Sequence['outputs.RuleTaskAction']] = None,
                 update_case_actions: Optional[Sequence['outputs.RuleUpdateCaseAction']] = None):
        """
        A list of actions to be run when the rule is triggered.
        :param Sequence['RuleAssignContactCategoryAction'] assign_contact_category_actions: Information about the contact category action. The syntax can be empty, for example, ``{}``.
        :param Sequence['RuleEventBridgeAction'] event_bridge_actions: Information about the EV action.
        :param Sequence['RuleSendNotificationAction'] send_notification_actions: Information about the send notification action.
        :param Sequence['RuleTaskAction'] task_actions: Information about the task action. This field is required if ``TriggerEventSource`` is one of the following values: ``OnZendeskTicketCreate`` | ``OnZendeskTicketStatusUpdate`` | ``OnSalesforceCaseCreate``
        """
        if assign_contact_category_actions is not None:
            pulumi.set(__self__, "assign_contact_category_actions", assign_contact_category_actions)
        if create_case_actions is not None:
            pulumi.set(__self__, "create_case_actions", create_case_actions)
        if end_associated_tasks_actions is not None:
            pulumi.set(__self__, "end_associated_tasks_actions", end_associated_tasks_actions)
        if event_bridge_actions is not None:
            pulumi.set(__self__, "event_bridge_actions", event_bridge_actions)
        if send_notification_actions is not None:
            pulumi.set(__self__, "send_notification_actions", send_notification_actions)
        if submit_auto_evaluation_actions is not None:
            pulumi.set(__self__, "submit_auto_evaluation_actions", submit_auto_evaluation_actions)
        if task_actions is not None:
            pulumi.set(__self__, "task_actions", task_actions)
        if update_case_actions is not None:
            pulumi.set(__self__, "update_case_actions", update_case_actions)

    @property
    @pulumi.getter(name="assignContactCategoryActions")
    def assign_contact_category_actions(self) -> Optional[Sequence['outputs.RuleAssignContactCategoryAction']]:
        """
        Information about the contact category action. The syntax can be empty, for example, ``{}``.
        """
        return pulumi.get(self, "assign_contact_category_actions")

    @property
    @pulumi.getter(name="createCaseActions")
    def create_case_actions(self) -> Optional[Sequence['outputs.RuleCreateCaseAction']]:
        return pulumi.get(self, "create_case_actions")

    @property
    @pulumi.getter(name="endAssociatedTasksActions")
    def end_associated_tasks_actions(self) -> Optional[Sequence['outputs.RuleEndAssociatedTasksAction']]:
        return pulumi.get(self, "end_associated_tasks_actions")

    @property
    @pulumi.getter(name="eventBridgeActions")
    def event_bridge_actions(self) -> Optional[Sequence['outputs.RuleEventBridgeAction']]:
        """
        Information about the EV action.
        """
        return pulumi.get(self, "event_bridge_actions")

    @property
    @pulumi.getter(name="sendNotificationActions")
    def send_notification_actions(self) -> Optional[Sequence['outputs.RuleSendNotificationAction']]:
        """
        Information about the send notification action.
        """
        return pulumi.get(self, "send_notification_actions")

    @property
    @pulumi.getter(name="submitAutoEvaluationActions")
    def submit_auto_evaluation_actions(self) -> Optional[Sequence['outputs.RuleSubmitAutoEvaluationAction']]:
        return pulumi.get(self, "submit_auto_evaluation_actions")

    @property
    @pulumi.getter(name="taskActions")
    def task_actions(self) -> Optional[Sequence['outputs.RuleTaskAction']]:
        """
        Information about the task action. This field is required if ``TriggerEventSource`` is one of the following values: ``OnZendeskTicketCreate`` | ``OnZendeskTicketStatusUpdate`` | ``OnSalesforceCaseCreate``
        """
        return pulumi.get(self, "task_actions")

    @property
    @pulumi.getter(name="updateCaseActions")
    def update_case_actions(self) -> Optional[Sequence['outputs.RuleUpdateCaseAction']]:
        return pulumi.get(self, "update_case_actions")


@pulumi.output_type
class RuleAssignContactCategoryAction(dict):
    """
    The definition for assigning contact category action.
    """
    def __init__(__self__):
        """
        The definition for assigning contact category action.
        """
        pass


@pulumi.output_type
class RuleCreateCaseAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateId":
            suggest = "template_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleCreateCaseAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleCreateCaseAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleCreateCaseAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fields: Sequence['outputs.RuleField'],
                 template_id: builtins.str):
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.RuleField']:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> builtins.str:
        return pulumi.get(self, "template_id")


@pulumi.output_type
class RuleEndAssociatedTasksAction(dict):
    """
    The definition for ending associated task action.
    """
    def __init__(__self__):
        """
        The definition for ending associated task action.
        """
        pass


@pulumi.output_type
class RuleEventBridgeAction(dict):
    """
    The EV action definition.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        The EV action definition.
        :param builtins.str name: The name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RuleField(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 value: 'outputs.RuleFieldValue'):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def value(self) -> 'outputs.RuleFieldValue':
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleFieldValue(dict):
    """
    Object for case field values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "emptyValue":
            suggest = "empty_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleFieldValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleFieldValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleFieldValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: Optional[builtins.bool] = None,
                 double_value: Optional[builtins.float] = None,
                 empty_value: Optional[Any] = None,
                 string_value: Optional[builtins.str] = None):
        """
        Object for case field values.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if empty_value is not None:
            pulumi.set(__self__, "empty_value", empty_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[builtins.float]:
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="emptyValue")
    def empty_value(self) -> Optional[Any]:
        return pulumi.get(self, "empty_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "string_value")


@pulumi.output_type
class RuleNotificationRecipientType(dict):
    """
    The type of notification recipient.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userArns":
            suggest = "user_arns"
        elif key == "userTags":
            suggest = "user_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleNotificationRecipientType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleNotificationRecipientType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleNotificationRecipientType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_arns: Optional[Sequence[builtins.str]] = None,
                 user_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        The type of notification recipient.
        :param Sequence[builtins.str] user_arns: The Amazon Resource Name (ARN) of the user account.
        :param Mapping[str, builtins.str] user_tags: The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }. CON users with the specified tags will be notified.
        """
        if user_arns is not None:
            pulumi.set(__self__, "user_arns", user_arns)
        if user_tags is not None:
            pulumi.set(__self__, "user_tags", user_tags)

    @property
    @pulumi.getter(name="userArns")
    def user_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the user account.
        """
        return pulumi.get(self, "user_arns")

    @property
    @pulumi.getter(name="userTags")
    def user_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }. CON users with the specified tags will be notified.
        """
        return pulumi.get(self, "user_tags")


@pulumi.output_type
class RuleReference(dict):
    """
    Information about the reference when the ``referenceType`` is ``URL``. Otherwise, null. (Supports variable injection in the ``Value`` field.)
    """
    def __init__(__self__, *,
                 type: 'RuleReferenceType',
                 value: builtins.str):
        """
        Information about the reference when the ``referenceType`` is ``URL``. Otherwise, null. (Supports variable injection in the ``Value`` field.)
        :param 'RuleReferenceType' type: The type of the reference. ``DATE`` must be of type Epoch timestamp. 
                 *Allowed values*: ``URL`` | ``ATTACHMENT`` | ``NUMBER`` | ``STRING`` | ``DATE`` | ``EMAIL``
        :param builtins.str value: A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed to an agent in the Contact Control Panel (CCP).
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> 'RuleReferenceType':
        """
        The type of the reference. ``DATE`` must be of type Epoch timestamp. 
          *Allowed values*: ``URL`` | ``ATTACHMENT`` | ``NUMBER`` | ``STRING`` | ``DATE`` | ``EMAIL``
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed to an agent in the Contact Control Panel (CCP).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleSendNotificationAction(dict):
    """
    Information about the send notification action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "deliveryMethod":
            suggest = "delivery_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSendNotificationAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSendNotificationAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSendNotificationAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 content_type: 'RuleSendNotificationActionContentType',
                 delivery_method: 'RuleSendNotificationActionDeliveryMethod',
                 recipient: 'outputs.RuleNotificationRecipientType',
                 subject: Optional[builtins.str] = None):
        """
        Information about the send notification action.
        :param builtins.str content: Notification content. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        :param 'RuleSendNotificationActionContentType' content_type: Content type format.
                 *Allowed value*: ``PLAIN_TEXT``
        :param 'RuleSendNotificationActionDeliveryMethod' delivery_method: Notification delivery method.
                 *Allowed value*: ``EMAIL``
        :param 'RuleNotificationRecipientType' recipient: Notification recipient.
        :param builtins.str subject: The subject of the email if the delivery method is ``EMAIL``. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "delivery_method", delivery_method)
        pulumi.set(__self__, "recipient", recipient)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        Notification content. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> 'RuleSendNotificationActionContentType':
        """
        Content type format.
          *Allowed value*: ``PLAIN_TEXT``
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="deliveryMethod")
    def delivery_method(self) -> 'RuleSendNotificationActionDeliveryMethod':
        """
        Notification delivery method.
          *Allowed value*: ``EMAIL``
        """
        return pulumi.get(self, "delivery_method")

    @property
    @pulumi.getter
    def recipient(self) -> 'outputs.RuleNotificationRecipientType':
        """
        Notification recipient.
        """
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the email if the delivery method is ``EMAIL``. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class RuleSubmitAutoEvaluationAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationFormArn":
            suggest = "evaluation_form_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSubmitAutoEvaluationAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSubmitAutoEvaluationAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSubmitAutoEvaluationAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_form_arn: builtins.str):
        pulumi.set(__self__, "evaluation_form_arn", evaluation_form_arn)

    @property
    @pulumi.getter(name="evaluationFormArn")
    def evaluation_form_arn(self) -> builtins.str:
        return pulumi.get(self, "evaluation_form_arn")


@pulumi.output_type
class RuleTaskAction(dict):
    """
    Information about the task action. This field is required if ``TriggerEventSource`` is one of the following values: ``OnZendeskTicketCreate`` | ``OnZendeskTicketStatusUpdate`` | ``OnSalesforceCaseCreate``
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactFlowArn":
            suggest = "contact_flow_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTaskAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTaskAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTaskAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_flow_arn: builtins.str,
                 name: builtins.str,
                 description: Optional[builtins.str] = None,
                 references: Optional[Mapping[str, 'outputs.RuleReference']] = None):
        """
        Information about the task action. This field is required if ``TriggerEventSource`` is one of the following values: ``OnZendeskTicketCreate`` | ``OnZendeskTicketStatusUpdate`` | ``OnSalesforceCaseCreate``
        :param builtins.str contact_flow_arn: The Amazon Resource Name (ARN) of the flow.
        :param builtins.str name: The name. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        :param builtins.str description: The description. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        :param Mapping[str, 'RuleReference'] references: Information about the reference when the ``referenceType`` is ``URL``. Otherwise, null. ``URL`` is the only accepted type. (Supports variable injection in the ``Value`` field.)
        """
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if references is not None:
            pulumi.set(__self__, "references", references)

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the flow.
        """
        return pulumi.get(self, "contact_flow_arn")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description. Supports variable injection. For more information, see [JSONPath reference](https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html) in the *Administrators Guide*.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def references(self) -> Optional[Mapping[str, 'outputs.RuleReference']]:
        """
        Information about the reference when the ``referenceType`` is ``URL``. Otherwise, null. ``URL`` is the only accepted type. (Supports variable injection in the ``Value`` field.)
        """
        return pulumi.get(self, "references")


@pulumi.output_type
class RuleTriggerEventSource(dict):
    """
    The name of the event source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventSourceName":
            suggest = "event_source_name"
        elif key == "integrationAssociationArn":
            suggest = "integration_association_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTriggerEventSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTriggerEventSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTriggerEventSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_source_name: 'RuleTriggerEventSourceEventSourceName',
                 integration_association_arn: Optional[builtins.str] = None):
        """
        The name of the event source.
        :param 'RuleTriggerEventSourceEventSourceName' event_source_name: The name of the event source.
        :param builtins.str integration_association_arn: The Amazon Resource Name (ARN) of the integration association. ``IntegrationAssociationArn`` is required if ``TriggerEventSource`` is one of the following values: ``OnZendeskTicketCreate`` | ``OnZendeskTicketStatusUpdate`` | ``OnSalesforceCaseCreate``
        """
        pulumi.set(__self__, "event_source_name", event_source_name)
        if integration_association_arn is not None:
            pulumi.set(__self__, "integration_association_arn", integration_association_arn)

    @property
    @pulumi.getter(name="eventSourceName")
    def event_source_name(self) -> 'RuleTriggerEventSourceEventSourceName':
        """
        The name of the event source.
        """
        return pulumi.get(self, "event_source_name")

    @property
    @pulumi.getter(name="integrationAssociationArn")
    def integration_association_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the integration association. ``IntegrationAssociationArn`` is required if ``TriggerEventSource`` is one of the following values: ``OnZendeskTicketCreate`` | ``OnZendeskTicketStatusUpdate`` | ``OnSalesforceCaseCreate``
        """
        return pulumi.get(self, "integration_association_arn")


@pulumi.output_type
class RuleUpdateCaseAction(dict):
    def __init__(__self__, *,
                 fields: Sequence['outputs.RuleField']):
        pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.RuleField']:
        return pulumi.get(self, "fields")


@pulumi.output_type
class SecurityProfileApplication(dict):
    """
    A third-party application's metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationPermissions":
            suggest = "application_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProfileApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProfileApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProfileApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_permissions: Sequence[builtins.str],
                 namespace: builtins.str):
        """
        A third-party application's metadata.
        :param Sequence[builtins.str] application_permissions: The permissions that the agent is granted on the application
        :param builtins.str namespace: Namespace of the application that you want to give access to.
        """
        pulumi.set(__self__, "application_permissions", application_permissions)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="applicationPermissions")
    def application_permissions(self) -> Sequence[builtins.str]:
        """
        The permissions that the agent is granted on the application
        """
        return pulumi.get(self, "application_permissions")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Namespace of the application that you want to give access to.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class SecurityProfileTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        A key-value pair to associate with a resource.
        :param builtins.str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param builtins.str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskTemplateDefaultFieldValue(dict):
    """
    the default value for the task template's field
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskTemplateDefaultFieldValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskTemplateDefaultFieldValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskTemplateDefaultFieldValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: builtins.str,
                 id: 'outputs.TaskTemplateFieldIdentifier'):
        """
        the default value for the task template's field
        :param builtins.str default_value: Default value for the field.
        :param 'TaskTemplateFieldIdentifier' id: Identifier of a field.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> builtins.str:
        """
        Default value for the field.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def id(self) -> 'outputs.TaskTemplateFieldIdentifier':
        """
        Identifier of a field.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class TaskTemplateField(dict):
    """
    A task template field object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "singleSelectOptions":
            suggest = "single_select_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskTemplateField. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskTemplateField.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskTemplateField.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: 'outputs.TaskTemplateFieldIdentifier',
                 type: 'TaskTemplateFieldType',
                 description: Optional[builtins.str] = None,
                 single_select_options: Optional[Sequence[builtins.str]] = None):
        """
        A task template field object.
        :param 'TaskTemplateFieldIdentifier' id: The unique identifier for the field.
        :param 'TaskTemplateFieldType' type: Indicates the type of field. Following are the valid field types: `NAME` `DESCRIPTION` | `SCHEDULED_TIME` | `QUICK_CONNECT` | `URL` | `NUMBER` | `TEXT` | `TEXT_AREA` | `DATE_TIME` | `BOOLEAN` | `SINGLE_SELECT` | `EMAIL`
        :param builtins.str description: The description of the task template's field
        :param Sequence[builtins.str] single_select_options: list of field options to be used with single select
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if single_select_options is not None:
            pulumi.set(__self__, "single_select_options", single_select_options)

    @property
    @pulumi.getter
    def id(self) -> 'outputs.TaskTemplateFieldIdentifier':
        """
        The unique identifier for the field.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> 'TaskTemplateFieldType':
        """
        Indicates the type of field. Following are the valid field types: `NAME` `DESCRIPTION` | `SCHEDULED_TIME` | `QUICK_CONNECT` | `URL` | `NUMBER` | `TEXT` | `TEXT_AREA` | `DATE_TIME` | `BOOLEAN` | `SINGLE_SELECT` | `EMAIL`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the task template's field
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="singleSelectOptions")
    def single_select_options(self) -> Optional[Sequence[builtins.str]]:
        """
        list of field options to be used with single select
        """
        return pulumi.get(self, "single_select_options")


@pulumi.output_type
class TaskTemplateFieldIdentifier(dict):
    """
    the identifier (name) for the task template field
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        the identifier (name) for the task template field
        :param builtins.str name: The name of the task template field
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the task template field
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TaskTemplateInvisibleFieldInfo(dict):
    """
    Invisible field info
    """
    def __init__(__self__, *,
                 id: 'outputs.TaskTemplateFieldIdentifier'):
        """
        Invisible field info
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> 'outputs.TaskTemplateFieldIdentifier':
        return pulumi.get(self, "id")


@pulumi.output_type
class TaskTemplateReadOnlyFieldInfo(dict):
    """
    ReadOnly field info
    """
    def __init__(__self__, *,
                 id: 'outputs.TaskTemplateFieldIdentifier'):
        """
        ReadOnly field info
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> 'outputs.TaskTemplateFieldIdentifier':
        return pulumi.get(self, "id")


@pulumi.output_type
class TaskTemplateRequiredFieldInfo(dict):
    """
    Required field info
    """
    def __init__(__self__, *,
                 id: 'outputs.TaskTemplateFieldIdentifier'):
        """
        Required field info
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> 'outputs.TaskTemplateFieldIdentifier':
        return pulumi.get(self, "id")


@pulumi.output_type
class UserHierarchyStructureLevelFive(dict):
    """
    Information about level five.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hierarchyLevelArn":
            suggest = "hierarchy_level_arn"
        elif key == "hierarchyLevelId":
            suggest = "hierarchy_level_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserHierarchyStructureLevelFive. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserHierarchyStructureLevelFive.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserHierarchyStructureLevelFive.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 hierarchy_level_arn: Optional[builtins.str] = None,
                 hierarchy_level_id: Optional[builtins.str] = None):
        """
        Information about level five.
        :param builtins.str name: The name of the hierarchy level.
        :param builtins.str hierarchy_level_arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param builtins.str hierarchy_level_id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if hierarchy_level_arn is not None:
            pulumi.set(__self__, "hierarchy_level_arn", hierarchy_level_arn)
        if hierarchy_level_id is not None:
            pulumi.set(__self__, "hierarchy_level_id", hierarchy_level_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the hierarchy level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="hierarchyLevelArn")
    def hierarchy_level_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_arn")

    @property
    @pulumi.getter(name="hierarchyLevelId")
    def hierarchy_level_id(self) -> Optional[builtins.str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_id")


@pulumi.output_type
class UserHierarchyStructureLevelFour(dict):
    """
    Information about level four.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hierarchyLevelArn":
            suggest = "hierarchy_level_arn"
        elif key == "hierarchyLevelId":
            suggest = "hierarchy_level_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserHierarchyStructureLevelFour. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserHierarchyStructureLevelFour.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserHierarchyStructureLevelFour.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 hierarchy_level_arn: Optional[builtins.str] = None,
                 hierarchy_level_id: Optional[builtins.str] = None):
        """
        Information about level four.
        :param builtins.str name: The name of the hierarchy level.
        :param builtins.str hierarchy_level_arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param builtins.str hierarchy_level_id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if hierarchy_level_arn is not None:
            pulumi.set(__self__, "hierarchy_level_arn", hierarchy_level_arn)
        if hierarchy_level_id is not None:
            pulumi.set(__self__, "hierarchy_level_id", hierarchy_level_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the hierarchy level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="hierarchyLevelArn")
    def hierarchy_level_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_arn")

    @property
    @pulumi.getter(name="hierarchyLevelId")
    def hierarchy_level_id(self) -> Optional[builtins.str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_id")


@pulumi.output_type
class UserHierarchyStructureLevelOne(dict):
    """
    Information about level one.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hierarchyLevelArn":
            suggest = "hierarchy_level_arn"
        elif key == "hierarchyLevelId":
            suggest = "hierarchy_level_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserHierarchyStructureLevelOne. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserHierarchyStructureLevelOne.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserHierarchyStructureLevelOne.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 hierarchy_level_arn: Optional[builtins.str] = None,
                 hierarchy_level_id: Optional[builtins.str] = None):
        """
        Information about level one.
        :param builtins.str name: The name of the hierarchy level.
        :param builtins.str hierarchy_level_arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param builtins.str hierarchy_level_id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if hierarchy_level_arn is not None:
            pulumi.set(__self__, "hierarchy_level_arn", hierarchy_level_arn)
        if hierarchy_level_id is not None:
            pulumi.set(__self__, "hierarchy_level_id", hierarchy_level_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the hierarchy level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="hierarchyLevelArn")
    def hierarchy_level_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_arn")

    @property
    @pulumi.getter(name="hierarchyLevelId")
    def hierarchy_level_id(self) -> Optional[builtins.str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_id")


@pulumi.output_type
class UserHierarchyStructureLevelThree(dict):
    """
    Information about level three.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hierarchyLevelArn":
            suggest = "hierarchy_level_arn"
        elif key == "hierarchyLevelId":
            suggest = "hierarchy_level_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserHierarchyStructureLevelThree. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserHierarchyStructureLevelThree.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserHierarchyStructureLevelThree.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 hierarchy_level_arn: Optional[builtins.str] = None,
                 hierarchy_level_id: Optional[builtins.str] = None):
        """
        Information about level three.
        :param builtins.str name: The name of the hierarchy level.
        :param builtins.str hierarchy_level_arn: The Amazon Resource Name (ARN) of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if hierarchy_level_arn is not None:
            pulumi.set(__self__, "hierarchy_level_arn", hierarchy_level_arn)
        if hierarchy_level_id is not None:
            pulumi.set(__self__, "hierarchy_level_id", hierarchy_level_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the hierarchy level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="hierarchyLevelArn")
    def hierarchy_level_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_arn")

    @property
    @pulumi.getter(name="hierarchyLevelId")
    def hierarchy_level_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "hierarchy_level_id")


@pulumi.output_type
class UserHierarchyStructureLevelTwo(dict):
    """
    Information about level two.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hierarchyLevelArn":
            suggest = "hierarchy_level_arn"
        elif key == "hierarchyLevelId":
            suggest = "hierarchy_level_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserHierarchyStructureLevelTwo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserHierarchyStructureLevelTwo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserHierarchyStructureLevelTwo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 hierarchy_level_arn: Optional[builtins.str] = None,
                 hierarchy_level_id: Optional[builtins.str] = None):
        """
        Information about level two.
        :param builtins.str name: The name of the hierarchy level.
        :param builtins.str hierarchy_level_arn: The Amazon Resource Name (ARN) of the hierarchy level.
        :param builtins.str hierarchy_level_id: The identifier of the hierarchy level.
        """
        pulumi.set(__self__, "name", name)
        if hierarchy_level_arn is not None:
            pulumi.set(__self__, "hierarchy_level_arn", hierarchy_level_arn)
        if hierarchy_level_id is not None:
            pulumi.set(__self__, "hierarchy_level_id", hierarchy_level_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the hierarchy level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="hierarchyLevelArn")
    def hierarchy_level_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_arn")

    @property
    @pulumi.getter(name="hierarchyLevelId")
    def hierarchy_level_id(self) -> Optional[builtins.str]:
        """
        The identifier of the hierarchy level.
        """
        return pulumi.get(self, "hierarchy_level_id")


@pulumi.output_type
class UserHierarchyStructureProperties(dict):
    """
    Information about the hierarchy structure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "levelFive":
            suggest = "level_five"
        elif key == "levelFour":
            suggest = "level_four"
        elif key == "levelOne":
            suggest = "level_one"
        elif key == "levelThree":
            suggest = "level_three"
        elif key == "levelTwo":
            suggest = "level_two"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserHierarchyStructureProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserHierarchyStructureProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserHierarchyStructureProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 level_five: Optional['outputs.UserHierarchyStructureLevelFive'] = None,
                 level_four: Optional['outputs.UserHierarchyStructureLevelFour'] = None,
                 level_one: Optional['outputs.UserHierarchyStructureLevelOne'] = None,
                 level_three: Optional['outputs.UserHierarchyStructureLevelThree'] = None,
                 level_two: Optional['outputs.UserHierarchyStructureLevelTwo'] = None):
        """
        Information about the hierarchy structure.
        :param 'UserHierarchyStructureLevelFour' level_four: The update for level four.
        :param 'UserHierarchyStructureLevelOne' level_one: The update for level one.
        :param 'UserHierarchyStructureLevelThree' level_three: The update for level three.
        :param 'UserHierarchyStructureLevelTwo' level_two: The update for level two.
        """
        if level_five is not None:
            pulumi.set(__self__, "level_five", level_five)
        if level_four is not None:
            pulumi.set(__self__, "level_four", level_four)
        if level_one is not None:
            pulumi.set(__self__, "level_one", level_one)
        if level_three is not None:
            pulumi.set(__self__, "level_three", level_three)
        if level_two is not None:
            pulumi.set(__self__, "level_two", level_two)

    @property
    @pulumi.getter(name="levelFive")
    def level_five(self) -> Optional['outputs.UserHierarchyStructureLevelFive']:
        return pulumi.get(self, "level_five")

    @property
    @pulumi.getter(name="levelFour")
    def level_four(self) -> Optional['outputs.UserHierarchyStructureLevelFour']:
        """
        The update for level four.
        """
        return pulumi.get(self, "level_four")

    @property
    @pulumi.getter(name="levelOne")
    def level_one(self) -> Optional['outputs.UserHierarchyStructureLevelOne']:
        """
        The update for level one.
        """
        return pulumi.get(self, "level_one")

    @property
    @pulumi.getter(name="levelThree")
    def level_three(self) -> Optional['outputs.UserHierarchyStructureLevelThree']:
        """
        The update for level three.
        """
        return pulumi.get(self, "level_three")

    @property
    @pulumi.getter(name="levelTwo")
    def level_two(self) -> Optional['outputs.UserHierarchyStructureLevelTwo']:
        """
        The update for level two.
        """
        return pulumi.get(self, "level_two")


@pulumi.output_type
class UserIdentityInfo(dict):
    """
    Contains information about the identity of a user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "secondaryEmail":
            suggest = "secondary_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 mobile: Optional[builtins.str] = None,
                 secondary_email: Optional[builtins.str] = None):
        """
        Contains information about the identity of a user.
        :param builtins.str email: The email address. If you are using SAML for identity management and include this parameter, an error is returned.
        :param builtins.str first_name: The first name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
        :param builtins.str last_name: The last name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
        :param builtins.str mobile: The user's mobile number.
        :param builtins.str secondary_email: The user's secondary email address. If you provide a secondary email, the user receives email notifications -- other than password reset notifications -- to this email address instead of to their primary email address.
               
               *Pattern* : `(?=^.{0,265}$)[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,63}`
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if secondary_email is not None:
            pulumi.set(__self__, "secondary_email", secondary_email)

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        The email address. If you are using SAML for identity management and include this parameter, an error is returned.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        The first name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        The last name. This is required if you are using Amazon Connect or SAML for identity management. Inputs must be in Unicode Normalization Form C (NFC). Text containing characters in a non-NFC form (for example, decomposed characters or combining marks) are not accepted.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def mobile(self) -> Optional[builtins.str]:
        """
        The user's mobile number.
        """
        return pulumi.get(self, "mobile")

    @property
    @pulumi.getter(name="secondaryEmail")
    def secondary_email(self) -> Optional[builtins.str]:
        """
        The user's secondary email address. If you provide a secondary email, the user receives email notifications -- other than password reset notifications -- to this email address instead of to their primary email address.

        *Pattern* : `(?=^.{0,265}$)[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,63}`
        """
        return pulumi.get(self, "secondary_email")


@pulumi.output_type
class UserPhoneConfig(dict):
    """
    Contains information about the phone configuration settings for a user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneType":
            suggest = "phone_type"
        elif key == "afterContactWorkTimeLimit":
            suggest = "after_contact_work_time_limit"
        elif key == "autoAccept":
            suggest = "auto_accept"
        elif key == "deskPhoneNumber":
            suggest = "desk_phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPhoneConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPhoneConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPhoneConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 phone_type: 'UserPhoneType',
                 after_contact_work_time_limit: Optional[builtins.int] = None,
                 auto_accept: Optional[builtins.bool] = None,
                 desk_phone_number: Optional[builtins.str] = None):
        """
        Contains information about the phone configuration settings for a user.
        :param 'UserPhoneType' phone_type: The phone type.
        :param builtins.int after_contact_work_time_limit: The After Call Work (ACW) timeout setting, in seconds. This parameter has a minimum value of 0 and a maximum value of 2,000,000 seconds (24 days). Enter 0 if you don't want to allocate a specific amount of ACW time. It essentially means an indefinite amount of time. When the conversation ends, ACW starts; the agent must choose Close contact to end ACW.
               
               > When returned by a `SearchUsers` call, `AfterContactWorkTimeLimit` is returned in milliseconds.
        :param builtins.bool auto_accept: The Auto accept setting.
        :param builtins.str desk_phone_number: The phone number for the user's desk phone.
        """
        pulumi.set(__self__, "phone_type", phone_type)
        if after_contact_work_time_limit is not None:
            pulumi.set(__self__, "after_contact_work_time_limit", after_contact_work_time_limit)
        if auto_accept is not None:
            pulumi.set(__self__, "auto_accept", auto_accept)
        if desk_phone_number is not None:
            pulumi.set(__self__, "desk_phone_number", desk_phone_number)

    @property
    @pulumi.getter(name="phoneType")
    def phone_type(self) -> 'UserPhoneType':
        """
        The phone type.
        """
        return pulumi.get(self, "phone_type")

    @property
    @pulumi.getter(name="afterContactWorkTimeLimit")
    def after_contact_work_time_limit(self) -> Optional[builtins.int]:
        """
        The After Call Work (ACW) timeout setting, in seconds. This parameter has a minimum value of 0 and a maximum value of 2,000,000 seconds (24 days). Enter 0 if you don't want to allocate a specific amount of ACW time. It essentially means an indefinite amount of time. When the conversation ends, ACW starts; the agent must choose Close contact to end ACW.

        > When returned by a `SearchUsers` call, `AfterContactWorkTimeLimit` is returned in milliseconds.
        """
        return pulumi.get(self, "after_contact_work_time_limit")

    @property
    @pulumi.getter(name="autoAccept")
    def auto_accept(self) -> Optional[builtins.bool]:
        """
        The Auto accept setting.
        """
        return pulumi.get(self, "auto_accept")

    @property
    @pulumi.getter(name="deskPhoneNumber")
    def desk_phone_number(self) -> Optional[builtins.str]:
        """
        The phone number for the user's desk phone.
        """
        return pulumi.get(self, "desk_phone_number")


@pulumi.output_type
class UserProficiency(dict):
    """
    Proficiency of a user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "attributeValue":
            suggest = "attribute_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProficiency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProficiency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProficiency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: builtins.str,
                 attribute_value: builtins.str,
                 level: builtins.float):
        """
        Proficiency of a user.
        :param builtins.str attribute_name: The name of user’s proficiency. You must use a predefined attribute name that is present in the Amazon Connect instance.
        :param builtins.str attribute_value: The value of user’s proficiency. You must use a predefined attribute value that is present in the Amazon Connect instance.
        :param builtins.float level: The level of the proficiency. The valid values are 1, 2, 3, 4 and 5.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_value", attribute_value)
        pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> builtins.str:
        """
        The name of user’s proficiency. You must use a predefined attribute name that is present in the Amazon Connect instance.
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> builtins.str:
        """
        The value of user’s proficiency. You must use a predefined attribute value that is present in the Amazon Connect instance.
        """
        return pulumi.get(self, "attribute_value")

    @property
    @pulumi.getter
    def level(self) -> builtins.float:
        """
        The level of the proficiency. The valid values are 1, 2, 3, 4 and 5.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class ValuesProperties(dict):
    """
    The values of a predefined attribute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stringList":
            suggest = "string_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValuesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValuesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValuesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 string_list: Optional[Sequence[builtins.str]] = None):
        """
        The values of a predefined attribute.
        :param Sequence[builtins.str] string_list: Predefined attribute values of type string list.
        """
        if string_list is not None:
            pulumi.set(__self__, "string_list", string_list)

    @property
    @pulumi.getter(name="stringList")
    def string_list(self) -> Optional[Sequence[builtins.str]]:
        """
        Predefined attribute values of type string list.
        """
        return pulumi.get(self, "string_list")


