# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetUserHierarchyGroupResult',
    'AwaitableGetUserHierarchyGroupResult',
    'get_user_hierarchy_group',
    'get_user_hierarchy_group_output',
]

@pulumi.output_type
class GetUserHierarchyGroupResult:
    def __init__(__self__, instance_arn=None, name=None, tags=None, user_hierarchy_group_arn=None):
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user_hierarchy_group_arn and not isinstance(user_hierarchy_group_arn, str):
            raise TypeError("Expected argument 'user_hierarchy_group_arn' to be a str")
        pulumi.set(__self__, "user_hierarchy_group_arn", user_hierarchy_group_arn)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the user hierarchy group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userHierarchyGroupArn")
    def user_hierarchy_group_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the user hierarchy group.
        """
        return pulumi.get(self, "user_hierarchy_group_arn")


class AwaitableGetUserHierarchyGroupResult(GetUserHierarchyGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserHierarchyGroupResult(
            instance_arn=self.instance_arn,
            name=self.name,
            tags=self.tags,
            user_hierarchy_group_arn=self.user_hierarchy_group_arn)


def get_user_hierarchy_group(user_hierarchy_group_arn: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserHierarchyGroupResult:
    """
    Resource Type definition for AWS::Connect::UserHierarchyGroup


    :param builtins.str user_hierarchy_group_arn: The Amazon Resource Name (ARN) for the user hierarchy group.
    """
    __args__ = dict()
    __args__['userHierarchyGroupArn'] = user_hierarchy_group_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getUserHierarchyGroup', __args__, opts=opts, typ=GetUserHierarchyGroupResult).value

    return AwaitableGetUserHierarchyGroupResult(
        instance_arn=pulumi.get(__ret__, 'instance_arn'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'),
        user_hierarchy_group_arn=pulumi.get(__ret__, 'user_hierarchy_group_arn'))
def get_user_hierarchy_group_output(user_hierarchy_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserHierarchyGroupResult]:
    """
    Resource Type definition for AWS::Connect::UserHierarchyGroup


    :param builtins.str user_hierarchy_group_arn: The Amazon Resource Name (ARN) for the user hierarchy group.
    """
    __args__ = dict()
    __args__['userHierarchyGroupArn'] = user_hierarchy_group_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:connect:getUserHierarchyGroup', __args__, opts=opts, typ=GetUserHierarchyGroupResult)
    return __ret__.apply(lambda __response__: GetUserHierarchyGroupResult(
        instance_arn=pulumi.get(__response__, 'instance_arn'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags'),
        user_hierarchy_group_arn=pulumi.get(__response__, 'user_hierarchy_group_arn')))
