# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTrafficDistributionGroupResult',
    'AwaitableGetTrafficDistributionGroupResult',
    'get_traffic_distribution_group',
    'get_traffic_distribution_group_output',
]

@pulumi.output_type
class GetTrafficDistributionGroupResult:
    def __init__(__self__, instance_arn=None, is_default=None, status=None, tags=None, traffic_distribution_group_arn=None):
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if traffic_distribution_group_arn and not isinstance(traffic_distribution_group_arn, str):
            raise TypeError("Expected argument 'traffic_distribution_group_arn' to be a str")
        pulumi.set(__self__, "traffic_distribution_group_arn", traffic_distribution_group_arn)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon Connect instance that has been replicated.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[builtins.bool]:
        """
        If this is the default traffic distribution group.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def status(self) -> Optional['TrafficDistributionGroupStatus']:
        """
        The status of the traffic distribution group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficDistributionGroupArn")
    def traffic_distribution_group_arn(self) -> Optional[builtins.str]:
        """
        The identifier of the traffic distribution group.
        """
        return pulumi.get(self, "traffic_distribution_group_arn")


class AwaitableGetTrafficDistributionGroupResult(GetTrafficDistributionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrafficDistributionGroupResult(
            instance_arn=self.instance_arn,
            is_default=self.is_default,
            status=self.status,
            tags=self.tags,
            traffic_distribution_group_arn=self.traffic_distribution_group_arn)


def get_traffic_distribution_group(traffic_distribution_group_arn: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrafficDistributionGroupResult:
    """
    Resource Type definition for AWS::Connect::TrafficDistributionGroup


    :param builtins.str traffic_distribution_group_arn: The identifier of the traffic distribution group.
    """
    __args__ = dict()
    __args__['trafficDistributionGroupArn'] = traffic_distribution_group_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getTrafficDistributionGroup', __args__, opts=opts, typ=GetTrafficDistributionGroupResult).value

    return AwaitableGetTrafficDistributionGroupResult(
        instance_arn=pulumi.get(__ret__, 'instance_arn'),
        is_default=pulumi.get(__ret__, 'is_default'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        traffic_distribution_group_arn=pulumi.get(__ret__, 'traffic_distribution_group_arn'))
def get_traffic_distribution_group_output(traffic_distribution_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrafficDistributionGroupResult]:
    """
    Resource Type definition for AWS::Connect::TrafficDistributionGroup


    :param builtins.str traffic_distribution_group_arn: The identifier of the traffic distribution group.
    """
    __args__ = dict()
    __args__['trafficDistributionGroupArn'] = traffic_distribution_group_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:connect:getTrafficDistributionGroup', __args__, opts=opts, typ=GetTrafficDistributionGroupResult)
    return __ret__.apply(lambda __response__: GetTrafficDistributionGroupResult(
        instance_arn=pulumi.get(__response__, 'instance_arn'),
        is_default=pulumi.get(__response__, 'is_default'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        traffic_distribution_group_arn=pulumi.get(__response__, 'traffic_distribution_group_arn')))
