# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetRuleResult',
    'AwaitableGetRuleResult',
    'get_rule',
    'get_rule_output',
]

@pulumi.output_type
class GetRuleResult:
    def __init__(__self__, actions=None, function=None, name=None, publish_status=None, rule_arn=None, tags=None):
        if actions and not isinstance(actions, dict):
            raise TypeError("Expected argument 'actions' to be a dict")
        pulumi.set(__self__, "actions", actions)
        if function and not isinstance(function, str):
            raise TypeError("Expected argument 'function' to be a str")
        pulumi.set(__self__, "function", function)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if publish_status and not isinstance(publish_status, str):
            raise TypeError("Expected argument 'publish_status' to be a str")
        pulumi.set(__self__, "publish_status", publish_status)
        if rule_arn and not isinstance(rule_arn, str):
            raise TypeError("Expected argument 'rule_arn' to be a str")
        pulumi.set(__self__, "rule_arn", rule_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def actions(self) -> Optional['outputs.RuleActions']:
        """
        A list of actions to be run when the rule is triggered.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def function(self) -> Optional[builtins.str]:
        """
        The conditions of the rule.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publishStatus")
    def publish_status(self) -> Optional['RulePublishStatus']:
        """
        The publish status of the rule.
          *Allowed values*: ``DRAFT`` | ``PUBLISHED``
        """
        return pulumi.get(self, "publish_status")

    @property
    @pulumi.getter(name="ruleArn")
    def rule_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the rule.
        """
        return pulumi.get(self, "rule_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRuleResult(GetRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleResult(
            actions=self.actions,
            function=self.function,
            name=self.name,
            publish_status=self.publish_status,
            rule_arn=self.rule_arn,
            tags=self.tags)


def get_rule(rule_arn: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleResult:
    """
    Creates a rule for the specified CON instance.


    :param builtins.str rule_arn: The Amazon Resource Name (ARN) of the rule.
    """
    __args__ = dict()
    __args__['ruleArn'] = rule_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getRule', __args__, opts=opts, typ=GetRuleResult).value

    return AwaitableGetRuleResult(
        actions=pulumi.get(__ret__, 'actions'),
        function=pulumi.get(__ret__, 'function'),
        name=pulumi.get(__ret__, 'name'),
        publish_status=pulumi.get(__ret__, 'publish_status'),
        rule_arn=pulumi.get(__ret__, 'rule_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_rule_output(rule_arn: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleResult]:
    """
    Creates a rule for the specified CON instance.


    :param builtins.str rule_arn: The Amazon Resource Name (ARN) of the rule.
    """
    __args__ = dict()
    __args__['ruleArn'] = rule_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:connect:getRule', __args__, opts=opts, typ=GetRuleResult)
    return __ret__.apply(lambda __response__: GetRuleResult(
        actions=pulumi.get(__response__, 'actions'),
        function=pulumi.get(__response__, 'function'),
        name=pulumi.get(__response__, 'name'),
        publish_status=pulumi.get(__response__, 'publish_status'),
        rule_arn=pulumi.get(__response__, 'rule_arn'),
        tags=pulumi.get(__response__, 'tags')))
