# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetIntegrationAssociationResult',
    'AwaitableGetIntegrationAssociationResult',
    'get_integration_association',
    'get_integration_association_output',
]

@pulumi.output_type
class GetIntegrationAssociationResult:
    def __init__(__self__, integration_association_id=None):
        if integration_association_id and not isinstance(integration_association_id, str):
            raise TypeError("Expected argument 'integration_association_id' to be a str")
        pulumi.set(__self__, "integration_association_id", integration_association_id)

    @property
    @pulumi.getter(name="integrationAssociationId")
    def integration_association_id(self) -> Optional[builtins.str]:
        """
        Identifier of the association with an Amazon Connect instance.
        """
        return pulumi.get(self, "integration_association_id")


class AwaitableGetIntegrationAssociationResult(GetIntegrationAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIntegrationAssociationResult(
            integration_association_id=self.integration_association_id)


def get_integration_association(instance_id: Optional[builtins.str] = None,
                                integration_arn: Optional[builtins.str] = None,
                                integration_type: Optional['IntegrationAssociationIntegrationType'] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIntegrationAssociationResult:
    """
    Resource Type definition for AWS::Connect::IntegrationAssociation


    :param builtins.str instance_id: The Amazon Resource Name (ARN) of the instance.
           
           *Minimum* : `1`
           
           *Maximum* : `100`
    :param builtins.str integration_arn: ARN of the integration being associated with the instance.
           
           *Minimum* : `1`
           
           *Maximum* : `140`
    :param 'IntegrationAssociationIntegrationType' integration_type: Specifies the integration type to be associated with the instance.
           
           *Allowed Values* : `LEX_BOT` | `LAMBDA_FUNCTION`
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['integrationArn'] = integration_arn
    __args__['integrationType'] = integration_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getIntegrationAssociation', __args__, opts=opts, typ=GetIntegrationAssociationResult).value

    return AwaitableGetIntegrationAssociationResult(
        integration_association_id=pulumi.get(__ret__, 'integration_association_id'))
def get_integration_association_output(instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                       integration_arn: Optional[pulumi.Input[builtins.str]] = None,
                                       integration_type: Optional[pulumi.Input['IntegrationAssociationIntegrationType']] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIntegrationAssociationResult]:
    """
    Resource Type definition for AWS::Connect::IntegrationAssociation


    :param builtins.str instance_id: The Amazon Resource Name (ARN) of the instance.
           
           *Minimum* : `1`
           
           *Maximum* : `100`
    :param builtins.str integration_arn: ARN of the integration being associated with the instance.
           
           *Minimum* : `1`
           
           *Maximum* : `140`
    :param 'IntegrationAssociationIntegrationType' integration_type: Specifies the integration type to be associated with the instance.
           
           *Allowed Values* : `LEX_BOT` | `LAMBDA_FUNCTION`
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['integrationArn'] = integration_arn
    __args__['integrationType'] = integration_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:connect:getIntegrationAssociation', __args__, opts=opts, typ=GetIntegrationAssociationResult)
    return __ret__.apply(lambda __response__: GetIntegrationAssociationResult(
        integration_association_id=pulumi.get(__response__, 'integration_association_id')))
