# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetContactFlowVersionResult',
    'AwaitableGetContactFlowVersionResult',
    'get_contact_flow_version',
    'get_contact_flow_version_output',
]

@pulumi.output_type
class GetContactFlowVersionResult:
    def __init__(__self__, contact_flow_version_arn=None, flow_content_sha256=None, version=None):
        if contact_flow_version_arn and not isinstance(contact_flow_version_arn, str):
            raise TypeError("Expected argument 'contact_flow_version_arn' to be a str")
        pulumi.set(__self__, "contact_flow_version_arn", contact_flow_version_arn)
        if flow_content_sha256 and not isinstance(flow_content_sha256, str):
            raise TypeError("Expected argument 'flow_content_sha256' to be a str")
        pulumi.set(__self__, "flow_content_sha256", flow_content_sha256)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contactFlowVersionArn")
    def contact_flow_version_arn(self) -> Optional[builtins.str]:
        """
        The identifier of the contact flow version (ARN).
        """
        return pulumi.get(self, "contact_flow_version_arn")

    @property
    @pulumi.getter(name="flowContentSha256")
    def flow_content_sha256(self) -> Optional[builtins.str]:
        """
        Indicates the checksum value of the latest published flow content
        """
        return pulumi.get(self, "flow_content_sha256")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.int]:
        """
        The version number of this revision
        """
        return pulumi.get(self, "version")


class AwaitableGetContactFlowVersionResult(GetContactFlowVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactFlowVersionResult(
            contact_flow_version_arn=self.contact_flow_version_arn,
            flow_content_sha256=self.flow_content_sha256,
            version=self.version)


def get_contact_flow_version(contact_flow_version_arn: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactFlowVersionResult:
    """
    Resource Type Definition for ContactFlowVersion


    :param builtins.str contact_flow_version_arn: The identifier of the contact flow version (ARN).
    """
    __args__ = dict()
    __args__['contactFlowVersionArn'] = contact_flow_version_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getContactFlowVersion', __args__, opts=opts, typ=GetContactFlowVersionResult).value

    return AwaitableGetContactFlowVersionResult(
        contact_flow_version_arn=pulumi.get(__ret__, 'contact_flow_version_arn'),
        flow_content_sha256=pulumi.get(__ret__, 'flow_content_sha256'),
        version=pulumi.get(__ret__, 'version'))
def get_contact_flow_version_output(contact_flow_version_arn: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContactFlowVersionResult]:
    """
    Resource Type Definition for ContactFlowVersion


    :param builtins.str contact_flow_version_arn: The identifier of the contact flow version (ARN).
    """
    __args__ = dict()
    __args__['contactFlowVersionArn'] = contact_flow_version_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:connect:getContactFlowVersion', __args__, opts=opts, typ=GetContactFlowVersionResult)
    return __ret__.apply(lambda __response__: GetContactFlowVersionResult(
        contact_flow_version_arn=pulumi.get(__response__, 'contact_flow_version_arn'),
        flow_content_sha256=pulumi.get(__response__, 'flow_content_sha256'),
        version=pulumi.get(__response__, 'version')))
