# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetAgentStatusResult',
    'AwaitableGetAgentStatusResult',
    'get_agent_status',
    'get_agent_status_output',
]

@pulumi.output_type
class GetAgentStatusResult:
    def __init__(__self__, agent_status_arn=None, description=None, display_order=None, instance_arn=None, last_modified_region=None, last_modified_time=None, name=None, reset_order_number=None, state=None, tags=None, type=None):
        if agent_status_arn and not isinstance(agent_status_arn, str):
            raise TypeError("Expected argument 'agent_status_arn' to be a str")
        pulumi.set(__self__, "agent_status_arn", agent_status_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_order and not isinstance(display_order, int):
            raise TypeError("Expected argument 'display_order' to be a int")
        pulumi.set(__self__, "display_order", display_order)
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)
        if last_modified_region and not isinstance(last_modified_region, str):
            raise TypeError("Expected argument 'last_modified_region' to be a str")
        pulumi.set(__self__, "last_modified_region", last_modified_region)
        if last_modified_time and not isinstance(last_modified_time, float):
            raise TypeError("Expected argument 'last_modified_time' to be a float")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if reset_order_number and not isinstance(reset_order_number, bool):
            raise TypeError("Expected argument 'reset_order_number' to be a bool")
        pulumi.set(__self__, "reset_order_number", reset_order_number)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="agentStatusArn")
    def agent_status_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the agent status.
        """
        return pulumi.get(self, "agent_status_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the status.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayOrder")
    def display_order(self) -> Optional[builtins.int]:
        """
        The display order of the status.
        """
        return pulumi.get(self, "display_order")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="lastModifiedRegion")
    def last_modified_region(self) -> Optional[builtins.str]:
        """
        Last modified region.
        """
        return pulumi.get(self, "last_modified_region")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[builtins.float]:
        """
        Last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the status.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resetOrderNumber")
    def reset_order_number(self) -> Optional[builtins.bool]:
        """
        A number indicating the reset order of the agent status.
        """
        return pulumi.get(self, "reset_order_number")

    @property
    @pulumi.getter
    def state(self) -> Optional['AgentStatusState']:
        """
        The state of the status.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional['AgentStatusType']:
        """
        The type of agent status.
        """
        return pulumi.get(self, "type")


class AwaitableGetAgentStatusResult(GetAgentStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentStatusResult(
            agent_status_arn=self.agent_status_arn,
            description=self.description,
            display_order=self.display_order,
            instance_arn=self.instance_arn,
            last_modified_region=self.last_modified_region,
            last_modified_time=self.last_modified_time,
            name=self.name,
            reset_order_number=self.reset_order_number,
            state=self.state,
            tags=self.tags,
            type=self.type)


def get_agent_status(agent_status_arn: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentStatusResult:
    """
    Resource Type definition for AWS::Connect::AgentStatus


    :param builtins.str agent_status_arn: The Amazon Resource Name (ARN) of the agent status.
    """
    __args__ = dict()
    __args__['agentStatusArn'] = agent_status_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getAgentStatus', __args__, opts=opts, typ=GetAgentStatusResult).value

    return AwaitableGetAgentStatusResult(
        agent_status_arn=pulumi.get(__ret__, 'agent_status_arn'),
        description=pulumi.get(__ret__, 'description'),
        display_order=pulumi.get(__ret__, 'display_order'),
        instance_arn=pulumi.get(__ret__, 'instance_arn'),
        last_modified_region=pulumi.get(__ret__, 'last_modified_region'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        name=pulumi.get(__ret__, 'name'),
        reset_order_number=pulumi.get(__ret__, 'reset_order_number'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_agent_status_output(agent_status_arn: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentStatusResult]:
    """
    Resource Type definition for AWS::Connect::AgentStatus


    :param builtins.str agent_status_arn: The Amazon Resource Name (ARN) of the agent status.
    """
    __args__ = dict()
    __args__['agentStatusArn'] = agent_status_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:connect:getAgentStatus', __args__, opts=opts, typ=GetAgentStatusResult)
    return __ret__.apply(lambda __response__: GetAgentStatusResult(
        agent_status_arn=pulumi.get(__response__, 'agent_status_arn'),
        description=pulumi.get(__response__, 'description'),
        display_order=pulumi.get(__response__, 'display_order'),
        instance_arn=pulumi.get(__response__, 'instance_arn'),
        last_modified_region=pulumi.get(__response__, 'last_modified_region'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        name=pulumi.get(__response__, 'name'),
        reset_order_number=pulumi.get(__response__, 'reset_order_number'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
