# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOrganizationConformancePackResult',
    'AwaitableGetOrganizationConformancePackResult',
    'get_organization_conformance_pack',
    'get_organization_conformance_pack_output',
]

@pulumi.output_type
class GetOrganizationConformancePackResult:
    def __init__(__self__, conformance_pack_input_parameters=None, delivery_s3_bucket=None, delivery_s3_key_prefix=None, excluded_accounts=None):
        if conformance_pack_input_parameters and not isinstance(conformance_pack_input_parameters, list):
            raise TypeError("Expected argument 'conformance_pack_input_parameters' to be a list")
        pulumi.set(__self__, "conformance_pack_input_parameters", conformance_pack_input_parameters)
        if delivery_s3_bucket and not isinstance(delivery_s3_bucket, str):
            raise TypeError("Expected argument 'delivery_s3_bucket' to be a str")
        pulumi.set(__self__, "delivery_s3_bucket", delivery_s3_bucket)
        if delivery_s3_key_prefix and not isinstance(delivery_s3_key_prefix, str):
            raise TypeError("Expected argument 'delivery_s3_key_prefix' to be a str")
        pulumi.set(__self__, "delivery_s3_key_prefix", delivery_s3_key_prefix)
        if excluded_accounts and not isinstance(excluded_accounts, list):
            raise TypeError("Expected argument 'excluded_accounts' to be a list")
        pulumi.set(__self__, "excluded_accounts", excluded_accounts)

    @property
    @pulumi.getter(name="conformancePackInputParameters")
    def conformance_pack_input_parameters(self) -> Optional[Sequence['outputs.OrganizationConformancePackConformancePackInputParameter']]:
        """
        A list of ConformancePackInputParameter objects.
        """
        return pulumi.get(self, "conformance_pack_input_parameters")

    @property
    @pulumi.getter(name="deliveryS3Bucket")
    def delivery_s3_bucket(self) -> Optional[builtins.str]:
        """
        AWS Config stores intermediate files while processing conformance pack template.
        """
        return pulumi.get(self, "delivery_s3_bucket")

    @property
    @pulumi.getter(name="deliveryS3KeyPrefix")
    def delivery_s3_key_prefix(self) -> Optional[builtins.str]:
        """
        The prefix for the delivery S3 bucket.
        """
        return pulumi.get(self, "delivery_s3_key_prefix")

    @property
    @pulumi.getter(name="excludedAccounts")
    def excluded_accounts(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of AWS accounts to be excluded from an organization conformance pack while deploying a conformance pack.
        """
        return pulumi.get(self, "excluded_accounts")


class AwaitableGetOrganizationConformancePackResult(GetOrganizationConformancePackResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationConformancePackResult(
            conformance_pack_input_parameters=self.conformance_pack_input_parameters,
            delivery_s3_bucket=self.delivery_s3_bucket,
            delivery_s3_key_prefix=self.delivery_s3_key_prefix,
            excluded_accounts=self.excluded_accounts)


def get_organization_conformance_pack(organization_conformance_pack_name: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationConformancePackResult:
    """
    Resource schema for AWS::Config::OrganizationConformancePack.


    :param builtins.str organization_conformance_pack_name: The name of the organization conformance pack.
    """
    __args__ = dict()
    __args__['organizationConformancePackName'] = organization_conformance_pack_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:configuration:getOrganizationConformancePack', __args__, opts=opts, typ=GetOrganizationConformancePackResult).value

    return AwaitableGetOrganizationConformancePackResult(
        conformance_pack_input_parameters=pulumi.get(__ret__, 'conformance_pack_input_parameters'),
        delivery_s3_bucket=pulumi.get(__ret__, 'delivery_s3_bucket'),
        delivery_s3_key_prefix=pulumi.get(__ret__, 'delivery_s3_key_prefix'),
        excluded_accounts=pulumi.get(__ret__, 'excluded_accounts'))
def get_organization_conformance_pack_output(organization_conformance_pack_name: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationConformancePackResult]:
    """
    Resource schema for AWS::Config::OrganizationConformancePack.


    :param builtins.str organization_conformance_pack_name: The name of the organization conformance pack.
    """
    __args__ = dict()
    __args__['organizationConformancePackName'] = organization_conformance_pack_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:configuration:getOrganizationConformancePack', __args__, opts=opts, typ=GetOrganizationConformancePackResult)
    return __ret__.apply(lambda __response__: GetOrganizationConformancePackResult(
        conformance_pack_input_parameters=pulumi.get(__response__, 'conformance_pack_input_parameters'),
        delivery_s3_bucket=pulumi.get(__response__, 'delivery_s3_bucket'),
        delivery_s3_key_prefix=pulumi.get(__response__, 'delivery_s3_key_prefix'),
        excluded_accounts=pulumi.get(__response__, 'excluded_accounts')))
