# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetAggregationAuthorizationResult',
    'AwaitableGetAggregationAuthorizationResult',
    'get_aggregation_authorization',
    'get_aggregation_authorization_output',
]

@pulumi.output_type
class GetAggregationAuthorizationResult:
    def __init__(__self__, aggregation_authorization_arn=None, tags=None):
        if aggregation_authorization_arn and not isinstance(aggregation_authorization_arn, str):
            raise TypeError("Expected argument 'aggregation_authorization_arn' to be a str")
        pulumi.set(__self__, "aggregation_authorization_arn", aggregation_authorization_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="aggregationAuthorizationArn")
    def aggregation_authorization_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the AggregationAuthorization.
        """
        return pulumi.get(self, "aggregation_authorization_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags for the AggregationAuthorization.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAggregationAuthorizationResult(GetAggregationAuthorizationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAggregationAuthorizationResult(
            aggregation_authorization_arn=self.aggregation_authorization_arn,
            tags=self.tags)


def get_aggregation_authorization(authorized_account_id: Optional[builtins.str] = None,
                                  authorized_aws_region: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAggregationAuthorizationResult:
    """
    Resource Type definition for AWS::Config::AggregationAuthorization


    :param builtins.str authorized_account_id: The 12-digit account ID of the account authorized to aggregate data.
    :param builtins.str authorized_aws_region: The region authorized to collect aggregated data.
    """
    __args__ = dict()
    __args__['authorizedAccountId'] = authorized_account_id
    __args__['authorizedAwsRegion'] = authorized_aws_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:configuration:getAggregationAuthorization', __args__, opts=opts, typ=GetAggregationAuthorizationResult).value

    return AwaitableGetAggregationAuthorizationResult(
        aggregation_authorization_arn=pulumi.get(__ret__, 'aggregation_authorization_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_aggregation_authorization_output(authorized_account_id: Optional[pulumi.Input[builtins.str]] = None,
                                         authorized_aws_region: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAggregationAuthorizationResult]:
    """
    Resource Type definition for AWS::Config::AggregationAuthorization


    :param builtins.str authorized_account_id: The 12-digit account ID of the account authorized to aggregate data.
    :param builtins.str authorized_aws_region: The region authorized to collect aggregated data.
    """
    __args__ = dict()
    __args__['authorizedAccountId'] = authorized_account_id
    __args__['authorizedAwsRegion'] = authorized_aws_region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:configuration:getAggregationAuthorization', __args__, opts=opts, typ=GetAggregationAuthorizationResult)
    return __ret__.apply(lambda __response__: GetAggregationAuthorizationResult(
        aggregation_authorization_arn=pulumi.get(__response__, 'aggregation_authorization_arn'),
        tags=pulumi.get(__response__, 'tags')))
