# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigRuleArgs', 'ConfigRule']

@pulumi.input_type
class ConfigRuleArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['ConfigRuleSourceArgs'],
                 compliance: Optional[pulumi.Input['CompliancePropertiesArgs']] = None,
                 config_rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleEvaluationModeConfigurationArgs']]]] = None,
                 input_parameters: Optional[Any] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input['ConfigRuleScopeArgs']] = None):
        """
        The set of arguments for constructing a ConfigRule resource.
        :param pulumi.Input['ConfigRuleSourceArgs'] source: Provides the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
        :param pulumi.Input['CompliancePropertiesArgs'] compliance: Indicates whether an AWS resource or CC rule is compliant and provides the number of contributors that affect the compliance.
        :param pulumi.Input[builtins.str] config_rule_name: A name for the CC rule. If you don't specify a name, CFN generates a unique physical ID and uses that ID for the rule name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
        :param pulumi.Input[builtins.str] description: The description that you provide for the CC rule.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigRuleEvaluationModeConfigurationArgs']]] evaluation_modes: The modes the CC rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.
        :param Any input_parameters: A string, in JSON format, that is passed to the CC rule Lambda function.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Config::ConfigRule` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] maximum_execution_frequency: The maximum frequency with which CC runs evaluations for a rule. You can specify a value for ``MaximumExecutionFrequency`` when:
                 +  You are using an AWS managed rule that is triggered at a periodic frequency.
                 +  Your custom rule is triggered when CC delivers the configuration snapshot. For more information, see [ConfigSnapshotDeliveryProperties](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html).
                 
                 By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the ``MaximumExecutionFrequency`` parameter.
        :param pulumi.Input['ConfigRuleScopeArgs'] scope: Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
                 The scope can be empty.
        """
        pulumi.set(__self__, "source", source)
        if compliance is not None:
            pulumi.set(__self__, "compliance", compliance)
        if config_rule_name is not None:
            pulumi.set(__self__, "config_rule_name", config_rule_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if evaluation_modes is not None:
            pulumi.set(__self__, "evaluation_modes", evaluation_modes)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['ConfigRuleSourceArgs']:
        """
        Provides the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['ConfigRuleSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def compliance(self) -> Optional[pulumi.Input['CompliancePropertiesArgs']]:
        """
        Indicates whether an AWS resource or CC rule is compliant and provides the number of contributors that affect the compliance.
        """
        return pulumi.get(self, "compliance")

    @compliance.setter
    def compliance(self, value: Optional[pulumi.Input['CompliancePropertiesArgs']]):
        pulumi.set(self, "compliance", value)

    @property
    @pulumi.getter(name="configRuleName")
    def config_rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the CC rule. If you don't specify a name, CFN generates a unique physical ID and uses that ID for the rule name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
        """
        return pulumi.get(self, "config_rule_name")

    @config_rule_name.setter
    def config_rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_rule_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description that you provide for the CC rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="evaluationModes")
    def evaluation_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleEvaluationModeConfigurationArgs']]]]:
        """
        The modes the CC rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.
        """
        return pulumi.get(self, "evaluation_modes")

    @evaluation_modes.setter
    def evaluation_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleEvaluationModeConfigurationArgs']]]]):
        pulumi.set(self, "evaluation_modes", value)

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[Any]:
        """
        A string, in JSON format, that is passed to the CC rule Lambda function.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Config::ConfigRule` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[Any]):
        pulumi.set(self, "input_parameters", value)

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum frequency with which CC runs evaluations for a rule. You can specify a value for ``MaximumExecutionFrequency`` when:
          +  You are using an AWS managed rule that is triggered at a periodic frequency.
          +  Your custom rule is triggered when CC delivers the configuration snapshot. For more information, see [ConfigSnapshotDeliveryProperties](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html).
          
          By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the ``MaximumExecutionFrequency`` parameter.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maximum_execution_frequency", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['ConfigRuleScopeArgs']]:
        """
        Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
          The scope can be empty.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['ConfigRuleScopeArgs']]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("aws-native:configuration:ConfigRule")
class ConfigRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compliance: Optional[pulumi.Input[Union['CompliancePropertiesArgs', 'CompliancePropertiesArgsDict']]] = None,
                 config_rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleEvaluationModeConfigurationArgs', 'ConfigRuleEvaluationModeConfigurationArgsDict']]]]] = None,
                 input_parameters: Optional[Any] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[Union['ConfigRuleScopeArgs', 'ConfigRuleScopeArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['ConfigRuleSourceArgs', 'ConfigRuleSourceArgsDict']]] = None,
                 __props__=None):
        """
        You must first create and start the CC configuration recorder in order to create CC managed rules with CFNlong. For more information, see [Managing the Configuration Recorder](https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html).
          Adds or updates an CC rule to evaluate if your AWS resources comply with your desired configurations. For information on how many CC rules you can have per account, see [Service Limits](https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html) in the *Developer Guide*.
         There are two types of rules: *Managed Rules* and *Custom Rules*. You can use the ``ConfigRule`` resource to create both CC Managed Rules and CC Custom Rules.
          CC Managed Rules are predefined, customizable rules created by CC. For a list of managed rules, see [List of Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html). If you are adding an CC managed rule, you must specify the rule's identifier for the ``SourceIdentifier`` key.
          CC Custom Rules are rules that you create from scratch. There are two ways to create CC custom rules: with Lambda functions ([Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function)) and with CFNGUARDshort ([Guard GitHub Repository](https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard)), a policy-as-code language. CC custom rules created with LAMlong are called *Custom Lambda Rules* and CC custom rules created with CFNGUARDshort are called *Custom Policy Rules*.
         If you are adding a new CC Custom LAM rule, you first need to create an LAMlong function that the rule invokes to evaluate your resources. When you use the ``ConfigRule`` resource to add a Custom LAM rule to CC, you must specify the Amazon Resource Name (ARN) that LAMlong assigns to the function. You specify the ARN in the ``SourceIdentifier`` key. This key is part of the ``Source`` object, which is part of the ``ConfigRule`` object.
         For any new CC rule that you add, specify the ``ConfigRuleName`` in the ``ConfigRule`` object. Do not specify the ``ConfigRuleArn`` or the ``ConfigRuleId``. These values are generated by CC for new rules.
         If you are updating a rule that you added previously, you can specify the rule by ``ConfigRuleName``, ``ConfigRuleId``, or ``ConfigRuleArn`` in the ``ConfigRule`` data type that you use in this request.
         For more information about developing and using CC rules, see [Evaluating Resources with Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html) in the *Developer Guide*.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CompliancePropertiesArgs', 'CompliancePropertiesArgsDict']] compliance: Indicates whether an AWS resource or CC rule is compliant and provides the number of contributors that affect the compliance.
        :param pulumi.Input[builtins.str] config_rule_name: A name for the CC rule. If you don't specify a name, CFN generates a unique physical ID and uses that ID for the rule name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
        :param pulumi.Input[builtins.str] description: The description that you provide for the CC rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleEvaluationModeConfigurationArgs', 'ConfigRuleEvaluationModeConfigurationArgsDict']]]] evaluation_modes: The modes the CC rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.
        :param Any input_parameters: A string, in JSON format, that is passed to the CC rule Lambda function.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Config::ConfigRule` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] maximum_execution_frequency: The maximum frequency with which CC runs evaluations for a rule. You can specify a value for ``MaximumExecutionFrequency`` when:
                 +  You are using an AWS managed rule that is triggered at a periodic frequency.
                 +  Your custom rule is triggered when CC delivers the configuration snapshot. For more information, see [ConfigSnapshotDeliveryProperties](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html).
                 
                 By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the ``MaximumExecutionFrequency`` parameter.
        :param pulumi.Input[Union['ConfigRuleScopeArgs', 'ConfigRuleScopeArgsDict']] scope: Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
                 The scope can be empty.
        :param pulumi.Input[Union['ConfigRuleSourceArgs', 'ConfigRuleSourceArgsDict']] source: Provides the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        You must first create and start the CC configuration recorder in order to create CC managed rules with CFNlong. For more information, see [Managing the Configuration Recorder](https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html).
          Adds or updates an CC rule to evaluate if your AWS resources comply with your desired configurations. For information on how many CC rules you can have per account, see [Service Limits](https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html) in the *Developer Guide*.
         There are two types of rules: *Managed Rules* and *Custom Rules*. You can use the ``ConfigRule`` resource to create both CC Managed Rules and CC Custom Rules.
          CC Managed Rules are predefined, customizable rules created by CC. For a list of managed rules, see [List of Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html). If you are adding an CC managed rule, you must specify the rule's identifier for the ``SourceIdentifier`` key.
          CC Custom Rules are rules that you create from scratch. There are two ways to create CC custom rules: with Lambda functions ([Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function)) and with CFNGUARDshort ([Guard GitHub Repository](https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard)), a policy-as-code language. CC custom rules created with LAMlong are called *Custom Lambda Rules* and CC custom rules created with CFNGUARDshort are called *Custom Policy Rules*.
         If you are adding a new CC Custom LAM rule, you first need to create an LAMlong function that the rule invokes to evaluate your resources. When you use the ``ConfigRule`` resource to add a Custom LAM rule to CC, you must specify the Amazon Resource Name (ARN) that LAMlong assigns to the function. You specify the ARN in the ``SourceIdentifier`` key. This key is part of the ``Source`` object, which is part of the ``ConfigRule`` object.
         For any new CC rule that you add, specify the ``ConfigRuleName`` in the ``ConfigRule`` object. Do not specify the ``ConfigRuleArn`` or the ``ConfigRuleId``. These values are generated by CC for new rules.
         If you are updating a rule that you added previously, you can specify the rule by ``ConfigRuleName``, ``ConfigRuleId``, or ``ConfigRuleArn`` in the ``ConfigRule`` data type that you use in this request.
         For more information about developing and using CC rules, see [Evaluating Resources with Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html) in the *Developer Guide*.

        :param str resource_name: The name of the resource.
        :param ConfigRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compliance: Optional[pulumi.Input[Union['CompliancePropertiesArgs', 'CompliancePropertiesArgsDict']]] = None,
                 config_rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 evaluation_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigRuleEvaluationModeConfigurationArgs', 'ConfigRuleEvaluationModeConfigurationArgsDict']]]]] = None,
                 input_parameters: Optional[Any] = None,
                 maximum_execution_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[Union['ConfigRuleScopeArgs', 'ConfigRuleScopeArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['ConfigRuleSourceArgs', 'ConfigRuleSourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigRuleArgs.__new__(ConfigRuleArgs)

            __props__.__dict__["compliance"] = compliance
            __props__.__dict__["config_rule_name"] = config_rule_name
            __props__.__dict__["description"] = description
            __props__.__dict__["evaluation_modes"] = evaluation_modes
            __props__.__dict__["input_parameters"] = input_parameters
            __props__.__dict__["maximum_execution_frequency"] = maximum_execution_frequency
            __props__.__dict__["scope"] = scope
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["arn"] = None
            __props__.__dict__["config_rule_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["configRuleName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConfigRule, __self__).__init__(
            'aws-native:configuration:ConfigRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConfigRule':
        """
        Get an existing ConfigRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConfigRuleArgs.__new__(ConfigRuleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["compliance"] = None
        __props__.__dict__["config_rule_id"] = None
        __props__.__dict__["config_rule_name"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["evaluation_modes"] = None
        __props__.__dict__["input_parameters"] = None
        __props__.__dict__["maximum_execution_frequency"] = None
        __props__.__dict__["scope"] = None
        __props__.__dict__["source"] = None
        return ConfigRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS Config rule, such as `arn:aws:config:us-east-1:123456789012:config-rule/config-rule-a1bzhi` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def compliance(self) -> pulumi.Output[Optional['outputs.ComplianceProperties']]:
        """
        Indicates whether an AWS resource or CC rule is compliant and provides the number of contributors that affect the compliance.
        """
        return pulumi.get(self, "compliance")

    @property
    @pulumi.getter(name="configRuleId")
    def config_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the AWS Config rule, such as `config-rule-a1bzhi` .
        """
        return pulumi.get(self, "config_rule_id")

    @property
    @pulumi.getter(name="configRuleName")
    def config_rule_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A name for the CC rule. If you don't specify a name, CFN generates a unique physical ID and uses that ID for the rule name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
        """
        return pulumi.get(self, "config_rule_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description that you provide for the CC rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationModes")
    def evaluation_modes(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigRuleEvaluationModeConfiguration']]]:
        """
        The modes the CC rule can be evaluated in. The valid values are distinct objects. By default, the value is Detective evaluation mode only.
        """
        return pulumi.get(self, "evaluation_modes")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> pulumi.Output[Optional[Any]]:
        """
        A string, in JSON format, that is passed to the CC rule Lambda function.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Config::ConfigRule` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "input_parameters")

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The maximum frequency with which CC runs evaluations for a rule. You can specify a value for ``MaximumExecutionFrequency`` when:
          +  You are using an AWS managed rule that is triggered at a periodic frequency.
          +  Your custom rule is triggered when CC delivers the configuration snapshot. For more information, see [ConfigSnapshotDeliveryProperties](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html).
          
          By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the ``MaximumExecutionFrequency`` parameter.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional['outputs.ConfigRuleScope']]:
        """
        Defines which resources can trigger an evaluation for the rule. The scope can include one or more resource types, a combination of one resource type and one resource ID, or a combination of a tag key and value. Specify a scope to constrain the resources that can trigger an evaluation for the rule. If you do not specify a scope, evaluations are triggered when any resource in the recording group changes.
          The scope can be empty.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.ConfigRuleSource']:
        """
        Provides the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the notifications that cause the function to evaluate your AWS resources.
        """
        return pulumi.get(self, "source")

