# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetFlywheelResult',
    'AwaitableGetFlywheelResult',
    'get_flywheel',
    'get_flywheel_output',
]

@pulumi.output_type
class GetFlywheelResult:
    def __init__(__self__, active_model_arn=None, arn=None, data_access_role_arn=None, data_security_config=None, tags=None):
        if active_model_arn and not isinstance(active_model_arn, str):
            raise TypeError("Expected argument 'active_model_arn' to be a str")
        pulumi.set(__self__, "active_model_arn", active_model_arn)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if data_access_role_arn and not isinstance(data_access_role_arn, str):
            raise TypeError("Expected argument 'data_access_role_arn' to be a str")
        pulumi.set(__self__, "data_access_role_arn", data_access_role_arn)
        if data_security_config and not isinstance(data_security_config, dict):
            raise TypeError("Expected argument 'data_security_config' to be a dict")
        pulumi.set(__self__, "data_security_config", data_security_config)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="activeModelArn")
    def active_model_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Number (ARN) of the active model version.
        """
        return pulumi.get(self, "active_model_arn")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the flywheel.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the flywheel data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @property
    @pulumi.getter(name="dataSecurityConfig")
    def data_security_config(self) -> Optional['outputs.FlywheelDataSecurityConfig']:
        """
        Data security configuration.
        """
        return pulumi.get(self, "data_security_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department.
        """
        return pulumi.get(self, "tags")


class AwaitableGetFlywheelResult(GetFlywheelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlywheelResult(
            active_model_arn=self.active_model_arn,
            arn=self.arn,
            data_access_role_arn=self.data_access_role_arn,
            data_security_config=self.data_security_config,
            tags=self.tags)


def get_flywheel(arn: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlywheelResult:
    """
    The AWS::Comprehend::Flywheel resource creates an Amazon Comprehend Flywheel that enables customer to train their model.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the flywheel.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:comprehend:getFlywheel', __args__, opts=opts, typ=GetFlywheelResult).value

    return AwaitableGetFlywheelResult(
        active_model_arn=pulumi.get(__ret__, 'active_model_arn'),
        arn=pulumi.get(__ret__, 'arn'),
        data_access_role_arn=pulumi.get(__ret__, 'data_access_role_arn'),
        data_security_config=pulumi.get(__ret__, 'data_security_config'),
        tags=pulumi.get(__ret__, 'tags'))
def get_flywheel_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlywheelResult]:
    """
    The AWS::Comprehend::Flywheel resource creates an Amazon Comprehend Flywheel that enables customer to train their model.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the flywheel.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:comprehend:getFlywheel', __args__, opts=opts, typ=GetFlywheelResult)
    return __ret__.apply(lambda __response__: GetFlywheelResult(
        active_model_arn=pulumi.get(__response__, 'active_model_arn'),
        arn=pulumi.get(__response__, 'arn'),
        data_access_role_arn=pulumi.get(__response__, 'data_access_role_arn'),
        data_security_config=pulumi.get(__response__, 'data_security_config'),
        tags=pulumi.get(__response__, 'tags')))
