# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DocumentClassifierArgs', 'DocumentClassifier']

@pulumi.input_type
class DocumentClassifierArgs:
    def __init__(__self__, *,
                 data_access_role_arn: pulumi.Input[builtins.str],
                 input_data_config: pulumi.Input['DocumentClassifierInputDataConfigArgs'],
                 language_code: pulumi.Input['DocumentClassifierLanguageCode'],
                 document_classifier_name: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input['DocumentClassifierMode']] = None,
                 model_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_policy: Optional[pulumi.Input[builtins.str]] = None,
                 output_data_config: Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a DocumentClassifier resource.
        :param pulumi.Input[builtins.str] data_access_role_arn: The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
        :param pulumi.Input['DocumentClassifierInputDataConfigArgs'] input_data_config: Specifies the format and location of the input data for the job.
        :param pulumi.Input['DocumentClassifierLanguageCode'] language_code: The language of the input documents. You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.
        :param pulumi.Input[builtins.str] document_classifier_name: The name of the document classifier.
        :param pulumi.Input['DocumentClassifierMode'] mode: Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
        :param pulumi.Input[builtins.str] model_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        :param pulumi.Input[builtins.str] model_policy: The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another AWS account to import your custom model.
               
               Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:
               
               `"{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]}"`
               
               To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:
               
               `'{"attribute": "value", "attribute": ["value"]}'`
        :param pulumi.Input['DocumentClassifierOutputDataConfigArgs'] output_data_config: Provides output results configuration parameters for custom classifier jobs.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags to associate with the document classifier. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
        :param pulumi.Input[builtins.str] version_name: The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the AWS account / AWS Region .
        :param pulumi.Input[builtins.str] volume_kms_key_id: ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        :param pulumi.Input['DocumentClassifierVpcConfigArgs'] vpc_config: Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        pulumi.set(__self__, "data_access_role_arn", data_access_role_arn)
        pulumi.set(__self__, "input_data_config", input_data_config)
        pulumi.set(__self__, "language_code", language_code)
        if document_classifier_name is not None:
            pulumi.set(__self__, "document_classifier_name", document_classifier_name)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if model_kms_key_id is not None:
            pulumi.set(__self__, "model_kms_key_id", model_kms_key_id)
        if model_policy is not None:
            pulumi.set(__self__, "model_policy", model_policy)
        if output_data_config is not None:
            pulumi.set(__self__, "output_data_config", output_data_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @data_access_role_arn.setter
    def data_access_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_access_role_arn", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Input['DocumentClassifierInputDataConfigArgs']:
        """
        Specifies the format and location of the input data for the job.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: pulumi.Input['DocumentClassifierInputDataConfigArgs']):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input['DocumentClassifierLanguageCode']:
        """
        The language of the input documents. You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input['DocumentClassifierLanguageCode']):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="documentClassifierName")
    def document_classifier_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the document classifier.
        """
        return pulumi.get(self, "document_classifier_name")

    @document_classifier_name.setter
    def document_classifier_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_classifier_name", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input['DocumentClassifierMode']]:
        """
        Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input['DocumentClassifierMode']]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        """
        return pulumi.get(self, "model_kms_key_id")

    @model_kms_key_id.setter
    def model_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_kms_key_id", value)

    @property
    @pulumi.getter(name="modelPolicy")
    def model_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another AWS account to import your custom model.

        Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:

        `"{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]}"`

        To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:

        `'{"attribute": "value", "attribute": ["value"]}'`
        """
        return pulumi.get(self, "model_policy")

    @model_policy.setter
    def model_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_policy", value)

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']]:
        """
        Provides output results configuration parameters for custom classifier jobs.
        """
        return pulumi.get(self, "output_data_config")

    @output_data_config.setter
    def output_data_config(self, value: Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']]):
        pulumi.set(self, "output_data_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags to associate with the document classifier. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the AWS account / AWS Region .
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_name", value)

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        """
        return pulumi.get(self, "volume_kms_key_id")

    @volume_kms_key_id.setter
    def volume_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_kms_key_id", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']]:
        """
        Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.type_token("aws-native:comprehend:DocumentClassifier")
class DocumentClassifier(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 document_classifier_name: Optional[pulumi.Input[builtins.str]] = None,
                 input_data_config: Optional[pulumi.Input[Union['DocumentClassifierInputDataConfigArgs', 'DocumentClassifierInputDataConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input['DocumentClassifierLanguageCode']] = None,
                 mode: Optional[pulumi.Input['DocumentClassifierMode']] = None,
                 model_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_policy: Optional[pulumi.Input[builtins.str]] = None,
                 output_data_config: Optional[pulumi.Input[Union['DocumentClassifierOutputDataConfigArgs', 'DocumentClassifierOutputDataConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input[Union['DocumentClassifierVpcConfigArgs', 'DocumentClassifierVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Document Classifier enables training document classifier models.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_access_role_arn: The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
        :param pulumi.Input[builtins.str] document_classifier_name: The name of the document classifier.
        :param pulumi.Input[Union['DocumentClassifierInputDataConfigArgs', 'DocumentClassifierInputDataConfigArgsDict']] input_data_config: Specifies the format and location of the input data for the job.
        :param pulumi.Input['DocumentClassifierLanguageCode'] language_code: The language of the input documents. You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.
        :param pulumi.Input['DocumentClassifierMode'] mode: Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
        :param pulumi.Input[builtins.str] model_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        :param pulumi.Input[builtins.str] model_policy: The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another AWS account to import your custom model.
               
               Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:
               
               `"{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]}"`
               
               To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:
               
               `'{"attribute": "value", "attribute": ["value"]}'`
        :param pulumi.Input[Union['DocumentClassifierOutputDataConfigArgs', 'DocumentClassifierOutputDataConfigArgsDict']] output_data_config: Provides output results configuration parameters for custom classifier jobs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags to associate with the document classifier. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
        :param pulumi.Input[builtins.str] version_name: The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the AWS account / AWS Region .
        :param pulumi.Input[builtins.str] volume_kms_key_id: ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        :param pulumi.Input[Union['DocumentClassifierVpcConfigArgs', 'DocumentClassifierVpcConfigArgsDict']] vpc_config: Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DocumentClassifierArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Document Classifier enables training document classifier models.

        :param str resource_name: The name of the resource.
        :param DocumentClassifierArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DocumentClassifierArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 document_classifier_name: Optional[pulumi.Input[builtins.str]] = None,
                 input_data_config: Optional[pulumi.Input[Union['DocumentClassifierInputDataConfigArgs', 'DocumentClassifierInputDataConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input['DocumentClassifierLanguageCode']] = None,
                 mode: Optional[pulumi.Input['DocumentClassifierMode']] = None,
                 model_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_policy: Optional[pulumi.Input[builtins.str]] = None,
                 output_data_config: Optional[pulumi.Input[Union['DocumentClassifierOutputDataConfigArgs', 'DocumentClassifierOutputDataConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input[Union['DocumentClassifierVpcConfigArgs', 'DocumentClassifierVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DocumentClassifierArgs.__new__(DocumentClassifierArgs)

            if data_access_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'data_access_role_arn'")
            __props__.__dict__["data_access_role_arn"] = data_access_role_arn
            __props__.__dict__["document_classifier_name"] = document_classifier_name
            if input_data_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_data_config'")
            __props__.__dict__["input_data_config"] = input_data_config
            if language_code is None and not opts.urn:
                raise TypeError("Missing required property 'language_code'")
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["mode"] = mode
            __props__.__dict__["model_kms_key_id"] = model_kms_key_id
            __props__.__dict__["model_policy"] = model_policy
            __props__.__dict__["output_data_config"] = output_data_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version_name"] = version_name
            __props__.__dict__["volume_kms_key_id"] = volume_kms_key_id
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["dataAccessRoleArn", "documentClassifierName", "inputDataConfig", "languageCode", "mode", "modelKmsKeyId", "outputDataConfig", "versionName", "volumeKmsKeyId", "vpcConfig"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DocumentClassifier, __self__).__init__(
            'aws-native:comprehend:DocumentClassifier',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DocumentClassifier':
        """
        Get an existing DocumentClassifier resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DocumentClassifierArgs.__new__(DocumentClassifierArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["data_access_role_arn"] = None
        __props__.__dict__["document_classifier_name"] = None
        __props__.__dict__["input_data_config"] = None
        __props__.__dict__["language_code"] = None
        __props__.__dict__["mode"] = None
        __props__.__dict__["model_kms_key_id"] = None
        __props__.__dict__["model_policy"] = None
        __props__.__dict__["output_data_config"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["version_name"] = None
        __props__.__dict__["volume_kms_key_id"] = None
        __props__.__dict__["vpc_config"] = None
        return DocumentClassifier(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the document classifier.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @property
    @pulumi.getter(name="documentClassifierName")
    def document_classifier_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the document classifier.
        """
        return pulumi.get(self, "document_classifier_name")

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Output['outputs.DocumentClassifierInputDataConfig']:
        """
        Specifies the format and location of the input data for the job.
        """
        return pulumi.get(self, "input_data_config")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output['DocumentClassifierLanguageCode']:
        """
        The language of the input documents. You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional['DocumentClassifierMode']]:
        """
        Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        """
        return pulumi.get(self, "model_kms_key_id")

    @property
    @pulumi.getter(name="modelPolicy")
    def model_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another AWS account to import your custom model.

        Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:

        `"{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]}"`

        To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:

        `'{"attribute": "value", "attribute": ["value"]}'`
        """
        return pulumi.get(self, "model_policy")

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> pulumi.Output[Optional['outputs.DocumentClassifierOutputDataConfig']]:
        """
        Provides output results configuration parameters for custom classifier jobs.
        """
        return pulumi.get(self, "output_data_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags to associate with the document classifier. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the AWS account / AWS Region .
        """
        return pulumi.get(self, "version_name")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        """
        return pulumi.get(self, "volume_kms_key_id")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.DocumentClassifierVpcConfig']]:
        """
        Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        return pulumi.get(self, "vpc_config")

