# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'DocumentClassifierAugmentedManifestsListItemArgs',
    'DocumentClassifierAugmentedManifestsListItemArgsDict',
    'DocumentClassifierDocumentReaderConfigArgs',
    'DocumentClassifierDocumentReaderConfigArgsDict',
    'DocumentClassifierDocumentsArgs',
    'DocumentClassifierDocumentsArgsDict',
    'DocumentClassifierInputDataConfigArgs',
    'DocumentClassifierInputDataConfigArgsDict',
    'DocumentClassifierOutputDataConfigArgs',
    'DocumentClassifierOutputDataConfigArgsDict',
    'DocumentClassifierVpcConfigArgs',
    'DocumentClassifierVpcConfigArgsDict',
    'FlywheelDataSecurityConfigArgs',
    'FlywheelDataSecurityConfigArgsDict',
    'FlywheelDocumentClassificationConfigArgs',
    'FlywheelDocumentClassificationConfigArgsDict',
    'FlywheelEntityRecognitionConfigArgs',
    'FlywheelEntityRecognitionConfigArgsDict',
    'FlywheelEntityTypesListItemArgs',
    'FlywheelEntityTypesListItemArgsDict',
    'FlywheelTaskConfigArgs',
    'FlywheelTaskConfigArgsDict',
    'FlywheelVpcConfigArgs',
    'FlywheelVpcConfigArgsDict',
]

MYPY = False

if not MYPY:
    class DocumentClassifierAugmentedManifestsListItemArgsDict(TypedDict):
        attribute_names: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.

        If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.

        If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
        """
        s3_uri: pulumi.Input[builtins.str]
        """
        The Amazon S3 location of the augmented manifest file.
        """
        split: NotRequired[pulumi.Input['DocumentClassifierAugmentedManifestsListItemSplit']]
        """
        The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.

        TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.

        TEST - all of the documents in the manifest will be used for testing.
        """
elif False:
    DocumentClassifierAugmentedManifestsListItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentClassifierAugmentedManifestsListItemArgs:
    def __init__(__self__, *,
                 attribute_names: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 s3_uri: pulumi.Input[builtins.str],
                 split: Optional[pulumi.Input['DocumentClassifierAugmentedManifestsListItemSplit']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] attribute_names: The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.
               
               If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.
               
               If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
        :param pulumi.Input[builtins.str] s3_uri: The Amazon S3 location of the augmented manifest file.
        :param pulumi.Input['DocumentClassifierAugmentedManifestsListItemSplit'] split: The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.
               
               TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
               
               TEST - all of the documents in the manifest will be used for testing.
        """
        pulumi.set(__self__, "attribute_names", attribute_names)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if split is not None:
            pulumi.set(__self__, "split", split)

    @property
    @pulumi.getter(name="attributeNames")
    def attribute_names(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.

        If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.

        If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
        """
        return pulumi.get(self, "attribute_names")

    @attribute_names.setter
    def attribute_names(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "attribute_names", value)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon S3 location of the augmented manifest file.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter
    def split(self) -> Optional[pulumi.Input['DocumentClassifierAugmentedManifestsListItemSplit']]:
        """
        The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.

        TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.

        TEST - all of the documents in the manifest will be used for testing.
        """
        return pulumi.get(self, "split")

    @split.setter
    def split(self, value: Optional[pulumi.Input['DocumentClassifierAugmentedManifestsListItemSplit']]):
        pulumi.set(self, "split", value)


if not MYPY:
    class DocumentClassifierDocumentReaderConfigArgsDict(TypedDict):
        document_read_action: pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadAction']
        """
        This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:

        - `TEXTRACT_DETECT_DOCUMENT_TEXT` - The Amazon Comprehend service uses the `DetectDocumentText` API operation.
        - `TEXTRACT_ANALYZE_DOCUMENT` - The Amazon Comprehend service uses the `AnalyzeDocument` API operation.
        """
        document_read_mode: NotRequired[pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadMode']]
        """
        Determines the text extraction actions for PDF files. Enter one of the following values:

        - `SERVICE_DEFAULT` - use the Amazon Comprehend service defaults for PDF files.
        - `FORCE_DOCUMENT_READ_ACTION` - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.
        """
        feature_types: NotRequired[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierDocumentReaderConfigFeatureTypesItem']]]]
        """
        Specifies the type of Amazon Textract features to apply. If you chose `TEXTRACT_ANALYZE_DOCUMENT` as the read action, you must specify one or both of the following values:

        - `TABLES` - Returns additional information about any tables that are detected in the input document.
        - `FORMS` - Returns additional information about any forms that are detected in the input document.
        """
elif False:
    DocumentClassifierDocumentReaderConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentClassifierDocumentReaderConfigArgs:
    def __init__(__self__, *,
                 document_read_action: pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadAction'],
                 document_read_mode: Optional[pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadMode']] = None,
                 feature_types: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierDocumentReaderConfigFeatureTypesItem']]]] = None):
        """
        :param pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadAction'] document_read_action: This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:
               
               - `TEXTRACT_DETECT_DOCUMENT_TEXT` - The Amazon Comprehend service uses the `DetectDocumentText` API operation.
               - `TEXTRACT_ANALYZE_DOCUMENT` - The Amazon Comprehend service uses the `AnalyzeDocument` API operation.
        :param pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadMode'] document_read_mode: Determines the text extraction actions for PDF files. Enter one of the following values:
               
               - `SERVICE_DEFAULT` - use the Amazon Comprehend service defaults for PDF files.
               - `FORCE_DOCUMENT_READ_ACTION` - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.
        :param pulumi.Input[Sequence[pulumi.Input['DocumentClassifierDocumentReaderConfigFeatureTypesItem']]] feature_types: Specifies the type of Amazon Textract features to apply. If you chose `TEXTRACT_ANALYZE_DOCUMENT` as the read action, you must specify one or both of the following values:
               
               - `TABLES` - Returns additional information about any tables that are detected in the input document.
               - `FORMS` - Returns additional information about any forms that are detected in the input document.
        """
        pulumi.set(__self__, "document_read_action", document_read_action)
        if document_read_mode is not None:
            pulumi.set(__self__, "document_read_mode", document_read_mode)
        if feature_types is not None:
            pulumi.set(__self__, "feature_types", feature_types)

    @property
    @pulumi.getter(name="documentReadAction")
    def document_read_action(self) -> pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadAction']:
        """
        This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:

        - `TEXTRACT_DETECT_DOCUMENT_TEXT` - The Amazon Comprehend service uses the `DetectDocumentText` API operation.
        - `TEXTRACT_ANALYZE_DOCUMENT` - The Amazon Comprehend service uses the `AnalyzeDocument` API operation.
        """
        return pulumi.get(self, "document_read_action")

    @document_read_action.setter
    def document_read_action(self, value: pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadAction']):
        pulumi.set(self, "document_read_action", value)

    @property
    @pulumi.getter(name="documentReadMode")
    def document_read_mode(self) -> Optional[pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadMode']]:
        """
        Determines the text extraction actions for PDF files. Enter one of the following values:

        - `SERVICE_DEFAULT` - use the Amazon Comprehend service defaults for PDF files.
        - `FORCE_DOCUMENT_READ_ACTION` - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.
        """
        return pulumi.get(self, "document_read_mode")

    @document_read_mode.setter
    def document_read_mode(self, value: Optional[pulumi.Input['DocumentClassifierDocumentReaderConfigDocumentReadMode']]):
        pulumi.set(self, "document_read_mode", value)

    @property
    @pulumi.getter(name="featureTypes")
    def feature_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierDocumentReaderConfigFeatureTypesItem']]]]:
        """
        Specifies the type of Amazon Textract features to apply. If you chose `TEXTRACT_ANALYZE_DOCUMENT` as the read action, you must specify one or both of the following values:

        - `TABLES` - Returns additional information about any tables that are detected in the input document.
        - `FORMS` - Returns additional information about any forms that are detected in the input document.
        """
        return pulumi.get(self, "feature_types")

    @feature_types.setter
    def feature_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierDocumentReaderConfigFeatureTypesItem']]]]):
        pulumi.set(self, "feature_types", value)


if not MYPY:
    class DocumentClassifierDocumentsArgsDict(TypedDict):
        s3_uri: pulumi.Input[builtins.str]
        """
        The S3 URI location of the training documents specified in the S3Uri CSV file.
        """
        test_s3_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.
        """
elif False:
    DocumentClassifierDocumentsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentClassifierDocumentsArgs:
    def __init__(__self__, *,
                 s3_uri: pulumi.Input[builtins.str],
                 test_s3_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] s3_uri: The S3 URI location of the training documents specified in the S3Uri CSV file.
        :param pulumi.Input[builtins.str] test_s3_uri: The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if test_s3_uri is not None:
            pulumi.set(__self__, "test_s3_uri", test_s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[builtins.str]:
        """
        The S3 URI location of the training documents specified in the S3Uri CSV file.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="testS3Uri")
    def test_s3_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.
        """
        return pulumi.get(self, "test_s3_uri")

    @test_s3_uri.setter
    def test_s3_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_s3_uri", value)


if not MYPY:
    class DocumentClassifierInputDataConfigArgsDict(TypedDict):
        augmented_manifests: NotRequired[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierAugmentedManifestsListItemArgsDict']]]]
        """
        A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.

        This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST` .
        """
        data_format: NotRequired[pulumi.Input['DocumentClassifierInputDataConfigDataFormat']]
        """
        The format of your training data:

        - `COMPREHEND_CSV` : A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
        - `AUGMENTED_MANIFEST` : A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels.

        If you use this value, you must provide the `AugmentedManifests` parameter in your request.

        If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
        """
        document_reader_config: NotRequired[pulumi.Input['DocumentClassifierDocumentReaderConfigArgsDict']]
        document_type: NotRequired[pulumi.Input['DocumentClassifierInputDataConfigDocumentType']]
        """
        The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
        """
        documents: NotRequired[pulumi.Input['DocumentClassifierDocumentsArgsDict']]
        """
        The S3 location of the training documents. This parameter is required in a request to create a native document model.
        """
        label_delimiter: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
        """
        s3_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.

        For example, if you use the URI `S3://bucketName/prefix` , if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.

        This parameter is required if you set `DataFormat` to `COMPREHEND_CSV` .
        """
        test_s3_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same AWS Region as the API endpoint that you are calling.
        """
elif False:
    DocumentClassifierInputDataConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentClassifierInputDataConfigArgs:
    def __init__(__self__, *,
                 augmented_manifests: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierAugmentedManifestsListItemArgs']]]] = None,
                 data_format: Optional[pulumi.Input['DocumentClassifierInputDataConfigDataFormat']] = None,
                 document_reader_config: Optional[pulumi.Input['DocumentClassifierDocumentReaderConfigArgs']] = None,
                 document_type: Optional[pulumi.Input['DocumentClassifierInputDataConfigDocumentType']] = None,
                 documents: Optional[pulumi.Input['DocumentClassifierDocumentsArgs']] = None,
                 label_delimiter: Optional[pulumi.Input[builtins.str]] = None,
                 s3_uri: Optional[pulumi.Input[builtins.str]] = None,
                 test_s3_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DocumentClassifierAugmentedManifestsListItemArgs']]] augmented_manifests: A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
               
               This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST` .
        :param pulumi.Input['DocumentClassifierInputDataConfigDataFormat'] data_format: The format of your training data:
               
               - `COMPREHEND_CSV` : A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
               - `AUGMENTED_MANIFEST` : A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels.
               
               If you use this value, you must provide the `AugmentedManifests` parameter in your request.
               
               If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
        :param pulumi.Input['DocumentClassifierInputDataConfigDocumentType'] document_type: The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
        :param pulumi.Input['DocumentClassifierDocumentsArgs'] documents: The S3 location of the training documents. This parameter is required in a request to create a native document model.
        :param pulumi.Input[builtins.str] label_delimiter: Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
        :param pulumi.Input[builtins.str] s3_uri: The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
               
               For example, if you use the URI `S3://bucketName/prefix` , if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
               
               This parameter is required if you set `DataFormat` to `COMPREHEND_CSV` .
        :param pulumi.Input[builtins.str] test_s3_uri: This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same AWS Region as the API endpoint that you are calling.
        """
        if augmented_manifests is not None:
            pulumi.set(__self__, "augmented_manifests", augmented_manifests)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if document_reader_config is not None:
            pulumi.set(__self__, "document_reader_config", document_reader_config)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if documents is not None:
            pulumi.set(__self__, "documents", documents)
        if label_delimiter is not None:
            pulumi.set(__self__, "label_delimiter", label_delimiter)
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)
        if test_s3_uri is not None:
            pulumi.set(__self__, "test_s3_uri", test_s3_uri)

    @property
    @pulumi.getter(name="augmentedManifests")
    def augmented_manifests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierAugmentedManifestsListItemArgs']]]]:
        """
        A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.

        This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST` .
        """
        return pulumi.get(self, "augmented_manifests")

    @augmented_manifests.setter
    def augmented_manifests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierAugmentedManifestsListItemArgs']]]]):
        pulumi.set(self, "augmented_manifests", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input['DocumentClassifierInputDataConfigDataFormat']]:
        """
        The format of your training data:

        - `COMPREHEND_CSV` : A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
        - `AUGMENTED_MANIFEST` : A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels.

        If you use this value, you must provide the `AugmentedManifests` parameter in your request.

        If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input['DocumentClassifierInputDataConfigDataFormat']]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter(name="documentReaderConfig")
    def document_reader_config(self) -> Optional[pulumi.Input['DocumentClassifierDocumentReaderConfigArgs']]:
        return pulumi.get(self, "document_reader_config")

    @document_reader_config.setter
    def document_reader_config(self, value: Optional[pulumi.Input['DocumentClassifierDocumentReaderConfigArgs']]):
        pulumi.set(self, "document_reader_config", value)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[pulumi.Input['DocumentClassifierInputDataConfigDocumentType']]:
        """
        The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: Optional[pulumi.Input['DocumentClassifierInputDataConfigDocumentType']]):
        pulumi.set(self, "document_type", value)

    @property
    @pulumi.getter
    def documents(self) -> Optional[pulumi.Input['DocumentClassifierDocumentsArgs']]:
        """
        The S3 location of the training documents. This parameter is required in a request to create a native document model.
        """
        return pulumi.get(self, "documents")

    @documents.setter
    def documents(self, value: Optional[pulumi.Input['DocumentClassifierDocumentsArgs']]):
        pulumi.set(self, "documents", value)

    @property
    @pulumi.getter(name="labelDelimiter")
    def label_delimiter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
        """
        return pulumi.get(self, "label_delimiter")

    @label_delimiter.setter
    def label_delimiter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_delimiter", value)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.

        For example, if you use the URI `S3://bucketName/prefix` , if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.

        This parameter is required if you set `DataFormat` to `COMPREHEND_CSV` .
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="testS3Uri")
    def test_s3_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same AWS Region as the API endpoint that you are calling.
        """
        return pulumi.get(self, "test_s3_uri")

    @test_s3_uri.setter
    def test_s3_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "test_s3_uri", value)


if not MYPY:
    class DocumentClassifierOutputDataConfigArgsDict(TypedDict):
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId can be one of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        - KMS Key Alias: `"alias/ExampleAlias"`
        - ARN of a KMS Key Alias: `"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
        """
        s3_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        When you use the `OutputDataConfig` object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files. The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.

        When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The `S3Uri` field contains the location of the output file, called `output.tar.gz` . It is a compressed archive that contains the confusion matrix.
        """
elif False:
    DocumentClassifierOutputDataConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentClassifierOutputDataConfigArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 s3_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_id: ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId can be one of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
               - KMS Key Alias: `"alias/ExampleAlias"`
               - ARN of a KMS Key Alias: `"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
        :param pulumi.Input[builtins.str] s3_uri: When you use the `OutputDataConfig` object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files. The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.
               
               When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The `S3Uri` field contains the location of the output file, called `output.tar.gz` . It is a compressed archive that contains the confusion matrix.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId can be one of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        - KMS Key Alias: `"alias/ExampleAlias"`
        - ARN of a KMS Key Alias: `"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When you use the `OutputDataConfig` object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files. The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.

        When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The `S3Uri` field contains the location of the output file, called `output.tar.gz` . It is a compressed archive that contains the confusion matrix.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_uri", value)


if not MYPY:
    class DocumentClassifierVpcConfigArgsDict(TypedDict):
        security_group_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        """
        subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
elif False:
    DocumentClassifierVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentClassifierVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnets: The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnets", value)


if not MYPY:
    class FlywheelDataSecurityConfigArgsDict(TypedDict):
        data_lake_kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt the data in the data lake.
        """
        model_kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        """
        volume_kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt the volume.
        """
        vpc_config: NotRequired[pulumi.Input['FlywheelVpcConfigArgsDict']]
        """
        Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
elif False:
    FlywheelDataSecurityConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlywheelDataSecurityConfigArgs:
    def __init__(__self__, *,
                 data_lake_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input['FlywheelVpcConfigArgs']] = None):
        """
        :param pulumi.Input[builtins.str] data_lake_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt the data in the data lake.
        :param pulumi.Input[builtins.str] model_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        :param pulumi.Input[builtins.str] volume_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt the volume.
        :param pulumi.Input['FlywheelVpcConfigArgs'] vpc_config: Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        if data_lake_kms_key_id is not None:
            pulumi.set(__self__, "data_lake_kms_key_id", data_lake_kms_key_id)
        if model_kms_key_id is not None:
            pulumi.set(__self__, "model_kms_key_id", model_kms_key_id)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="dataLakeKmsKeyId")
    def data_lake_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt the data in the data lake.
        """
        return pulumi.get(self, "data_lake_kms_key_id")

    @data_lake_kms_key_id.setter
    def data_lake_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_lake_kms_key_id", value)

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        """
        return pulumi.get(self, "model_kms_key_id")

    @model_kms_key_id.setter
    def model_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_kms_key_id", value)

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt the volume.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @volume_kms_key_id.setter
    def volume_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_kms_key_id", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FlywheelVpcConfigArgs']]:
        """
        Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FlywheelVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


if not MYPY:
    class FlywheelDocumentClassificationConfigArgsDict(TypedDict):
        mode: pulumi.Input['FlywheelDocumentClassificationConfigMode']
        """
        Classification mode indicates whether the documents are `MULTI_CLASS` or `MULTI_LABEL` .
        """
        labels: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        One or more labels to associate with the custom classifier.
        """
elif False:
    FlywheelDocumentClassificationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlywheelDocumentClassificationConfigArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input['FlywheelDocumentClassificationConfigMode'],
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input['FlywheelDocumentClassificationConfigMode'] mode: Classification mode indicates whether the documents are `MULTI_CLASS` or `MULTI_LABEL` .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] labels: One or more labels to associate with the custom classifier.
        """
        pulumi.set(__self__, "mode", mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input['FlywheelDocumentClassificationConfigMode']:
        """
        Classification mode indicates whether the documents are `MULTI_CLASS` or `MULTI_LABEL` .
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input['FlywheelDocumentClassificationConfigMode']):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more labels to associate with the custom classifier.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class FlywheelEntityRecognitionConfigArgsDict(TypedDict):
        entity_types: NotRequired[pulumi.Input[Sequence[pulumi.Input['FlywheelEntityTypesListItemArgsDict']]]]
        """
        Up to 25 entity types that the model is trained to recognize.
        """
elif False:
    FlywheelEntityRecognitionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlywheelEntityRecognitionConfigArgs:
    def __init__(__self__, *,
                 entity_types: Optional[pulumi.Input[Sequence[pulumi.Input['FlywheelEntityTypesListItemArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['FlywheelEntityTypesListItemArgs']]] entity_types: Up to 25 entity types that the model is trained to recognize.
        """
        if entity_types is not None:
            pulumi.set(__self__, "entity_types", entity_types)

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlywheelEntityTypesListItemArgs']]]]:
        """
        Up to 25 entity types that the model is trained to recognize.
        """
        return pulumi.get(self, "entity_types")

    @entity_types.setter
    def entity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlywheelEntityTypesListItemArgs']]]]):
        pulumi.set(self, "entity_types", value)


if not MYPY:
    class FlywheelEntityTypesListItemArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.

        Entity types must not contain the following invalid characters: \\n (line break), \\\\n (escaped line break, \\r (carriage return), \\\\r (escaped carriage return), \\t (tab), \\\\t (escaped tab), and , (comma).
        """
elif False:
    FlywheelEntityTypesListItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlywheelEntityTypesListItemArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] type: An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.
               
               Entity types must not contain the following invalid characters: \\n (line break), \\\\n (escaped line break, \\r (carriage return), \\\\r (escaped carriage return), \\t (tab), \\\\t (escaped tab), and , (comma).
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.

        Entity types must not contain the following invalid characters: \\n (line break), \\\\n (escaped line break, \\r (carriage return), \\\\r (escaped carriage return), \\t (tab), \\\\t (escaped tab), and , (comma).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class FlywheelTaskConfigArgsDict(TypedDict):
        language_code: pulumi.Input['FlywheelTaskConfigLanguageCode']
        """
        Language code for the language that the model supports.
        """
        document_classification_config: NotRequired[pulumi.Input['FlywheelDocumentClassificationConfigArgsDict']]
        """
        Configuration required for a document classification model.
        """
        entity_recognition_config: NotRequired[pulumi.Input['FlywheelEntityRecognitionConfigArgsDict']]
        """
        Configuration required for an entity recognition model.
        """
elif False:
    FlywheelTaskConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlywheelTaskConfigArgs:
    def __init__(__self__, *,
                 language_code: pulumi.Input['FlywheelTaskConfigLanguageCode'],
                 document_classification_config: Optional[pulumi.Input['FlywheelDocumentClassificationConfigArgs']] = None,
                 entity_recognition_config: Optional[pulumi.Input['FlywheelEntityRecognitionConfigArgs']] = None):
        """
        :param pulumi.Input['FlywheelTaskConfigLanguageCode'] language_code: Language code for the language that the model supports.
        :param pulumi.Input['FlywheelDocumentClassificationConfigArgs'] document_classification_config: Configuration required for a document classification model.
        :param pulumi.Input['FlywheelEntityRecognitionConfigArgs'] entity_recognition_config: Configuration required for an entity recognition model.
        """
        pulumi.set(__self__, "language_code", language_code)
        if document_classification_config is not None:
            pulumi.set(__self__, "document_classification_config", document_classification_config)
        if entity_recognition_config is not None:
            pulumi.set(__self__, "entity_recognition_config", entity_recognition_config)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input['FlywheelTaskConfigLanguageCode']:
        """
        Language code for the language that the model supports.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input['FlywheelTaskConfigLanguageCode']):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="documentClassificationConfig")
    def document_classification_config(self) -> Optional[pulumi.Input['FlywheelDocumentClassificationConfigArgs']]:
        """
        Configuration required for a document classification model.
        """
        return pulumi.get(self, "document_classification_config")

    @document_classification_config.setter
    def document_classification_config(self, value: Optional[pulumi.Input['FlywheelDocumentClassificationConfigArgs']]):
        pulumi.set(self, "document_classification_config", value)

    @property
    @pulumi.getter(name="entityRecognitionConfig")
    def entity_recognition_config(self) -> Optional[pulumi.Input['FlywheelEntityRecognitionConfigArgs']]:
        """
        Configuration required for an entity recognition model.
        """
        return pulumi.get(self, "entity_recognition_config")

    @entity_recognition_config.setter
    def entity_recognition_config(self, value: Optional[pulumi.Input['FlywheelEntityRecognitionConfigArgs']]):
        pulumi.set(self, "entity_recognition_config", value)


if not MYPY:
    class FlywheelVpcConfigArgsDict(TypedDict):
        security_group_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        """
        subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
elif False:
    FlywheelVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlywheelVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnets: The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnets", value)


