# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserPoolGroupArgs', 'UserPoolGroup']

@pulumi.input_type
class UserPoolGroupArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 precedence: Optional[pulumi.Input[builtins.int]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a UserPoolGroup resource.
        :param pulumi.Input[builtins.str] user_pool_id: The ID of the user pool where you want to create a user group.
        :param pulumi.Input[builtins.str] description: A description of the group that you're creating.
        :param pulumi.Input[builtins.str] group_name: A name for the group. This name must be unique in your user pool.
        :param pulumi.Input[builtins.int] precedence: A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower `Precedence` values take precedence over groups with higher or null `Precedence` values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the `cognito:roles` and `cognito:preferred_role` claims.
               
               Two groups can have the same `Precedence` value. If this happens, neither group takes precedence over the other. If two groups with the same `Precedence` have the same role ARN, that role is used in the `cognito:preferred_role` claim in tokens for users in each group. If the two groups have different role ARNs, the `cognito:preferred_role` claim isn't set in users' tokens.
               
               The default `Precedence` value is null. The maximum `Precedence` value is `2^31-1` .
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) for the IAM role that you want to associate with the group. A group role primarily declares a preferred role for the credentials that you get from an identity pool. Amazon Cognito ID tokens have a `cognito:preferred_role` claim that presents the highest-precedence group that a user belongs to. Both ID and access tokens also contain a `cognito:groups` claim that list all the groups that a user is a member of.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if precedence is not None:
            pulumi.set(__self__, "precedence", precedence)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the user pool where you want to create a user group.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the group that you're creating.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the group. This name must be unique in your user pool.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter
    def precedence(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower `Precedence` values take precedence over groups with higher or null `Precedence` values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the `cognito:roles` and `cognito:preferred_role` claims.

        Two groups can have the same `Precedence` value. If this happens, neither group takes precedence over the other. If two groups with the same `Precedence` have the same role ARN, that role is used in the `cognito:preferred_role` claim in tokens for users in each group. If the two groups have different role ARNs, the `cognito:preferred_role` claim isn't set in users' tokens.

        The default `Precedence` value is null. The maximum `Precedence` value is `2^31-1` .
        """
        return pulumi.get(self, "precedence")

    @precedence.setter
    def precedence(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "precedence", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that you want to associate with the group. A group role primarily declares a preferred role for the credentials that you get from an identity pool. Amazon Cognito ID tokens have a `cognito:preferred_role` claim that presents the highest-precedence group that a user belongs to. Both ID and access tokens also contain a `cognito:groups` claim that list all the groups that a user is a member of.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.type_token("aws-native:cognito:UserPoolGroup")
class UserPoolGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 precedence: Optional[pulumi.Input[builtins.int]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Cognito::UserPoolGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the group that you're creating.
        :param pulumi.Input[builtins.str] group_name: A name for the group. This name must be unique in your user pool.
        :param pulumi.Input[builtins.int] precedence: A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower `Precedence` values take precedence over groups with higher or null `Precedence` values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the `cognito:roles` and `cognito:preferred_role` claims.
               
               Two groups can have the same `Precedence` value. If this happens, neither group takes precedence over the other. If two groups with the same `Precedence` have the same role ARN, that role is used in the `cognito:preferred_role` claim in tokens for users in each group. If the two groups have different role ARNs, the `cognito:preferred_role` claim isn't set in users' tokens.
               
               The default `Precedence` value is null. The maximum `Precedence` value is `2^31-1` .
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) for the IAM role that you want to associate with the group. A group role primarily declares a preferred role for the credentials that you get from an identity pool. Amazon Cognito ID tokens have a `cognito:preferred_role` claim that presents the highest-precedence group that a user belongs to. Both ID and access tokens also contain a `cognito:groups` claim that list all the groups that a user is a member of.
        :param pulumi.Input[builtins.str] user_pool_id: The ID of the user pool where you want to create a user group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserPoolGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Cognito::UserPoolGroup

        :param str resource_name: The name of the resource.
        :param UserPoolGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserPoolGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 precedence: Optional[pulumi.Input[builtins.int]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserPoolGroupArgs.__new__(UserPoolGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["precedence"] = precedence
            __props__.__dict__["role_arn"] = role_arn
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["groupName", "userPoolId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(UserPoolGroup, __self__).__init__(
            'aws-native:cognito:UserPoolGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'UserPoolGroup':
        """
        Get an existing UserPoolGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = UserPoolGroupArgs.__new__(UserPoolGroupArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["group_name"] = None
        __props__.__dict__["precedence"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["user_pool_id"] = None
        return UserPoolGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the group that you're creating.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A name for the group. This name must be unique in your user pool.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def precedence(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower `Precedence` values take precedence over groups with higher or null `Precedence` values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the `cognito:roles` and `cognito:preferred_role` claims.

        Two groups can have the same `Precedence` value. If this happens, neither group takes precedence over the other. If two groups with the same `Precedence` have the same role ARN, that role is used in the `cognito:preferred_role` claim in tokens for users in each group. If the two groups have different role ARNs, the `cognito:preferred_role` claim isn't set in users' tokens.

        The default `Precedence` value is null. The maximum `Precedence` value is `2^31-1` .
        """
        return pulumi.get(self, "precedence")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that you want to associate with the group. A group role primarily declares a preferred role for the credentials that you get from an identity pool. Amazon Cognito ID tokens have a `cognito:preferred_role` claim that presents the highest-precedence group that a user belongs to. Both ID and access tokens also contain a `cognito:groups` claim that list all the groups that a user is a member of.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the user pool where you want to create a user group.
        """
        return pulumi.get(self, "user_pool_id")

