# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'IdentityPoolCognitoIdentityProvider',
    'IdentityPoolCognitoStreams',
    'IdentityPoolPushSync',
    'IdentityPoolRoleAttachmentMappingRule',
    'IdentityPoolRoleAttachmentRoleMapping',
    'IdentityPoolRoleAttachmentRulesConfigurationType',
    'LogDeliveryConfigurationCloudWatchLogsConfiguration',
    'LogDeliveryConfigurationFirehoseConfiguration',
    'LogDeliveryConfigurationLogConfiguration',
    'LogDeliveryConfigurationS3Configuration',
    'ManagedLoginBrandingAssetType',
    'UserPoolAccountRecoverySetting',
    'UserPoolAddOns',
    'UserPoolAdminCreateUserConfig',
    'UserPoolAdvancedSecurityAdditionalFlows',
    'UserPoolClientAnalyticsConfiguration',
    'UserPoolClientRefreshTokenRotation',
    'UserPoolClientTokenValidityUnits',
    'UserPoolCustomEmailSender',
    'UserPoolCustomSmsSender',
    'UserPoolDeviceConfiguration',
    'UserPoolDomainCustomDomainConfigType',
    'UserPoolEmailConfiguration',
    'UserPoolInviteMessageTemplate',
    'UserPoolLambdaConfig',
    'UserPoolNumberAttributeConstraints',
    'UserPoolPasswordPolicy',
    'UserPoolPolicies',
    'UserPoolPreTokenGenerationConfig',
    'UserPoolRecoveryOption',
    'UserPoolResourceServerResourceServerScopeType',
    'UserPoolRiskConfigurationAttachmentAccountTakeoverActionType',
    'UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType',
    'UserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType',
    'UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType',
    'UserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationType',
    'UserPoolRiskConfigurationAttachmentNotifyConfigurationType',
    'UserPoolRiskConfigurationAttachmentNotifyEmailType',
    'UserPoolRiskConfigurationAttachmentRiskExceptionConfigurationType',
    'UserPoolSchemaAttribute',
    'UserPoolSignInPolicy',
    'UserPoolSmsConfiguration',
    'UserPoolStringAttributeConstraints',
    'UserPoolUserAttributeType',
    'UserPoolUserAttributeUpdateSettings',
    'UserPoolUsernameConfiguration',
    'UserPoolVerificationMessageTemplate',
]

@pulumi.output_type
class IdentityPoolCognitoIdentityProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "providerName":
            suggest = "provider_name"
        elif key == "serverSideTokenCheck":
            suggest = "server_side_token_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolCognitoIdentityProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolCognitoIdentityProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolCognitoIdentityProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: builtins.str,
                 provider_name: builtins.str,
                 server_side_token_check: Optional[builtins.bool] = None):
        """
        :param builtins.str client_id: The client ID for the Amazon Cognito user pool.
        :param builtins.str provider_name: The provider name for an Amazon Cognito user pool. For example: `cognito-idp.us-east-2.amazonaws.com/us-east-2_123456789` .
        :param builtins.bool server_side_token_check: TRUE if server-side token validation is enabled for the identity provider’s token.
               
               After you set the `ServerSideTokenCheck` to TRUE for an identity pool, that identity pool checks with the integrated user pools to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
               
               If the user is signed out or deleted, the identity pool returns a 400 Not Authorized error.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "provider_name", provider_name)
        if server_side_token_check is not None:
            pulumi.set(__self__, "server_side_token_check", server_side_token_check)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        The client ID for the Amazon Cognito user pool.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> builtins.str:
        """
        The provider name for an Amazon Cognito user pool. For example: `cognito-idp.us-east-2.amazonaws.com/us-east-2_123456789` .
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="serverSideTokenCheck")
    def server_side_token_check(self) -> Optional[builtins.bool]:
        """
        TRUE if server-side token validation is enabled for the identity provider’s token.

        After you set the `ServerSideTokenCheck` to TRUE for an identity pool, that identity pool checks with the integrated user pools to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.

        If the user is signed out or deleted, the identity pool returns a 400 Not Authorized error.
        """
        return pulumi.get(self, "server_side_token_check")


@pulumi.output_type
class IdentityPoolCognitoStreams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "streamName":
            suggest = "stream_name"
        elif key == "streamingStatus":
            suggest = "streaming_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolCognitoStreams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolCognitoStreams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolCognitoStreams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[builtins.str] = None,
                 stream_name: Optional[builtins.str] = None,
                 streaming_status: Optional[builtins.str] = None):
        """
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the role Amazon Cognito can assume to publish to the stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke `PutRecord` on your Amazon Cognito stream.
        :param builtins.str stream_name: The name of the Amazon Cognito stream to receive updates. This stream must be in the developer's account and in the same Region as the identity pool.
        :param builtins.str streaming_status: Status of the Amazon Cognito streams. Valid values are: `ENABLED` or `DISABLED` .
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)
        if streaming_status is not None:
            pulumi.set(__self__, "streaming_status", streaming_status)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the role Amazon Cognito can assume to publish to the stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke `PutRecord` on your Amazon Cognito stream.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[builtins.str]:
        """
        The name of the Amazon Cognito stream to receive updates. This stream must be in the developer's account and in the same Region as the identity pool.
        """
        return pulumi.get(self, "stream_name")

    @property
    @pulumi.getter(name="streamingStatus")
    def streaming_status(self) -> Optional[builtins.str]:
        """
        Status of the Amazon Cognito streams. Valid values are: `ENABLED` or `DISABLED` .
        """
        return pulumi.get(self, "streaming_status")


@pulumi.output_type
class IdentityPoolPushSync(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationArns":
            suggest = "application_arns"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolPushSync. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolPushSync.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolPushSync.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_arns: Optional[Sequence[builtins.str]] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] application_arns: The ARNs of the Amazon SNS platform applications that could be used by clients.
        :param builtins.str role_arn: An IAM role configured to allow Amazon Cognito to call Amazon SNS on behalf of the developer.
        """
        if application_arns is not None:
            pulumi.set(__self__, "application_arns", application_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="applicationArns")
    def application_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        The ARNs of the Amazon SNS platform applications that could be used by clients.
        """
        return pulumi.get(self, "application_arns")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        An IAM role configured to allow Amazon Cognito to call Amazon SNS on behalf of the developer.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class IdentityPoolRoleAttachmentMappingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolRoleAttachmentMappingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolRoleAttachmentMappingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolRoleAttachmentMappingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim: builtins.str,
                 match_type: builtins.str,
                 role_arn: builtins.str,
                 value: builtins.str):
        pulumi.set(__self__, "claim", claim)
        pulumi.set(__self__, "match_type", match_type)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def claim(self) -> builtins.str:
        return pulumi.get(self, "claim")

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> builtins.str:
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class IdentityPoolRoleAttachmentRoleMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ambiguousRoleResolution":
            suggest = "ambiguous_role_resolution"
        elif key == "identityProvider":
            suggest = "identity_provider"
        elif key == "rulesConfiguration":
            suggest = "rules_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolRoleAttachmentRoleMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolRoleAttachmentRoleMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolRoleAttachmentRoleMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 ambiguous_role_resolution: Optional[builtins.str] = None,
                 identity_provider: Optional[builtins.str] = None,
                 rules_configuration: Optional['outputs.IdentityPoolRoleAttachmentRulesConfigurationType'] = None):
        pulumi.set(__self__, "type", type)
        if ambiguous_role_resolution is not None:
            pulumi.set(__self__, "ambiguous_role_resolution", ambiguous_role_resolution)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if rules_configuration is not None:
            pulumi.set(__self__, "rules_configuration", rules_configuration)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="ambiguousRoleResolution")
    def ambiguous_role_resolution(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ambiguous_role_resolution")

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[builtins.str]:
        return pulumi.get(self, "identity_provider")

    @property
    @pulumi.getter(name="rulesConfiguration")
    def rules_configuration(self) -> Optional['outputs.IdentityPoolRoleAttachmentRulesConfigurationType']:
        return pulumi.get(self, "rules_configuration")


@pulumi.output_type
class IdentityPoolRoleAttachmentRulesConfigurationType(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.IdentityPoolRoleAttachmentMappingRule']):
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.IdentityPoolRoleAttachmentMappingRule']:
        return pulumi.get(self, "rules")


@pulumi.output_type
class LogDeliveryConfigurationCloudWatchLogsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupArn":
            suggest = "log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryConfigurationCloudWatchLogsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryConfigurationCloudWatchLogsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryConfigurationCloudWatchLogsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_arn: Optional[builtins.str] = None):
        if log_group_arn is not None:
            pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "log_group_arn")


@pulumi.output_type
class LogDeliveryConfigurationFirehoseConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryConfigurationFirehoseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryConfigurationFirehoseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryConfigurationFirehoseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream_arn: Optional[builtins.str] = None):
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class LogDeliveryConfigurationLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogsConfiguration":
            suggest = "cloud_watch_logs_configuration"
        elif key == "eventSource":
            suggest = "event_source"
        elif key == "firehoseConfiguration":
            suggest = "firehose_configuration"
        elif key == "logLevel":
            suggest = "log_level"
        elif key == "s3Configuration":
            suggest = "s3_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryConfigurationLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryConfigurationLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryConfigurationLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs_configuration: Optional['outputs.LogDeliveryConfigurationCloudWatchLogsConfiguration'] = None,
                 event_source: Optional[builtins.str] = None,
                 firehose_configuration: Optional['outputs.LogDeliveryConfigurationFirehoseConfiguration'] = None,
                 log_level: Optional[builtins.str] = None,
                 s3_configuration: Optional['outputs.LogDeliveryConfigurationS3Configuration'] = None):
        if cloud_watch_logs_configuration is not None:
            pulumi.set(__self__, "cloud_watch_logs_configuration", cloud_watch_logs_configuration)
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if firehose_configuration is not None:
            pulumi.set(__self__, "firehose_configuration", firehose_configuration)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if s3_configuration is not None:
            pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="cloudWatchLogsConfiguration")
    def cloud_watch_logs_configuration(self) -> Optional['outputs.LogDeliveryConfigurationCloudWatchLogsConfiguration']:
        return pulumi.get(self, "cloud_watch_logs_configuration")

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[builtins.str]:
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="firehoseConfiguration")
    def firehose_configuration(self) -> Optional['outputs.LogDeliveryConfigurationFirehoseConfiguration']:
        return pulumi.get(self, "firehose_configuration")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> Optional['outputs.LogDeliveryConfigurationS3Configuration']:
        return pulumi.get(self, "s3_configuration")


@pulumi.output_type
class LogDeliveryConfigurationS3Configuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryConfigurationS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryConfigurationS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryConfigurationS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: Optional[builtins.str] = None):
        if bucket_arn is not None:
            pulumi.set(__self__, "bucket_arn", bucket_arn)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "bucket_arn")


@pulumi.output_type
class ManagedLoginBrandingAssetType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "colorMode":
            suggest = "color_mode"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedLoginBrandingAssetType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedLoginBrandingAssetType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedLoginBrandingAssetType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: 'ManagedLoginBrandingCategoryType',
                 color_mode: 'ManagedLoginBrandingColorModeType',
                 extension: 'ManagedLoginBrandingExtensionType',
                 bytes: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None):
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "color_mode", color_mode)
        pulumi.set(__self__, "extension", extension)
        if bytes is not None:
            pulumi.set(__self__, "bytes", bytes)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def category(self) -> 'ManagedLoginBrandingCategoryType':
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="colorMode")
    def color_mode(self) -> 'ManagedLoginBrandingColorModeType':
        return pulumi.get(self, "color_mode")

    @property
    @pulumi.getter
    def extension(self) -> 'ManagedLoginBrandingExtensionType':
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def bytes(self) -> Optional[builtins.str]:
        return pulumi.get(self, "bytes")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class UserPoolAccountRecoverySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryMechanisms":
            suggest = "recovery_mechanisms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolAccountRecoverySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolAccountRecoverySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolAccountRecoverySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recovery_mechanisms: Optional[Sequence['outputs.UserPoolRecoveryOption']] = None):
        """
        :param Sequence['UserPoolRecoveryOption'] recovery_mechanisms: The list of options and priorities for user message delivery in forgot-password operations. Sets or displays user pool preferences for email or SMS message priority, whether users should fall back to a second delivery method, and whether passwords should only be reset by administrators.
        """
        if recovery_mechanisms is not None:
            pulumi.set(__self__, "recovery_mechanisms", recovery_mechanisms)

    @property
    @pulumi.getter(name="recoveryMechanisms")
    def recovery_mechanisms(self) -> Optional[Sequence['outputs.UserPoolRecoveryOption']]:
        """
        The list of options and priorities for user message delivery in forgot-password operations. Sets or displays user pool preferences for email or SMS message priority, whether users should fall back to a second delivery method, and whether passwords should only be reset by administrators.
        """
        return pulumi.get(self, "recovery_mechanisms")


@pulumi.output_type
class UserPoolAddOns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedSecurityAdditionalFlows":
            suggest = "advanced_security_additional_flows"
        elif key == "advancedSecurityMode":
            suggest = "advanced_security_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolAddOns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolAddOns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolAddOns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_security_additional_flows: Optional['outputs.UserPoolAdvancedSecurityAdditionalFlows'] = None,
                 advanced_security_mode: Optional[builtins.str] = None):
        """
        :param 'UserPoolAdvancedSecurityAdditionalFlows' advanced_security_additional_flows: Threat protection configuration options for additional authentication types in your user pool, including custom authentication.
        :param builtins.str advanced_security_mode: The operating mode of threat protection for standard authentication types in your user pool, including username-password and secure remote password (SRP) authentication.
        """
        if advanced_security_additional_flows is not None:
            pulumi.set(__self__, "advanced_security_additional_flows", advanced_security_additional_flows)
        if advanced_security_mode is not None:
            pulumi.set(__self__, "advanced_security_mode", advanced_security_mode)

    @property
    @pulumi.getter(name="advancedSecurityAdditionalFlows")
    def advanced_security_additional_flows(self) -> Optional['outputs.UserPoolAdvancedSecurityAdditionalFlows']:
        """
        Threat protection configuration options for additional authentication types in your user pool, including custom authentication.
        """
        return pulumi.get(self, "advanced_security_additional_flows")

    @property
    @pulumi.getter(name="advancedSecurityMode")
    def advanced_security_mode(self) -> Optional[builtins.str]:
        """
        The operating mode of threat protection for standard authentication types in your user pool, including username-password and secure remote password (SRP) authentication.
        """
        return pulumi.get(self, "advanced_security_mode")


@pulumi.output_type
class UserPoolAdminCreateUserConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowAdminCreateUserOnly":
            suggest = "allow_admin_create_user_only"
        elif key == "inviteMessageTemplate":
            suggest = "invite_message_template"
        elif key == "unusedAccountValidityDays":
            suggest = "unused_account_validity_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolAdminCreateUserConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolAdminCreateUserConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolAdminCreateUserConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_admin_create_user_only: Optional[builtins.bool] = None,
                 invite_message_template: Optional['outputs.UserPoolInviteMessageTemplate'] = None,
                 unused_account_validity_days: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_admin_create_user_only: The setting for allowing self-service sign-up. When `true` , only administrators can create new user profiles. When `false` , users can register themselves and create a new user profile with the `SignUp` operation.
        :param 'UserPoolInviteMessageTemplate' invite_message_template: The template for the welcome message to new users. This template must include the `{####}` temporary password placeholder if you are creating users with passwords. If your users don't have passwords, you can omit the placeholder.
               
               See also [Customizing User Invitation Messages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization) .
        :param builtins.int unused_account_validity_days: This parameter is no longer in use.
               
               The password expiration limit in days for administrator-created users. When this time expires, the user can't sign in with their temporary password. To reset the account after that time limit, you must call `AdminCreateUser` again, specifying `RESEND` for the `MessageAction` parameter.
               
               The default value for this parameter is 7.
        """
        if allow_admin_create_user_only is not None:
            pulumi.set(__self__, "allow_admin_create_user_only", allow_admin_create_user_only)
        if invite_message_template is not None:
            pulumi.set(__self__, "invite_message_template", invite_message_template)
        if unused_account_validity_days is not None:
            pulumi.set(__self__, "unused_account_validity_days", unused_account_validity_days)

    @property
    @pulumi.getter(name="allowAdminCreateUserOnly")
    def allow_admin_create_user_only(self) -> Optional[builtins.bool]:
        """
        The setting for allowing self-service sign-up. When `true` , only administrators can create new user profiles. When `false` , users can register themselves and create a new user profile with the `SignUp` operation.
        """
        return pulumi.get(self, "allow_admin_create_user_only")

    @property
    @pulumi.getter(name="inviteMessageTemplate")
    def invite_message_template(self) -> Optional['outputs.UserPoolInviteMessageTemplate']:
        """
        The template for the welcome message to new users. This template must include the `{####}` temporary password placeholder if you are creating users with passwords. If your users don't have passwords, you can omit the placeholder.

        See also [Customizing User Invitation Messages](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization) .
        """
        return pulumi.get(self, "invite_message_template")

    @property
    @pulumi.getter(name="unusedAccountValidityDays")
    def unused_account_validity_days(self) -> Optional[builtins.int]:
        """
        This parameter is no longer in use.

        The password expiration limit in days for administrator-created users. When this time expires, the user can't sign in with their temporary password. To reset the account after that time limit, you must call `AdminCreateUser` again, specifying `RESEND` for the `MessageAction` parameter.

        The default value for this parameter is 7.
        """
        return pulumi.get(self, "unused_account_validity_days")


@pulumi.output_type
class UserPoolAdvancedSecurityAdditionalFlows(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customAuthMode":
            suggest = "custom_auth_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolAdvancedSecurityAdditionalFlows. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolAdvancedSecurityAdditionalFlows.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolAdvancedSecurityAdditionalFlows.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_auth_mode: Optional[builtins.str] = None):
        """
        :param builtins.str custom_auth_mode: The operating mode of threat protection in custom authentication with [Custom authentication challenge Lambda triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        """
        if custom_auth_mode is not None:
            pulumi.set(__self__, "custom_auth_mode", custom_auth_mode)

    @property
    @pulumi.getter(name="customAuthMode")
    def custom_auth_mode(self) -> Optional[builtins.str]:
        """
        The operating mode of threat protection in custom authentication with [Custom authentication challenge Lambda triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        """
        return pulumi.get(self, "custom_auth_mode")


@pulumi.output_type
class UserPoolClientAnalyticsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationArn":
            suggest = "application_arn"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "userDataShared":
            suggest = "user_data_shared"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolClientAnalyticsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolClientAnalyticsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolClientAnalyticsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_arn: Optional[builtins.str] = None,
                 application_id: Optional[builtins.str] = None,
                 external_id: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None,
                 user_data_shared: Optional[builtins.bool] = None):
        """
        :param builtins.str application_arn: The Amazon Resource Name (ARN) of an Amazon Pinpoint project that you want to connect to your user pool app client. Amazon Cognito publishes events to the Amazon Pinpoint project that `ApplicationArn` declares. You can also configure your application to pass an endpoint ID in the `AnalyticsMetadata` parameter of sign-in operations. The endpoint ID is information about the destination for push notifications
        :param builtins.str application_id: Your Amazon Pinpoint project ID.
        :param builtins.str external_id: The [external ID](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html) of the role that Amazon Cognito assumes to send analytics data to Amazon Pinpoint.
        :param builtins.str role_arn: The ARN of an AWS Identity and Access Management role that has the permissions required for Amazon Cognito to publish events to Amazon Pinpoint analytics.
        :param builtins.bool user_data_shared: If `UserDataShared` is `true` , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if user_data_shared is not None:
            pulumi.set(__self__, "user_data_shared", user_data_shared)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an Amazon Pinpoint project that you want to connect to your user pool app client. Amazon Cognito publishes events to the Amazon Pinpoint project that `ApplicationArn` declares. You can also configure your application to pass an endpoint ID in the `AnalyticsMetadata` parameter of sign-in operations. The endpoint ID is information about the destination for push notifications
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        Your Amazon Pinpoint project ID.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        The [external ID](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html) of the role that Amazon Cognito assumes to send analytics data to Amazon Pinpoint.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of an AWS Identity and Access Management role that has the permissions required for Amazon Cognito to publish events to Amazon Pinpoint analytics.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="userDataShared")
    def user_data_shared(self) -> Optional[builtins.bool]:
        """
        If `UserDataShared` is `true` , Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
        """
        return pulumi.get(self, "user_data_shared")


@pulumi.output_type
class UserPoolClientRefreshTokenRotation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retryGracePeriodSeconds":
            suggest = "retry_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolClientRefreshTokenRotation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolClientRefreshTokenRotation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolClientRefreshTokenRotation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature: Optional['UserPoolClientRefreshTokenRotationFeature'] = None,
                 retry_grace_period_seconds: Optional[builtins.int] = None):
        """
        :param 'UserPoolClientRefreshTokenRotationFeature' feature: The state of refresh token rotation for the current app client.
        :param builtins.int retry_grace_period_seconds: When you request a token refresh with `GetTokensFromRefreshToken` , the original refresh token that you're rotating out can remain valid for a period of time of up to 60 seconds. This allows for client-side retries. When `RetryGracePeriodSeconds` is `0` , the grace period is disabled and a successful request immediately invalidates the submitted refresh token.
        """
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if retry_grace_period_seconds is not None:
            pulumi.set(__self__, "retry_grace_period_seconds", retry_grace_period_seconds)

    @property
    @pulumi.getter
    def feature(self) -> Optional['UserPoolClientRefreshTokenRotationFeature']:
        """
        The state of refresh token rotation for the current app client.
        """
        return pulumi.get(self, "feature")

    @property
    @pulumi.getter(name="retryGracePeriodSeconds")
    def retry_grace_period_seconds(self) -> Optional[builtins.int]:
        """
        When you request a token refresh with `GetTokensFromRefreshToken` , the original refresh token that you're rotating out can remain valid for a period of time of up to 60 seconds. This allows for client-side retries. When `RetryGracePeriodSeconds` is `0` , the grace period is disabled and a successful request immediately invalidates the submitted refresh token.
        """
        return pulumi.get(self, "retry_grace_period_seconds")


@pulumi.output_type
class UserPoolClientTokenValidityUnits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "idToken":
            suggest = "id_token"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolClientTokenValidityUnits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolClientTokenValidityUnits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolClientTokenValidityUnits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[builtins.str] = None,
                 id_token: Optional[builtins.str] = None,
                 refresh_token: Optional[builtins.str] = None):
        """
        :param builtins.str access_token: A time unit for the value that you set in the `AccessTokenValidity` parameter. The default `AccessTokenValidity` time unit is `hours` . `AccessTokenValidity` duration can range from five minutes to one day.
        :param builtins.str id_token: A time unit for the value that you set in the `IdTokenValidity` parameter. The default `IdTokenValidity` time unit is `hours` . `IdTokenValidity` duration can range from five minutes to one day.
        :param builtins.str refresh_token: A time unit for the value that you set in the `RefreshTokenValidity` parameter. The default `RefreshTokenValidity` time unit is `days` . `RefreshTokenValidity` duration can range from 60 minutes to 10 years.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if id_token is not None:
            pulumi.set(__self__, "id_token", id_token)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[builtins.str]:
        """
        A time unit for the value that you set in the `AccessTokenValidity` parameter. The default `AccessTokenValidity` time unit is `hours` . `AccessTokenValidity` duration can range from five minutes to one day.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> Optional[builtins.str]:
        """
        A time unit for the value that you set in the `IdTokenValidity` parameter. The default `IdTokenValidity` time unit is `hours` . `IdTokenValidity` duration can range from five minutes to one day.
        """
        return pulumi.get(self, "id_token")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[builtins.str]:
        """
        A time unit for the value that you set in the `RefreshTokenValidity` parameter. The default `RefreshTokenValidity` time unit is `days` . `RefreshTokenValidity` duration can range from 60 minutes to 10 years.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class UserPoolCustomEmailSender(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "lambdaVersion":
            suggest = "lambda_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolCustomEmailSender. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolCustomEmailSender.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolCustomEmailSender.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: Optional[builtins.str] = None,
                 lambda_version: Optional[builtins.str] = None):
        """
        :param builtins.str lambda_arn: The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.
        :param builtins.str lambda_version: The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.
               
               You must use a `LambdaVersion` of `V1_0` with a custom sender function.
        """
        if lambda_arn is not None:
            pulumi.set(__self__, "lambda_arn", lambda_arn)
        if lambda_version is not None:
            pulumi.set(__self__, "lambda_version", lambda_version)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="lambdaVersion")
    def lambda_version(self) -> Optional[builtins.str]:
        """
        The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.

        You must use a `LambdaVersion` of `V1_0` with a custom sender function.
        """
        return pulumi.get(self, "lambda_version")


@pulumi.output_type
class UserPoolCustomSmsSender(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "lambdaVersion":
            suggest = "lambda_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolCustomSmsSender. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolCustomSmsSender.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolCustomSmsSender.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: Optional[builtins.str] = None,
                 lambda_version: Optional[builtins.str] = None):
        """
        :param builtins.str lambda_arn: The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.
        :param builtins.str lambda_version: The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.
               
               You must use a `LambdaVersion` of `V1_0` with a custom sender function.
        """
        if lambda_arn is not None:
            pulumi.set(__self__, "lambda_arn", lambda_arn)
        if lambda_version is not None:
            pulumi.set(__self__, "lambda_version", lambda_version)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="lambdaVersion")
    def lambda_version(self) -> Optional[builtins.str]:
        """
        The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.

        You must use a `LambdaVersion` of `V1_0` with a custom sender function.
        """
        return pulumi.get(self, "lambda_version")


@pulumi.output_type
class UserPoolDeviceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "challengeRequiredOnNewDevice":
            suggest = "challenge_required_on_new_device"
        elif key == "deviceOnlyRememberedOnUserPrompt":
            suggest = "device_only_remembered_on_user_prompt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolDeviceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolDeviceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolDeviceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 challenge_required_on_new_device: Optional[builtins.bool] = None,
                 device_only_remembered_on_user_prompt: Optional[builtins.bool] = None):
        """
        :param builtins.bool challenge_required_on_new_device: When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
               
               > Whether or not `ChallengeRequiredOnNewDevice` is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
        :param builtins.bool device_only_remembered_on_user_prompt: When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a `ConfirmDevice` API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user's choice in an `UpdateDeviceStatus` API request.
               
               When `DeviceOnlyRememberedOnUserPrompt` is `false` , Amazon Cognito immediately remembers devices that you register in a `ConfirmDevice` API request.
        """
        if challenge_required_on_new_device is not None:
            pulumi.set(__self__, "challenge_required_on_new_device", challenge_required_on_new_device)
        if device_only_remembered_on_user_prompt is not None:
            pulumi.set(__self__, "device_only_remembered_on_user_prompt", device_only_remembered_on_user_prompt)

    @property
    @pulumi.getter(name="challengeRequiredOnNewDevice")
    def challenge_required_on_new_device(self) -> Optional[builtins.bool]:
        """
        When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).

        > Whether or not `ChallengeRequiredOnNewDevice` is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
        """
        return pulumi.get(self, "challenge_required_on_new_device")

    @property
    @pulumi.getter(name="deviceOnlyRememberedOnUserPrompt")
    def device_only_remembered_on_user_prompt(self) -> Optional[builtins.bool]:
        """
        When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a `ConfirmDevice` API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user's choice in an `UpdateDeviceStatus` API request.

        When `DeviceOnlyRememberedOnUserPrompt` is `false` , Amazon Cognito immediately remembers devices that you register in a `ConfirmDevice` API request.
        """
        return pulumi.get(self, "device_only_remembered_on_user_prompt")


@pulumi.output_type
class UserPoolDomainCustomDomainConfigType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolDomainCustomDomainConfigType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolDomainCustomDomainConfigType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolDomainCustomDomainConfigType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_arn: Optional[builtins.str] = None):
        """
        :param builtins.str certificate_arn: The Amazon Resource Name (ARN) of an AWS Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.
        """
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an AWS Certificate Manager SSL certificate. You use this certificate for the subdomain of your custom domain.
        """
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class UserPoolEmailConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationSet":
            suggest = "configuration_set"
        elif key == "emailSendingAccount":
            suggest = "email_sending_account"
        elif key == "from":
            suggest = "from_"
        elif key == "replyToEmailAddress":
            suggest = "reply_to_email_address"
        elif key == "sourceArn":
            suggest = "source_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolEmailConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolEmailConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolEmailConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_set: Optional[builtins.str] = None,
                 email_sending_account: Optional[builtins.str] = None,
                 from_: Optional[builtins.str] = None,
                 reply_to_email_address: Optional[builtins.str] = None,
                 source_arn: Optional[builtins.str] = None):
        """
        :param builtins.str configuration_set: The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails:
               
               - **Event publishing** - Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other AWS services such as and Amazon CloudWatch
               - **IP pool management** - When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.
        :param builtins.str email_sending_account: Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration. Specify one of the following values:
               
               - **COGNITO_DEFAULT** - When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
               
               To look up the email delivery limit for the default option, see [Limits](https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html) in the *Amazon Cognito Developer Guide* .
               
               The default FROM address is `no-reply@verificationemail.com` . To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the `SourceArn` parameter.
               - **DEVELOPER** - When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your AWS account .
               
               If you use this option, provide the ARN of an Amazon SES verified email address for the `SourceArn` parameter.
               
               Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a *service-linked role* , which is a type of role in your AWS account . This role contains the permissions that allow you to access Amazon SES and send email messages from your email address. For more information about the service-linked role that Amazon Cognito creates, see [Using Service-Linked Roles for Amazon Cognito](https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html) in the *Amazon Cognito Developer Guide* .
        :param builtins.str from_: Either the sender’s email address or the sender’s name with their email address. For example, `testuser@example.com` or `Test User <testuser@example.com>` . This address appears before the body of the email.
        :param builtins.str reply_to_email_address: The destination to which the receiver of the email should reply.
        :param builtins.str source_arn: The ARN of a verified email address or an address from a verified domain in Amazon SES. You can set a `SourceArn` email from a verified domain only with an API request. You can set a verified email address, but not an address in a verified domain, in the Amazon Cognito console. Amazon Cognito uses the email address that you provide in one of the following ways, depending on the value that you specify for the `EmailSendingAccount` parameter:
               
               - If you specify `COGNITO_DEFAULT` , Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.
               - If you specify `DEVELOPER` , Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.
               
               The Region value of the `SourceArn` parameter must indicate a supported AWS Region of your user pool. Typically, the Region in the `SourceArn` and the user pool Region are the same. For more information, see [Amazon SES email configuration regions](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping) in the [Amazon Cognito Developer Guide](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html) .
        """
        if configuration_set is not None:
            pulumi.set(__self__, "configuration_set", configuration_set)
        if email_sending_account is not None:
            pulumi.set(__self__, "email_sending_account", email_sending_account)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if reply_to_email_address is not None:
            pulumi.set(__self__, "reply_to_email_address", reply_to_email_address)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)

    @property
    @pulumi.getter(name="configurationSet")
    def configuration_set(self) -> Optional[builtins.str]:
        """
        The set of configuration rules that can be applied to emails sent using Amazon Simple Email Service. A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails:

        - **Event publishing** - Amazon Simple Email Service can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other AWS services such as and Amazon CloudWatch
        - **IP pool management** - When leasing dedicated IP addresses with Amazon Simple Email Service, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.
        """
        return pulumi.get(self, "configuration_set")

    @property
    @pulumi.getter(name="emailSendingAccount")
    def email_sending_account(self) -> Optional[builtins.str]:
        """
        Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration. Specify one of the following values:

        - **COGNITO_DEFAULT** - When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.

        To look up the email delivery limit for the default option, see [Limits](https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html) in the *Amazon Cognito Developer Guide* .

        The default FROM address is `no-reply@verificationemail.com` . To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the `SourceArn` parameter.
        - **DEVELOPER** - When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your AWS account .

        If you use this option, provide the ARN of an Amazon SES verified email address for the `SourceArn` parameter.

        Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a *service-linked role* , which is a type of role in your AWS account . This role contains the permissions that allow you to access Amazon SES and send email messages from your email address. For more information about the service-linked role that Amazon Cognito creates, see [Using Service-Linked Roles for Amazon Cognito](https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html) in the *Amazon Cognito Developer Guide* .
        """
        return pulumi.get(self, "email_sending_account")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[builtins.str]:
        """
        Either the sender’s email address or the sender’s name with their email address. For example, `testuser@example.com` or `Test User <testuser@example.com>` . This address appears before the body of the email.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter(name="replyToEmailAddress")
    def reply_to_email_address(self) -> Optional[builtins.str]:
        """
        The destination to which the receiver of the email should reply.
        """
        return pulumi.get(self, "reply_to_email_address")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[builtins.str]:
        """
        The ARN of a verified email address or an address from a verified domain in Amazon SES. You can set a `SourceArn` email from a verified domain only with an API request. You can set a verified email address, but not an address in a verified domain, in the Amazon Cognito console. Amazon Cognito uses the email address that you provide in one of the following ways, depending on the value that you specify for the `EmailSendingAccount` parameter:

        - If you specify `COGNITO_DEFAULT` , Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.
        - If you specify `DEVELOPER` , Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.

        The Region value of the `SourceArn` parameter must indicate a supported AWS Region of your user pool. Typically, the Region in the `SourceArn` and the user pool Region are the same. For more information, see [Amazon SES email configuration regions](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping) in the [Amazon Cognito Developer Guide](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html) .
        """
        return pulumi.get(self, "source_arn")


@pulumi.output_type
class UserPoolInviteMessageTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailMessage":
            suggest = "email_message"
        elif key == "emailSubject":
            suggest = "email_subject"
        elif key == "smsMessage":
            suggest = "sms_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolInviteMessageTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolInviteMessageTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolInviteMessageTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_message: Optional[builtins.str] = None,
                 email_subject: Optional[builtins.str] = None,
                 sms_message: Optional[builtins.str] = None):
        """
        :param builtins.str email_message: The message template for email messages. EmailMessage is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
        :param builtins.str email_subject: The subject line for email messages. EmailSubject is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
        :param builtins.str sms_message: The message template for SMS messages.
        """
        if email_message is not None:
            pulumi.set(__self__, "email_message", email_message)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if sms_message is not None:
            pulumi.set(__self__, "sms_message", sms_message)

    @property
    @pulumi.getter(name="emailMessage")
    def email_message(self) -> Optional[builtins.str]:
        """
        The message template for email messages. EmailMessage is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
        """
        return pulumi.get(self, "email_message")

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[builtins.str]:
        """
        The subject line for email messages. EmailSubject is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
        """
        return pulumi.get(self, "email_subject")

    @property
    @pulumi.getter(name="smsMessage")
    def sms_message(self) -> Optional[builtins.str]:
        """
        The message template for SMS messages.
        """
        return pulumi.get(self, "sms_message")


@pulumi.output_type
class UserPoolLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createAuthChallenge":
            suggest = "create_auth_challenge"
        elif key == "customEmailSender":
            suggest = "custom_email_sender"
        elif key == "customMessage":
            suggest = "custom_message"
        elif key == "customSmsSender":
            suggest = "custom_sms_sender"
        elif key == "defineAuthChallenge":
            suggest = "define_auth_challenge"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "postAuthentication":
            suggest = "post_authentication"
        elif key == "postConfirmation":
            suggest = "post_confirmation"
        elif key == "preAuthentication":
            suggest = "pre_authentication"
        elif key == "preSignUp":
            suggest = "pre_sign_up"
        elif key == "preTokenGeneration":
            suggest = "pre_token_generation"
        elif key == "preTokenGenerationConfig":
            suggest = "pre_token_generation_config"
        elif key == "userMigration":
            suggest = "user_migration"
        elif key == "verifyAuthChallengeResponse":
            suggest = "verify_auth_challenge_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_auth_challenge: Optional[builtins.str] = None,
                 custom_email_sender: Optional['outputs.UserPoolCustomEmailSender'] = None,
                 custom_message: Optional[builtins.str] = None,
                 custom_sms_sender: Optional['outputs.UserPoolCustomSmsSender'] = None,
                 define_auth_challenge: Optional[builtins.str] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 post_authentication: Optional[builtins.str] = None,
                 post_confirmation: Optional[builtins.str] = None,
                 pre_authentication: Optional[builtins.str] = None,
                 pre_sign_up: Optional[builtins.str] = None,
                 pre_token_generation: Optional[builtins.str] = None,
                 pre_token_generation_config: Optional['outputs.UserPoolPreTokenGenerationConfig'] = None,
                 user_migration: Optional[builtins.str] = None,
                 verify_auth_challenge_response: Optional[builtins.str] = None):
        """
        :param builtins.str create_auth_challenge: The configuration of a create auth challenge Lambda trigger, one of three triggers in the sequence of the [custom authentication challenge triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        :param 'UserPoolCustomEmailSender' custom_email_sender: The configuration of a custom email sender Lambda trigger. This trigger routes all email notifications from a user pool to a Lambda function that delivers the message using custom logic.
        :param builtins.str custom_message: A custom message Lambda trigger. This trigger is an opportunity to customize all SMS and email messages from your user pool. When a custom message trigger is active, your user pool routes all messages to a Lambda function that returns a runtime-customized message subject and body for your user pool to deliver to a user.
        :param 'UserPoolCustomSmsSender' custom_sms_sender: The configuration of a custom SMS sender Lambda trigger. This trigger routes all SMS notifications from a user pool to a Lambda function that delivers the message using custom logic.
        :param builtins.str define_auth_challenge: The configuration of a define auth challenge Lambda trigger, one of three triggers in the sequence of the [custom authentication challenge triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        :param builtins.str kms_key_id: The ARN of an [KMS key](https://docs.aws.amazon.com//kms/latest/developerguide/concepts.html#master_keys) . Amazon Cognito uses the key to encrypt codes and temporary passwords sent to custom sender Lambda triggers.
        :param builtins.str post_authentication: The configuration of a [post authentication Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html) in a user pool. This trigger can take custom actions after a user signs in.
        :param builtins.str post_confirmation: The configuration of a [post confirmation Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html) in a user pool. This trigger can take custom actions after a user confirms their user account and their email address or phone number.
        :param builtins.str pre_authentication: The configuration of a [pre authentication trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html) in a user pool. This trigger can evaluate and modify user sign-in events.
        :param builtins.str pre_sign_up: The configuration of a [pre sign-up Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html) in a user pool. This trigger evaluates new users and can bypass confirmation, [link a federated user profile](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html) , or block sign-up requests.
        :param builtins.str pre_token_generation: The legacy configuration of a [pre token generation Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html) in a user pool.
               
               Set this parameter for legacy purposes. If you also set an ARN in `PreTokenGenerationConfig` , its value must be identical to `PreTokenGeneration` . For new instances of pre token generation triggers, set the `LambdaArn` of `PreTokenGenerationConfig` .
        :param 'UserPoolPreTokenGenerationConfig' pre_token_generation_config: The detailed configuration of a [pre token generation Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html) in a user pool. If you also set an ARN in `PreTokenGeneration` , its value must be identical to `PreTokenGenerationConfig` .
        :param builtins.str user_migration: The configuration of a [migrate user Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html) in a user pool. This trigger can create user profiles when users sign in or attempt to reset their password with credentials that don't exist yet.
        :param builtins.str verify_auth_challenge_response: The configuration of a verify auth challenge Lambda trigger, one of three triggers in the sequence of the [custom authentication challenge triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        """
        if create_auth_challenge is not None:
            pulumi.set(__self__, "create_auth_challenge", create_auth_challenge)
        if custom_email_sender is not None:
            pulumi.set(__self__, "custom_email_sender", custom_email_sender)
        if custom_message is not None:
            pulumi.set(__self__, "custom_message", custom_message)
        if custom_sms_sender is not None:
            pulumi.set(__self__, "custom_sms_sender", custom_sms_sender)
        if define_auth_challenge is not None:
            pulumi.set(__self__, "define_auth_challenge", define_auth_challenge)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if post_authentication is not None:
            pulumi.set(__self__, "post_authentication", post_authentication)
        if post_confirmation is not None:
            pulumi.set(__self__, "post_confirmation", post_confirmation)
        if pre_authentication is not None:
            pulumi.set(__self__, "pre_authentication", pre_authentication)
        if pre_sign_up is not None:
            pulumi.set(__self__, "pre_sign_up", pre_sign_up)
        if pre_token_generation is not None:
            pulumi.set(__self__, "pre_token_generation", pre_token_generation)
        if pre_token_generation_config is not None:
            pulumi.set(__self__, "pre_token_generation_config", pre_token_generation_config)
        if user_migration is not None:
            pulumi.set(__self__, "user_migration", user_migration)
        if verify_auth_challenge_response is not None:
            pulumi.set(__self__, "verify_auth_challenge_response", verify_auth_challenge_response)

    @property
    @pulumi.getter(name="createAuthChallenge")
    def create_auth_challenge(self) -> Optional[builtins.str]:
        """
        The configuration of a create auth challenge Lambda trigger, one of three triggers in the sequence of the [custom authentication challenge triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        """
        return pulumi.get(self, "create_auth_challenge")

    @property
    @pulumi.getter(name="customEmailSender")
    def custom_email_sender(self) -> Optional['outputs.UserPoolCustomEmailSender']:
        """
        The configuration of a custom email sender Lambda trigger. This trigger routes all email notifications from a user pool to a Lambda function that delivers the message using custom logic.
        """
        return pulumi.get(self, "custom_email_sender")

    @property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> Optional[builtins.str]:
        """
        A custom message Lambda trigger. This trigger is an opportunity to customize all SMS and email messages from your user pool. When a custom message trigger is active, your user pool routes all messages to a Lambda function that returns a runtime-customized message subject and body for your user pool to deliver to a user.
        """
        return pulumi.get(self, "custom_message")

    @property
    @pulumi.getter(name="customSmsSender")
    def custom_sms_sender(self) -> Optional['outputs.UserPoolCustomSmsSender']:
        """
        The configuration of a custom SMS sender Lambda trigger. This trigger routes all SMS notifications from a user pool to a Lambda function that delivers the message using custom logic.
        """
        return pulumi.get(self, "custom_sms_sender")

    @property
    @pulumi.getter(name="defineAuthChallenge")
    def define_auth_challenge(self) -> Optional[builtins.str]:
        """
        The configuration of a define auth challenge Lambda trigger, one of three triggers in the sequence of the [custom authentication challenge triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        """
        return pulumi.get(self, "define_auth_challenge")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        The ARN of an [KMS key](https://docs.aws.amazon.com//kms/latest/developerguide/concepts.html#master_keys) . Amazon Cognito uses the key to encrypt codes and temporary passwords sent to custom sender Lambda triggers.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="postAuthentication")
    def post_authentication(self) -> Optional[builtins.str]:
        """
        The configuration of a [post authentication Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html) in a user pool. This trigger can take custom actions after a user signs in.
        """
        return pulumi.get(self, "post_authentication")

    @property
    @pulumi.getter(name="postConfirmation")
    def post_confirmation(self) -> Optional[builtins.str]:
        """
        The configuration of a [post confirmation Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html) in a user pool. This trigger can take custom actions after a user confirms their user account and their email address or phone number.
        """
        return pulumi.get(self, "post_confirmation")

    @property
    @pulumi.getter(name="preAuthentication")
    def pre_authentication(self) -> Optional[builtins.str]:
        """
        The configuration of a [pre authentication trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html) in a user pool. This trigger can evaluate and modify user sign-in events.
        """
        return pulumi.get(self, "pre_authentication")

    @property
    @pulumi.getter(name="preSignUp")
    def pre_sign_up(self) -> Optional[builtins.str]:
        """
        The configuration of a [pre sign-up Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html) in a user pool. This trigger evaluates new users and can bypass confirmation, [link a federated user profile](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html) , or block sign-up requests.
        """
        return pulumi.get(self, "pre_sign_up")

    @property
    @pulumi.getter(name="preTokenGeneration")
    def pre_token_generation(self) -> Optional[builtins.str]:
        """
        The legacy configuration of a [pre token generation Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html) in a user pool.

        Set this parameter for legacy purposes. If you also set an ARN in `PreTokenGenerationConfig` , its value must be identical to `PreTokenGeneration` . For new instances of pre token generation triggers, set the `LambdaArn` of `PreTokenGenerationConfig` .
        """
        return pulumi.get(self, "pre_token_generation")

    @property
    @pulumi.getter(name="preTokenGenerationConfig")
    def pre_token_generation_config(self) -> Optional['outputs.UserPoolPreTokenGenerationConfig']:
        """
        The detailed configuration of a [pre token generation Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html) in a user pool. If you also set an ARN in `PreTokenGeneration` , its value must be identical to `PreTokenGenerationConfig` .
        """
        return pulumi.get(self, "pre_token_generation_config")

    @property
    @pulumi.getter(name="userMigration")
    def user_migration(self) -> Optional[builtins.str]:
        """
        The configuration of a [migrate user Lambda trigger](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html) in a user pool. This trigger can create user profiles when users sign in or attempt to reset their password with credentials that don't exist yet.
        """
        return pulumi.get(self, "user_migration")

    @property
    @pulumi.getter(name="verifyAuthChallengeResponse")
    def verify_auth_challenge_response(self) -> Optional[builtins.str]:
        """
        The configuration of a verify auth challenge Lambda trigger, one of three triggers in the sequence of the [custom authentication challenge triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html) .
        """
        return pulumi.get(self, "verify_auth_challenge_response")


@pulumi.output_type
class UserPoolNumberAttributeConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolNumberAttributeConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolNumberAttributeConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolNumberAttributeConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: Optional[builtins.str] = None,
                 min_value: Optional[builtins.str] = None):
        """
        :param builtins.str max_value: The maximum length of a number attribute value. Must be a number less than or equal to `2^1023` , represented as a string with a length of 131072 characters or fewer.
        :param builtins.str min_value: The minimum value of an attribute that is of the number data type.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[builtins.str]:
        """
        The maximum length of a number attribute value. Must be a number less than or equal to `2^1023` , represented as a string with a length of 131072 characters or fewer.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[builtins.str]:
        """
        The minimum value of an attribute that is of the number data type.
        """
        return pulumi.get(self, "min_value")


@pulumi.output_type
class UserPoolPasswordPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumLength":
            suggest = "minimum_length"
        elif key == "passwordHistorySize":
            suggest = "password_history_size"
        elif key == "requireLowercase":
            suggest = "require_lowercase"
        elif key == "requireNumbers":
            suggest = "require_numbers"
        elif key == "requireSymbols":
            suggest = "require_symbols"
        elif key == "requireUppercase":
            suggest = "require_uppercase"
        elif key == "temporaryPasswordValidityDays":
            suggest = "temporary_password_validity_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolPasswordPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolPasswordPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolPasswordPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimum_length: Optional[builtins.int] = None,
                 password_history_size: Optional[builtins.int] = None,
                 require_lowercase: Optional[builtins.bool] = None,
                 require_numbers: Optional[builtins.bool] = None,
                 require_symbols: Optional[builtins.bool] = None,
                 require_uppercase: Optional[builtins.bool] = None,
                 temporary_password_validity_days: Optional[builtins.int] = None):
        """
        :param builtins.int minimum_length: The minimum length of the password in the policy that you have set. This value can't be less than 6.
        :param builtins.int password_history_size: The number of previous passwords that you want Amazon Cognito to restrict each user from reusing. Users can't set a password that matches any of `n` previous passwords, where `n` is the value of `PasswordHistorySize` .
        :param builtins.bool require_lowercase: The requirement in a password policy that users must include at least one lowercase letter in their password.
        :param builtins.bool require_numbers: The requirement in a password policy that users must include at least one number in their password.
        :param builtins.bool require_symbols: The requirement in a password policy that users must include at least one symbol in their password.
        :param builtins.bool require_uppercase: The requirement in a password policy that users must include at least one uppercase letter in their password.
        :param builtins.int temporary_password_validity_days: The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password. Defaults to `7` . If you submit a value of `0` , Amazon Cognito treats it as a null value and sets `TemporaryPasswordValidityDays` to its default value.
               
               > When you set `TemporaryPasswordValidityDays` for a user pool, you can no longer set a value for the legacy `UnusedAccountValidityDays` parameter in that user pool.
        """
        if minimum_length is not None:
            pulumi.set(__self__, "minimum_length", minimum_length)
        if password_history_size is not None:
            pulumi.set(__self__, "password_history_size", password_history_size)
        if require_lowercase is not None:
            pulumi.set(__self__, "require_lowercase", require_lowercase)
        if require_numbers is not None:
            pulumi.set(__self__, "require_numbers", require_numbers)
        if require_symbols is not None:
            pulumi.set(__self__, "require_symbols", require_symbols)
        if require_uppercase is not None:
            pulumi.set(__self__, "require_uppercase", require_uppercase)
        if temporary_password_validity_days is not None:
            pulumi.set(__self__, "temporary_password_validity_days", temporary_password_validity_days)

    @property
    @pulumi.getter(name="minimumLength")
    def minimum_length(self) -> Optional[builtins.int]:
        """
        The minimum length of the password in the policy that you have set. This value can't be less than 6.
        """
        return pulumi.get(self, "minimum_length")

    @property
    @pulumi.getter(name="passwordHistorySize")
    def password_history_size(self) -> Optional[builtins.int]:
        """
        The number of previous passwords that you want Amazon Cognito to restrict each user from reusing. Users can't set a password that matches any of `n` previous passwords, where `n` is the value of `PasswordHistorySize` .
        """
        return pulumi.get(self, "password_history_size")

    @property
    @pulumi.getter(name="requireLowercase")
    def require_lowercase(self) -> Optional[builtins.bool]:
        """
        The requirement in a password policy that users must include at least one lowercase letter in their password.
        """
        return pulumi.get(self, "require_lowercase")

    @property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> Optional[builtins.bool]:
        """
        The requirement in a password policy that users must include at least one number in their password.
        """
        return pulumi.get(self, "require_numbers")

    @property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> Optional[builtins.bool]:
        """
        The requirement in a password policy that users must include at least one symbol in their password.
        """
        return pulumi.get(self, "require_symbols")

    @property
    @pulumi.getter(name="requireUppercase")
    def require_uppercase(self) -> Optional[builtins.bool]:
        """
        The requirement in a password policy that users must include at least one uppercase letter in their password.
        """
        return pulumi.get(self, "require_uppercase")

    @property
    @pulumi.getter(name="temporaryPasswordValidityDays")
    def temporary_password_validity_days(self) -> Optional[builtins.int]:
        """
        The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password. Defaults to `7` . If you submit a value of `0` , Amazon Cognito treats it as a null value and sets `TemporaryPasswordValidityDays` to its default value.

        > When you set `TemporaryPasswordValidityDays` for a user pool, you can no longer set a value for the legacy `UnusedAccountValidityDays` parameter in that user pool.
        """
        return pulumi.get(self, "temporary_password_validity_days")


@pulumi.output_type
class UserPoolPolicies(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordPolicy":
            suggest = "password_policy"
        elif key == "signInPolicy":
            suggest = "sign_in_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolPolicies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolPolicies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolPolicies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_policy: Optional['outputs.UserPoolPasswordPolicy'] = None,
                 sign_in_policy: Optional['outputs.UserPoolSignInPolicy'] = None):
        """
        :param 'UserPoolPasswordPolicy' password_policy: The password policy settings for a user pool, including complexity, history, and length requirements.
        :param 'UserPoolSignInPolicy' sign_in_policy: The policy for allowed types of authentication in a user pool. To activate this setting, your user pool must be in the [Essentials tier](https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html) or higher.
        """
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)
        if sign_in_policy is not None:
            pulumi.set(__self__, "sign_in_policy", sign_in_policy)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional['outputs.UserPoolPasswordPolicy']:
        """
        The password policy settings for a user pool, including complexity, history, and length requirements.
        """
        return pulumi.get(self, "password_policy")

    @property
    @pulumi.getter(name="signInPolicy")
    def sign_in_policy(self) -> Optional['outputs.UserPoolSignInPolicy']:
        """
        The policy for allowed types of authentication in a user pool. To activate this setting, your user pool must be in the [Essentials tier](https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html) or higher.
        """
        return pulumi.get(self, "sign_in_policy")


@pulumi.output_type
class UserPoolPreTokenGenerationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "lambdaVersion":
            suggest = "lambda_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolPreTokenGenerationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolPreTokenGenerationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolPreTokenGenerationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: Optional[builtins.str] = None,
                 lambda_version: Optional[builtins.str] = None):
        """
        :param builtins.str lambda_arn: The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.
               
               This parameter and the `PreTokenGeneration` property of `LambdaConfig` have the same value. For new instances of pre token generation triggers, set `LambdaArn` .
        :param builtins.str lambda_version: The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.
        """
        if lambda_arn is not None:
            pulumi.set(__self__, "lambda_arn", lambda_arn)
        if lambda_version is not None:
            pulumi.set(__self__, "lambda_version", lambda_version)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the function that you want to assign to your Lambda trigger.

        This parameter and the `PreTokenGeneration` property of `LambdaConfig` have the same value. For new instances of pre token generation triggers, set `LambdaArn` .
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="lambdaVersion")
    def lambda_version(self) -> Optional[builtins.str]:
        """
        The user pool trigger version of the request that Amazon Cognito sends to your Lambda function. Higher-numbered versions add fields that support new features.
        """
        return pulumi.get(self, "lambda_version")


@pulumi.output_type
class UserPoolRecoveryOption(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 priority: Optional[builtins.int] = None):
        """
        :param builtins.str name: The recovery method that this object sets a recovery option for.
        :param builtins.int priority: Your priority preference for using the specified attribute in account recovery. The highest priority is `1` .
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The recovery method that this object sets a recovery option for.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        Your priority preference for using the specified attribute in account recovery. The highest priority is `1` .
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class UserPoolResourceServerResourceServerScopeType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scopeDescription":
            suggest = "scope_description"
        elif key == "scopeName":
            suggest = "scope_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolResourceServerResourceServerScopeType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolResourceServerResourceServerScopeType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolResourceServerResourceServerScopeType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scope_description: builtins.str,
                 scope_name: builtins.str):
        """
        :param builtins.str scope_description: A friendly description of a custom scope.
        :param builtins.str scope_name: The name of the scope. Amazon Cognito renders custom scopes in the format `resourceServerIdentifier/ScopeName` . For example, if this parameter is `exampleScope` in the resource server with the identifier `exampleResourceServer` , you request and receive the scope `exampleResourceServer/exampleScope` .
        """
        pulumi.set(__self__, "scope_description", scope_description)
        pulumi.set(__self__, "scope_name", scope_name)

    @property
    @pulumi.getter(name="scopeDescription")
    def scope_description(self) -> builtins.str:
        """
        A friendly description of a custom scope.
        """
        return pulumi.get(self, "scope_description")

    @property
    @pulumi.getter(name="scopeName")
    def scope_name(self) -> builtins.str:
        """
        The name of the scope. Amazon Cognito renders custom scopes in the format `resourceServerIdentifier/ScopeName` . For example, if this parameter is `exampleScope` in the resource server with the identifier `exampleResourceServer` , you request and receive the scope `exampleResourceServer/exampleScope` .
        """
        return pulumi.get(self, "scope_name")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentAccountTakeoverActionType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventAction":
            suggest = "event_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentAccountTakeoverActionType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentAccountTakeoverActionType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentAccountTakeoverActionType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_action: builtins.str,
                 notify: builtins.bool):
        """
        :param builtins.str event_action: The action to take for the attempted account takeover action for the associated risk level. Valid values are as follows:
               
               - `BLOCK` : Block the request.
               - `MFA_IF_CONFIGURED` : Present an MFA challenge if possible. MFA is possible if the user pool has active MFA methods that the user can set up. For example, if the user pool only supports SMS message MFA but the user doesn't have a phone number attribute, MFA setup isn't possible. If MFA setup isn't possible, allow the request.
               - `MFA_REQUIRED` : Present an MFA challenge if possible. Block the request if a user hasn't set up MFA. To sign in with required MFA, users must have an email address or phone number attribute, or a registered TOTP factor.
               - `NO_ACTION` : Take no action. Permit sign-in.
        :param builtins.bool notify: Determines whether Amazon Cognito sends a user a notification message when your user pools assesses a user's session at the associated risk level.
        """
        pulumi.set(__self__, "event_action", event_action)
        pulumi.set(__self__, "notify", notify)

    @property
    @pulumi.getter(name="eventAction")
    def event_action(self) -> builtins.str:
        """
        The action to take for the attempted account takeover action for the associated risk level. Valid values are as follows:

        - `BLOCK` : Block the request.
        - `MFA_IF_CONFIGURED` : Present an MFA challenge if possible. MFA is possible if the user pool has active MFA methods that the user can set up. For example, if the user pool only supports SMS message MFA but the user doesn't have a phone number attribute, MFA setup isn't possible. If MFA setup isn't possible, allow the request.
        - `MFA_REQUIRED` : Present an MFA challenge if possible. Block the request if a user hasn't set up MFA. To sign in with required MFA, users must have an email address or phone number attribute, or a registered TOTP factor.
        - `NO_ACTION` : Take no action. Permit sign-in.
        """
        return pulumi.get(self, "event_action")

    @property
    @pulumi.getter
    def notify(self) -> builtins.bool:
        """
        Determines whether Amazon Cognito sends a user a notification message when your user pools assesses a user's session at the associated risk level.
        """
        return pulumi.get(self, "notify")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highAction":
            suggest = "high_action"
        elif key == "lowAction":
            suggest = "low_action"
        elif key == "mediumAction":
            suggest = "medium_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_action: Optional['outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionType'] = None,
                 low_action: Optional['outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionType'] = None,
                 medium_action: Optional['outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionType'] = None):
        """
        :param 'UserPoolRiskConfigurationAttachmentAccountTakeoverActionType' high_action: The action that you assign to a high-risk assessment by threat protection.
        :param 'UserPoolRiskConfigurationAttachmentAccountTakeoverActionType' low_action: The action that you assign to a low-risk assessment by threat protection.
        :param 'UserPoolRiskConfigurationAttachmentAccountTakeoverActionType' medium_action: The action that you assign to a medium-risk assessment by threat protection.
        """
        if high_action is not None:
            pulumi.set(__self__, "high_action", high_action)
        if low_action is not None:
            pulumi.set(__self__, "low_action", low_action)
        if medium_action is not None:
            pulumi.set(__self__, "medium_action", medium_action)

    @property
    @pulumi.getter(name="highAction")
    def high_action(self) -> Optional['outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionType']:
        """
        The action that you assign to a high-risk assessment by threat protection.
        """
        return pulumi.get(self, "high_action")

    @property
    @pulumi.getter(name="lowAction")
    def low_action(self) -> Optional['outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionType']:
        """
        The action that you assign to a low-risk assessment by threat protection.
        """
        return pulumi.get(self, "low_action")

    @property
    @pulumi.getter(name="mediumAction")
    def medium_action(self) -> Optional['outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionType']:
        """
        The action that you assign to a medium-risk assessment by threat protection.
        """
        return pulumi.get(self, "medium_action")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyConfiguration":
            suggest = "notify_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: 'outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType',
                 notify_configuration: Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyConfigurationType'] = None):
        """
        :param 'UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType' actions: A list of account-takeover actions for each level of risk that Amazon Cognito might assess with threat protection.
        :param 'UserPoolRiskConfigurationAttachmentNotifyConfigurationType' notify_configuration: The settings for composing and sending an email message when threat protection assesses a risk level with adaptive authentication. When you choose to notify users in `AccountTakeoverRiskConfiguration` , Amazon Cognito sends an email message using the method and template that you set with this data type.
        """
        pulumi.set(__self__, "actions", actions)
        if notify_configuration is not None:
            pulumi.set(__self__, "notify_configuration", notify_configuration)

    @property
    @pulumi.getter
    def actions(self) -> 'outputs.UserPoolRiskConfigurationAttachmentAccountTakeoverActionsType':
        """
        A list of account-takeover actions for each level of risk that Amazon Cognito might assess with threat protection.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="notifyConfiguration")
    def notify_configuration(self) -> Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyConfigurationType']:
        """
        The settings for composing and sending an email message when threat protection assesses a risk level with adaptive authentication. When you choose to notify users in `AccountTakeoverRiskConfiguration` , Amazon Cognito sends an email message using the method and template that you set with this data type.
        """
        return pulumi.get(self, "notify_configuration")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventAction":
            suggest = "event_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_action: builtins.str):
        """
        :param builtins.str event_action: The action that Amazon Cognito takes when it detects compromised credentials.
        """
        pulumi.set(__self__, "event_action", event_action)

    @property
    @pulumi.getter(name="eventAction")
    def event_action(self) -> builtins.str:
        """
        The action that Amazon Cognito takes when it detects compromised credentials.
        """
        return pulumi.get(self, "event_action")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventFilter":
            suggest = "event_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: 'outputs.UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType',
                 event_filter: Optional[Sequence[builtins.str]] = None):
        """
        :param 'UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType' actions: Settings for the actions that you want your user pool to take when Amazon Cognito detects compromised credentials.
        :param Sequence[builtins.str] event_filter: Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to all events.
        """
        pulumi.set(__self__, "actions", actions)
        if event_filter is not None:
            pulumi.set(__self__, "event_filter", event_filter)

    @property
    @pulumi.getter
    def actions(self) -> 'outputs.UserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsType':
        """
        Settings for the actions that you want your user pool to take when Amazon Cognito detects compromised credentials.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="eventFilter")
    def event_filter(self) -> Optional[Sequence[builtins.str]]:
        """
        Settings for the sign-in activity where you want to configure compromised-credentials actions. Defaults to all events.
        """
        return pulumi.get(self, "event_filter")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentNotifyConfigurationType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArn":
            suggest = "source_arn"
        elif key == "blockEmail":
            suggest = "block_email"
        elif key == "from":
            suggest = "from_"
        elif key == "mfaEmail":
            suggest = "mfa_email"
        elif key == "noActionEmail":
            suggest = "no_action_email"
        elif key == "replyTo":
            suggest = "reply_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentNotifyConfigurationType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentNotifyConfigurationType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentNotifyConfigurationType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arn: builtins.str,
                 block_email: Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyEmailType'] = None,
                 from_: Optional[builtins.str] = None,
                 mfa_email: Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyEmailType'] = None,
                 no_action_email: Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyEmailType'] = None,
                 reply_to: Optional[builtins.str] = None):
        """
        :param builtins.str source_arn: The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the `From` parameter.
        :param 'UserPoolRiskConfigurationAttachmentNotifyEmailType' block_email: The template for the email message that your user pool sends when a detected risk event is blocked.
        :param builtins.str from_: The email address that sends the email message. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.
        :param 'UserPoolRiskConfigurationAttachmentNotifyEmailType' mfa_email: The template for the email message that your user pool sends when MFA is challenged in response to a detected risk.
        :param 'UserPoolRiskConfigurationAttachmentNotifyEmailType' no_action_email: The template for the email message that your user pool sends when no action is taken in response to a detected risk.
        :param builtins.str reply_to: The reply-to email address of an email template.
        """
        pulumi.set(__self__, "source_arn", source_arn)
        if block_email is not None:
            pulumi.set(__self__, "block_email", block_email)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if mfa_email is not None:
            pulumi.set(__self__, "mfa_email", mfa_email)
        if no_action_email is not None:
            pulumi.set(__self__, "no_action_email", no_action_email)
        if reply_to is not None:
            pulumi.set(__self__, "reply_to", reply_to)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the `From` parameter.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="blockEmail")
    def block_email(self) -> Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyEmailType']:
        """
        The template for the email message that your user pool sends when a detected risk event is blocked.
        """
        return pulumi.get(self, "block_email")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[builtins.str]:
        """
        The email address that sends the email message. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter(name="mfaEmail")
    def mfa_email(self) -> Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyEmailType']:
        """
        The template for the email message that your user pool sends when MFA is challenged in response to a detected risk.
        """
        return pulumi.get(self, "mfa_email")

    @property
    @pulumi.getter(name="noActionEmail")
    def no_action_email(self) -> Optional['outputs.UserPoolRiskConfigurationAttachmentNotifyEmailType']:
        """
        The template for the email message that your user pool sends when no action is taken in response to a detected risk.
        """
        return pulumi.get(self, "no_action_email")

    @property
    @pulumi.getter(name="replyTo")
    def reply_to(self) -> Optional[builtins.str]:
        """
        The reply-to email address of an email template.
        """
        return pulumi.get(self, "reply_to")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentNotifyEmailType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "textBody":
            suggest = "text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentNotifyEmailType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentNotifyEmailType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentNotifyEmailType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: builtins.str,
                 html_body: Optional[builtins.str] = None,
                 text_body: Optional[builtins.str] = None):
        """
        :param builtins.str subject: The subject of the threat protection email notification.
        :param builtins.str html_body: The body of an email notification formatted in HTML. Choose an `HtmlBody` or a `TextBody` to send an HTML-formatted or plaintext message, respectively.
        :param builtins.str text_body: The body of an email notification formatted in plaintext. Choose an `HtmlBody` or a `TextBody` to send an HTML-formatted or plaintext message, respectively.
        """
        pulumi.set(__self__, "subject", subject)
        if html_body is not None:
            pulumi.set(__self__, "html_body", html_body)
        if text_body is not None:
            pulumi.set(__self__, "text_body", text_body)

    @property
    @pulumi.getter
    def subject(self) -> builtins.str:
        """
        The subject of the threat protection email notification.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> Optional[builtins.str]:
        """
        The body of an email notification formatted in HTML. Choose an `HtmlBody` or a `TextBody` to send an HTML-formatted or plaintext message, respectively.
        """
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter(name="textBody")
    def text_body(self) -> Optional[builtins.str]:
        """
        The body of an email notification formatted in plaintext. Choose an `HtmlBody` or a `TextBody` to send an HTML-formatted or plaintext message, respectively.
        """
        return pulumi.get(self, "text_body")


@pulumi.output_type
class UserPoolRiskConfigurationAttachmentRiskExceptionConfigurationType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockedIpRangeList":
            suggest = "blocked_ip_range_list"
        elif key == "skippedIpRangeList":
            suggest = "skipped_ip_range_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolRiskConfigurationAttachmentRiskExceptionConfigurationType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolRiskConfigurationAttachmentRiskExceptionConfigurationType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolRiskConfigurationAttachmentRiskExceptionConfigurationType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blocked_ip_range_list: Optional[Sequence[builtins.str]] = None,
                 skipped_ip_range_list: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] blocked_ip_range_list: An always-block IP address list. Overrides the risk decision and always blocks authentication requests. This parameter is displayed and set in CIDR notation.
        :param Sequence[builtins.str] skipped_ip_range_list: An always-allow IP address list. Risk detection isn't performed on the IP addresses in this range list. This parameter is displayed and set in CIDR notation.
        """
        if blocked_ip_range_list is not None:
            pulumi.set(__self__, "blocked_ip_range_list", blocked_ip_range_list)
        if skipped_ip_range_list is not None:
            pulumi.set(__self__, "skipped_ip_range_list", skipped_ip_range_list)

    @property
    @pulumi.getter(name="blockedIpRangeList")
    def blocked_ip_range_list(self) -> Optional[Sequence[builtins.str]]:
        """
        An always-block IP address list. Overrides the risk decision and always blocks authentication requests. This parameter is displayed and set in CIDR notation.
        """
        return pulumi.get(self, "blocked_ip_range_list")

    @property
    @pulumi.getter(name="skippedIpRangeList")
    def skipped_ip_range_list(self) -> Optional[Sequence[builtins.str]]:
        """
        An always-allow IP address list. Risk detection isn't performed on the IP addresses in this range list. This parameter is displayed and set in CIDR notation.
        """
        return pulumi.get(self, "skipped_ip_range_list")


@pulumi.output_type
class UserPoolSchemaAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeDataType":
            suggest = "attribute_data_type"
        elif key == "developerOnlyAttribute":
            suggest = "developer_only_attribute"
        elif key == "numberAttributeConstraints":
            suggest = "number_attribute_constraints"
        elif key == "stringAttributeConstraints":
            suggest = "string_attribute_constraints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolSchemaAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolSchemaAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolSchemaAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_data_type: Optional[builtins.str] = None,
                 developer_only_attribute: Optional[builtins.bool] = None,
                 mutable: Optional[builtins.bool] = None,
                 name: Optional[builtins.str] = None,
                 number_attribute_constraints: Optional['outputs.UserPoolNumberAttributeConstraints'] = None,
                 required: Optional[builtins.bool] = None,
                 string_attribute_constraints: Optional['outputs.UserPoolStringAttributeConstraints'] = None):
        """
        :param builtins.str attribute_data_type: The data format of the values for your attribute. When you choose an `AttributeDataType` , Amazon Cognito validates the input against the data type. A custom attribute value in your user's ID token is always a string, for example `"custom:isMember" : "true"` or `"custom:YearsAsMember" : "12"` .
        :param builtins.bool developer_only_attribute: > You should use [WriteAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes) in the user pool client to control how attributes can be mutated for new use cases instead of using `DeveloperOnlyAttribute` . 
               
               Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, `DeveloperOnlyAttribute` can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.
        :param builtins.bool mutable: Specifies whether the value of the attribute can be changed.
               
               Any user pool attribute whose value you map from an IdP attribute must be mutable, with a parameter value of `true` . Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see [Specifying Identity Provider Attribute Mappings for Your User Pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html) .
        :param builtins.str name: The name of your user pool attribute. When you create or update a user pool, adding a schema attribute creates a custom or developer-only attribute. When you add an attribute with a `Name` value of `MyAttribute` , Amazon Cognito creates the custom attribute `custom:MyAttribute` . When `DeveloperOnlyAttribute` is `true` , Amazon Cognito creates your attribute as `dev:MyAttribute` . In an operation that describes a user pool, Amazon Cognito returns this value as `value` for standard attributes, `custom:value` for custom attributes, and `dev:value` for developer-only attributes..
        :param 'UserPoolNumberAttributeConstraints' number_attribute_constraints: Specifies the constraints for an attribute of the number type.
        :param builtins.bool required: Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.
        :param 'UserPoolStringAttributeConstraints' string_attribute_constraints: Specifies the constraints for an attribute of the string type.
        """
        if attribute_data_type is not None:
            pulumi.set(__self__, "attribute_data_type", attribute_data_type)
        if developer_only_attribute is not None:
            pulumi.set(__self__, "developer_only_attribute", developer_only_attribute)
        if mutable is not None:
            pulumi.set(__self__, "mutable", mutable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_attribute_constraints is not None:
            pulumi.set(__self__, "number_attribute_constraints", number_attribute_constraints)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if string_attribute_constraints is not None:
            pulumi.set(__self__, "string_attribute_constraints", string_attribute_constraints)

    @property
    @pulumi.getter(name="attributeDataType")
    def attribute_data_type(self) -> Optional[builtins.str]:
        """
        The data format of the values for your attribute. When you choose an `AttributeDataType` , Amazon Cognito validates the input against the data type. A custom attribute value in your user's ID token is always a string, for example `"custom:isMember" : "true"` or `"custom:YearsAsMember" : "12"` .
        """
        return pulumi.get(self, "attribute_data_type")

    @property
    @pulumi.getter(name="developerOnlyAttribute")
    def developer_only_attribute(self) -> Optional[builtins.bool]:
        """
        > You should use [WriteAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes) in the user pool client to control how attributes can be mutated for new use cases instead of using `DeveloperOnlyAttribute` . 

        Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, `DeveloperOnlyAttribute` can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.
        """
        return pulumi.get(self, "developer_only_attribute")

    @property
    @pulumi.getter
    def mutable(self) -> Optional[builtins.bool]:
        """
        Specifies whether the value of the attribute can be changed.

        Any user pool attribute whose value you map from an IdP attribute must be mutable, with a parameter value of `true` . Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see [Specifying Identity Provider Attribute Mappings for Your User Pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html) .
        """
        return pulumi.get(self, "mutable")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of your user pool attribute. When you create or update a user pool, adding a schema attribute creates a custom or developer-only attribute. When you add an attribute with a `Name` value of `MyAttribute` , Amazon Cognito creates the custom attribute `custom:MyAttribute` . When `DeveloperOnlyAttribute` is `true` , Amazon Cognito creates your attribute as `dev:MyAttribute` . In an operation that describes a user pool, Amazon Cognito returns this value as `value` for standard attributes, `custom:value` for custom attributes, and `dev:value` for developer-only attributes..
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberAttributeConstraints")
    def number_attribute_constraints(self) -> Optional['outputs.UserPoolNumberAttributeConstraints']:
        """
        Specifies the constraints for an attribute of the number type.
        """
        return pulumi.get(self, "number_attribute_constraints")

    @property
    @pulumi.getter
    def required(self) -> Optional[builtins.bool]:
        """
        Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter(name="stringAttributeConstraints")
    def string_attribute_constraints(self) -> Optional['outputs.UserPoolStringAttributeConstraints']:
        """
        Specifies the constraints for an attribute of the string type.
        """
        return pulumi.get(self, "string_attribute_constraints")


@pulumi.output_type
class UserPoolSignInPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedFirstAuthFactors":
            suggest = "allowed_first_auth_factors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolSignInPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolSignInPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolSignInPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_first_auth_factors: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allowed_first_auth_factors: The sign-in methods that a user pool supports as the first factor. You can permit users to start authentication with a standard username and password, or with other one-time password and hardware factors.
               
               Supports values of `EMAIL_OTP` , `SMS_OTP` , `WEB_AUTHN` and `PASSWORD` ,
        """
        if allowed_first_auth_factors is not None:
            pulumi.set(__self__, "allowed_first_auth_factors", allowed_first_auth_factors)

    @property
    @pulumi.getter(name="allowedFirstAuthFactors")
    def allowed_first_auth_factors(self) -> Optional[Sequence[builtins.str]]:
        """
        The sign-in methods that a user pool supports as the first factor. You can permit users to start authentication with a standard username and password, or with other one-time password and hardware factors.

        Supports values of `EMAIL_OTP` , `SMS_OTP` , `WEB_AUTHN` and `PASSWORD` ,
        """
        return pulumi.get(self, "allowed_first_auth_factors")


@pulumi.output_type
class UserPoolSmsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"
        elif key == "snsCallerArn":
            suggest = "sns_caller_arn"
        elif key == "snsRegion":
            suggest = "sns_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolSmsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolSmsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolSmsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: Optional[builtins.str] = None,
                 sns_caller_arn: Optional[builtins.str] = None,
                 sns_region: Optional[builtins.str] = None):
        """
        :param builtins.str external_id: The external ID provides additional security for your IAM role. You can use an `ExternalId` with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an `ExternalId` , your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the `ExternalID` . If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the `ExternalId` .
               
               For more information about the `ExternalId` of a role, see [How to use an external ID when granting access to your AWS resources to a third party](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html) .
        :param builtins.str sns_caller_arn: The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your AWS account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a [spending limit](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html) .
        :param builtins.str sns_region: The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported *Legacy Amazon SNS alternate Region* .
               
               Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) .
        """
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if sns_caller_arn is not None:
            pulumi.set(__self__, "sns_caller_arn", sns_caller_arn)
        if sns_region is not None:
            pulumi.set(__self__, "sns_region", sns_region)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        The external ID provides additional security for your IAM role. You can use an `ExternalId` with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an `ExternalId` , your Amazon Cognito user pool includes it in the request to assume your IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the `ExternalID` . If you use the Amazon Cognito Management Console to create a role for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that demonstrates use of the `ExternalId` .

        For more information about the `ExternalId` of a role, see [How to use an external ID when granting access to your AWS resources to a third party](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html) .
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="snsCallerArn")
    def sns_caller_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your AWS account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a [spending limit](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html) .
        """
        return pulumi.get(self, "sns_caller_arn")

    @property
    @pulumi.getter(name="snsRegion")
    def sns_region(self) -> Optional[builtins.str]:
        """
        The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported *Legacy Amazon SNS alternate Region* .

        Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) .
        """
        return pulumi.get(self, "sns_region")


@pulumi.output_type
class UserPoolStringAttributeConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxLength":
            suggest = "max_length"
        elif key == "minLength":
            suggest = "min_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolStringAttributeConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolStringAttributeConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolStringAttributeConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_length: Optional[builtins.str] = None,
                 min_length: Optional[builtins.str] = None):
        """
        :param builtins.str max_length: The maximum length of a string attribute value. Must be a number less than or equal to `2^1023` , represented as a string with a length of 131072 characters or fewer.
        :param builtins.str min_length: The minimum length of a string attribute value.
        """
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[builtins.str]:
        """
        The maximum length of a string attribute value. Must be a number less than or equal to `2^1023` , represented as a string with a length of 131072 characters or fewer.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[builtins.str]:
        """
        The minimum length of a string attribute value.
        """
        return pulumi.get(self, "min_length")


@pulumi.output_type
class UserPoolUserAttributeType(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the attribute.
        :param builtins.str value: The value of the attribute.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the attribute.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UserPoolUserAttributeUpdateSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributesRequireVerificationBeforeUpdate":
            suggest = "attributes_require_verification_before_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolUserAttributeUpdateSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolUserAttributeUpdateSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolUserAttributeUpdateSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes_require_verification_before_update: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] attributes_require_verification_before_update: Requires that your user verifies their email address, phone number, or both before Amazon Cognito updates the value of that attribute. When you update a user attribute that has this option activated, Amazon Cognito sends a verification message to the new phone number or email address. Amazon Cognito doesn’t change the value of the attribute until your user responds to the verification message and confirms the new value.
               
               When `AttributesRequireVerificationBeforeUpdate` is false, your user pool doesn't require that your users verify attribute changes before Amazon Cognito updates them. In a user pool where `AttributesRequireVerificationBeforeUpdate` is false, API operations that change attribute values can immediately update a user’s `email` or `phone_number` attribute.
        """
        pulumi.set(__self__, "attributes_require_verification_before_update", attributes_require_verification_before_update)

    @property
    @pulumi.getter(name="attributesRequireVerificationBeforeUpdate")
    def attributes_require_verification_before_update(self) -> Sequence[builtins.str]:
        """
        Requires that your user verifies their email address, phone number, or both before Amazon Cognito updates the value of that attribute. When you update a user attribute that has this option activated, Amazon Cognito sends a verification message to the new phone number or email address. Amazon Cognito doesn’t change the value of the attribute until your user responds to the verification message and confirms the new value.

        When `AttributesRequireVerificationBeforeUpdate` is false, your user pool doesn't require that your users verify attribute changes before Amazon Cognito updates them. In a user pool where `AttributesRequireVerificationBeforeUpdate` is false, API operations that change attribute values can immediately update a user’s `email` or `phone_number` attribute.
        """
        return pulumi.get(self, "attributes_require_verification_before_update")


@pulumi.output_type
class UserPoolUsernameConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolUsernameConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolUsernameConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolUsernameConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: Optional[builtins.bool] = None):
        """
        :param builtins.bool case_sensitive: Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs. For most use cases, set case sensitivity to `False` (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.
               
               Valid values include:
               
               - **true** - Enables case sensitivity for all username input. When this option is set to `true` , users must sign in using the exact capitalization of their given username, such as "UserName". This is the default value.
               - **false** - Enables case insensitivity for all username input. For example, when this option is set to `false` , users can sign in using `username` , `USERNAME` , or `UserName` . This option also enables both `preferred_username` and `email` alias to be case insensitive, in addition to the `username` attribute.
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[builtins.bool]:
        """
        Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs. For most use cases, set case sensitivity to `False` (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.

        Valid values include:

        - **true** - Enables case sensitivity for all username input. When this option is set to `true` , users must sign in using the exact capitalization of their given username, such as "UserName". This is the default value.
        - **false** - Enables case insensitivity for all username input. For example, when this option is set to `false` , users can sign in using `username` , `USERNAME` , or `UserName` . This option also enables both `preferred_username` and `email` alias to be case insensitive, in addition to the `username` attribute.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class UserPoolVerificationMessageTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultEmailOption":
            suggest = "default_email_option"
        elif key == "emailMessage":
            suggest = "email_message"
        elif key == "emailMessageByLink":
            suggest = "email_message_by_link"
        elif key == "emailSubject":
            suggest = "email_subject"
        elif key == "emailSubjectByLink":
            suggest = "email_subject_by_link"
        elif key == "smsMessage":
            suggest = "sms_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolVerificationMessageTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolVerificationMessageTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolVerificationMessageTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_email_option: Optional[builtins.str] = None,
                 email_message: Optional[builtins.str] = None,
                 email_message_by_link: Optional[builtins.str] = None,
                 email_subject: Optional[builtins.str] = None,
                 email_subject_by_link: Optional[builtins.str] = None,
                 sms_message: Optional[builtins.str] = None):
        """
        :param builtins.str default_email_option: The configuration of verification emails to contain a clickable link or a verification code.
               
               For link, your template body must contain link text in the format `{##Click here##}` . "Click here" in the example is a customizable string. For code, your template body must contain a code placeholder in the format `{####}` .
        :param builtins.str email_message: The template for email messages that Amazon Cognito sends to your users. You can set an `EmailMessage` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        :param builtins.str email_message_by_link: The email message template for sending a confirmation link to the user. You can set an `EmailMessageByLink` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        :param builtins.str email_subject: The subject line for the email message template. You can set an `EmailSubject` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        :param builtins.str email_subject_by_link: The subject line for the email message template for sending a confirmation link to the user. You can set an `EmailSubjectByLink` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        :param builtins.str sms_message: The template for SMS messages that Amazon Cognito sends to your users.
        """
        if default_email_option is not None:
            pulumi.set(__self__, "default_email_option", default_email_option)
        if email_message is not None:
            pulumi.set(__self__, "email_message", email_message)
        if email_message_by_link is not None:
            pulumi.set(__self__, "email_message_by_link", email_message_by_link)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if email_subject_by_link is not None:
            pulumi.set(__self__, "email_subject_by_link", email_subject_by_link)
        if sms_message is not None:
            pulumi.set(__self__, "sms_message", sms_message)

    @property
    @pulumi.getter(name="defaultEmailOption")
    def default_email_option(self) -> Optional[builtins.str]:
        """
        The configuration of verification emails to contain a clickable link or a verification code.

        For link, your template body must contain link text in the format `{##Click here##}` . "Click here" in the example is a customizable string. For code, your template body must contain a code placeholder in the format `{####}` .
        """
        return pulumi.get(self, "default_email_option")

    @property
    @pulumi.getter(name="emailMessage")
    def email_message(self) -> Optional[builtins.str]:
        """
        The template for email messages that Amazon Cognito sends to your users. You can set an `EmailMessage` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        """
        return pulumi.get(self, "email_message")

    @property
    @pulumi.getter(name="emailMessageByLink")
    def email_message_by_link(self) -> Optional[builtins.str]:
        """
        The email message template for sending a confirmation link to the user. You can set an `EmailMessageByLink` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        """
        return pulumi.get(self, "email_message_by_link")

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[builtins.str]:
        """
        The subject line for the email message template. You can set an `EmailSubject` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        """
        return pulumi.get(self, "email_subject")

    @property
    @pulumi.getter(name="emailSubjectByLink")
    def email_subject_by_link(self) -> Optional[builtins.str]:
        """
        The subject line for the email message template for sending a confirmation link to the user. You can set an `EmailSubjectByLink` template only if the value of [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` . When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER` , your user pool sends email messages with your own Amazon SES configuration.
        """
        return pulumi.get(self, "email_subject_by_link")

    @property
    @pulumi.getter(name="smsMessage")
    def sms_message(self) -> Optional[builtins.str]:
        """
        The template for SMS messages that Amazon Cognito sends to your users.
        """
        return pulumi.get(self, "sms_message")


