# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogDeliveryConfigurationArgs', 'LogDeliveryConfiguration']

@pulumi.input_type
class LogDeliveryConfigurationArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[builtins.str],
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a LogDeliveryConfiguration resource.
        :param pulumi.Input[builtins.str] user_pool_id: The ID of the user pool where you configured logging.
        :param pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]] log_configurations: A logging destination of a user pool. User pools can have multiple logging destinations for message-delivery and user-activity logs.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if log_configurations is not None:
            pulumi.set(__self__, "log_configurations", log_configurations)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the user pool where you configured logging.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]]:
        """
        A logging destination of a user pool. User pools can have multiple logging destinations for message-delivery and user-activity logs.
        """
        return pulumi.get(self, "log_configurations")

    @log_configurations.setter
    def log_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]]):
        pulumi.set(self, "log_configurations", value)


@pulumi.type_token("aws-native:cognito:LogDeliveryConfiguration")
class LogDeliveryConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Cognito::LogDeliveryConfiguration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]] log_configurations: A logging destination of a user pool. User pools can have multiple logging destinations for message-delivery and user-activity logs.
        :param pulumi.Input[builtins.str] user_pool_id: The ID of the user pool where you configured logging.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogDeliveryConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Cognito::LogDeliveryConfiguration

        :param str resource_name: The name of the resource.
        :param LogDeliveryConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogDeliveryConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]]] = None,
                 user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogDeliveryConfigurationArgs.__new__(LogDeliveryConfigurationArgs)

            __props__.__dict__["log_configurations"] = log_configurations
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["userPoolId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LogDeliveryConfiguration, __self__).__init__(
            'aws-native:cognito:LogDeliveryConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LogDeliveryConfiguration':
        """
        Get an existing LogDeliveryConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LogDeliveryConfigurationArgs.__new__(LogDeliveryConfigurationArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["log_configurations"] = None
        __props__.__dict__["user_pool_id"] = None
        return LogDeliveryConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        A user pool ID, for example `us-east-1_EXAMPLE` .
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.LogDeliveryConfigurationLogConfiguration']]]:
        """
        A logging destination of a user pool. User pools can have multiple logging destinations for message-delivery and user-activity logs.
        """
        return pulumi.get(self, "log_configurations")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the user pool where you configured logging.
        """
        return pulumi.get(self, "user_pool_id")

