# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityPoolPrincipalTagArgs', 'IdentityPoolPrincipalTag']

@pulumi.input_type
class IdentityPoolPrincipalTagArgs:
    def __init__(__self__, *,
                 identity_pool_id: pulumi.Input[builtins.str],
                 identity_provider_name: pulumi.Input[builtins.str],
                 principal_tags: Optional[Any] = None,
                 use_defaults: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a IdentityPoolPrincipalTag resource.
        :param pulumi.Input[builtins.str] identity_pool_id: The identity pool that you want to associate with this principal tag map.
        :param pulumi.Input[builtins.str] identity_provider_name: The identity pool identity provider (IdP) that you want to associate with this principal tag map.
        :param Any principal_tags: A JSON-formatted list of user claims and the principal tags that you want to associate with them. When Amazon Cognito requests credentials, it sets the value of the principal tag to the value of the user's claim.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Cognito::IdentityPoolPrincipalTag` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.bool] use_defaults: Use a default set of mappings between claims and tags for this provider, instead of a custom map.
        """
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "identity_provider_name", identity_provider_name)
        if principal_tags is not None:
            pulumi.set(__self__, "principal_tags", principal_tags)
        if use_defaults is not None:
            pulumi.set(__self__, "use_defaults", use_defaults)

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The identity pool that you want to associate with this principal tag map.
        """
        return pulumi.get(self, "identity_pool_id")

    @identity_pool_id.setter
    def identity_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_pool_id", value)

    @property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> pulumi.Input[builtins.str]:
        """
        The identity pool identity provider (IdP) that you want to associate with this principal tag map.
        """
        return pulumi.get(self, "identity_provider_name")

    @identity_provider_name.setter
    def identity_provider_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_provider_name", value)

    @property
    @pulumi.getter(name="principalTags")
    def principal_tags(self) -> Optional[Any]:
        """
        A JSON-formatted list of user claims and the principal tags that you want to associate with them. When Amazon Cognito requests credentials, it sets the value of the principal tag to the value of the user's claim.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Cognito::IdentityPoolPrincipalTag` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "principal_tags")

    @principal_tags.setter
    def principal_tags(self, value: Optional[Any]):
        pulumi.set(self, "principal_tags", value)

    @property
    @pulumi.getter(name="useDefaults")
    def use_defaults(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use a default set of mappings between claims and tags for this provider, instead of a custom map.
        """
        return pulumi.get(self, "use_defaults")

    @use_defaults.setter
    def use_defaults(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_defaults", value)


@pulumi.type_token("aws-native:cognito:IdentityPoolPrincipalTag")
class IdentityPoolPrincipalTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 principal_tags: Optional[Any] = None,
                 use_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Cognito::IdentityPoolPrincipalTag

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] identity_pool_id: The identity pool that you want to associate with this principal tag map.
        :param pulumi.Input[builtins.str] identity_provider_name: The identity pool identity provider (IdP) that you want to associate with this principal tag map.
        :param Any principal_tags: A JSON-formatted list of user claims and the principal tags that you want to associate with them. When Amazon Cognito requests credentials, it sets the value of the principal tag to the value of the user's claim.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Cognito::IdentityPoolPrincipalTag` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.bool] use_defaults: Use a default set of mappings between claims and tags for this provider, instead of a custom map.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityPoolPrincipalTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Cognito::IdentityPoolPrincipalTag

        :param str resource_name: The name of the resource.
        :param IdentityPoolPrincipalTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityPoolPrincipalTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 principal_tags: Optional[Any] = None,
                 use_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityPoolPrincipalTagArgs.__new__(IdentityPoolPrincipalTagArgs)

            if identity_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'identity_pool_id'")
            __props__.__dict__["identity_pool_id"] = identity_pool_id
            if identity_provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_name'")
            __props__.__dict__["identity_provider_name"] = identity_provider_name
            __props__.__dict__["principal_tags"] = principal_tags
            __props__.__dict__["use_defaults"] = use_defaults
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["identityPoolId", "identityProviderName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IdentityPoolPrincipalTag, __self__).__init__(
            'aws-native:cognito:IdentityPoolPrincipalTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IdentityPoolPrincipalTag':
        """
        Get an existing IdentityPoolPrincipalTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IdentityPoolPrincipalTagArgs.__new__(IdentityPoolPrincipalTagArgs)

        __props__.__dict__["identity_pool_id"] = None
        __props__.__dict__["identity_provider_name"] = None
        __props__.__dict__["principal_tags"] = None
        __props__.__dict__["use_defaults"] = None
        return IdentityPoolPrincipalTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The identity pool that you want to associate with this principal tag map.
        """
        return pulumi.get(self, "identity_pool_id")

    @property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> pulumi.Output[builtins.str]:
        """
        The identity pool identity provider (IdP) that you want to associate with this principal tag map.
        """
        return pulumi.get(self, "identity_provider_name")

    @property
    @pulumi.getter(name="principalTags")
    def principal_tags(self) -> pulumi.Output[Optional[Any]]:
        """
        A JSON-formatted list of user claims and the principal tags that you want to associate with them. When Amazon Cognito requests credentials, it sets the value of the principal tag to the value of the user's claim.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Cognito::IdentityPoolPrincipalTag` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "principal_tags")

    @property
    @pulumi.getter(name="useDefaults")
    def use_defaults(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Use a default set of mappings between claims and tags for this provider, instead of a custom map.
        """
        return pulumi.get(self, "use_defaults")

