# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserPoolResourceServerResult',
    'AwaitableGetUserPoolResourceServerResult',
    'get_user_pool_resource_server',
    'get_user_pool_resource_server_output',
]

@pulumi.output_type
class GetUserPoolResourceServerResult:
    def __init__(__self__, name=None, scopes=None):
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A friendly name for the resource server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence['outputs.UserPoolResourceServerResourceServerScopeType']]:
        """
        A list of scopes. Each scope is a map with keys `ScopeName` and `ScopeDescription` .
        """
        return pulumi.get(self, "scopes")


class AwaitableGetUserPoolResourceServerResult(GetUserPoolResourceServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserPoolResourceServerResult(
            name=self.name,
            scopes=self.scopes)


def get_user_pool_resource_server(identifier: Optional[builtins.str] = None,
                                  user_pool_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserPoolResourceServerResult:
    """
    Resource Type definition for AWS::Cognito::UserPoolResourceServer


    :param builtins.str identifier: A unique resource server identifier for the resource server. The identifier can be an API friendly name like `solar-system-data` . You can also set an API URL like `https://solar-system-data-api.example.com` as your identifier.
           
           Amazon Cognito represents scopes in the access token in the format `$resource-server-identifier/$scope` . Longer scope-identifier strings increase the size of your access tokens.
    :param builtins.str user_pool_id: The ID of the user pool where you want to create a resource server.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cognito:getUserPoolResourceServer', __args__, opts=opts, typ=GetUserPoolResourceServerResult).value

    return AwaitableGetUserPoolResourceServerResult(
        name=pulumi.get(__ret__, 'name'),
        scopes=pulumi.get(__ret__, 'scopes'))
def get_user_pool_resource_server_output(identifier: Optional[pulumi.Input[builtins.str]] = None,
                                         user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserPoolResourceServerResult]:
    """
    Resource Type definition for AWS::Cognito::UserPoolResourceServer


    :param builtins.str identifier: A unique resource server identifier for the resource server. The identifier can be an API friendly name like `solar-system-data` . You can also set an API URL like `https://solar-system-data-api.example.com` as your identifier.
           
           Amazon Cognito represents scopes in the access token in the format `$resource-server-identifier/$scope` . Longer scope-identifier strings increase the size of your access tokens.
    :param builtins.str user_pool_id: The ID of the user pool where you want to create a resource server.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cognito:getUserPoolResourceServer', __args__, opts=opts, typ=GetUserPoolResourceServerResult)
    return __ret__.apply(lambda __response__: GetUserPoolResourceServerResult(
        name=pulumi.get(__response__, 'name'),
        scopes=pulumi.get(__response__, 'scopes')))
