# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetUserPoolResult',
    'AwaitableGetUserPoolResult',
    'get_user_pool',
    'get_user_pool_output',
]

@pulumi.output_type
class GetUserPoolResult:
    def __init__(__self__, account_recovery_setting=None, admin_create_user_config=None, alias_attributes=None, arn=None, auto_verified_attributes=None, deletion_protection=None, device_configuration=None, email_authentication_message=None, email_authentication_subject=None, email_configuration=None, email_verification_message=None, email_verification_subject=None, lambda_config=None, mfa_configuration=None, policies=None, provider_name=None, provider_url=None, schema=None, sms_authentication_message=None, sms_configuration=None, sms_verification_message=None, user_attribute_update_settings=None, user_pool_add_ons=None, user_pool_id=None, user_pool_name=None, user_pool_tags=None, user_pool_tier=None, username_attributes=None, username_configuration=None, verification_message_template=None, web_authn_relying_party_id=None, web_authn_user_verification=None):
        if account_recovery_setting and not isinstance(account_recovery_setting, dict):
            raise TypeError("Expected argument 'account_recovery_setting' to be a dict")
        pulumi.set(__self__, "account_recovery_setting", account_recovery_setting)
        if admin_create_user_config and not isinstance(admin_create_user_config, dict):
            raise TypeError("Expected argument 'admin_create_user_config' to be a dict")
        pulumi.set(__self__, "admin_create_user_config", admin_create_user_config)
        if alias_attributes and not isinstance(alias_attributes, list):
            raise TypeError("Expected argument 'alias_attributes' to be a list")
        pulumi.set(__self__, "alias_attributes", alias_attributes)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_verified_attributes and not isinstance(auto_verified_attributes, list):
            raise TypeError("Expected argument 'auto_verified_attributes' to be a list")
        pulumi.set(__self__, "auto_verified_attributes", auto_verified_attributes)
        if deletion_protection and not isinstance(deletion_protection, str):
            raise TypeError("Expected argument 'deletion_protection' to be a str")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if device_configuration and not isinstance(device_configuration, dict):
            raise TypeError("Expected argument 'device_configuration' to be a dict")
        pulumi.set(__self__, "device_configuration", device_configuration)
        if email_authentication_message and not isinstance(email_authentication_message, str):
            raise TypeError("Expected argument 'email_authentication_message' to be a str")
        pulumi.set(__self__, "email_authentication_message", email_authentication_message)
        if email_authentication_subject and not isinstance(email_authentication_subject, str):
            raise TypeError("Expected argument 'email_authentication_subject' to be a str")
        pulumi.set(__self__, "email_authentication_subject", email_authentication_subject)
        if email_configuration and not isinstance(email_configuration, dict):
            raise TypeError("Expected argument 'email_configuration' to be a dict")
        pulumi.set(__self__, "email_configuration", email_configuration)
        if email_verification_message and not isinstance(email_verification_message, str):
            raise TypeError("Expected argument 'email_verification_message' to be a str")
        pulumi.set(__self__, "email_verification_message", email_verification_message)
        if email_verification_subject and not isinstance(email_verification_subject, str):
            raise TypeError("Expected argument 'email_verification_subject' to be a str")
        pulumi.set(__self__, "email_verification_subject", email_verification_subject)
        if lambda_config and not isinstance(lambda_config, dict):
            raise TypeError("Expected argument 'lambda_config' to be a dict")
        pulumi.set(__self__, "lambda_config", lambda_config)
        if mfa_configuration and not isinstance(mfa_configuration, str):
            raise TypeError("Expected argument 'mfa_configuration' to be a str")
        pulumi.set(__self__, "mfa_configuration", mfa_configuration)
        if policies and not isinstance(policies, dict):
            raise TypeError("Expected argument 'policies' to be a dict")
        pulumi.set(__self__, "policies", policies)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if provider_url and not isinstance(provider_url, str):
            raise TypeError("Expected argument 'provider_url' to be a str")
        pulumi.set(__self__, "provider_url", provider_url)
        if schema and not isinstance(schema, list):
            raise TypeError("Expected argument 'schema' to be a list")
        pulumi.set(__self__, "schema", schema)
        if sms_authentication_message and not isinstance(sms_authentication_message, str):
            raise TypeError("Expected argument 'sms_authentication_message' to be a str")
        pulumi.set(__self__, "sms_authentication_message", sms_authentication_message)
        if sms_configuration and not isinstance(sms_configuration, dict):
            raise TypeError("Expected argument 'sms_configuration' to be a dict")
        pulumi.set(__self__, "sms_configuration", sms_configuration)
        if sms_verification_message and not isinstance(sms_verification_message, str):
            raise TypeError("Expected argument 'sms_verification_message' to be a str")
        pulumi.set(__self__, "sms_verification_message", sms_verification_message)
        if user_attribute_update_settings and not isinstance(user_attribute_update_settings, dict):
            raise TypeError("Expected argument 'user_attribute_update_settings' to be a dict")
        pulumi.set(__self__, "user_attribute_update_settings", user_attribute_update_settings)
        if user_pool_add_ons and not isinstance(user_pool_add_ons, dict):
            raise TypeError("Expected argument 'user_pool_add_ons' to be a dict")
        pulumi.set(__self__, "user_pool_add_ons", user_pool_add_ons)
        if user_pool_id and not isinstance(user_pool_id, str):
            raise TypeError("Expected argument 'user_pool_id' to be a str")
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if user_pool_name and not isinstance(user_pool_name, str):
            raise TypeError("Expected argument 'user_pool_name' to be a str")
        pulumi.set(__self__, "user_pool_name", user_pool_name)
        if user_pool_tags and not isinstance(user_pool_tags, dict):
            raise TypeError("Expected argument 'user_pool_tags' to be a dict")
        pulumi.set(__self__, "user_pool_tags", user_pool_tags)
        if user_pool_tier and not isinstance(user_pool_tier, str):
            raise TypeError("Expected argument 'user_pool_tier' to be a str")
        pulumi.set(__self__, "user_pool_tier", user_pool_tier)
        if username_attributes and not isinstance(username_attributes, list):
            raise TypeError("Expected argument 'username_attributes' to be a list")
        pulumi.set(__self__, "username_attributes", username_attributes)
        if username_configuration and not isinstance(username_configuration, dict):
            raise TypeError("Expected argument 'username_configuration' to be a dict")
        pulumi.set(__self__, "username_configuration", username_configuration)
        if verification_message_template and not isinstance(verification_message_template, dict):
            raise TypeError("Expected argument 'verification_message_template' to be a dict")
        pulumi.set(__self__, "verification_message_template", verification_message_template)
        if web_authn_relying_party_id and not isinstance(web_authn_relying_party_id, str):
            raise TypeError("Expected argument 'web_authn_relying_party_id' to be a str")
        pulumi.set(__self__, "web_authn_relying_party_id", web_authn_relying_party_id)
        if web_authn_user_verification and not isinstance(web_authn_user_verification, str):
            raise TypeError("Expected argument 'web_authn_user_verification' to be a str")
        pulumi.set(__self__, "web_authn_user_verification", web_authn_user_verification)

    @property
    @pulumi.getter(name="accountRecoverySetting")
    def account_recovery_setting(self) -> Optional['outputs.UserPoolAccountRecoverySetting']:
        """
        The available verified method a user can use to recover their password when they call `ForgotPassword` . You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
        """
        return pulumi.get(self, "account_recovery_setting")

    @property
    @pulumi.getter(name="adminCreateUserConfig")
    def admin_create_user_config(self) -> Optional['outputs.UserPoolAdminCreateUserConfig']:
        """
        The settings for administrator creation of users in a user pool. Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.
        """
        return pulumi.get(self, "admin_create_user_config")

    @property
    @pulumi.getter(name="aliasAttributes")
    def alias_attributes(self) -> Optional[Sequence[builtins.str]]:
        """
        Attributes supported as an alias for this user pool. For more information about alias attributes, see [Customizing sign-in attributes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-aliases) .
        """
        return pulumi.get(self, "alias_attributes")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the user pool, such as `arn:aws:cognito-idp:us-east-1:123412341234:userpool/us-east-1_123412341` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoVerifiedAttributes")
    def auto_verified_attributes(self) -> Optional[Sequence[builtins.str]]:
        """
        The attributes that you want your user pool to automatically verify. For more information, see [Verifying contact information at sign-up](https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#allowing-users-to-sign-up-and-confirm-themselves) .
        """
        return pulumi.get(self, "auto_verified_attributes")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[builtins.str]:
        """
        When active, `DeletionProtection` prevents accidental deletion of your user
        pool. Before you can delete a user pool that you have protected against deletion, you
        must deactivate this feature.

        When you try to delete a protected user pool in a `DeleteUserPool` API request, Amazon Cognito returns an `InvalidParameterException` error. To delete a protected user pool, send a new `DeleteUserPool` request after you deactivate deletion protection in an `UpdateUserPool` API request.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="deviceConfiguration")
    def device_configuration(self) -> Optional['outputs.UserPoolDeviceConfiguration']:
        """
        The device-remembering configuration for a user pool. Device remembering or device tracking is a "Remember me on this device" option for user pools that perform authentication with the device key of a trusted device in the back end, instead of a user-provided MFA code. For more information about device authentication, see [Working with user devices in your user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html) . A null value indicates that you have deactivated device remembering in your user pool.

        > When you provide a value for any `DeviceConfiguration` field, you activate the Amazon Cognito device-remembering feature. For more information, see [Working with devices](https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html) .
        """
        return pulumi.get(self, "device_configuration")

    @property
    @pulumi.getter(name="emailAuthenticationMessage")
    def email_authentication_message(self) -> Optional[builtins.str]:
        return pulumi.get(self, "email_authentication_message")

    @property
    @pulumi.getter(name="emailAuthenticationSubject")
    def email_authentication_subject(self) -> Optional[builtins.str]:
        return pulumi.get(self, "email_authentication_subject")

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional['outputs.UserPoolEmailConfiguration']:
        """
        The email configuration of your user pool. The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
        """
        return pulumi.get(self, "email_configuration")

    @property
    @pulumi.getter(name="emailVerificationMessage")
    def email_verification_message(self) -> Optional[builtins.str]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html) .
        """
        return pulumi.get(self, "email_verification_message")

    @property
    @pulumi.getter(name="emailVerificationSubject")
    def email_verification_subject(self) -> Optional[builtins.str]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html) .
        """
        return pulumi.get(self, "email_verification_subject")

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional['outputs.UserPoolLambdaConfig']:
        """
        A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
        """
        return pulumi.get(self, "lambda_config")

    @property
    @pulumi.getter(name="mfaConfiguration")
    def mfa_configuration(self) -> Optional[builtins.str]:
        """
        Displays the state of multi-factor authentication (MFA) as on, off, or optional. When `ON` , all users must set up MFA before they can sign in. When `OPTIONAL` , your application must make a client-side determination of whether a user wants to register an MFA device. For user pools with adaptive authentication with threat protection, choose `OPTIONAL` .

        When `MfaConfiguration` is `OPTIONAL` , managed login doesn't automatically prompt users to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users who have chosen and configured a preferred MFA factor.
        """
        return pulumi.get(self, "mfa_configuration")

    @property
    @pulumi.getter
    def policies(self) -> Optional['outputs.UserPoolPolicies']:
        """
        A list of user pool policies. Contains the policy that sets password-complexity requirements.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[builtins.str]:
        """
        A friendly name for the IdP.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="providerUrl")
    def provider_url(self) -> Optional[builtins.str]:
        """
        The URL of the provider of the Amazon Cognito user pool, specified as a `String` .
        """
        return pulumi.get(self, "provider_url")

    @property
    @pulumi.getter
    def schema(self) -> Optional[Sequence['outputs.UserPoolSchemaAttribute']]:
        """
        An array of attributes for the new user pool. You can add custom attributes and modify the properties of default attributes. The specifications in this parameter set the required attributes in your user pool. For more information, see [Working with user attributes](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html) .
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="smsAuthenticationMessage")
    def sms_authentication_message(self) -> Optional[builtins.str]:
        """
        The contents of the SMS authentication message.
        """
        return pulumi.get(self, "sms_authentication_message")

    @property
    @pulumi.getter(name="smsConfiguration")
    def sms_configuration(self) -> Optional['outputs.UserPoolSmsConfiguration']:
        """
        The settings for your Amazon Cognito user pool to send SMS messages with Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account . For more information see [SMS message settings](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html) .
        """
        return pulumi.get(self, "sms_configuration")

    @property
    @pulumi.getter(name="smsVerificationMessage")
    def sms_verification_message(self) -> Optional[builtins.str]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-verificationmessagetemplate.html) .
        """
        return pulumi.get(self, "sms_verification_message")

    @property
    @pulumi.getter(name="userAttributeUpdateSettings")
    def user_attribute_update_settings(self) -> Optional['outputs.UserPoolUserAttributeUpdateSettings']:
        """
        The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate` ,
        a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
        more information, see [Verifying updates to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates) .
        """
        return pulumi.get(self, "user_attribute_update_settings")

    @property
    @pulumi.getter(name="userPoolAddOns")
    def user_pool_add_ons(self) -> Optional['outputs.UserPoolAddOns']:
        """
        Contains settings for activation of threat protection, including the operating mode and additional authentication types. To log user security information but take no action, set to `AUDIT` . To configure automatic security responses to potentially unwanted traffic to your user pool, set to `ENFORCED` .

        For more information, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) . To activate this setting, your user pool must be on the [Plus tier](https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html) .
        """
        return pulumi.get(self, "user_pool_add_ons")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[builtins.str]:
        """
        The ID of the user pool.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="userPoolName")
    def user_pool_name(self) -> Optional[builtins.str]:
        """
        A friendly name for your user pool.
        """
        return pulumi.get(self, "user_pool_name")

    @property
    @pulumi.getter(name="userPoolTags")
    def user_pool_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
        """
        return pulumi.get(self, "user_pool_tags")

    @property
    @pulumi.getter(name="userPoolTier")
    def user_pool_tier(self) -> Optional['UserPoolTier']:
        """
        The user pool [feature plan](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html) , or tier. This parameter determines the eligibility of the user pool for features like managed login, access-token customization, and threat protection. Defaults to `ESSENTIALS` .
        """
        return pulumi.get(self, "user_pool_tier")

    @property
    @pulumi.getter(name="usernameAttributes")
    def username_attributes(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies whether a user can use an email address or phone number as a username when they sign up.
        """
        return pulumi.get(self, "username_attributes")

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> Optional['outputs.UserPoolUsernameConfiguration']:
        """
        Sets the case sensitivity option for sign-in usernames. When `CaseSensitive` is `false` (case insensitive), users can sign in with any combination of capital and lowercase letters. For example, `username` , `USERNAME` , or `UserName` , or for email, `email@example.com` or `EMaiL@eXamplE.Com` . For most use cases, set case sensitivity to `false` as a best practice. When usernames and email addresses are case insensitive, Amazon Cognito treats any variation in case as the same user, and prevents a case variation from being assigned to the same attribute for a different user.

        When `CaseSensitive` is `true` (case sensitive), Amazon Cognito interprets `USERNAME` and `UserName` as distinct users.

        This configuration is immutable after you set it.
        """
        return pulumi.get(self, "username_configuration")

    @property
    @pulumi.getter(name="verificationMessageTemplate")
    def verification_message_template(self) -> Optional['outputs.UserPoolVerificationMessageTemplate']:
        """
        The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.

        Set the email message type that corresponds to your `DefaultEmailOption` selection. For `CONFIRM_WITH_LINK` , specify an `EmailMessageByLink` and leave `EmailMessage` blank. For `CONFIRM_WITH_CODE` , specify an `EmailMessage` and leave `EmailMessageByLink` blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
        """
        return pulumi.get(self, "verification_message_template")

    @property
    @pulumi.getter(name="webAuthnRelyingPartyId")
    def web_authn_relying_party_id(self) -> Optional[builtins.str]:
        """
        Sets or displays the authentication domain, typically your user pool domain, that passkey providers must use as a relying party (RP) in their configuration.

        Under the following conditions, the passkey relying party ID must be the fully-qualified domain name of your custom domain:

        - The user pool is configured for passkey authentication.
        - The user pool has a custom domain, whether or not it also has a prefix domain.
        - Your application performs authentication with managed login or the classic hosted UI.
        """
        return pulumi.get(self, "web_authn_relying_party_id")

    @property
    @pulumi.getter(name="webAuthnUserVerification")
    def web_authn_user_verification(self) -> Optional[builtins.str]:
        """
        When `required` , users can only register and sign in users with passkeys that are capable of [user verification](https://docs.aws.amazon.com/https://www.w3.org/TR/webauthn-2/#enum-userVerificationRequirement) . When `preferred` , your user pool doesn't require the use of authenticators with user verification but encourages it.
        """
        return pulumi.get(self, "web_authn_user_verification")


class AwaitableGetUserPoolResult(GetUserPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserPoolResult(
            account_recovery_setting=self.account_recovery_setting,
            admin_create_user_config=self.admin_create_user_config,
            alias_attributes=self.alias_attributes,
            arn=self.arn,
            auto_verified_attributes=self.auto_verified_attributes,
            deletion_protection=self.deletion_protection,
            device_configuration=self.device_configuration,
            email_authentication_message=self.email_authentication_message,
            email_authentication_subject=self.email_authentication_subject,
            email_configuration=self.email_configuration,
            email_verification_message=self.email_verification_message,
            email_verification_subject=self.email_verification_subject,
            lambda_config=self.lambda_config,
            mfa_configuration=self.mfa_configuration,
            policies=self.policies,
            provider_name=self.provider_name,
            provider_url=self.provider_url,
            schema=self.schema,
            sms_authentication_message=self.sms_authentication_message,
            sms_configuration=self.sms_configuration,
            sms_verification_message=self.sms_verification_message,
            user_attribute_update_settings=self.user_attribute_update_settings,
            user_pool_add_ons=self.user_pool_add_ons,
            user_pool_id=self.user_pool_id,
            user_pool_name=self.user_pool_name,
            user_pool_tags=self.user_pool_tags,
            user_pool_tier=self.user_pool_tier,
            username_attributes=self.username_attributes,
            username_configuration=self.username_configuration,
            verification_message_template=self.verification_message_template,
            web_authn_relying_party_id=self.web_authn_relying_party_id,
            web_authn_user_verification=self.web_authn_user_verification)


def get_user_pool(user_pool_id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserPoolResult:
    """
    Definition of AWS::Cognito::UserPool Resource Type


    :param builtins.str user_pool_id: The ID of the user pool.
    """
    __args__ = dict()
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cognito:getUserPool', __args__, opts=opts, typ=GetUserPoolResult).value

    return AwaitableGetUserPoolResult(
        account_recovery_setting=pulumi.get(__ret__, 'account_recovery_setting'),
        admin_create_user_config=pulumi.get(__ret__, 'admin_create_user_config'),
        alias_attributes=pulumi.get(__ret__, 'alias_attributes'),
        arn=pulumi.get(__ret__, 'arn'),
        auto_verified_attributes=pulumi.get(__ret__, 'auto_verified_attributes'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        device_configuration=pulumi.get(__ret__, 'device_configuration'),
        email_authentication_message=pulumi.get(__ret__, 'email_authentication_message'),
        email_authentication_subject=pulumi.get(__ret__, 'email_authentication_subject'),
        email_configuration=pulumi.get(__ret__, 'email_configuration'),
        email_verification_message=pulumi.get(__ret__, 'email_verification_message'),
        email_verification_subject=pulumi.get(__ret__, 'email_verification_subject'),
        lambda_config=pulumi.get(__ret__, 'lambda_config'),
        mfa_configuration=pulumi.get(__ret__, 'mfa_configuration'),
        policies=pulumi.get(__ret__, 'policies'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        provider_url=pulumi.get(__ret__, 'provider_url'),
        schema=pulumi.get(__ret__, 'schema'),
        sms_authentication_message=pulumi.get(__ret__, 'sms_authentication_message'),
        sms_configuration=pulumi.get(__ret__, 'sms_configuration'),
        sms_verification_message=pulumi.get(__ret__, 'sms_verification_message'),
        user_attribute_update_settings=pulumi.get(__ret__, 'user_attribute_update_settings'),
        user_pool_add_ons=pulumi.get(__ret__, 'user_pool_add_ons'),
        user_pool_id=pulumi.get(__ret__, 'user_pool_id'),
        user_pool_name=pulumi.get(__ret__, 'user_pool_name'),
        user_pool_tags=pulumi.get(__ret__, 'user_pool_tags'),
        user_pool_tier=pulumi.get(__ret__, 'user_pool_tier'),
        username_attributes=pulumi.get(__ret__, 'username_attributes'),
        username_configuration=pulumi.get(__ret__, 'username_configuration'),
        verification_message_template=pulumi.get(__ret__, 'verification_message_template'),
        web_authn_relying_party_id=pulumi.get(__ret__, 'web_authn_relying_party_id'),
        web_authn_user_verification=pulumi.get(__ret__, 'web_authn_user_verification'))
def get_user_pool_output(user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserPoolResult]:
    """
    Definition of AWS::Cognito::UserPool Resource Type


    :param builtins.str user_pool_id: The ID of the user pool.
    """
    __args__ = dict()
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cognito:getUserPool', __args__, opts=opts, typ=GetUserPoolResult)
    return __ret__.apply(lambda __response__: GetUserPoolResult(
        account_recovery_setting=pulumi.get(__response__, 'account_recovery_setting'),
        admin_create_user_config=pulumi.get(__response__, 'admin_create_user_config'),
        alias_attributes=pulumi.get(__response__, 'alias_attributes'),
        arn=pulumi.get(__response__, 'arn'),
        auto_verified_attributes=pulumi.get(__response__, 'auto_verified_attributes'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        device_configuration=pulumi.get(__response__, 'device_configuration'),
        email_authentication_message=pulumi.get(__response__, 'email_authentication_message'),
        email_authentication_subject=pulumi.get(__response__, 'email_authentication_subject'),
        email_configuration=pulumi.get(__response__, 'email_configuration'),
        email_verification_message=pulumi.get(__response__, 'email_verification_message'),
        email_verification_subject=pulumi.get(__response__, 'email_verification_subject'),
        lambda_config=pulumi.get(__response__, 'lambda_config'),
        mfa_configuration=pulumi.get(__response__, 'mfa_configuration'),
        policies=pulumi.get(__response__, 'policies'),
        provider_name=pulumi.get(__response__, 'provider_name'),
        provider_url=pulumi.get(__response__, 'provider_url'),
        schema=pulumi.get(__response__, 'schema'),
        sms_authentication_message=pulumi.get(__response__, 'sms_authentication_message'),
        sms_configuration=pulumi.get(__response__, 'sms_configuration'),
        sms_verification_message=pulumi.get(__response__, 'sms_verification_message'),
        user_attribute_update_settings=pulumi.get(__response__, 'user_attribute_update_settings'),
        user_pool_add_ons=pulumi.get(__response__, 'user_pool_add_ons'),
        user_pool_id=pulumi.get(__response__, 'user_pool_id'),
        user_pool_name=pulumi.get(__response__, 'user_pool_name'),
        user_pool_tags=pulumi.get(__response__, 'user_pool_tags'),
        user_pool_tier=pulumi.get(__response__, 'user_pool_tier'),
        username_attributes=pulumi.get(__response__, 'username_attributes'),
        username_configuration=pulumi.get(__response__, 'username_configuration'),
        verification_message_template=pulumi.get(__response__, 'verification_message_template'),
        web_authn_relying_party_id=pulumi.get(__response__, 'web_authn_relying_party_id'),
        web_authn_user_verification=pulumi.get(__response__, 'web_authn_user_verification')))
