# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetManagedLoginBrandingResult',
    'AwaitableGetManagedLoginBrandingResult',
    'get_managed_login_branding',
    'get_managed_login_branding_output',
]

@pulumi.output_type
class GetManagedLoginBrandingResult:
    def __init__(__self__, assets=None, managed_login_branding_id=None, settings=None, use_cognito_provided_values=None):
        if assets and not isinstance(assets, list):
            raise TypeError("Expected argument 'assets' to be a list")
        pulumi.set(__self__, "assets", assets)
        if managed_login_branding_id and not isinstance(managed_login_branding_id, str):
            raise TypeError("Expected argument 'managed_login_branding_id' to be a str")
        pulumi.set(__self__, "managed_login_branding_id", managed_login_branding_id)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if use_cognito_provided_values and not isinstance(use_cognito_provided_values, bool):
            raise TypeError("Expected argument 'use_cognito_provided_values' to be a bool")
        pulumi.set(__self__, "use_cognito_provided_values", use_cognito_provided_values)

    @property
    @pulumi.getter
    def assets(self) -> Optional[Sequence['outputs.ManagedLoginBrandingAssetType']]:
        """
        An array of image files that you want to apply to roles like backgrounds, logos, and icons. Each object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
        """
        return pulumi.get(self, "assets")

    @property
    @pulumi.getter(name="managedLoginBrandingId")
    def managed_login_branding_id(self) -> Optional[builtins.str]:
        """
        The ID of the managed login branding style.
        """
        return pulumi.get(self, "managed_login_branding_id")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        A JSON file, encoded as a `Document` type, with the the settings that you want to apply to your style.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Cognito::ManagedLoginBranding` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="useCognitoProvidedValues")
    def use_cognito_provided_values(self) -> Optional[builtins.bool]:
        """
        When true, applies the default branding style options. This option reverts to default style options that are managed by Amazon Cognito. You can modify them later in the branding editor.

        When you specify `true` for this option, you must also omit values for `Settings` and `Assets` in the request.
        """
        return pulumi.get(self, "use_cognito_provided_values")


class AwaitableGetManagedLoginBrandingResult(GetManagedLoginBrandingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedLoginBrandingResult(
            assets=self.assets,
            managed_login_branding_id=self.managed_login_branding_id,
            settings=self.settings,
            use_cognito_provided_values=self.use_cognito_provided_values)


def get_managed_login_branding(managed_login_branding_id: Optional[builtins.str] = None,
                               user_pool_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedLoginBrandingResult:
    """
    Resource Type definition for AWS::Cognito::ManagedLoginBranding


    :param builtins.str managed_login_branding_id: The ID of the managed login branding style.
    :param builtins.str user_pool_id: The user pool where the branding style is assigned.
    """
    __args__ = dict()
    __args__['managedLoginBrandingId'] = managed_login_branding_id
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cognito:getManagedLoginBranding', __args__, opts=opts, typ=GetManagedLoginBrandingResult).value

    return AwaitableGetManagedLoginBrandingResult(
        assets=pulumi.get(__ret__, 'assets'),
        managed_login_branding_id=pulumi.get(__ret__, 'managed_login_branding_id'),
        settings=pulumi.get(__ret__, 'settings'),
        use_cognito_provided_values=pulumi.get(__ret__, 'use_cognito_provided_values'))
def get_managed_login_branding_output(managed_login_branding_id: Optional[pulumi.Input[builtins.str]] = None,
                                      user_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedLoginBrandingResult]:
    """
    Resource Type definition for AWS::Cognito::ManagedLoginBranding


    :param builtins.str managed_login_branding_id: The ID of the managed login branding style.
    :param builtins.str user_pool_id: The user pool where the branding style is assigned.
    """
    __args__ = dict()
    __args__['managedLoginBrandingId'] = managed_login_branding_id
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cognito:getManagedLoginBranding', __args__, opts=opts, typ=GetManagedLoginBrandingResult)
    return __ret__.apply(lambda __response__: GetManagedLoginBrandingResult(
        assets=pulumi.get(__response__, 'assets'),
        managed_login_branding_id=pulumi.get(__response__, 'managed_login_branding_id'),
        settings=pulumi.get(__response__, 'settings'),
        use_cognito_provided_values=pulumi.get(__response__, 'use_cognito_provided_values')))
