# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['NotificationRuleArgs', 'NotificationRule']

@pulumi.input_type
class NotificationRuleArgs:
    def __init__(__self__, *,
                 detail_type: pulumi.Input['NotificationRuleDetailType'],
                 event_type_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 resource: pulumi.Input[builtins.str],
                 targets: pulumi.Input[Sequence[pulumi.Input['NotificationRuleTargetArgs']]],
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 event_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['NotificationRuleStatus']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NotificationRule resource.
        :param pulumi.Input['NotificationRuleDetailType'] detail_type: The level of detail to include in the notifications for this resource. `BASIC` will include only the contents of the event as it would appear in Amazon CloudWatch. `FULL` will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_type_ids: A list of event types associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        :param pulumi.Input[builtins.str] resource: The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline , repositories in AWS CodeCommit , and build projects in AWS CodeBuild .
        :param pulumi.Input[Sequence[pulumi.Input['NotificationRuleTargetArgs']]] targets: A list of Amazon Resource Names (ARNs) of Amazon SNS topics and  clients to associate with the notification rule.
        :param pulumi.Input[builtins.str] created_by: The name or email alias of the person who created the notification rule.
        :param pulumi.Input[builtins.str] event_type_id: The event type associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        :param pulumi.Input[builtins.str] name: The name for the notification rule. Notification rule names must be unique in your AWS account .
        :param pulumi.Input['NotificationRuleStatus'] status: The status of the notification rule. The default value is `ENABLED` . If the status is set to `DISABLED` , notifications aren't sent for the notification rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A list of tags to apply to this notification rule. Key names cannot start with " `aws` ".
        :param pulumi.Input[builtins.str] target_address: The Amazon Resource Name (ARN) of the Amazon SNS topic or  client.
        """
        pulumi.set(__self__, "detail_type", detail_type)
        pulumi.set(__self__, "event_type_ids", event_type_ids)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "targets", targets)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if event_type_id is not None:
            pulumi.set(__self__, "event_type_id", event_type_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_address is not None:
            pulumi.set(__self__, "target_address", target_address)

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> pulumi.Input['NotificationRuleDetailType']:
        """
        The level of detail to include in the notifications for this resource. `BASIC` will include only the contents of the event as it would appear in Amazon CloudWatch. `FULL` will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
        """
        return pulumi.get(self, "detail_type")

    @detail_type.setter
    def detail_type(self, value: pulumi.Input['NotificationRuleDetailType']):
        pulumi.set(self, "detail_type", value)

    @property
    @pulumi.getter(name="eventTypeIds")
    def event_type_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of event types associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        """
        return pulumi.get(self, "event_type_ids")

    @event_type_ids.setter
    def event_type_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "event_type_ids", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline , repositories in AWS CodeCommit , and build projects in AWS CodeBuild .
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input['NotificationRuleTargetArgs']]]:
        """
        A list of Amazon Resource Names (ARNs) of Amazon SNS topics and  clients to associate with the notification rule.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input['NotificationRuleTargetArgs']]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name or email alias of the person who created the notification rule.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="eventTypeId")
    def event_type_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The event type associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        """
        return pulumi.get(self, "event_type_id")

    @event_type_id.setter
    def event_type_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_type_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the notification rule. Notification rule names must be unique in your AWS account .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['NotificationRuleStatus']]:
        """
        The status of the notification rule. The default value is `ENABLED` . If the status is set to `DISABLED` , notifications aren't sent for the notification rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['NotificationRuleStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A list of tags to apply to this notification rule. Key names cannot start with " `aws` ".
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetAddress")
    def target_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic or  client.
        """
        return pulumi.get(self, "target_address")

    @target_address.setter
    def target_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_address", value)


@pulumi.type_token("aws-native:codestarnotifications:NotificationRule")
class NotificationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 detail_type: Optional[pulumi.Input['NotificationRuleDetailType']] = None,
                 event_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_type_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['NotificationRuleStatus']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_address: Optional[pulumi.Input[builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationRuleTargetArgs', 'NotificationRuleTargetArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::CodeStarNotifications::NotificationRule

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_by: The name or email alias of the person who created the notification rule.
        :param pulumi.Input['NotificationRuleDetailType'] detail_type: The level of detail to include in the notifications for this resource. `BASIC` will include only the contents of the event as it would appear in Amazon CloudWatch. `FULL` will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
        :param pulumi.Input[builtins.str] event_type_id: The event type associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_type_ids: A list of event types associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        :param pulumi.Input[builtins.str] name: The name for the notification rule. Notification rule names must be unique in your AWS account .
        :param pulumi.Input[builtins.str] resource: The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline , repositories in AWS CodeCommit , and build projects in AWS CodeBuild .
        :param pulumi.Input['NotificationRuleStatus'] status: The status of the notification rule. The default value is `ENABLED` . If the status is set to `DISABLED` , notifications aren't sent for the notification rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A list of tags to apply to this notification rule. Key names cannot start with " `aws` ".
        :param pulumi.Input[builtins.str] target_address: The Amazon Resource Name (ARN) of the Amazon SNS topic or  client.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NotificationRuleTargetArgs', 'NotificationRuleTargetArgsDict']]]] targets: A list of Amazon Resource Names (ARNs) of Amazon SNS topics and  clients to associate with the notification rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::CodeStarNotifications::NotificationRule

        :param str resource_name: The name of the resource.
        :param NotificationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_by: Optional[pulumi.Input[builtins.str]] = None,
                 detail_type: Optional[pulumi.Input['NotificationRuleDetailType']] = None,
                 event_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_type_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['NotificationRuleStatus']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_address: Optional[pulumi.Input[builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NotificationRuleTargetArgs', 'NotificationRuleTargetArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationRuleArgs.__new__(NotificationRuleArgs)

            __props__.__dict__["created_by"] = created_by
            if detail_type is None and not opts.urn:
                raise TypeError("Missing required property 'detail_type'")
            __props__.__dict__["detail_type"] = detail_type
            __props__.__dict__["event_type_id"] = event_type_id
            if event_type_ids is None and not opts.urn:
                raise TypeError("Missing required property 'event_type_ids'")
            __props__.__dict__["event_type_ids"] = event_type_ids
            __props__.__dict__["name"] = name
            if resource is None and not opts.urn:
                raise TypeError("Missing required property 'resource'")
            __props__.__dict__["resource"] = resource
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_address"] = target_address
            if targets is None and not opts.urn:
                raise TypeError("Missing required property 'targets'")
            __props__.__dict__["targets"] = targets
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["resource"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(NotificationRule, __self__).__init__(
            'aws-native:codestarnotifications:NotificationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NotificationRule':
        """
        Get an existing NotificationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NotificationRuleArgs.__new__(NotificationRuleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["created_by"] = None
        __props__.__dict__["detail_type"] = None
        __props__.__dict__["event_type_id"] = None
        __props__.__dict__["event_type_ids"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["resource"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_address"] = None
        __props__.__dict__["targets"] = None
        return NotificationRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the notification rule.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name or email alias of the person who created the notification rule.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> pulumi.Output['NotificationRuleDetailType']:
        """
        The level of detail to include in the notifications for this resource. `BASIC` will include only the contents of the event as it would appear in Amazon CloudWatch. `FULL` will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
        """
        return pulumi.get(self, "detail_type")

    @property
    @pulumi.getter(name="eventTypeId")
    def event_type_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The event type associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        """
        return pulumi.get(self, "event_type_id")

    @property
    @pulumi.getter(name="eventTypeIds")
    def event_type_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of event types associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        """
        return pulumi.get(self, "event_type_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the notification rule. Notification rule names must be unique in your AWS account .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resource to associate with the notification rule. Supported resources include pipelines in AWS CodePipeline , repositories in AWS CodeCommit , and build projects in AWS CodeBuild .
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['NotificationRuleStatus']]:
        """
        The status of the notification rule. The default value is `ENABLED` . If the status is set to `DISABLED` , notifications aren't sent for the notification rule.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A list of tags to apply to this notification rule. Key names cannot start with " `aws` ".
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetAddress")
    def target_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon SNS topic or  client.
        """
        return pulumi.get(self, "target_address")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence['outputs.NotificationRuleTarget']]:
        """
        A list of Amazon Resource Names (ARNs) of Amazon SNS topics and  clients to associate with the notification rule.
        """
        return pulumi.get(self, "targets")

