# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetNotificationRuleResult',
    'AwaitableGetNotificationRuleResult',
    'get_notification_rule',
    'get_notification_rule_output',
]

@pulumi.output_type
class GetNotificationRuleResult:
    def __init__(__self__, arn=None, created_by=None, detail_type=None, event_type_ids=None, name=None, status=None, tags=None, targets=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if detail_type and not isinstance(detail_type, str):
            raise TypeError("Expected argument 'detail_type' to be a str")
        pulumi.set(__self__, "detail_type", detail_type)
        if event_type_ids and not isinstance(event_type_ids, list):
            raise TypeError("Expected argument 'event_type_ids' to be a list")
        pulumi.set(__self__, "event_type_ids", event_type_ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the notification rule.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        The name or email alias of the person who created the notification rule.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> Optional['NotificationRuleDetailType']:
        """
        The level of detail to include in the notifications for this resource. `BASIC` will include only the contents of the event as it would appear in Amazon CloudWatch. `FULL` will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
        """
        return pulumi.get(self, "detail_type")

    @property
    @pulumi.getter(name="eventTypeIds")
    def event_type_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of event types associated with this notification rule. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide* .
        """
        return pulumi.get(self, "event_type_ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name for the notification rule. Notification rule names must be unique in your AWS account .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['NotificationRuleStatus']:
        """
        The status of the notification rule. The default value is `ENABLED` . If the status is set to `DISABLED` , notifications aren't sent for the notification rule.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A list of tags to apply to this notification rule. Key names cannot start with " `aws` ".
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.NotificationRuleTarget']]:
        """
        A list of Amazon Resource Names (ARNs) of Amazon SNS topics and  clients to associate with the notification rule.
        """
        return pulumi.get(self, "targets")


class AwaitableGetNotificationRuleResult(GetNotificationRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationRuleResult(
            arn=self.arn,
            created_by=self.created_by,
            detail_type=self.detail_type,
            event_type_ids=self.event_type_ids,
            name=self.name,
            status=self.status,
            tags=self.tags,
            targets=self.targets)


def get_notification_rule(arn: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationRuleResult:
    """
    Resource Type definition for AWS::CodeStarNotifications::NotificationRule


    :param builtins.str arn: The Amazon Resource Name (ARN) of the notification rule.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:codestarnotifications:getNotificationRule', __args__, opts=opts, typ=GetNotificationRuleResult).value

    return AwaitableGetNotificationRuleResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_by=pulumi.get(__ret__, 'created_by'),
        detail_type=pulumi.get(__ret__, 'detail_type'),
        event_type_ids=pulumi.get(__ret__, 'event_type_ids'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        targets=pulumi.get(__ret__, 'targets'))
def get_notification_rule_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNotificationRuleResult]:
    """
    Resource Type definition for AWS::CodeStarNotifications::NotificationRule


    :param builtins.str arn: The Amazon Resource Name (ARN) of the notification rule.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:codestarnotifications:getNotificationRule', __args__, opts=opts, typ=GetNotificationRuleResult)
    return __ret__.apply(lambda __response__: GetNotificationRuleResult(
        arn=pulumi.get(__response__, 'arn'),
        created_by=pulumi.get(__response__, 'created_by'),
        detail_type=pulumi.get(__response__, 'detail_type'),
        event_type_ids=pulumi.get(__response__, 'event_type_ids'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        targets=pulumi.get(__response__, 'targets')))
