# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    def __init__(__self__, connection_arn=None, connection_status=None, owner_account_id=None, tags=None):
        if connection_arn and not isinstance(connection_arn, str):
            raise TypeError("Expected argument 'connection_arn' to be a str")
        pulumi.set(__self__, "connection_arn", connection_arn)
        if connection_status and not isinstance(connection_status, str):
            raise TypeError("Expected argument 'connection_status' to be a str")
        pulumi.set(__self__, "connection_status", connection_status)
        if owner_account_id and not isinstance(owner_account_id, str):
            raise TypeError("Expected argument 'owner_account_id' to be a str")
        pulumi.set(__self__, "owner_account_id", owner_account_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectionArn")
    def connection_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the  connection. The ARN is used as the connection reference when the connection is shared between AWS services.
        """
        return pulumi.get(self, "connection_arn")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[builtins.str]:
        """
        The current status of the connection.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[builtins.str]:
        """
        The name of the external provider where your third-party code repository is configured. For Bitbucket, this is the account ID of the owner of the Bitbucket repository.
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Specifies the tags applied to a connection.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            connection_arn=self.connection_arn,
            connection_status=self.connection_status,
            owner_account_id=self.owner_account_id,
            tags=self.tags)


def get_connection(connection_arn: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    Schema for AWS::CodeConnections::Connection resource which can be used to connect external source providers with other AWS services (i.e. AWS CodePipeline)


    :param builtins.str connection_arn: The Amazon Resource Name (ARN) of the  connection. The ARN is used as the connection reference when the connection is shared between AWS services.
    """
    __args__ = dict()
    __args__['connectionArn'] = connection_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:codeconnections:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        connection_arn=pulumi.get(__ret__, 'connection_arn'),
        connection_status=pulumi.get(__ret__, 'connection_status'),
        owner_account_id=pulumi.get(__ret__, 'owner_account_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_connection_output(connection_arn: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionResult]:
    """
    Schema for AWS::CodeConnections::Connection resource which can be used to connect external source providers with other AWS services (i.e. AWS CodePipeline)


    :param builtins.str connection_arn: The Amazon Resource Name (ARN) of the  connection. The ARN is used as the connection reference when the connection is shared between AWS services.
    """
    __args__ = dict()
    __args__['connectionArn'] = connection_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:codeconnections:getConnection', __args__, opts=opts, typ=GetConnectionResult)
    return __ret__.apply(lambda __response__: GetConnectionResult(
        connection_arn=pulumi.get(__response__, 'connection_arn'),
        connection_status=pulumi.get(__response__, 'connection_status'),
        owner_account_id=pulumi.get(__response__, 'owner_account_id'),
        tags=pulumi.get(__response__, 'tags')))
