# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'FleetComputeConfiguration',
    'FleetProxyConfiguration',
    'FleetProxyRule',
    'FleetScalingConfigurationInput',
    'FleetTargetTrackingScalingConfiguration',
    'FleetVpcConfig',
]

@pulumi.output_type
class FleetComputeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "vCpu":
            suggest = "v_cpu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetComputeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetComputeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetComputeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk: Optional[builtins.int] = None,
                 instance_type: Optional[builtins.str] = None,
                 machine_type: Optional['FleetComputeConfigurationmachineType'] = None,
                 memory: Optional[builtins.int] = None,
                 v_cpu: Optional[builtins.int] = None):
        """
        :param builtins.int disk: The amount of disk space of the instance type included in your fleet.
        :param builtins.str instance_type: The EC2 instance type to be launched in your fleet.
        :param 'FleetComputeConfigurationmachineType' machine_type: The machine type of the instance type included in your fleet.
        :param builtins.int memory: The amount of memory of the instance type included in your fleet.
        :param builtins.int v_cpu: The number of vCPUs of the instance type included in your fleet.
        """
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if v_cpu is not None:
            pulumi.set(__self__, "v_cpu", v_cpu)

    @property
    @pulumi.getter
    def disk(self) -> Optional[builtins.int]:
        """
        The amount of disk space of the instance type included in your fleet.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[builtins.str]:
        """
        The EC2 instance type to be launched in your fleet.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional['FleetComputeConfigurationmachineType']:
        """
        The machine type of the instance type included in your fleet.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        The amount of memory of the instance type included in your fleet.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> Optional[builtins.int]:
        """
        The number of vCPUs of the instance type included in your fleet.
        """
        return pulumi.get(self, "v_cpu")


@pulumi.output_type
class FleetProxyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBehavior":
            suggest = "default_behavior"
        elif key == "orderedProxyRules":
            suggest = "ordered_proxy_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetProxyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetProxyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetProxyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_behavior: Optional['FleetProxyConfigurationDefaultBehavior'] = None,
                 ordered_proxy_rules: Optional[Sequence['outputs.FleetProxyRule']] = None):
        """
        :param 'FleetProxyConfigurationDefaultBehavior' default_behavior: The default behavior of outgoing traffic.
        :param Sequence['FleetProxyRule'] ordered_proxy_rules: An array of `FleetProxyRule` objects that represent the specified destination domains or IPs to allow or deny network access control to.
        """
        if default_behavior is not None:
            pulumi.set(__self__, "default_behavior", default_behavior)
        if ordered_proxy_rules is not None:
            pulumi.set(__self__, "ordered_proxy_rules", ordered_proxy_rules)

    @property
    @pulumi.getter(name="defaultBehavior")
    def default_behavior(self) -> Optional['FleetProxyConfigurationDefaultBehavior']:
        """
        The default behavior of outgoing traffic.
        """
        return pulumi.get(self, "default_behavior")

    @property
    @pulumi.getter(name="orderedProxyRules")
    def ordered_proxy_rules(self) -> Optional[Sequence['outputs.FleetProxyRule']]:
        """
        An array of `FleetProxyRule` objects that represent the specified destination domains or IPs to allow or deny network access control to.
        """
        return pulumi.get(self, "ordered_proxy_rules")


@pulumi.output_type
class FleetProxyRule(dict):
    def __init__(__self__, *,
                 effect: Optional['FleetProxyRuleEffect'] = None,
                 entities: Optional[Sequence[builtins.str]] = None,
                 type: Optional['FleetProxyRuleType'] = None):
        """
        :param 'FleetProxyRuleEffect' effect: The behavior of the proxy rule.
        :param Sequence[builtins.str] entities: The destination of the proxy rule.
        :param 'FleetProxyRuleType' type: The type of proxy rule.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def effect(self) -> Optional['FleetProxyRuleEffect']:
        """
        The behavior of the proxy rule.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def entities(self) -> Optional[Sequence[builtins.str]]:
        """
        The destination of the proxy rule.
        """
        return pulumi.get(self, "entities")

    @property
    @pulumi.getter
    def type(self) -> Optional['FleetProxyRuleType']:
        """
        The type of proxy rule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FleetScalingConfigurationInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "scalingType":
            suggest = "scaling_type"
        elif key == "targetTrackingScalingConfigs":
            suggest = "target_tracking_scaling_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetScalingConfigurationInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetScalingConfigurationInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetScalingConfigurationInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: Optional[builtins.int] = None,
                 scaling_type: Optional['FleetScalingConfigurationInputScalingType'] = None,
                 target_tracking_scaling_configs: Optional[Sequence['outputs.FleetTargetTrackingScalingConfiguration']] = None):
        """
        :param builtins.int max_capacity: The maximum number of instances in the ﬂeet when auto-scaling.
        :param 'FleetScalingConfigurationInputScalingType' scaling_type: The scaling type for a compute fleet.
        :param Sequence['FleetTargetTrackingScalingConfiguration'] target_tracking_scaling_configs: A list of `TargetTrackingScalingConfiguration` objects.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if scaling_type is not None:
            pulumi.set(__self__, "scaling_type", scaling_type)
        if target_tracking_scaling_configs is not None:
            pulumi.set(__self__, "target_tracking_scaling_configs", target_tracking_scaling_configs)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[builtins.int]:
        """
        The maximum number of instances in the ﬂeet when auto-scaling.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="scalingType")
    def scaling_type(self) -> Optional['FleetScalingConfigurationInputScalingType']:
        """
        The scaling type for a compute fleet.
        """
        return pulumi.get(self, "scaling_type")

    @property
    @pulumi.getter(name="targetTrackingScalingConfigs")
    def target_tracking_scaling_configs(self) -> Optional[Sequence['outputs.FleetTargetTrackingScalingConfiguration']]:
        """
        A list of `TargetTrackingScalingConfiguration` objects.
        """
        return pulumi.get(self, "target_tracking_scaling_configs")


@pulumi.output_type
class FleetTargetTrackingScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricType":
            suggest = "metric_type"
        elif key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetTargetTrackingScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetTargetTrackingScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetTargetTrackingScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_type: Optional['FleetTargetTrackingScalingConfigurationMetricType'] = None,
                 target_value: Optional[builtins.float] = None):
        """
        :param 'FleetTargetTrackingScalingConfigurationMetricType' metric_type: The metric type to determine auto-scaling.
        :param builtins.float target_value: The value of `metricType` when to start scaling.
        """
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if target_value is not None:
            pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional['FleetTargetTrackingScalingConfigurationMetricType']:
        """
        The metric type to determine auto-scaling.
        """
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> Optional[builtins.float]:
        """
        The value of `metricType` when to start scaling.
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class FleetVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnets: Optional[Sequence[builtins.str]] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] security_group_ids: A list of one or more security groups IDs in your Amazon VPC.
        :param Sequence[builtins.str] subnets: A list of one or more subnet IDs in your Amazon VPC.
        :param builtins.str vpc_id: The ID of the Amazon VPC.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of one or more security groups IDs in your Amazon VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of one or more subnet IDs in your Amazon VPC.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        The ID of the Amazon VPC.
        """
        return pulumi.get(self, "vpc_id")


