# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetFleetResult',
    'AwaitableGetFleetResult',
    'get_fleet',
    'get_fleet_output',
]

@pulumi.output_type
class GetFleetResult:
    def __init__(__self__, arn=None, base_capacity=None, compute_configuration=None, compute_type=None, environment_type=None, fleet_proxy_configuration=None, fleet_service_role=None, fleet_vpc_config=None, image_id=None, name=None, overflow_behavior=None, scaling_configuration=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if base_capacity and not isinstance(base_capacity, int):
            raise TypeError("Expected argument 'base_capacity' to be a int")
        pulumi.set(__self__, "base_capacity", base_capacity)
        if compute_configuration and not isinstance(compute_configuration, dict):
            raise TypeError("Expected argument 'compute_configuration' to be a dict")
        pulumi.set(__self__, "compute_configuration", compute_configuration)
        if compute_type and not isinstance(compute_type, str):
            raise TypeError("Expected argument 'compute_type' to be a str")
        pulumi.set(__self__, "compute_type", compute_type)
        if environment_type and not isinstance(environment_type, str):
            raise TypeError("Expected argument 'environment_type' to be a str")
        pulumi.set(__self__, "environment_type", environment_type)
        if fleet_proxy_configuration and not isinstance(fleet_proxy_configuration, dict):
            raise TypeError("Expected argument 'fleet_proxy_configuration' to be a dict")
        pulumi.set(__self__, "fleet_proxy_configuration", fleet_proxy_configuration)
        if fleet_service_role and not isinstance(fleet_service_role, str):
            raise TypeError("Expected argument 'fleet_service_role' to be a str")
        pulumi.set(__self__, "fleet_service_role", fleet_service_role)
        if fleet_vpc_config and not isinstance(fleet_vpc_config, dict):
            raise TypeError("Expected argument 'fleet_vpc_config' to be a dict")
        pulumi.set(__self__, "fleet_vpc_config", fleet_vpc_config)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if overflow_behavior and not isinstance(overflow_behavior, str):
            raise TypeError("Expected argument 'overflow_behavior' to be a str")
        pulumi.set(__self__, "overflow_behavior", overflow_behavior)
        if scaling_configuration and not isinstance(scaling_configuration, dict):
            raise TypeError("Expected argument 'scaling_configuration' to be a dict")
        pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the compute fleet.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> Optional[builtins.int]:
        """
        The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
        """
        return pulumi.get(self, "base_capacity")

    @property
    @pulumi.getter(name="computeConfiguration")
    def compute_configuration(self) -> Optional['outputs.FleetComputeConfiguration']:
        """
        The compute configuration of the compute fleet. This is only required if `computeType` is set to `ATTRIBUTE_BASED_COMPUTE` or `CUSTOM_INSTANCE_TYPE` .
        """
        return pulumi.get(self, "compute_configuration")

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> Optional['FleetComputeType']:
        """
        Information about the compute resources the compute fleet uses. Available values include:

        - `ATTRIBUTE_BASED_COMPUTE` : Specify the amount of vCPUs, memory, disk space, and the type of machine.

        > If you use `ATTRIBUTE_BASED_COMPUTE` , you must define your attributes by using `computeConfiguration` . AWS CodeBuild will select the cheapest instance that satisfies your specified attributes. For more information, see [Reserved capacity environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types) in the *AWS CodeBuild User Guide* .
        - `BUILD_GENERAL1_SMALL` : Use up to 4 GiB memory and 2 vCPUs for builds.
        - `BUILD_GENERAL1_MEDIUM` : Use up to 8 GiB memory and 4 vCPUs for builds.
        - `BUILD_GENERAL1_LARGE` : Use up to 16 GiB memory and 8 vCPUs for builds, depending on your environment type.
        - `BUILD_GENERAL1_XLARGE` : Use up to 72 GiB memory and 36 vCPUs for builds, depending on your environment type.
        - `BUILD_GENERAL1_2XLARGE` : Use up to 144 GiB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
        - `BUILD_LAMBDA_1GB` : Use up to 1 GiB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER` .
        - `BUILD_LAMBDA_2GB` : Use up to 2 GiB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER` .
        - `BUILD_LAMBDA_4GB` : Use up to 4 GiB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER` .
        - `BUILD_LAMBDA_8GB` : Use up to 8 GiB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER` .
        - `BUILD_LAMBDA_10GB` : Use up to 10 GiB memory for builds. Only available for environment type `LINUX_LAMBDA_CONTAINER` and `ARM_LAMBDA_CONTAINER` .

        If you use `BUILD_GENERAL1_SMALL` :

        - For environment type `LINUX_CONTAINER` , you can use up to 4 GiB memory and 2 vCPUs for builds.
        - For environment type `LINUX_GPU_CONTAINER` , you can use up to 16 GiB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
        - For environment type `ARM_CONTAINER` , you can use up to 4 GiB memory and 2 vCPUs on ARM-based processors for builds.

        If you use `BUILD_GENERAL1_LARGE` :

        - For environment type `LINUX_CONTAINER` , you can use up to 16 GiB memory and 8 vCPUs for builds.
        - For environment type `LINUX_GPU_CONTAINER` , you can use up to 255 GiB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
        - For environment type `ARM_CONTAINER` , you can use up to 16 GiB memory and 8 vCPUs on ARM-based processors for builds.

        For more information, see [On-demand environment types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types) in the *AWS CodeBuild User Guide.*
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional['FleetEnvironmentType']:
        """
        The environment type of the compute fleet.

        - The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
        - The environment type `ARM_EC2` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
        - The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
        - The environment type `LINUX_EC2` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
        - The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
        - The environment type `MAC_ARM` is available only in regions US East (Ohio), US East (N. Virginia), US West (Oregon), Europe (Frankfurt), and Asia Pacific (Sydney).
        - The environment type `WINDOWS_EC2` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
        - The environment type `WINDOWS_SERVER_2019_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).
        - The environment type `WINDOWS_SERVER_2022_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).

        For more information, see [Build environment compute types](https://docs.aws.amazon.com//codebuild/latest/userguide/build-env-ref-compute-types.html) in the *AWS CodeBuild user guide* .
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="fleetProxyConfiguration")
    def fleet_proxy_configuration(self) -> Optional['outputs.FleetProxyConfiguration']:
        """
        Information about the proxy configurations that apply network access control to your reserved capacity instances.
        """
        return pulumi.get(self, "fleet_proxy_configuration")

    @property
    @pulumi.getter(name="fleetServiceRole")
    def fleet_service_role(self) -> Optional[builtins.str]:
        """
        The service role associated with the compute fleet. For more information, see [Allow a user to add a permission policy for a fleet service role](https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html) in the *AWS CodeBuild User Guide* .
        """
        return pulumi.get(self, "fleet_service_role")

    @property
    @pulumi.getter(name="fleetVpcConfig")
    def fleet_vpc_config(self) -> Optional['outputs.FleetVpcConfig']:
        """
        Information about the VPC configuration that AWS CodeBuild accesses.
        """
        return pulumi.get(self, "fleet_vpc_config")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[builtins.str]:
        """
        The Amazon Machine Image (AMI) of the compute fleet.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the compute fleet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overflowBehavior")
    def overflow_behavior(self) -> Optional['FleetOverflowBehavior']:
        """
        The compute fleet overflow behavior.

        - For overflow behavior `QUEUE` , your overflow builds need to wait on the existing fleet instance to become available.
        - For overflow behavior `ON_DEMAND` , your overflow builds run on CodeBuild on-demand.

        > If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you add the required VPC permissions to your project service role. For more information, see [Example policy statement to allow CodeBuild access to AWS services required to create a VPC network interface](https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface) .
        """
        return pulumi.get(self, "overflow_behavior")

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> Optional['outputs.FleetScalingConfigurationInput']:
        """
        The scaling configuration of the compute fleet.
        """
        return pulumi.get(self, "scaling_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tag key and value pairs associated with this compute fleet.

        These tags are available for use by AWS services that support AWS CodeBuild compute fleet tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetFleetResult(GetFleetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetResult(
            arn=self.arn,
            base_capacity=self.base_capacity,
            compute_configuration=self.compute_configuration,
            compute_type=self.compute_type,
            environment_type=self.environment_type,
            fleet_proxy_configuration=self.fleet_proxy_configuration,
            fleet_service_role=self.fleet_service_role,
            fleet_vpc_config=self.fleet_vpc_config,
            image_id=self.image_id,
            name=self.name,
            overflow_behavior=self.overflow_behavior,
            scaling_configuration=self.scaling_configuration,
            tags=self.tags)


def get_fleet(arn: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetResult:
    """
    Resource Type definition for AWS::CodeBuild::Fleet


    :param builtins.str arn: The ARN of the compute fleet.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:codebuild:getFleet', __args__, opts=opts, typ=GetFleetResult).value

    return AwaitableGetFleetResult(
        arn=pulumi.get(__ret__, 'arn'),
        base_capacity=pulumi.get(__ret__, 'base_capacity'),
        compute_configuration=pulumi.get(__ret__, 'compute_configuration'),
        compute_type=pulumi.get(__ret__, 'compute_type'),
        environment_type=pulumi.get(__ret__, 'environment_type'),
        fleet_proxy_configuration=pulumi.get(__ret__, 'fleet_proxy_configuration'),
        fleet_service_role=pulumi.get(__ret__, 'fleet_service_role'),
        fleet_vpc_config=pulumi.get(__ret__, 'fleet_vpc_config'),
        image_id=pulumi.get(__ret__, 'image_id'),
        name=pulumi.get(__ret__, 'name'),
        overflow_behavior=pulumi.get(__ret__, 'overflow_behavior'),
        scaling_configuration=pulumi.get(__ret__, 'scaling_configuration'),
        tags=pulumi.get(__ret__, 'tags'))
def get_fleet_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetResult]:
    """
    Resource Type definition for AWS::CodeBuild::Fleet


    :param builtins.str arn: The ARN of the compute fleet.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:codebuild:getFleet', __args__, opts=opts, typ=GetFleetResult)
    return __ret__.apply(lambda __response__: GetFleetResult(
        arn=pulumi.get(__response__, 'arn'),
        base_capacity=pulumi.get(__response__, 'base_capacity'),
        compute_configuration=pulumi.get(__response__, 'compute_configuration'),
        compute_type=pulumi.get(__response__, 'compute_type'),
        environment_type=pulumi.get(__response__, 'environment_type'),
        fleet_proxy_configuration=pulumi.get(__response__, 'fleet_proxy_configuration'),
        fleet_service_role=pulumi.get(__response__, 'fleet_service_role'),
        fleet_vpc_config=pulumi.get(__response__, 'fleet_vpc_config'),
        image_id=pulumi.get(__response__, 'image_id'),
        name=pulumi.get(__response__, 'name'),
        overflow_behavior=pulumi.get(__response__, 'overflow_behavior'),
        scaling_configuration=pulumi.get(__response__, 'scaling_configuration'),
        tags=pulumi.get(__response__, 'tags')))
