# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDashboardResult',
    'AwaitableGetDashboardResult',
    'get_dashboard',
    'get_dashboard_output',
]

@pulumi.output_type
class GetDashboardResult:
    def __init__(__self__, dashboard_body=None):
        if dashboard_body and not isinstance(dashboard_body, str):
            raise TypeError("Expected argument 'dashboard_body' to be a str")
        pulumi.set(__self__, "dashboard_body", dashboard_body)

    @property
    @pulumi.getter(name="dashboardBody")
    def dashboard_body(self) -> Optional[builtins.str]:
        """
        The detailed information about the dashboard in JSON format, including the widgets to include and their location on the dashboard
        """
        return pulumi.get(self, "dashboard_body")


class AwaitableGetDashboardResult(GetDashboardResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDashboardResult(
            dashboard_body=self.dashboard_body)


def get_dashboard(dashboard_name: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDashboardResult:
    """
    Resource Type definition for AWS::CloudWatch::Dashboard


    :param builtins.str dashboard_name: The name of the dashboard. The name must be between 1 and 255 characters. If you do not specify a name, one will be generated automatically.
    """
    __args__ = dict()
    __args__['dashboardName'] = dashboard_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cloudwatch:getDashboard', __args__, opts=opts, typ=GetDashboardResult).value

    return AwaitableGetDashboardResult(
        dashboard_body=pulumi.get(__ret__, 'dashboard_body'))
def get_dashboard_output(dashboard_name: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDashboardResult]:
    """
    Resource Type definition for AWS::CloudWatch::Dashboard


    :param builtins.str dashboard_name: The name of the dashboard. The name must be between 1 and 255 characters. If you do not specify a name, one will be generated automatically.
    """
    __args__ = dict()
    __args__['dashboardName'] = dashboard_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cloudwatch:getDashboard', __args__, opts=opts, typ=GetDashboardResult)
    return __ret__.apply(lambda __response__: GetDashboardResult(
        dashboard_body=pulumi.get(__response__, 'dashboard_body')))
